'\"
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for TIX man pages
.de HS
.if '\\$2'tix'        .TH \\$1 n \\$3 \\TIX
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
'
'
.HS tixFileSelectbox tix 3.6
.BS
'
'
.SH NAME
tixFileSelectbox - Create and manipulate TIX FileSelectbox widgets
'
'
'
.SH SYNOPSIS
\fBtixFileSelectbox\fI \fIpathName ?\fIoptions\fR?
'
'
'
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
'
\fIFileSelectbox\fR supports all the standard options of a frame widget.
.fi
.LP
See the ``options'' manual entry for details on the standard options.
'
'
.SH "WIDGET-SPECIFIC OPTIONS"
'======================
'----------
.LP
.nf
Name:		\fBbackground\fR
Class:		\fBbackground\fR
Command-Line Switch:	\fB\-background\fR
.fi
.IP
Specifies the background color of the FileSelectbox widget. This
option will *not* affect the background of the entry and listbox
subwidgets, though.
'----------
.LP
.nf
Name:		\fBbrowsecmd\fR
Class:		\fBbrowseCmd\fR
Command-Line Switch:	\fB\-browsecmd\fR
.fi
.IP
Specifies the command to execute when the user browses through the
files. By default, if the \fB\-browsecmd\fR is specified, the browse
command will be executed when the user clicks on a filename in the
\fIFiles\fR listbox.
'----------
.LP
.nf
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies the command to execute when the \fIFileSelectbox\fR is
invoked. This command is executed with one parameter : the filename
selected by the user.
'----------
.LP
.nf
Name:		\fBentryBg\fR
Class:		\fBBackground\fR
Command-Line Switch:	\fB\-entrybg\fR
.fi
.IP
Specifies the background color of the entry subwidgets.
'----------
.LP
.nf
Name:		\fBentryFont\fR
Class:		\fBFont\fR
Command-Line Switch:	\fB\-entryfont\fR
.fi
.IP
Specifies the font of the entry subwidgets.
'----------
.LP
.nf
Name:		\fBfilter\fR
Class:		\fBFilter\fR
Command-Line Switch:	\fB\-filter\fR
.fi
.IP
Specifies the filtering string used in the \fIFilter\fR entry widget
of the \fIFileSelectbox\fR. It specifies the directory in which the
\fIFileSelectbox\fR works in and the matching pattern of the desired
file names. The default value of \fB\-filter\fR is the current working
directory of the program concatenated with the matching pattern of the
file names.
'----------
.LP
.nf
Name:		\fBforeground\fR
Class:		\fBForeground\fR
Command-Line Switch:	\fB\-foreground\fR
.fi
.IP
Specifies the foreground color of all the subwidgets.
'----------
.LP
.nf
Name:		\fBgrab\fR
Class:		\fBGrab\fR
Command-Line Switch:	\fB\-grab\fR
.fi
.IP
Specifies the grabbing policy the FileSelectbox when it is reading
a directory. Only values "global", "local" or "none" are allowed.
'----------
.LP
.nf
Name:		\fBlistboxBg\fR
Class:		\fBBackground\fR
Command-Line Switch:	\fB\-listboxbg\fR
.fi
.IP
Specifies the background color of the listbox subwidgets.
'----------
.LP
.nf
Name:		\fBlistboxFont\fR
Class:		\fBFont\fR
Command-Line Switch:	\fB\-listboxfont\fR
.fi
.IP
Specifies the font of the listbox subwidgets.
'----------
.LP
.nf
Name:		\fBpattern\fR
Class:		\fBPattern\fR
Command-Line Switch:	\fB\-pattern\fR
.fi
.IP
Specifies the matching pattern of the file names that should be listed in
the \fIFiles\fR listbox.
'----------
.LP
.nf
Name:		\fBselection\fR
Class:		\fBSelection\fR
Command-Line Switch:	\fB\-selection\fR
.fi
.IP
Specifies the file name that appears in the \fISelection\fR entry in
the \fIFileSelectbox\fR. You can use this option to indicate a default
filename.
'---------- 
.BE
'======================
'
'
'
.SH DESCRIPTION
'
.PP
'
The \fBtixFileSelectbox\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a FileSelectbox widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the FileSelectbox such
as its cursor and relief.
'
.PP
Note that the TIX \fIFileSelectbox\fR is a compound widget. It
consists of several sub-widgets. Some of the general options used by the
sub-widgets, such as background or font, may not be readily configured
by specifying the
?\fIoptions\fR? arguments. Please refer to the \fBTIX\fR man page for
more details of general configuration of the TIX compound widgets.
'
.PP
The TIX \fIFileSelectbox\fR is similar to the standard Motif(TM)
file-selection box. It is generally used to select a file
to operate on. It archives the files mostly recently selected so that
they can be quickly selected again. A \fIFileSelectbox\fR is normally
packed in a \fIfile dialog box\fR. The convinence function
\fItixMkFileDialog\fR will provides a quick way of creating such a dialog.
Please read the man page of \fItixMkFileDialog\fR for more details.
'
.SH "WIDGET COMMAND"
.PP
'
The \fBtixFileSelectbox\fR command creates a new Tcl command whose
name is the same as the path name of the \fIFileSelectbox\fR's window.  This
command may be used to invoke various
operations on the widget. It has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?

.DE
'
\fIPathName\fR is the name of the command, which is the same as
the \fIFileSelectbox\fR widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for \fIFileSelectbox\fR widgets:
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBtixFileSelectbox\fR
command.
'
.TP
'
\fIpathName \fBfilter\fR
Update the files listed in the \fIFileSelectbox\fR 
according to the filtering pattern sepcified
in the \fIFilter\fR entry widget.
.TP
'
\fIpathName \fBinvoke\fR
Execute the command specified by the \fB-command\fR option
in the \fIFilter\fR entry widget.
'
.SH "DEFAULT BINDINGS"
TIX automatically creates class bindings for FileSelectboxes that give them
the following default behavior:
.IP [1]
Mouse button 1 in the \fIDirectory\fR listbox will change
the filter string to the selected directory.
.IP [2]
Mouse button 1 in the \fIFiles\fR listbox will change
the filename that appears in the \fISelection\fR entry. It will also
trigger the \fB-browsecmd\fR if the option has been specified.
.IP [3]
The current directory will be changed by (1) double
clicking the \fIDirectory\fR listbox or (2) invoking the \fIFilter\fR
Combobox. Please refer to the man page of \fBtixCombobox\fR for the
default bindings of the Comboboxes and how they can be invoked.
.IP [4]
The command specified by the option -command will be
invoked by (1) double clicking the \fIFiles\fR listbox or
(2) invoking \fISelection\fR Combobox.
'
.SH AUTHOR
.PP
Ioi Kim Lam - ioi@graphics.cis.upenn.edu
'
.SH KEYWORDS
FileSelectbox, Combobox, TIX, 
