/* setresource.c
 *
 * Copyright 1990,1991 the Regents of the University of California.  All
 * rights reserved.  Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that this copyright notice appear in all
 * copies.  See the file copyright.h for more information.
 *
 */

/*
 * contains general object manipulation commands.
 *
 */

#include <stdio.h>
#include "xwrap.h"
#include <X11/IntrinsicP.h>      /* is this really needed? */
#include <X11/CoreP.h>
#include <X11/Xaw/TextP.h>       /* to get XtNScrollMode, etc. */
#include <X11/Xmu/Converters.h>  /* for converting from string to ...  */

#include "debug.h"
#include "global.h"
#include "util.h"
#include "object.h"

extern void PressCallback();     /* defined in create.c */
extern void SendToInterpreter(); /* defined in create.c */

static int ParseSetTablePosition(clientData,interp,argc,argv)
     char *clientData;
     Tcl_Interp *interp;
     int argc;
     char **argv;
{
	Widget w;
	char result[MAXLINE],usage[MAXLINE];
	entering("ParseSetTablePosition");
	sprintf(usage,"%s object-name column row",argv[0]);
	if (BadUsage(argc,4,usage,interp)) {
		myreturn TCL_ERROR;
	}
	if (!(w=WidgetExists(argv[1],interp))) {
		myreturn TCL_ERROR;
	}
	if (XtClass(XtParent(w))==tableWidgetClass) {
		XtTblPosition(w,abs(atoi(argv[2])),abs(atoi(argv[3])));
	} else {
		sprintf(result,"The parent of '%s' is not a table object",
			argv[1]);
		Tcl_Return(interp,result,TCL_VOLATILE);
		myreturn TCL_ERROR;
	}
	myreturn TCL_OK;
}

static int ParseSetTableSpan(clientData,interp,argc,argv)
     char *clientData;
     Tcl_Interp *interp;
     int argc;
     char **argv;
{
	Widget w;
	char result[MAXLINE],usage[MAXLINE];
	entering("ParseSetTableSpan");
	sprintf(usage,"%s object-name h_span v_span",argv[0]);
	if (BadUsage(argc,4,usage,interp)) {
		myreturn TCL_ERROR;
	}
	if (!(w=WidgetExists(argv[1],interp))) {
		myreturn TCL_ERROR;
	}
	if (XtClass(XtParent(w))==tableWidgetClass) {
		XtTblResize(w,abs(atoi(argv[2])),abs(atoi(argv[3])));
	} else {
		sprintf(result,"The parent of '%s' is not a table object",
			argv[1]);
		Tcl_Return(interp,result,TCL_VOLATILE);
		myreturn TCL_ERROR;
	}
	myreturn TCL_OK;
}

static int DoSetBoolean(interp,argc,argv)
     Tcl_Interp *interp;
     int argc;
     char **argv;
     /* used for commands which set a boolean resource for a widget:
	'setresource object-name True|False' */
{
	Boolean b;
	Widget w;
	XrmValue from,to;   /* for converting string to... */
	char result[MAXLINE];
	entering("DoSetBoolean");
	if (!(w=WidgetExists(argv[1],interp))) {
		myreturn TCL_ERROR;
	}
	if (argc>2) {
		from.size = strlen(from.addr=argv[2]);
		XtConvert(w,XtRString,&from,XtRBoolean,&to);
		if (to.addr==NULL) {
			b=True;
		} else {
			b = *((Boolean*)to.addr);
		}
	} else {
		b=True;
	}
	if (mystrcmp(argv[0],"setmappedwhenmanaged")==0) {
		XtVaSetValues(w,XtNmappedWhenManaged,b,NULL);
	} else if (mystrcmp(argv[0],"setresize")==0) {
		XtVaSetValues(w,XtNresize,b,NULL);
	} else if (mystrcmp(argv[0],"setsensitive")==0) {
		XtVaSetValues(w,XtNsensitive,b,NULL);
	} else if (mystrcmp(argv[0],"setforcecolumns")==0) {
		XtVaSetValues(w,XtNforceColumns,b,NULL);
	} else if (mystrcmp(argv[0],"setstate")==0) {
		XtVaSetValues(w,XtNstate,b,NULL);
	} else if (mystrcmp(argv[0],"setautofill")==0) {
		XtVaSetValues(w,XtNautoFill,b,NULL);
	} else if (mystrcmp(argv[0],"setresizable")==0) {
		XtVaSetValues(w,XtNresizable,b,NULL);
	} else if (mystrcmp(argv[0],"setallowresize")==0) {
		XtVaSetValues(w,XtNallowResize,b,NULL);
	} else if (mystrcmp(argv[0],"setallowshellresize")==0) {
		XtVaSetValues(w,XtNallowShellResize,b,NULL);
	} else if (mystrcmp(argv[0],"setshowgrip")==0) {
		XtVaSetValues(w,XtNshowGrip,b,NULL);
	} else if (mystrcmp(argv[0],"setskipadjust")==0) {
		XtVaSetValues(w,XtNskipAdjust,b,NULL);
	} else if (mystrcmp(argv[0],"setresizetopreferred")==0) {
		XtVaSetValues(w,XtNresizeToPreferred,b,NULL);
	} else if (mystrcmp(argv[0],"setallowhoriz")==0) {
		XtVaSetValues(w,XtNallowHoriz,b,NULL);
	} else if (mystrcmp(argv[0],"setallowvert")==0) {
		XtVaSetValues(w,XtNallowVert,b,NULL);
	} else if (mystrcmp(argv[0],"setforcebars")==0) {
		XtVaSetValues(w,XtNforceBars,b,NULL);
	} else if (mystrcmp(argv[0],"setusebottom")==0) {
		XtVaSetValues(w,XtNuseBottom,b,NULL);
	} else if (mystrcmp(argv[0],"setuseright")==0) {
		XtVaSetValues(w,XtNuseRight,b,NULL);
	} else if (mystrcmp(argv[0],"setformcanresize")==0) {
		if (b)
		  XtVaSetValues(w,XtNbottom,XtRubber,
				XtNleft,XtRubber,
				XtNright,XtRubber,
				XtNtop,XtRubber,NULL);
		else
		  XtVaSetValues(w,XtNbottom,XtChainTop,
				XtNleft,XtChainLeft,
				XtNright,XtChainLeft,
				XtNtop,XtChainTop,NULL);
	} else if (mystrcmp(argv[0],"setformcanresizebottom")==0) {
		if (b)
		  XtVaSetValues(w,XtNbottom,XtRubber,NULL);
		else
		  XtVaSetValues(w,XtNbottom,XtChainBottom,NULL);
	} else if (mystrcmp(argv[0],"setformcanresizetop")==0) {
		if (b)
		  XtVaSetValues(w,XtNtop,XtRubber,NULL);
		else
		  XtVaSetValues(w,XtNtop,XtChainTop,NULL);
	} else if (mystrcmp(argv[0],"setformcanresizeleft")==0) {
		if (b)
		  XtVaSetValues(w,XtNleft,XtRubber,NULL);
		else
		  XtVaSetValues(w,XtNleft,XtChainLeft,NULL);
	} else if (mystrcmp(argv[0],"setformcanresizeright")==0) {
		if (b)
		  XtVaSetValues(w,XtNright,XtRubber,NULL);
		else
		  XtVaSetValues(w,XtNright,XtChainRight,NULL);
	} else if (mystrcmp(argv[0],"setformdolayout")==0) {
		if (XtClass(w)==formWidgetClass) {
			XawFormDoLayout(w,b);
		} else {
			sprintf(result,"'%s' is not a form object",argv[1]);
			Tcl_Return(interp,result,TCL_VOLATILE);
			myreturn TCL_ERROR;
		}
	} else {
		sprintf (result,"Don't know how to '%s' for object %s\n.",
			 argv[0],argv[1]);
		Tcl_Return(interp,result,TCL_VOLATILE);
		myreturn TCL_ERROR;
	}
	myreturn TCL_OK;
}

static int ParseSetBoolean(clientData,interp,argc,argv)
     char *clientData;
     Tcl_Interp *interp;
     int argc;
     char **argv;
     /* used for commands which set a boolean resource for a widget:
	'setresource object-name True|False' */
{
	char usage[MAXLINE];
	char **newargv,**nameargv;
	int newargc,nameargc,i,r;
	entering("ParseSetBoolean");
	sprintf(usage,"%s object-name [True|False]",argv[0]);
	if (BadUsageOptional(argc,3,usage,interp)) {
		myreturn TCL_ERROR;
	}
	newargc=argc;
	newargv = (char**)(XtMalloc((newargc+1)*sizeof(char *)));
	for (i=0; i<newargc; i++) {newargv[i]=argv[i];}
	if (Tcl_SplitList(interp,argv[1],&nameargc,&nameargv)==TCL_ERROR) {
		myreturn TCL_ERROR;
	}
	for (i=0; i<nameargc; i++) {
		newargv[1]=nameargv[i];
		r = DoSetBoolean(interp,newargc,newargv);
		if (r!=TCL_OK) {
			XtFree((char*)nameargv);
			XtFree(newargv);
			myreturn r;
		}
	}
	XtFree((char*)nameargv);
	XtFree(newargv);
	myreturn TCL_OK;
}

static int DoSetResource(interp,argc,argv)
     Tcl_Interp *interp;
     int argc;
     char **argv;
{
	char *result,*tempstr;   /* use tempstr for the string part that */
	Dimension d,d2;          /* goes into result so I don't have to  */
	Position p,p2;           /* count characters :-)  */
	Widget w;
	Pixmap *bitmap,*bitmap2;
	XrmValue from,to;   /* for converting string to... */
	entering("DoSetResource");
	if (!(w=WidgetExists(argv[1],interp))) {
		myreturn TCL_ERROR;
	}
	from.size = strlen(from.addr=argv[2]);
	/* look for bitmap file and set it */
	if (((mystrcmp(argv[0],"setbitmap")==0)||
	     (mystrcmp(argv[0],"setrightbitmap")==0)||
	     (mystrcmp(argv[0],"setleftbitmap")==0))&&
	    ((strlen(argv[2])>0)&&(mystrcmp(argv[2],"NULL")!=0))) {
		XtConvert(w,XtRString,&from,XtRBitmap,&to);
		if (to.addr==NULL) {
			tempstr = XtNewString("Cannot find bitmap file:");
			result = XtMalloc(strlen(argv[2])+strlen(tempstr)+3);
			sprintf(result,"%s %s\n",tempstr,argv[2]);
			Tcl_Return(interp,result,TCL_VOLATILE);
			XtFree(result);
			XtFree(tempstr);
			myreturn TCL_ERROR;
		}
		bitmap=(Pixmap*)to.addr;
		if (argc>3) {
			from.size = strlen(from.addr=argv[3]);
			XtConvert(w,XtRString,&from,XtRBitmap,&to);
			if (to.addr==NULL) {
				tempstr = 
				  XtNewString("Cannot find bitmap file:");
				result = XtMalloc(strlen(argv[3])+
						  strlen(tempstr)+3);
				sprintf(result,"%s %s\n",tempstr,argv[3]);
				Tcl_Return(interp,result,TCL_VOLATILE);
				XtFree(result);
				XtFree(tempstr);
				myreturn TCL_ERROR;
			}
			bitmap2=(Pixmap*)to.addr;
		} else {
			bitmap2 = bitmap;
		}
	}
	d=(Dimension)atoi(argv[2]);
	p=(Position)atoi(argv[2]);
	if (argc>3) {
		d2=(Dimension)atoi(argv[3]);
		p2=(Position)atoi(argv[3]);
	} else {
		d2=d;
		p2=p;
	}
	if (mystrcmp(argv[0],"setlabel")==0) {
		XtVaSetValues(w,XtNlabel,argv[2],NULL);
	} else if (mystrcmp(argv[0],"setx")==0) {
		if (XtClass(XtParent(w))==formWidgetClass) {
			XtVaSetValues(w,XtNhorizDistance,p,NULL);
		} else {
			XtVaSetValues(w,XtNx,p,NULL);
		}
	} else if (mystrcmp(argv[0],"sety")==0) {
		if (XtClass(XtParent(w))==formWidgetClass) {
			XtVaSetValues(w,XtNvertDistance,p,NULL);
		} else {
			XtVaSetValues(w,XtNy,p,NULL);
		}
	} else if (mystrcmp(argv[0],"setxy")==0) {
		if (XtClass(XtParent(w))==formWidgetClass) {
			XtVaSetValues(w,XtNhorizDistance,p,
				      XtNvertDistance,p2,NULL);
		} else {
			XtVaSetValues(w,XtNx,p,XtNy,p2,NULL);
		}
	} else if (mystrcmp(argv[0],"sethorizdistance")==0) {
		XtVaSetValues(w,XtNhorizDistance,d,NULL);
	} else if (mystrcmp(argv[0],"setvertdistance")==0) {
		XtVaSetValues(w,XtNvertDistance,d,NULL);
	} else if (mystrcmp(argv[0],"sethorizvertdistance")==0) {
		XtVaSetValues(w,XtNhorizDistance,d,
			      XtNvertDistance,d2,NULL);
	} else if (mystrcmp(argv[0],"setheight")==0) {
		XtVaSetValues(w,XtNheight,d,NULL);
	} else if (mystrcmp(argv[0],"setwidth")==0) {
		XtVaSetValues(w,XtNwidth,d,NULL);
	} else if (mystrcmp(argv[0],"setwidthheight")==0) {
		XtVaSetValues(w,XtNwidth,d,XtNheight,d2,NULL);
	} else if (mystrcmp(argv[0],"setborderwidth")==0) {
		XtVaSetValues(w,XtNborderWidth,d,NULL);
	} else if (mystrcmp(argv[0],"setvalue")==0) {
		XtVaSetValues(w,XtNvalue,argv[2],NULL);
		if (XtClass(w)==dialogWidgetClass) {
			XEvent event;
			XtCallActionProc(XtNameToWidget(w,"value"),
							"end-of-line",
							&event,NULL,ZERO);
		}
	} else if (mystrcmp(argv[0],"settablecolumnspacing")==0) {
		if (XtClass(w)==tableWidgetClass) {
			XtVaSetValues(w,XtNcolumnSpacing,d,NULL);
		}
	} else if (mystrcmp(argv[0],"settablerowspacing")==0) {
		if (XtClass(w)==tableWidgetClass) {
			XtVaSetValues(w,XtNrowSpacing,d,NULL);
		}
	} else if (mystrcmp(argv[0],"settablelayout")==0) {
		if (XtClass(w)==tableWidgetClass) {
			XtVaSetValues(w,XtNlayout,XtTblParseLayout(argv[2]),
				      NULL);
		}
	} else if (mystrcmp(argv[0],"setmenuname")==0) {
		XtVaSetValues(w,XtNmenuName,argv[2],NULL);
	} else if (mystrcmp(argv[0],"setlisthighlighted")==0) {
		if (XtClass(w)==listWidgetClass) {
			int i,n;
			XtVaGetValues(w,XtNnumberStrings,&n,NULL);
			i = atoi(argv[2]);
			if ((i>=0)&&(i<n)) {
				EmptyEventLoop();
				XawListHighlight(w,i);
				XtCallCallbacks(w,XtNcallback,
						XawListShowCurrent(w));
				XawListHighlight(w,i);
			}
		}
	} else if (mystrcmp(argv[0],"setcallback")==0) {
		if ((XtClass(w)==commandWidgetClass)||
		    (XtClass(w)==toggleWidgetClass)||
		    (XtClass(w)==gripWidgetClass)||
		    (XtClass(w)==smeBSBObjectClass)||
		    (XtClass(w)==menuButtonWidgetClass)) {
			XtRemoveAllCallbacks(w,XtNcallback);
			XtAddCallback(w,XtNcallback,PressCallback,
				      XtNewString(argv[2]));
		} else if (XtClass(w)==listWidgetClass) {
			char *clicktranslation;
			XtRemoveAllCallbacks(w,XtNcallback);
			XtAddCallback(w,XtNcallback,PressCallback,
				      XtNewString(argv[2]));
			tempstr = 
			  XtNewString("<Btn1Up>(2): DoubleClickList(\"\")");
			clicktranslation = XtMalloc(strlen(argv[2])+
						    strlen(tempstr)+1);
			sprintf(clicktranslation,
				"<Btn1Up>(2): DoubleClickList(\"%s\")",
				argv[2]);
			XtOverrideTranslations(w,
				XtParseTranslationTable(clicktranslation));
			XtFree(tempstr);
			XtFree(clicktranslation);
		} else if (XtClass(w)==scToolWidgetClass) {
			XtRemoveAllCallbacks(w,XtNcommandCallback);
			XtRemoveAllCallbacks(w,XtNexitCallback);
			XtAddCallback(w,XtNcommandCallback,SendToInterpreter,
				      XtNewString(argv[2]));
			XtAddCallback(w,XtNexitCallback,SendToInterpreter,
				      XtNewString(argv[2]));
		} else {
			tempstr = 
			  XtNewString(
			   "Object '' must be a button, list or text.\n");
			result = XtMalloc(strlen(argv[1])+strlen(tempstr)+1);
			sprintf(result,
			    "Object '%s' must be a button, list or text.\n",
				argv[1]);
			Tcl_Return(interp,result,TCL_VOLATILE);
			XtFree(result);
			XtFree(tempstr);
			myreturn TCL_ERROR;
		}
	} else if (mystrcmp(argv[0],"setwrap")==0) {
		XtConvert(w,XtRString,&from,XtRWrapMode,&to);
		if (to.addr!=NULL) {
			XtVaSetValues(w,XtNwrap,
				      *(XawTextWrapMode*)to.addr,NULL);
		}
	} else if (mystrcmp(argv[0],"setedittype")==0) {
		XtConvert(w,XtRString,&from,XtREditMode,&to);
		if (to.addr!=NULL) {
			XtVaSetValues(w,XtNeditType,
				      *(XawTextEditType*)to.addr,NULL);
		}
	} else if (mystrcmp(argv[0],"setscrollvertical")==0) {
		XtConvert(w,XtRString,&from,XtRScrollMode,&to);
		if (to.addr!=NULL) {
			XtVaSetValues(w,XtNscrollVertical,
				      *(XawTextScrollMode*)to.addr,NULL);
		}
	} else if (mystrcmp(argv[0],"setscrollhorizontal")==0) {
		XtConvert(w,XtRString,&from,XtRScrollMode,&to);
		if (to.addr!=NULL) {
			XtVaSetValues(w,XtNscrollHorizontal,
				      *(XawTextScrollMode*)to.addr,NULL);
		}
	} else if (mystrcmp(argv[0],"setorientation")==0) {
		XtConvert(w,XtRString,&from,XtROrientation,&to);
		if (to.addr!=NULL) {
			XtVaSetValues(w,XtNorientation,
				      *(XtOrientation*)to.addr,NULL);
		}
	} else if ((mystrcmp(argv[0],"setfromvertical")==0)||
		   (mystrcmp(argv[0],"setfromhorizontal")==0)) {
		Widget nextwidget;
		if ((strlen(argv[2])==0)||(mystrcmp("NULL",argv[2])==0)) {
			if (mystrcmp(argv[0],"setfromhorizontal")==0)
			  XtVaSetValues(w,XtNfromHoriz,NULL,NULL);
			else
			  XtVaSetValues(w,XtNfromVert,NULL,NULL);
		} else {
			if (!(nextwidget=WidgetExists(argv[2],interp))) {
				/* check if the name is a sibling or parent
				   of w */
				if (!(nextwidget=WidgetSiblingOrParent(w,
						       argv[2],interp))) {
					myreturn TCL_ERROR;
				}
			}
			if ((XtParent(w)==XtParent(nextwidget))||
			    (XtParent(w)==nextwidget)) {
				if (mystrcmp(argv[0],"setfromhorizontal")==0)
				  XtVaSetValues(w,XtNfromHoriz,nextwidget,
						NULL);
				else
				  XtVaSetValues(w,XtNfromVert,nextwidget,
						NULL);
			} else {
				Tcl_Return(interp,
					   "Objects must have same parent",
					   TCL_STATIC);
				myreturn TCL_ERROR;
			}
		}
	} else if (mystrcmp(argv[0],"setradiogroup")==0) {
		if (InvalidType(argv[1],toggleWidgetClass,interp)) {
			myreturn TCL_ERROR;
		}
		if ((strlen(argv[2])==0)||(mystrcmp(argv[2],"NULL")==0)) {
			XawToggleChangeRadioGroup(w,NULL);
		} else {
			Widget nextwidget;
			if (!(nextwidget=WidgetExists(argv[2],interp))) {
				myreturn TCL_ERROR;
			}
			XawToggleChangeRadioGroup(w,nextwidget);
		}
	} else if (mystrcmp(argv[0],"setbitmap")==0) {
		if ((strlen(argv[2])==0)||(mystrcmp(argv[2],"NULL")==0)) {
			XtVaSetValues(w,XtNbitmap,NULL,NULL);
		} else {
			XtVaSetValues(w,XtNbitmap,*bitmap,NULL);
		}
	} else if (mystrcmp(argv[0],"setrightbitmap")==0) {
		if ((strlen(argv[2])==0)||(mystrcmp(argv[2],"NULL")==0)) {
			XtVaSetValues(w,XtNrightBitmap,NULL,NULL);
		} else {
			XtVaSetValues(w,XtNrightBitmap,*bitmap,NULL);
		}
	} else if (mystrcmp(argv[0],"setleftbitmap")==0) {
		if ((strlen(argv[2])==0)||(mystrcmp(argv[2],"NULL")==0)) {
			XtVaSetValues(w,XtNleftBitmap,NULL,NULL);
		} else {
			XtVaSetValues(w,XtNleftBitmap,*bitmap,NULL);
		}
	} else if (mystrcmp(argv[0],"setrightleftbitmap")==0) {
		if ((strlen(argv[2])==0)||(mystrcmp(argv[2],"NULL")==0)) {
			XtVaSetValues(w,XtNrightBitmap,NULL,
				      XtNleftBitmap,NULL,NULL);
		} else {
			XtVaSetValues(w,XtNrightBitmap,*bitmap,
				      XtNleftBitmap,*bitmap2,NULL);
		}
	} else if (mystrcmp(argv[0],"setfont")==0) {
		XFontStruct *newfont;
		newfont = XLoadQueryFont(XtDisplay(w),argv[2]);
		if (newfont) {
			XtVaSetValues(w,XtNfont,newfont,NULL);
		} else {
			tempstr = XtNewString("Cannot find font");
			result = XtMalloc(strlen(argv[2])+strlen(tempstr)+3);
			sprintf(result,"%s %s\n",tempstr,argv[2]);
			Tcl_Return(interp,result,TCL_VOLATILE);
			XtFree(result);
			XtFree(tempstr);
			myreturn TCL_OK;
		}
	} else if (mystrcmp(argv[0],"settranslation")==0) {
		XtConvert(w,XtRString,&from,XtRTranslationTable,&to);
		if (to.addr==NULL) {
			tempstr = XtNewString("Cannot apply translation");
			result = XtMalloc(strlen(argv[1])+
					  strlen(argv[2])+
					  strlen(tempstr)+7);
			sprintf(result,"%s %s to %s\n",argv[2],argv[1]);
			Tcl_Return(interp,result,TCL_VOLATILE);
			XtFree(result);
			XtFree(tempstr);
			myreturn TCL_ERROR;
		}
		XtOverrideTranslations(w,*(XtTranslations*)to.addr);
	} else if (mystrcmp(argv[0],"seticon")==0) {
		if ((strlen(argv[2])==0)||(mystrcmp(argv[2],"NULL")==0)) {
			XtVaSetValues(w,XtNicon,NULL,NULL);
		} else {
			XtVaSetValues(w,XtNicon,*bitmap,NULL);
		}
	} else {
		tempstr = XtNewString("Don't know how to");
		result = XtMalloc(strlen(argv[0])+
				  strlen(argv[1])+
				  strlen(tempstr)+16);
		sprintf (result,"%s %s for object %s\n.",
			 tempstr,argv[0],argv[1]);
		Tcl_Return(interp,result,TCL_VOLATILE);
		XtFree(result);
		XtFree(tempstr);
		myreturn TCL_ERROR;
	}
	myreturn TCL_OK;
}

static int ParseSetResource(clientData,interp,argc,argv)
     char *clientData;
     Tcl_Interp *interp;
     int argc;
     char **argv;
     /* used for commands which set one or two resources for a widget:
	'setresource list-of-object-names value [value]' */
{
	char usage[MAXLINE];
	char **newargv,**nameargv;
	int newargc,nameargc,i,r;
	entering("ParseSetResource");
	sprintf(usage,"%s list-of-object-names value [value]",argv[0]);
	if (BadUsageOptional(argc,4,usage,interp)) {
		myreturn TCL_ERROR;
	}
	newargc=argc;
	newargv = (char**)(XtMalloc((newargc+1)*sizeof(char *)));
	for (i=0; i<newargc; i++) {newargv[i]=argv[i];}
	if (Tcl_SplitList(interp,argv[1],&nameargc,&nameargv)==TCL_ERROR) {
		myreturn TCL_ERROR;
	}
	for (i=0; i<nameargc; i++) {
		newargv[1]=nameargv[i];
		r = DoSetResource(interp,newargc,newargv);
		if (r!=TCL_OK) {
			XtFree((char*)nameargv);
			XtFree(newargv);
			myreturn r;
		}
	}
	XtFree((char*)nameargv);
	XtFree(newargv);
	myreturn TCL_OK;
}

void AddWidgetSetCommands(interp)
     Tcl_Interp *interp;
{
	entering("AddWidgetSetCommands");

	/* create commands for setting resources for particular types */

	CREATE("settableposition",ParseSetTablePosition);
	CREATE("settablespan",ParseSetTableSpan);

	/* create commands for setting resources:  setresource object value */

	CREATE("setbitmap",ParseSetResource);
	CREATE("setborderwidth",ParseSetResource);
	CREATE("setcallback",ParseSetResource);
	CREATE("setedittype",ParseSetResource);
	CREATE("setfont",ParseSetResource);
	CREATE("setfromhorizontal",ParseSetResource);
	CREATE("setfromvertical",ParseSetResource);
	CREATE("setheight",ParseSetResource);
	CREATE("sethorizdistance",ParseSetResource);
	CREATE("sethorizvertdistance",ParseSetResource);
	CREATE("seticon",ParseSetResource);
	CREATE("setlabel",ParseSetResource);
	CREATE("setleftbitmap",ParseSetResource);
	CREATE("setlisthighlighted",ParseSetResource);
	CREATE("setmenuname",ParseSetResource);
	CREATE("setorientation",ParseSetResource);
	CREATE("setradiogroup",ParseSetResource);
	CREATE("setrightbitmap",ParseSetResource);
	CREATE("setrightleftbitmap",ParseSetResource);
	CREATE("setscrollhorizontal",ParseSetResource);
	CREATE("setscrollvertical",ParseSetResource);
	CREATE("settablecolumnspacing",ParseSetResource);
	CREATE("settablelayout",ParseSetResource);
	CREATE("settablerowspacing",ParseSetResource);
	CREATE("settranslation",ParseSetResource);
	CREATE("setvalue",ParseSetResource);
	CREATE("setvertdistance",ParseSetResource);
	CREATE("setwidth",ParseSetResource);
	CREATE("setwidthheight",ParseSetResource);
	CREATE("setwrap",ParseSetResource);
	CREATE("setx",ParseSetResource);
	CREATE("setxy",ParseSetResource);
	CREATE("sety",ParseSetResource);

	/* create boolean commands for setting resources: 
	   setresource object [True|False] */

	CREATE("setallowhoriz",ParseSetBoolean);
	CREATE("setallowresize",ParseSetBoolean);
	CREATE("setallowshellresize",ParseSetBoolean);
	CREATE("setallowvert",ParseSetBoolean);
	CREATE("setautofill",ParseSetBoolean);
	CREATE("setforcebars",ParseSetBoolean);
	CREATE("setforcecolumns",ParseSetBoolean);
	CREATE("setformcanresize",ParseSetBoolean);
	CREATE("setformcanresizebottom",ParseSetBoolean);
	CREATE("setformcanresizeleft",ParseSetBoolean);
	CREATE("setformcanresizeright",ParseSetBoolean);
	CREATE("setformcanresizetop",ParseSetBoolean);
	CREATE("setformdolayout",ParseSetBoolean);
	CREATE("setmappedwhenmanaged",ParseSetBoolean);
	CREATE("setresizable",ParseSetBoolean);
	CREATE("setresize",ParseSetBoolean);
	CREATE("setresizetopreferred",ParseSetBoolean);
	CREATE("setsensitive",ParseSetBoolean);
	CREATE("setshowgrip",ParseSetBoolean);
	CREATE("setskipadjust",ParseSetBoolean);
	CREATE("setstate",ParseSetBoolean);
	CREATE("setusebottom",ParseSetBoolean);
	CREATE("setuseright",ParseSetBoolean);

	myreturn;
}
