/* debug.h -- contains globals for debugging, and error messages. */

/*
 * Copyright 1990 the Regents of the University of California.  All
 * rights reserved.  Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that this copyright notice appear in all
 * copies.  See the file copyright.h for more information.
 *
 */

extern int debuglevel;

 /* call this at the beginning of each procedure and function.  
    entering("my_function") */
#define entering(msg) if (debuglevel>0) entering_proc(msg)

#define myreturn exit_proc(); return

extern void exit_proc();
extern void entering_proc(); 
extern void set_debuglevel();  /* int, sets the debuglevel:
				  0 -- no debug messages, default
				  1 -- Debug messages only
				  2 -- Entering and debug messages
				  3 -- Entering, debug messages, and 
				       exiting messages
				  4 -- all of 3 and malloc_verify called 
				       at every procedure call and
				       malloc_debug set to 1
				  5 -- all of 4 and malloc_debug set to 2 */

extern int get_debuglevel();
extern void myerror();      /* used for run-time error msgs. */
extern void dprint();       /* general debug statements */
