.TH XCBI 1 "25 Jul 91" "Local Commands"
.SH NAME
xcbi \- An X Window Configurable button interface for simple UNIX programs
.SH SYNOPSIS
.B xcbi
[
.B \-\fIXtoolkitoptions\fP ...
]
[
.B \-exec \fIxcbi command\fP
]
[
.B \-file \fIsetupfile\fP
]
[
.I args...
]
.SH DESCRIPTION
.IX "xcbi command"  ""  "\fLxcbi\fP \(em configurable button interface"
.IX "coninterface
.I Xcbi
is an X11 Window System application which provides a simple,
configurable, X11 interface to most command line UNIX programs such as
dbx or ftp. The interface may incorporate
buttons, pull down menus, popup dialog boxes, scrollable text windows, and
many other user interface objects.
.PP
Configuration is provided via a setup file (with the
.B \-file
option)
or by executing commands through buttons, pull down menus and popup dialogs
while the program is running.
.PP
.I Xcbi
uses the
.I tcl
interpreter from John Ousterhaut at UC Berkeley.  This interpreter has
variables, procudure calls, loop constructs, and many other common
language features.  Reference will be made to 
.I tcl
throughout this man page.  See the
.I tcl
man page for more information on 
.I tcl.
.SH OBJECTS
.I Xcbi
interfaces consist of hierarchical groupings of many different
types of Athena Widget objects including:
labels, boxes, special text windows, panes, viewports,
buttons, pull down menus, menu items, menu lines,
dialog boxes, lists, forms, tables, and grips.  See the Athena Widget manual
for a detailed description of these widgets.  Two widgets, the special text
widget and the table widget, are not Athena Widgets.
.PP
.I Special text windows
allows the user to enter commands to running UNIX programs or to the xcbi
command interpreter if no program is connected to the text window.  The
output of UNIX programs are displayed in text windows.  A filter
procedure can be defined to parse the output of the UNIX program.
.PP
.I Table widgets
are from the WCL library and are documented in Table.doc.

.SH OBJECT CREATION COMMANDS
.I Xcbi
commands are grouped into five categories:  tcl builtin (see 
.I tcl
man page for more details), object creation, resource retrieval,
resource setting, object manipulation, and miscellaneous.  Object
creation commands begin with 
.B new,
resource setting commands begin with
.B set,
and resource retrieval commands begin with
.B get.
.PP
All the commands are briefly described below.  The object creation
commands begin with the string
.B new.
Most take at least two argument (except for 
.B newpopup
) the 
.B parent
and the
.B object-name
The parent argument specifies the parent widget in which the new
widget will be created.  A full heirarchical name must be used.  The '*'
character can be used.  If the new widget is going to be the top
level widget then its parent must be the string
.B top.
The 
.B object-name
argument specifies the name of the newly created widget.  Only
numbers, letters, underscore, and dash should be used as the widget
name.
.PP
The following commands are used to create objects. Each creates an
Athena Widget of the same class as the command name.  The commands are
more or less self explanatory, a few are explained in more detail.
Some contraint or composite Athena Widgets
.I must
have a child before they can be realized, therefore all widgets can be
initially created unmanaged and then later managed after the children
have been created.
.HP
.B newbox
.I parent object-name [unmanaged]
.HP
.B newbutton
.I parent object-name label callback|menuname
.br
Creates a button (a command Widget) named
.I object-name
in the parent object.
Pressing the button will cause the
.I callback
to be interpreted by the xcbi command interpreter.  A useful callback might
be the
.B write
command to send a string to a program.  By default, the button will
be just large enough to fit the 
.I label.
.HP
.B newcheckbox
.I parent name label togglecallback [buttoncallback]
.HP
.B newdialog
.I parent object-name [unmanaged]
.HP
.B newform
.I parent object-name [unmanaged]
.HP
.B newgrip
.I parent object-name [unmanaged]
.HP
.B newlabel
.I parent name string [justification]
.HP
.B newlist
.I parent object-name callback
.HP
.B newmenu
.I parent object-name [unmanaged]
.HP
.B newmenubutton
.I parent object-name label callback|menuname
.HP
.B newmenuitem
.I parent object-name label callback|menuname
.HP
.B newmenuline
.I parent object-name [unmanaged]
.HP
.B newpane
.I parent object-name [unmanaged]
.HP
.B newpopup
.I name
.HP
.B newtable
.I parent object-name [unmanaged]
.HP
.B newtext
.I parent window-name [callback] [columns] [rows]
.HP
.B newtoggle
.I parent object-name label callback|menuname
.HP
.B newviewport
.I parent object-name [unmanaged]
.PP
.SH RESOURCE COMMANDS
.I Xcbi
has commands to set and retrieve resources. The syntax of the resource
retrieval command is:
.HP
.B get<resourcename>
.I object-name
.br
Where
.I object-name
is the full hierarchy name of the widget.
.PP
The syntax of the resource setting command is:
.HP
.B set<resourcename>
.I <object-name or list-of-objectnames> value
.br
Where
.I object-name
is the full hierarchy name of the widget and
.I list-of-objectnames
is a tcl list of widget names.
.PP
Most of the retrieval commands are named according to the resource that they
retreive with a few exceptions for items that are not resources. The
following resources can be retrieved:
.br
.B allowhoriz allowresize allowshellresize allowvert autofill
.B borderwidth callback filelist fontheight fontwidth
.B forcebars forcecolumns fromhoriz height label
.B listhighlighted mappedwhenmanaged menuname program resizable
.B resize resizetopreferred sensitive showgrip skipadjust
.B state usebottom useright value width
.B x y
.PP
Most of the resource setting commands are named according to the
resource that they set.
The following resources can be set:
.br
.B allowhoriz allowresize allowshellresize allowvert autofill
.B bitmap borderwidth callback debugwidget edittype
.B font forcebars forcecolumns formcanresize formcanresizebottom
.B formcanresizeleft formcanresizeright formcanresizetop formdolayout
.B fromhorizontal fromvertical height horizdistance horizvertdistance icon
.B label leftbitmap listhighlighted mappedwhenmanaged menuname
.B orientation radiogroup resizable resize resizetopreferred
.B rightbitmap rightleftbitmap scrollhorizontal scrollvertical sensitive
.B showgrip skipadjust state tablecolumnspacing tablelayout
.B tableposition tablerowspacing tablespan translation upfile
.B usebottom useright value vertdistance width
.B wrap x y  
.PP
The resources
.B width, height, x,
and
.B y
can be set in pairs with the resource 
.B widthheight
and
.B xy.
.SH ADDITIONAL COMMANDS
The following additional commands are recognized:
.HP
.B argc
.br
Returns the number of command line arguments passed to xcbi after Xt has
parsed out all of its options.
.HP
.B argv
.I number
.br
Returns the value of the command line argument number
.I number.
.HP
.B break
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B case
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B catch
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B changelist
.I list-name new-list
.br
Changes the list named
.I list-name
to
.I new-list.
.HP
.B clear
.I text-window-name
.br
Clears the window named
.IR text-window-name .
.HP
.B concat
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B continue
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B currentlinenumber
.I window-name
.br
Returns the line number of the insertion point (the caret ``^'') of the
text window called
.IR window-name .
.br
.HP
.B debuglevel
.I level
.br
Sets a debugging level to 
.I level
where the level is from 0 to 5.  O means no debugging and 5 means full
debugging with calls to malloc_verify() at every function call (if
compiled with debug option).
.HP
.B destroy
.I object-name
.br
Destroys the widget called 
.IR object-name .
.HP
.B displaycaret
.I text-window-name flag
.br
Displays or hides the caret (``^'') of the text object called
.IR text-window-name .
The
.I flag
argument is either
.I true
or
.IR false .
.HP
.B emptyeventloop
.br
This causes the X event loop to be dispatched.  This is useful when a
.I tcl
calculation may take a long time and the user might also want to process
a few X events such as displaying a status message.
.HP
.B error
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B eval
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B exec
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B expr
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B file
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B for
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B foreach
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B format
.I format-string arg arg ...
.br
tcl builtin.  Generates a formatted string similar to the behavior of
sprintf.  The
.I format-string
contains the traditional C % fields which are used to format the
.IR args .
The
.I format-string
may also contain standard C backslash escapes for newlines, tabs and
control characters.  (This is a tcl command.  See the
.I tcl
manual for more details.)
.HP
.B glob
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B global
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B gotoline
.I window-name line-number
.br
Moves the insertion point in the text window called
.I window-name
to the line
.IR line-number .
.HP
.B history
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B iconify
.br
Iconifies the entire
.I xcbi
window.  This does not work under all window managers, but should work
under
.IR twm .
.HP
.B if
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B index
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B info
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B length
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B list
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B listnames
.br
Returns a list of all the names of widgets that have been created and
managed.
.HP
.B locatefile
.I file
[
.I directory-list
]
.br
Returns a pathname for
.IR file .
If
.I file
doesn't begin with a slash (``/'') it will be searched for in each of the
colon (``:'') separated directories listed in
.IR directory-list .
If
.I directory-list
isn't specified, the variable
.B setuppath
will be used.
.RB ( Setuppath 's
initial value is taken from the
.B xcbi.setupPath
X11 resource.)
.br
.HP
.B lowercase
.I string
.br
Converts
.I string
to all lowercase.
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B manage
.I object-name
.br
Manages the object called
.IR object-name .
.HP
.B map
.I object-name
.br
Causes the object named
.I object-name
to become visible if it was made invisible by the unmap command.
.HP
.B movepointer
.I object-name [xoffset yoffset]
.br
Moves the pointer to the object called
.IR object-name .
The optional
.IR xoffset 'and' yoffset
specify the distance from the upper-right corner of
.IR object-name .
Use this command sparingly as the user does not expect the pointer to
be moved to an arbitrary place on the screen.
.HP
.B object
.I object-name option
.br
Operates on an
.I xcbi
object.  The
.I option
indicates what to do with the object.  The valid options are:
.B exists
and
.BR type .
.HP
.B object
.I object-name
.B exists
.br
Returns 1 if object
.I object-name
exists, 0 if it doesn't.
.HP
.B object
.I object-name
.B type
.br
Returns the type of the object called
.IR object-name .
The types of objects are:
.BR button,
.BR box,
.BR dialog,
.BR form,
.BR grip,
.BR label,
.BR menu,
.BR menubutton,
.BR menuitem,
.BR menuline,
.BR pane,
.BR popup,
.BR table,
.BR text,
.BR toggle,
.BR list,
.BR viewport,
and
.BR Unknown.
.HP
.B paste
[
.I string
]
.br
Returns the value of cut_buffer 0.  If the optional argument
.I string
is given, then set the value of cut_buffer 0 to
.I string.
.HP
.B popdown
.I object-name
.br
Pops down the object called
.IR object-name .
.HP
.B popup
.I popup-name
[
.I goto-object
]
.br
Pops up the popup named
.IR popup-name .
.I goto-object
specifies the object that the cursor will be warped to when the popup
appears.  (Yeah, I know, I shouldn't warp the cursor...:-)  The popup
is centered around the current cursor position.  If the popup is not
completely visible, it will be moved to become fully visible.
.HP
.B popuponly
.I popup-name
.br
Pops up the popup named
.I popup-name
in the same place that it was previously popped up.
.HP
.B press
.I object-name
.br
Press the button or menu item named
.IR object-name .
Useful for pressing an object from within another command.
.HP
.B print
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B proc
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B querypointer
.I object-name
.br
Returns the x,y coordinates of the pointer relative to the object
called
.IR object-name .
.HP
.B quit
.br
Terminates
.IR xcbi .
This is usually part of the return string for a button.  For example:
.nf
.in +3
.ft B

newbutton *box quit Quit quit

.ft R
.in -3
.fi
.HP
.B random
.I integer
.br
Generates a random number between 0 and
.I integer
minus 1.
.RI ( Integer
must be less than 32767.)
.HP
.B range
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B rename
.br
1tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B return
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B run
.I window-name 
[
.IR hostname :
]
.I pathname
[
program-args
]
.br
Runs the program
.I pathname
and connects the input and output of the program to the window named
.I window-name.
The
.I pathname
is looked up in the PATH environment variable.  The optional parameter
.IR hostname :
is used to run the
.I pathname
on a different host.  The program
.B rsh
is used to do this therefore the permissions must be set correctly in
your
.B .rhosts
file. 
Command line arguments for the tool are optionally entered last.
.HP
.B scan
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B set
.I variable string
.br
tcl builtin. Gives the
.I variable
the value
.IR string .
Variables can be used for almost any object name or within a button or
item strings by preceding the variable with a ``$''.  This is similar to
sh syntax, i.e. ``$temp'' will give the value of the variable ``temp''.
(This is a tcl command.  See the 
.I tcl
manual for more information.)
.HP
.B setupfile
.br
Returns the value of the setup file that was originally used,
i.e. argv[0].setup or the file from the
.B \-file
option.
.HP
.B source
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B string
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B textsearch
.I text-window-name [direction]
.br
Brings up a search box for the text object named
.I text-window-name
and sets the direction to
.IR direction .
.I Direction
can be ``forward'' or ``backward''. The default is ``forward''.
.HP
.B time
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B trace
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B uniconify
.br
Uniconifies the entire
.I xcbi
window.  Does not work under all window managers, but should work under
.IR twm .
.HP
.B unmap
.I object-name
.br
Makes the object named
.I object-name
invisible.  If
.I object-name
is the name of a menu item, then the item cannot be selected.
.HP
.B uplevel
.br
tcl builtin.  See the
.I tcl
manual for more details.
.HP
.B usefilter
.I text-window-name flag
.br
Tells the text object named
.I text-window-name
to use its filter function defined by the
.I callback
parameter to
.IR newtext .
The
.I flag
argument is either 
.I true
or
.IR false .
.HP
.B version
.br
Returns the
.I xcbi
version.
.HP
.B wait
.I n
.br
Causes
.I
xcbi
to wait for
.I n
seconds.
.HP
.B write
.I text-window-name string
.br
Writes
.I string
to a text window.  If variable or backslash substitution is desired, then the
.B format
command must be used in conjunction with the
.B write
command.  For example:
.nf
.in +3
.ft B

write *cshwindow {[format "ls \-l %s\\n" $myfile]}

.ft R
.in -3
.fi
will send the command ``ls \-l'' and the value of $myfile to the
window called *cshwindow.
.HP
.B writeuser
.I text-window-name string
.br
Just like the
.I write
command, but writes as if the user entered it.  I.e. a newline in the
.I string
will cause the
.I string
to be sent to whatever program is attached to the text window.
.PP
Notes: Any line beginning with a ``#'' is a comment. Any string
containing a nonalphanumeric character must be enclosed in braces
``{\|}'' or it will be considered a list of strings.  Command
substitution is done by enclosing the command in square brackets
``[\|]''.  Commands can be combined together with semi-colons (``;'')
as in csh.  Any errors from the xcbi command interpreter will be sent
to stdout.
.SH OPTIONS
.I Xcbi
accepts most of the standard X Toolkit command line options along with
the additional options listed below:
.TP 6
.B \-file \fIsetupfile\fP
This option specifies the
.I setupfile
to use.  The setup file contains a list of commands that are to be
interpreted by
.I xcbi
before the main window is realized.
If
.I setupfile
doesn't start with a slash (``/'')
.I xcbi
will search for it in each of the directories in the resource variable
.BR xcbi.setupPath .
The default search path is
.B .:\s-2XCBISETUPDIR\s+2
(where
.B \s-2XCBISETUPDIR\s+2
is usually /usr/lib/X11/xcbi but may be different on your system.)
.IP
A default
.I setupfile
is inferred from the name
.I xcbi
is invoked by with a trailing
.B .setup
added.  Thus creating a symbolic link from, say,
.I Browser
to
.I xcbi
and then executing
.I Browser
would cause
.I xcbi
to look for
.B Browser.setup
in each of the directories listed in
.BR xcbi.setupPath .
.TP 6
.B \-exec \fIxcbi command\fP
This option specifies an
.I xcbi
command to execute before loading in the
.IR setupfile .
.IP
All other arguments are passed through to the
.I xcbi
command interpreter and can be accessed via the
.B argv
or
.B argc
commands.
.TP 6
.B \-setup \fIpathname\fP
This option specifies the 
.I setupPath
resource.  This overrides the default path.
.SH RESOURCES
.I Xcbi
understands most of the core X Toolkit resource names as well as:
.HP
.B exec
(class
.BR Exec )
.br
Specifies a string to execute before reading in the setup file.
.HP
.B file
(class
.BR File )
.br
Specifies a setup file to read in.
.HP
.B setupPath
(class
.BR SetupPath )
.br
Specifies a colon (``:'') separated set of directories to search for
setup files.  The value of this resource is assigned to the variable
.B setuppath
when
.I xcbi
starts.
.PP
The hierarchy of many of the composite objects follows the Athena Widgets
hierarchy documented in the Athena Widgets manual.  All objects are Widgets
so the standard resource database can be used to set values.
.SH EXAMPLE
.LP
An example setup file to run csh with a button for ``ls \-laF'' and
``exit'' is shown below:
.nf
.in +3
.ft B
#example xcbi setup file
#first create a box to hold the buttons and the text window
newbox top box
#next, create a label saying that this is an example
newlabel box title {Example xcbi usage with csh}
#create a text window
newtext box cshwindow
#run /bin/csh in the textwindow
run *cshwindow /bin/csh
#set the scroll modes
setscrollvert *cshwindow whenNeeded
setscrollhoriz *cshwindow whenNeeded
#add buttons for exiting and for ls \-laF
newbutton box exit Exit {write *cshwindow exit\\n; wait 1; quit}
newbutton box ls ls {write *cshwindow [format "ls \-laF\\n"]}

.ft R
.in -3
.fi
.PP
Other examples are included with the source and should be installed in
/usr/lib/X11/xcbi or where ever libraries are usually installed.
.SH BUGS
The user cannot type some control characters in the text windows.  To
send them to a program, the
.B write
command must be used. (Use \\nnn in
the string, e.g. ``write *cshwindow \\004''.)
.PP
Screen updating in the text widget is kind of slow.
.PP
Sometimes tool processes do not exit properly and must be killed by
hand. (Use ``kill \-9 <pid>''.)
.PP
If there are many widgets, then sometimes wildcard specifications of
widget names will cause the program to crash (esp. if the widget does
not exists).  This seems to happen on a Sparcstation running Sun OS
4.1, but not on a Sun 3 running OS 3.5.
.SH COPYRIGHT
Copyright 1990, 1991 the Regents of the University of California.  All
rights reserved.  Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without fee is
hereby granted, provided that the above copyright notice appear in all
copies.  See copyright.h for more details.
.SH AUTHOR
Jeremy Uejio, Lawrence Livermore National Laboratory.
