/*
 * Copyright 1990 the Regents of the University of California.  All
 * rights reserved.  Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that this copyright notice appear in all
 * copies.  See the file copyright.h for more information.
 *
 */

#include "copyright.h"
/*#include <X11/copyright.h>*/

#ifndef _ScToolP_h
#define _ScToolP_h

#include "ScTool.h"
/* include superclass private header file */
#include <X11/Xaw/AsciiTextP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

/* none */

typedef struct {
	int dummy;
} ScToolClassPart;

typedef struct _ScToolClassRec {
    CoreClassPart	 core_class;
    SimpleClassPart      simple_part;
    TextClassPart        text_class;
    AsciiClassPart       ascii_class;
    ScToolClassPart	 scTool_class;
} ScToolClassRec;

extern ScToolClassRec scToolClassRec;

typedef struct {
	/* resources */
	XtCallbackList input_callback;  /* callback when <CR> is pressed */
	XtCallbackList exit_callback;   /* callback when <CR> is pressed */
	/* private state */
	char *line;          /* points to line to be executed */
	XawTextPosition start_pos;       /* position of last <CR> */
	int do_callback;     /* wheather or not the callback is called on CR */
	int always_callback; /* wheather or not the callback is called on CR
			        while the tool is running. */
	XtInputId inputId;   /* input ID for X.  Needed so that I can
			        do an XtRemoveInput */
	int master;          /* the socket number. */
	int pid;             /* the process id.  (Needed to kill the tool) */
	char *program;       /* the program name that is running */
	char **argv;         /* parameters used to start the program */
	int argc;
} ScToolPart;

typedef struct _ScToolRec {
    CorePart	    core;
    SimplePart      simple;
    TextPart        text;
    AsciiPart       ascii;
    ScToolPart     scTool;
} ScToolRec;

#endif  _ScToolP_h
