#| -*-Scheme-*-

$Header: ttyout.scm,v 14.6 90/11/09 08:44:46 GMT cph Rel $

Copyright (c) 1988, 1990 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Console Output Port
;;; package: (runtime console-output)

(declare (usual-integrations))

(define (initialize-package!)
  (set! console-output-port
	(make-output-port `((BEEP ,operation/beep)
			    (BUFFER-SIZE ,operation/buffer-size)
			    (BUFFERED-CHARS ,operation/buffered-chars)
			    (CHANNEL ,operation/channel)
			    (CLEAR ,operation/clear)
			    (FLUSH-OUTPUT ,operation/flush-output)
			    (PRINT-SELF ,operation/print-self)
			    (SET-BUFFER-SIZE ,operation/set-buffer-size)
			    (WRITE-CHAR ,operation/write-char)
			    (WRITE-STRING ,operation/write-string)
			    (X-SIZE ,operation/x-size)
			    (Y-SIZE ,operation/y-size))
			  false))
  (reset-console-output)
  (add-event-receiver! event:after-restore reset-console-output))

(define (reset-console-output)
  (set-output-port/state!
   console-output-port
   (make-output-port-state
    (make-output-buffer (tty-output-channel) buffer-size)
    ((ucode-primitive tty-command-clear 0))
    ((ucode-primitive tty-command-beep 0)))))

(define-structure (output-port-state
		   (type vector)
		   (conc-name output-port-state/))
  ;; Buffer must come first, so we can use operations from generic
  ;; output port implementation.
  (buffer false read-only true)
  (clear-command false read-only true)
  (beep-command false read-only true))

(define buffer-size 512)
(define console-output-port)

(define-integrable (output-port/buffer port)
  (output-port-state/buffer (output-port/state port)))

(define-integrable (output-port/clear-command port)
  (output-port-state/clear-command (output-port/state port)))

(define-integrable (output-port/beep-command port)
  (output-port-state/beep-command (output-port/state port)))

(define (operation/write-char port char)
  (operation/write-string port (string char)))

(define (operation/write-string port string)
  (output-buffer/write-string-block (output-port/buffer port) string)
  (if transcript-port (output-port/write-string transcript-port string)))

(define (operation/flush-output port)
  (output-buffer/drain-block (output-port/buffer port))
  (if transcript-port (output-port/flush-output transcript-port)))

(define (operation/clear port)
  (operation/write-string port (output-port/clear-command port)))

(define (operation/beep port)
  (operation/write-string port (output-port/beep-command port)))

(define-integrable (operation/x-size port)
  port
  ((ucode-primitive tty-x-size 0)))

(define-integrable (operation/y-size port)
  port
  ((ucode-primitive tty-y-size 0)))

(define (operation/print-self state port)
  port
  (unparse-string state "to console"))