#| -*-Scheme-*-

$Header: genout.scm,v 1.1 90/11/09 08:45:28 GMT cph Rel $

Copyright (c) 1990 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Generic Output Ports
;;; package: (runtime generic-output)

(declare (usual-integrations))

(define (initialize-package!)
  (set! output-port-template
	(make-output-port `((ASSOCIATED-PORT ,output-port/associated-port)
			    (BUFFER-SIZE ,operation/buffer-size)
			    (BUFFERED-CHARS ,operation/buffered-chars)
			    (CHANNEL ,operation/channel)
			    (CLOSE ,operation/close)
			    (FLUSH-OUTPUT ,operation/flush-output)
			    (PRINT-SELF ,operation/print-self)
			    (SET-BUFFER-SIZE ,operation/set-buffer-size)
			    (WRITE-CHAR ,operation/write-char)
			    (WRITE-STRING ,operation/write-string))
			  false))
  unspecific)

(define output-port-template)

(define (make-generic-output-port channel buffer-size)
  (output-port/copy
   output-port-template
   (make-output-port-state (make-output-buffer channel buffer-size) false)))

(define-structure (output-port-state (type vector)
				     (conc-name output-port-state/))
  ;; Buffer must come first -- other output ports use the buffer
  ;; operations defined here.
  (buffer false read-only true)
  (associated-port false))

(define-integrable (output-port/buffer port)
  (output-port-state/buffer (output-port/state port)))

(define-integrable (output-port/associated-port port)
  (output-port-state/associated-port (output-port/state port)))

(define-integrable (set-output-port/associated-port! port port*)
  (set-output-port-state/associated-port! (output-port/state port) port*))

(define (operation/buffer-size port)
  (output-buffer/size (output-port/buffer port)))

(define (operation/set-buffer-size port buffer-size)
  (output-buffer/set-size (output-port/buffer port) buffer-size))

(define (operation/buffered-chars port)
  (output-buffer/buffered-chars (output-port/buffer port)))

(define (operation/channel port)
  (output-buffer/channel (output-port/buffer port)))

(define (operation/close port)
  (output-buffer/close (output-port/buffer port)))

(define (operation/flush-output port)
  (output-buffer/drain-block (output-port/buffer port)))

(define (operation/print-self state port)
  (unparse-string state "for channel: ")
  (unparse-object state (operation/channel port)))

(define (operation/write-char port char)
  (output-buffer/write-string-block (output-port/buffer port) (string char)))

(define (operation/write-string port string)
  (output-buffer/write-string-block (output-port/buffer port) string))