package WordList::EN::PersonName::PopularBabyName::US::SSA::1900::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-22'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyName-US-SSA'; # DIST
our $VERSION = '0.003'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("longest_word_len",11,"num_words_contain_nonword_chars",0,"num_words_contain_whitespace",0,"num_words_contains_whitespace",0,"num_words",1000,"avg_word_len",5.646,"num_words_contains_nonword_chars",0,"num_words_contains_unicode",0,"num_words_contain_unicode",0,"shortest_word_len",2); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 1900 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyName::US::SSA::1900::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 1900 (from Social Security Administration)

=head1 VERSION

This document describes version 0.003 of WordList::EN::PersonName::PopularBabyName::US::SSA::1900::MaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyName-US-SSA), released on 2020-05-22.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyName::US::SSA::1900::MaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyName::US::SSA::1900::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.646 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyName-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
John
William
James
George
Charles
Robert
Joseph
Frank
Edward
Henry
Thomas
Walter
Harry
Willie
Arthur
Albert
Fred
Clarence
Paul
Harold
Roy
Joe
Raymond
Richard
Charlie
Louis
Jack
Earl
Carl
Ernest
Ralph
David
Samuel
Sam
Howard
Herbert
Andrew
Elmer
Lee
Lawrence
Francis
Alfred
Will
Daniel
Eugene
Leo
Oscar
Floyd
Herman
Jesse
Michael
Lewis
Tom
Leonard
Ray
Clyde
Benjamin
Peter
Claude
Lester
Theodore
Russell
Eddie
Frederick
Leroy
Clifford
Anthony
Jim
Jessie
Martin
Edgar
Chester
Ben
Edwin
Dewey
Cecil
Stanley
Lloyd
Donald
Homer
Harvey
Luther
Norman
Johnnie
Leon
Bernard
Ed
Hugh
Patrick
Kenneth
Leslie
Victor
Alexander
Philip
Oliver
Mack
Horace
Milton
Guy
Everett
Jacob
Melvin
Charley
Allen
Alvin
Earnest
Ira
Sidney
Archie
Otis
Virgil
Julius
Jerry
Percy
Otto
Isaac
Bill
Glenn
Maurice
Alex
Dan
Warren
Hubert
Marion
Lonnie
Nathan
Stephen
Wesley
Vincent
Marvin
Manuel
Willard
Vernon
Willis
Dave
Morris
Jose
Wallace
Wilbur
Gerald
Rufus
Bennie
Bert
August
Rudolph
Gilbert
Curtis
Perry
Max
Steve
Franklin
Gordon
Mark
Nelson
Glen
Mckinley
Roland
Dennis
Mike
Sylvester
Johnie
Matthew
Calvin
Jess
Emil
Phillip
Marshall
Amos
Elbert
Felix
Arnold
Jake
Ellis
Gus
Emmett
Clayton
Irvin
Jimmie
Nathaniel
Adolph
Moses
Alonzo
Cornelius
Pete
Irving
Orville
Adam
Ollie
Claud
Clifton
Douglas
Jay
Aaron
Tony
Abraham
Bob
Jasper
Roscoe
Levi
Nicholas
Sherman
Edmund
Owen
Noah
Clinton
Ivan
Monroe
Wilson
Ervin
Bruce
Elijah
Reuben
Jerome
Wayne
Juan
Barney
Ross
Grant
Don
Laurence
Roger
Tommie
Wilfred
Grady
Harley
Julian
Preston
Leland
Timothy
Antonio
Clark
Karl
Mary
Mose
Ted
Simon
Alva
Dock
Cleveland
Johnny
Roosevelt
Solomon
Luke
Carroll
Harrison
Jeff
Troy
Millard
Silas
Fredrick
Austin
Forrest
Ike
Allan
Loyd
Freddie
Myron
Wilbert
Aubrey
Boyd
Larry
Byron
Edd
Louie
Wiley
Jackson
Dwight
Rex
Anton
Neal
Hiram
Mathew
Van
Abe
Anderson
Wade
Bryan
Christopher
Malcolm
Miles
Andy
Dale
Merle
Fletcher
Forest
Riley
Emory
Grover
Mitchell
Elwood
Major
Neil
Newton
Pat
Randolph
Ruben
Jesus
Lyle
Murray
Nick
Clement
Gene
Marcus
Taylor
Ambrose
Edmond
Booker
Dean
Earle
Ned
Ramon
Russel
Augustus
Chris
Columbus
Dick
Eli
Emanuel
Delbert
Freeman
Isiah
Loren
Pedro
Spencer
Alton
Erwin
Jeremiah
Ward
Wilmer
Emery
Ezra
Jimmy
Lorenzo
Ora
Steven
Tommy
Clay
Conrad
Cyril
Ferdinand
Lynn
Pearl
Bud
Dallas
Elmo
Francisco
Lucius
Ronald
Stewart
Clair
Elton
Lyman
Scott
Burton
Carlton
Sterling
Al
Aloysius
Basil
Carlos
Dewitt
Elisha
Herschel
Lemuel
Billy
Cyrus
Enoch
Garland
Hobert
Johnson
Joshua
Noble
Orval
Vern
Alfonso
Alphonso
Christian
Dee
Hollis
Joel
Lowell
Emerson
Lon
Ulysses
Dudley
Elliott
General
Harris
Houston
Kelly
King
Lacy
Buck
Garfield
Irwin
Isaiah
Junius
Mason
Napoleon
Sammie
Shirley
Benny
Carter
Cleo
Elmore
Emile
Jennings
Jonas
Matt
Morgan
Raleigh
Wilber
Arther
Asa
Clarance
Fay
Gustave
Wendell
Early
Foster
Garrett
Odell
Zack
Clem
Green
Haywood
Odis
Sol
Washington
Adrian
Alan
Allie
Alphonse
Angelo
Coy
Ellsworth
Emmet
Hobart
Judge
Reginald
Rupert
Seth
Travis
Walker
Winfield
Bruno
Carey
Chas
Coleman
Hardy
Lionel
Lucious
Maynard
Smith
Anna
Buster
Dominick
Dorsey
Hal
Ivory
Josh
Judson
Lige
Olin
Porter
Royal
Sim
Truman
Billie
Bryant
Elvin
Evan
Ford
Isadore
Jefferson
Wilford
Benjiman
Buford
Crawford
Elias
Emmitt
Fritz
Harmon
Hugo
Merrill
Rubin
Saul
Webster
Wilburn
Alford
Berry
Bertha
Chauncey
Clint
Florence
Furman
Henery
Hyman
Jean
Jewel
Logan
Lonzo
Maxwell
Milford
Milo
Oren
Pablo
Phil
Pink
Prince
Ruby
Salvatore
Sandy
Son
Stuart
Tim
Waldo
Abner
Emma
Eric
Granville
Lucian
Luis
Murphy
Norbert
Omer
Otha
Otho
Palmer
Rodney
Sanford
Terry
Thurman
Bertram
Connie
Davis
Eldon
Elzie
Ethel
Hallie
Henderson
Hezekiah
Israel
Lenard
Lincoln
Lonie
Micheal
Pasquale
Roman
Rosevelt
Sampson
Shelby
Warner
Wm
Adolphus
Annie
Bailey
Bernie
Bonnie
Dana
Elie
Ezekiel
Frances
Gabriel
Gustav
Hamilton
Harlan
Hector
Ivy
Lambert
Lindsey
Mervin
Meyer
Toney
Verne
Vernie
Wash
Abram
Admiral
Arch
Art
Bishop
Boyce
Burl
Burt
Cicero
Doc
Ennis
Guss
Hans
Helen
Hosea
Joesph
Justin
Nat
Noel
Norris
Odie
Rolland
Tillman
Turner
Vivian
Albin
Artie
Cliff
Dillard
Duncan
Eldridge
Kelley
Lafayette
Lawson
Levy
Linwood
Madison
Mannie
Marie
Miguel
Ole
Parker
Randall
Thaddeus
Wylie
Alvie
Arlie
Armand
Aron
Bennett
Carson
Cleve
Collins
Dalton
Elizabeth
Elza
Everette
Gaston
Gladys
Gust
Keith
Lamar
Leander
Margaret
Nolan
Quincy
Rowland
Ruth
Teddy
Tomas
Unknown
Abel
Alec
Bradley
Cletus
Doyle
Elsie
Emilio
Fate
Giles
Graham
Hayes
Hazel
Hermon
Isidore
Jason
Jewell
Jonnie
Junior
Lindsay
Louise
Loy
Obie
Oral
Orlando
Ossie
Pierce
Richmond
Rollie
Valentine
Vance
Williams
Angus
Antoine
Archibald
Burley
Casper
Curley
Dominic
Felipe
Howell
Jule
Lillie
Miller
Monte
Olen
Reed
Thad
Theo
Walton
Wyatt
Alden
Alma
Benton
Bradford
Casey
Denis
Denver
Edna
Effie
Eunice
Golden
Hamp
Harland
Hershel
Hobson
Ida
Jules
Kirby
Less
Lou
Lucien
Mildred
Morton
Myles
Price
Roderick
Rollin
Rudy
Sheldon
Sonny
Sydney
Talmadge
Theadore
Tracy
Vester
Watson
Waverly
Wayman
Weldon
West
Westley
Winfred
Winston
Worth
Alberto
Ammon
Antone
Augustine
Avery
Beatrice
Brooks
Butler
Carleton
Cary
Clara
Ella
Emmit
Ernie
Evans
Fernando
Gregory
Hollie
Hunter
Junious
Mac
Melton
Minnie
Murry
Nellie
Ocie
Oran
Orie
Orin
Osie
Patsy
Rafael
Ransom
Raymon
Rocco
Rube
Santiago
Sylvan
Vaughn
Webb
Wheeler
Wilton
Addison
Alfredo
Auther
Axel
Benedict
Bessie
Brady
Buddie
Burnett
Caleb
Christ
Conley
Damon
Duke
Earlie
Eduardo
Elder
Ellie
Ewell
Farris
Geo
Gerard
Gideon
Grace
Gregorio
Guadalupe
Hampton
Hoyt
Ignatius
Isom
Issac
Jodie
Jonah
Jonathan
Jordan
Laurie
Laverne
Leeroy
Lemmie
Lillian
Marcellus
Marlin
Pierre
Rose
Royce
Stanford
Thornton
Thurston
Tobe
Tyler
Verner
Acie
Addie
Alvah
Barry
Bartley
Barton
Baxter
Bee
Benito
Bernice
Blair
Buddy
Cal
Carmen
Carmine
Clare
Claudie
Collis
Courtney
Dell
Delmar
Eliga
Eligah
Elwin
Estell
Eston
Foy
Frederic
French
Gale
Garnett
Godfrey
Goebel
Gray
Harlow
Hayden
Helmer
Hilliard
Joy
Julious
Lemon
Len
Leopold
Lesley
Lois
Loran
Ludwig
Luster
Mae
Melville
Moody
Norval
Omar
Orrin
Pleas
Reese
Rene
Rolla
Rossie
Sanders
Seward
Seymour
Sullivan
Tallie
Urban
Wong
Alfonzo
Allison
Alois
Alvis
Arlo
Artis
Arvid
Barnie
Bart
Brown
Callie
Cameron
Casimer
Cloyd
Collin
Colonel
Craig
Darrell
Delmer
Eddy
Edith
Elige
Elliot
Enos
Enrique
Erich
Ernst
Evert
Fabian
Ferris
Fitzhugh
Gail
Gary
Gorge
Harvie
Hester
Hosie
Hudson
Irene
Jennie
June
Lauren
Lupe
Martha
Mathias
Mearl
Milburn
Newell
Newt
Nora
Oswald
Ozie
Paris
Pinkney
Pleasant
Rush
Salvador
Santos
Schuyler
Shedrick
Shelley
Shellie
Spurgeon
Wellington
Wilfrid
Zollie
Ace
Adolf
Agnes
Alf
Alice
Almon
Arley
Arturo
Arvel
Beverly
Brice
Byrd
Ceasar
Cora
Doctor
Donovan
Dorothy
Drew
Elden
Elvis
Ephraim
Essie
Eva
Felton
Finley
Fleming
Gaylord
Gerhard
Gertrude
Heber
Hillard
Holly
Hughie
