# Games::Checkers, Copyright (C) 1996-2012 Mikhael Goikhman, migo@cpan.org
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

package Games::Checkers::Board::_14x14;

use strict;
use warnings;

use base 'Games::Checkers::Board';
use Games::Checkers::Constants;

use constant size_x => 14;
use constant size_y => 14;
use constant locs => 98;
use constant default_rows => 6;

use constant loc_directions => [
	[ NL,  7, NL, NL ], [  7,  8, NL, NL ], [  8,  9, NL, NL ], [  9, 10, NL, NL ], [ 10, 11, NL, NL ], [ 11, 12, NL, NL ], [ 12, 13, NL, NL ],
	[ 14, 15,  0,  1 ], [ 15, 16,  1,  2 ], [ 16, 17,  2,  3 ], [ 17, 18,  3,  4 ], [ 18, 19,  4,  5 ], [ 19, 20,  5,  6 ], [ 20, NL,  6, NL ],
	[ NL, 21, NL,  7 ], [ 21, 22,  7,  8 ], [ 22, 23,  8,  9 ], [ 23, 24,  9, 10 ], [ 24, 25, 10, 11 ], [ 25, 26, 11, 12 ], [ 26, 27, 12, 13 ],
	[ 28, 29, 14, 15 ], [ 29, 30, 15, 16 ], [ 30, 31, 16, 17 ], [ 31, 32, 17, 18 ], [ 32, 33, 18, 19 ], [ 33, 34, 19, 20 ], [ 34, NL, 20, NL ],
	[ NL, 35, NL, 21 ], [ 35, 36, 21, 22 ], [ 36, 37, 22, 23 ], [ 37, 38, 23, 24 ], [ 38, 39, 24, 25 ], [ 39, 40, 25, 26 ], [ 40, 41, 26, 27 ],
	[ 42, 43, 28, 29 ], [ 43, 44, 29, 30 ], [ 44, 45, 30, 31 ], [ 45, 46, 31, 32 ], [ 46, 47, 32, 33 ], [ 47, 48, 33, 34 ], [ 48, NL, 34, NL ],
	[ NL, 49, NL, 35 ], [ 49, 50, 35, 36 ], [ 50, 51, 36, 37 ], [ 51, 52, 37, 38 ], [ 52, 53, 38, 39 ], [ 53, 54, 39, 40 ], [ 54, 55, 40, 41 ],
	[ 56, 57, 42, 43 ], [ 57, 58, 43, 44 ], [ 58, 59, 44, 45 ], [ 59, 60, 45, 46 ], [ 60, 61, 46, 47 ], [ 61, 62, 47, 48 ], [ 62, NL, 48, NL ],
	[ NL, 63, NL, 49 ], [ 63, 64, 49, 50 ], [ 64, 65, 50, 51 ], [ 65, 66, 51, 52 ], [ 66, 67, 52, 53 ], [ 67, 68, 53, 54 ], [ 68, 69, 54, 55 ],
	[ 70, 71, 56, 57 ], [ 71, 72, 57, 58 ], [ 72, 73, 58, 59 ], [ 73, 74, 59, 60 ], [ 74, 75, 60, 61 ], [ 75, 76, 61, 62 ], [ 76, NL, 62, NL ],
	[ NL, 77, NL, 63 ], [ 77, 78, 63, 64 ], [ 78, 79, 64, 65 ], [ 79, 80, 65, 66 ], [ 80, 81, 66, 67 ], [ 81, 82, 67, 68 ], [ 82, 83, 68, 69 ],
	[ 84, 85, 70, 71 ], [ 85, 86, 71, 72 ], [ 86, 87, 72, 73 ], [ 87, 88, 73, 74 ], [ 88, 89, 74, 75 ], [ 89, 90, 75, 76 ], [ 90, NL, 76, NL ],
	[ NL, 91, NL, 77 ], [ 91, 92, 77, 78 ], [ 92, 93, 78, 79 ], [ 93, 94, 79, 80 ], [ 94, 95, 80, 81 ], [ 95, 96, 81, 82 ], [ 96, 97, 82, 83 ],
	[ NL, NL, 84, 85 ], [ NL, NL, 85, 86 ], [ NL, NL, 86, 87 ], [ NL, NL, 87, 88 ], [ NL, NL, 88, 89 ], [ NL, NL, 89, 90 ], [ NL, NL, 90, NL ],
];

use constant is_crowning => [
[
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1,
], [
	1, 1, 1, 1, 1, 1, 1,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
]
];

use constant pawn_step => [
[
	[      7 ], [  7,  8 ], [  8,  9 ], [  9, 10 ], [ 10, 11 ], [ 11, 12 ], [ 12, 13 ],
	[ 14, 15 ], [ 15, 16 ], [ 16, 17 ], [ 17, 18 ], [ 18, 19 ], [ 19, 20 ], [ 20     ],
	[     21 ], [ 21, 22 ], [ 22, 23 ], [ 23, 24 ], [ 24, 25 ], [ 25, 26 ], [ 26, 27 ],
	[ 28, 29 ], [ 29, 30 ], [ 30, 31 ], [ 31, 32 ], [ 32, 33 ], [ 33, 34 ], [ 34     ],
	[     35 ], [ 35, 36 ], [ 36, 37 ], [ 37, 38 ], [ 38, 39 ], [ 39, 40 ], [ 40, 41 ],
	[ 42, 43 ], [ 43, 44 ], [ 44, 45 ], [ 45, 46 ], [ 46, 47 ], [ 47, 48 ], [ 48     ],
	[     49 ], [ 49, 50 ], [ 50, 51 ], [ 51, 52 ], [ 52, 53 ], [ 53, 54 ], [ 54, 55 ],
	[ 56, 57 ], [ 57, 58 ], [ 58, 59 ], [ 59, 60 ], [ 60, 61 ], [ 61, 62 ], [ 62     ],
	[     63 ], [ 63, 64 ], [ 64, 65 ], [ 65, 66 ], [ 66, 67 ], [ 67, 68 ], [ 68, 69 ],
	[ 70, 71 ], [ 71, 72 ], [ 72, 73 ], [ 73, 74 ], [ 74, 75 ], [ 75, 76 ], [ 76     ],
	[     77 ], [ 77, 78 ], [ 78, 79 ], [ 79, 80 ], [ 80, 81 ], [ 81, 82 ], [ 82, 83 ],
	[ 84, 85 ], [ 85, 86 ], [ 86, 87 ], [ 87, 88 ], [ 88, 89 ], [ 89, 90 ], [ 90     ],
	[     91 ], [ 91, 92 ], [ 92, 93 ], [ 93, 94 ], [ 94, 95 ], [ 95, 96 ], [ 96, 97 ],
	[        ], [        ], [        ], [        ], [        ], [        ], [        ],
], [
	[        ], [        ], [        ], [        ], [        ], [        ], [        ],
	[  0,  1 ], [  1,  2 ], [  2,  3 ], [  3,  4 ], [  4,  5 ], [  5,  6 ], [  6     ],
	[      7 ], [  7,  8 ], [  8,  9 ], [  9, 10 ], [ 10, 11 ], [ 11, 12 ], [ 12, 13 ],
	[ 14, 15 ], [ 15, 16 ], [ 16, 17 ], [ 17, 18 ], [ 18, 19 ], [ 19, 20 ], [ 20     ],
	[     21 ], [ 21, 22 ], [ 22, 23 ], [ 23, 24 ], [ 24, 25 ], [ 25, 26 ], [ 26, 27 ],
	[ 28, 29 ], [ 29, 30 ], [ 30, 31 ], [ 31, 32 ], [ 32, 33 ], [ 33, 34 ], [ 34     ],
	[     35 ], [ 35, 36 ], [ 36, 37 ], [ 37, 38 ], [ 38, 39 ], [ 39, 40 ], [ 40, 41 ],
	[ 42, 43 ], [ 43, 44 ], [ 44, 45 ], [ 45, 46 ], [ 46, 47 ], [ 47, 48 ], [ 48     ],
	[     49 ], [ 49, 50 ], [ 50, 51 ], [ 51, 52 ], [ 52, 53 ], [ 53, 54 ], [ 54, 55 ],
	[ 56, 57 ], [ 57, 58 ], [ 58, 59 ], [ 59, 60 ], [ 60, 61 ], [ 61, 62 ], [ 62     ],
	[     63 ], [ 63, 64 ], [ 64, 65 ], [ 65, 66 ], [ 66, 67 ], [ 67, 68 ], [ 68, 69 ],
	[ 70, 71 ], [ 71, 72 ], [ 72, 73 ], [ 73, 74 ], [ 74, 75 ], [ 75, 76 ], [ 76     ],
	[     77 ], [ 77, 78 ], [ 78, 79 ], [ 79, 80 ], [ 80, 81 ], [ 81, 82 ], [ 82, 83 ],
	[ 84, 85 ], [ 85, 86 ], [ 86, 87 ], [ 87, 88 ], [ 88, 89 ], [ 89, 90 ], [ 90     ],
]
];

use constant pawn_beat => [
	[     15         ], [ 14, 16         ], [ 15, 17         ], [ 16, 18         ], [ 17, 19         ], [ 18, 20         ], [ 19             ],
	[     22         ], [ 21, 23         ], [ 22, 24         ], [ 23, 25         ], [ 24, 26         ], [ 25, 27         ], [ 26             ],
	[     29,      1 ], [ 28, 30,  0,  2 ], [ 29, 31,  1,  3 ], [ 30, 32,  2,  4 ], [ 31, 33,  3,  5 ], [ 32, 34,  4,  6 ], [ 33,      5     ],
	[     36,      8 ], [ 35, 37,  7,  9 ], [ 36, 38,  8, 10 ], [ 37, 39,  9, 11 ], [ 38, 40, 10, 12 ], [ 39, 41, 11, 13 ], [ 40,     12     ],
	[     43,     15 ], [ 42, 44, 14, 16 ], [ 43, 45, 15, 17 ], [ 44, 46, 16, 18 ], [ 45, 47, 17, 19 ], [ 46, 48, 18, 20 ], [ 47,     19     ],
	[     50,     22 ], [ 49, 51, 21, 23 ], [ 50, 52, 22, 24 ], [ 51, 53, 23, 25 ], [ 52, 54, 24, 26 ], [ 53, 55, 25, 27 ], [ 54,     26     ],
	[     57,     29 ], [ 56, 58, 28, 30 ], [ 57, 59, 29, 31 ], [ 58, 60, 30, 32 ], [ 59, 61, 31, 33 ], [ 60, 62, 32, 34 ], [ 61,     33     ],
	[     64,     36 ], [ 63, 65, 35, 37 ], [ 64, 66, 36, 38 ], [ 65, 67, 37, 39 ], [ 66, 68, 38, 40 ], [ 67, 69, 39, 41 ], [ 68,     40     ],
	[     71,     43 ], [ 70, 72, 42, 44 ], [ 71, 73, 43, 45 ], [ 72, 74, 44, 46 ], [ 73, 75, 45, 47 ], [ 74, 76, 46, 48 ], [ 75,     47     ],
	[     78,     50 ], [ 77, 79, 49, 51 ], [ 78, 80, 50, 52 ], [ 79, 81, 51, 53 ], [ 80, 82, 52, 54 ], [ 81, 83, 53, 55 ], [ 82,     54     ],
	[     85,     57 ], [ 84, 86, 56, 58 ], [ 85, 87, 57, 59 ], [ 86, 88, 58, 60 ], [ 87, 89, 59, 61 ], [ 88, 90, 60, 62 ], [ 89,     61     ],
	[     92,     64 ], [ 91, 93, 63, 65 ], [ 92, 94, 64, 66 ], [ 93, 95, 65, 67 ], [ 94, 96, 66, 68 ], [ 95, 97, 67, 69 ], [ 96,     68     ],
	[             71 ], [         70, 72 ], [         71, 73 ], [         72, 74 ], [         73, 75 ], [         74, 76 ], [         75     ],
	[             78 ], [         77, 79 ], [         78, 80 ], [         79, 81 ], [         80, 82 ], [         81, 83 ], [         82     ],
];

use constant pawn_beat_forward => [
[
	[     15 ], [ 14, 16 ], [ 15, 17 ], [ 16, 18 ], [ 17, 19 ], [ 18, 20 ], [ 19     ],
	[     22 ], [ 21, 23 ], [ 22, 24 ], [ 23, 25 ], [ 24, 26 ], [ 25, 27 ], [ 26     ],
	[     29 ], [ 28, 30 ], [ 29, 31 ], [ 30, 32 ], [ 31, 33 ], [ 32, 34 ], [ 33     ],
	[     36 ], [ 35, 37 ], [ 36, 38 ], [ 37, 39 ], [ 38, 40 ], [ 39, 41 ], [ 40     ],
	[     43 ], [ 42, 44 ], [ 43, 45 ], [ 44, 46 ], [ 45, 47 ], [ 46, 48 ], [ 47     ],
	[     50 ], [ 49, 51 ], [ 50, 52 ], [ 51, 53 ], [ 52, 54 ], [ 53, 55 ], [ 54     ],
	[     57 ], [ 56, 58 ], [ 57, 59 ], [ 58, 60 ], [ 59, 61 ], [ 60, 62 ], [ 61     ],
	[     64 ], [ 63, 65 ], [ 64, 66 ], [ 65, 67 ], [ 66, 68 ], [ 67, 69 ], [ 68     ],
	[     71 ], [ 70, 72 ], [ 71, 73 ], [ 72, 74 ], [ 73, 75 ], [ 74, 76 ], [ 75     ],
	[     78 ], [ 77, 79 ], [ 78, 80 ], [ 79, 81 ], [ 80, 82 ], [ 81, 83 ], [ 82     ],
	[     85 ], [ 84, 86 ], [ 85, 87 ], [ 86, 88 ], [ 87, 89 ], [ 88, 90 ], [ 89     ],
	[     92 ], [ 91, 93 ], [ 92, 94 ], [ 93, 95 ], [ 94, 96 ], [ 95, 97 ], [ 96     ],
	[        ], [        ], [        ], [        ], [        ], [        ], [        ],
	[        ], [        ], [        ], [        ], [        ], [        ], [        ],
], [
	[        ], [        ], [        ], [        ], [        ], [        ], [        ],
	[        ], [        ], [        ], [        ], [        ], [        ], [        ],
	[      1 ], [  0,  2 ], [  1,  3 ], [  2,  4 ], [  3,  5 ], [  4,  6 ], [  5     ],
	[      8 ], [  7,  9 ], [  8, 10 ], [  9, 11 ], [ 10, 12 ], [ 11, 13 ], [ 12     ],
	[     15 ], [ 14, 16 ], [ 15, 17 ], [ 16, 18 ], [ 17, 19 ], [ 18, 20 ], [ 19     ],
	[     22 ], [ 21, 23 ], [ 22, 24 ], [ 23, 25 ], [ 24, 26 ], [ 25, 27 ], [ 26     ],
	[     29 ], [ 28, 30 ], [ 29, 31 ], [ 30, 32 ], [ 31, 33 ], [ 32, 34 ], [ 33     ],
	[     36 ], [ 35, 37 ], [ 36, 38 ], [ 37, 39 ], [ 38, 40 ], [ 39, 41 ], [ 40     ],
	[     43 ], [ 42, 44 ], [ 43, 45 ], [ 44, 46 ], [ 45, 47 ], [ 46, 48 ], [ 47     ],
	[     50 ], [ 49, 51 ], [ 50, 52 ], [ 51, 53 ], [ 52, 54 ], [ 53, 55 ], [ 54     ],
	[     57 ], [ 56, 58 ], [ 57, 59 ], [ 58, 60 ], [ 59, 61 ], [ 60, 62 ], [ 61     ],
	[     64 ], [ 63, 65 ], [ 64, 66 ], [ 65, 67 ], [ 66, 68 ], [ 67, 69 ], [ 68     ],
	[     71 ], [ 70, 72 ], [ 71, 73 ], [ 72, 74 ], [ 73, 75 ], [ 74, 76 ], [ 75     ],
	[     78 ], [ 77, 79 ], [ 78, 80 ], [ 79, 81 ], [ 80, 82 ], [ 81, 83 ], [ 82     ],
]
];

use constant pawn_beat_8dirs => [
	[     15,                 28,  2 ], [ 14, 16,                 29,  3 ], [ 15, 17,              0, 30,  4 ], [ 16, 18,              1, 31,  5 ], [ 17, 19,              2, 32,  6 ], [ 18, 20,              3, 33     ], [ 19,                  4, 34     ],
	[     22,                 35,  9 ], [ 21, 23,                 36, 10 ], [ 22, 24,              7, 37, 11 ], [ 23, 25,              8, 38, 12 ], [ 24, 26,              9, 39, 13 ], [ 25, 27,             10, 40     ], [ 26,                 11, 41     ],
	[     29,      1,         42, 16 ], [ 28, 30,  0,  2,         43, 17 ], [ 29, 31,  1,  3,     14, 44, 18 ], [ 30, 32,  2,  4,     15, 45, 19 ], [ 31, 33,  3,  5,     16, 46, 20 ], [ 32, 34,  4,  6,     17, 47     ], [ 33,      5,         18, 48     ],
	[     36,      8,         49, 23 ], [ 35, 37,  7,  9,         50, 24 ], [ 36, 38,  8, 10,     21, 51, 25 ], [ 37, 39,  9, 11,     22, 52, 26 ], [ 38, 40, 10, 12,     23, 53, 27 ], [ 39, 41, 11, 13,     24, 54     ], [ 40,     12,         25, 55     ],
	[     43,     15,  0,     56, 30 ], [ 42, 44, 14, 16,  1,     57, 31 ], [ 43, 45, 15, 17,  2, 28, 58, 32 ], [ 44, 46, 16, 18,  3, 29, 59, 33 ], [ 45, 47, 17, 19,  4, 30, 60, 34 ], [ 46, 48, 18, 20,  5, 31, 61     ], [ 47,     19,      6, 32, 62     ],
	[     50,     22,  7,     63, 37 ], [ 49, 51, 21, 23,  8,     64, 38 ], [ 50, 52, 22, 24,  9, 35, 65, 39 ], [ 51, 53, 23, 25, 10, 36, 66, 40 ], [ 52, 54, 24, 26, 11, 37, 67, 41 ], [ 53, 55, 25, 27, 12, 38, 68     ], [ 54,     26,     13, 39, 69     ],
	[     57,     29, 14,     70, 44 ], [ 56, 58, 28, 30, 15,     71, 45 ], [ 57, 59, 29, 31, 16, 42, 72, 46 ], [ 58, 60, 30, 32, 17, 43, 73, 47 ], [ 59, 61, 31, 33, 18, 44, 74, 48 ], [ 60, 62, 32, 34, 19, 45, 75     ], [ 61,     33,     20, 46, 76     ],
	[     64,     36, 21,     77, 51 ], [ 63, 65, 35, 37, 22,     78, 52 ], [ 64, 66, 36, 38, 23, 49, 79, 53 ], [ 65, 67, 37, 39, 24, 50, 80, 54 ], [ 66, 68, 38, 40, 25, 51, 81, 55 ], [ 67, 69, 39, 41, 26, 52, 82     ], [ 68,     40,     27, 53, 83     ],
	[     71,     43, 28,     84, 58 ], [ 70, 72, 42, 44, 29,     85, 59 ], [ 71, 73, 43, 45, 30, 56, 86, 60 ], [ 72, 74, 44, 46, 31, 57, 87, 61 ], [ 73, 75, 45, 47, 32, 58, 88, 62 ], [ 74, 76, 46, 48, 33, 59, 89     ], [ 75,     47,     34, 60, 90     ],
	[     78,     50, 35,     91, 65 ], [ 77, 79, 49, 51, 36,     92, 66 ], [ 78, 80, 50, 52, 37, 63, 93, 67 ], [ 79, 81, 51, 53, 38, 64, 94, 68 ], [ 80, 82, 52, 54, 39, 65, 95, 69 ], [ 81, 83, 53, 55, 40, 66, 96     ], [ 82,     54,     41, 67, 97     ],
	[     85,     57, 42,         72 ], [ 84, 86, 56, 58, 43,         73 ], [ 85, 87, 57, 59, 44, 70,     74 ], [ 86, 88, 58, 60, 45, 71,     75 ], [ 87, 89, 59, 61, 46, 72,     76 ], [ 88, 90, 60, 62, 47, 73         ], [ 89,     61,     48, 74         ],
	[     92,     64, 49,         79 ], [ 91, 93, 63, 65, 50,         80 ], [ 92, 94, 64, 66, 51, 77,     81 ], [ 93, 95, 65, 67, 52, 78,     82 ], [ 94, 96, 66, 68, 53, 79,     83 ], [ 95, 97, 67, 69, 54, 80         ], [ 96,     68,     55, 81         ],
	[             71, 56,         86 ], [         70, 72, 57,         87 ], [         71, 73, 58, 84,     88 ], [         72, 74, 59, 85,     89 ], [         73, 75, 60, 86,     90 ], [         74, 76, 61, 87         ], [         75,     62, 88         ],
	[             78, 63,         93 ], [         77, 79, 64,         94 ], [         78, 80, 65, 91,     95 ], [         79, 81, 66, 92,     96 ], [         80, 82, 67, 93,     97 ], [         81, 83, 68, 94         ], [         82,     69, 95         ],
];

use constant king_step => [
	[      7,             15,             22,             30,             37,             45,             52,             60,             67,             75,             82,             90,             97         ],
	[  7,  8,         14, 16,             23,             31,             38,             46,             53,             61,             68,             76,             83                                         ],
	[  8,  9,         15, 17,         21, 24,         28, 32,             39,             47,             54,             62,             69                                                                         ],
	[  9, 10,         16, 18,         22, 25,         29, 33,         35, 40,         42, 48,             55                                                                                                         ],
	[ 10, 11,         17, 19,         23, 26,         30, 34,         36, 41,         43,             49,             56                                                                                             ],
	[ 11, 12,         18, 20,         24, 27,         31,             37,             44,             50,             57,             63,             70                                                             ],
	[ 12, 13,         19,             25,             32,             38,             45,             51,             58,             64,             71,             77,             84                             ],
	[ 14, 15,  0,  1,     22,             30,             37,             45,             52,             60,             67,             75,             82,             90,             97                         ],
	[ 15, 16,  1,  2, 21, 23,         28, 31,             38,             46,             53,             61,             68,             76,             83                                                         ],
	[ 16, 17,  2,  3, 22, 24,         29, 32,         35, 39,         42, 47,             54,             62,             69                                                                                         ],
	[ 17, 18,  3,  4, 23, 25,         30, 33,         36, 40,         43, 48,         49, 55,         56                                                                                                             ],
	[ 18, 19,  4,  5, 24, 26,         31, 34,         37, 41,         44,             50,             57,             63,             70                                                                             ],
	[ 19, 20,  5,  6, 25, 27,         32,             38,             45,             51,             58,             64,             71,             77,             84                                             ],
	[ 20,      6,     26,             33,             39,             46,             52,             59,             65,             72,             78,             85,             91                             ],
	[     21,      7,     29,      1,     36,             44,             51,             59,             66,             74,             81,             89,             96                                         ],
	[ 21, 22,  7,  8, 28, 30,  0,  2,     37,             45,             52,             60,             67,             75,             82,             90,             97                                         ],
	[ 22, 23,  8,  9, 29, 31,  1,  3, 35, 38,         42, 46,             53,             61,             68,             76,             83                                                                         ],
	[ 23, 24,  9, 10, 30, 32,  2,  4, 36, 39,         43, 47,         49, 54,         56, 62,             69                                                                                                         ],
	[ 24, 25, 10, 11, 31, 33,  3,  5, 37, 40,         44, 48,         50, 55,         57,             63,             70                                                                                             ],
	[ 25, 26, 11, 12, 32, 34,  4,  6, 38, 41,         45,             51,             58,             64,             71,             77,             84                                                             ],
	[ 26, 27, 12, 13, 33,      5,     39,             46,             52,             59,             65,             72,             78,             85,             91                                             ],
	[ 28, 29, 14, 15,     36,      8,     44,      2,     51,             59,             66,             74,             81,             89,             96                                                         ],
	[ 29, 30, 15, 16, 35, 37,  7,  9, 42, 45,  0,  3,     52,             60,             67,             75,             82,             90,             97                                                         ],
	[ 30, 31, 16, 17, 36, 38,  8, 10, 43, 46,  1,  4, 49, 53,         56, 61,             68,             76,             83                                                                                         ],
	[ 31, 32, 17, 18, 37, 39,  9, 11, 44, 47,  2,  5, 50, 54,         57, 62,         63, 69,         70                                                                                                             ],
	[ 32, 33, 18, 19, 38, 40, 10, 12, 45, 48,  3,  6, 51, 55,         58,             64,             71,             77,             84                                                                             ],
	[ 33, 34, 19, 20, 39, 41, 11, 13, 46,      4,     52,             59,             65,             72,             78,             85,             91                                                             ],
	[ 34,     20,     40,     12,     47,      5,     53,             60,             66,             73,             79,             86,             92                                                             ],
	[     35,     21,     43,     15,     50,      8,     58,      2,     65,             73,             80,             88,             95                                                                         ],
	[ 35, 36, 21, 22, 42, 44, 14, 16,     51,      9,     59,      3,     66,             74,             81,             89,             96                                                                         ],
	[ 36, 37, 22, 23, 43, 45, 15, 17, 49, 52,  7, 10, 56, 60,  0,  4,     67,             75,             82,             90,             97                                                                         ],
	[ 37, 38, 23, 24, 44, 46, 16, 18, 50, 53,  8, 11, 57, 61,  1,  5, 63, 68,         70, 76,             83                                                                                                         ],
	[ 38, 39, 24, 25, 45, 47, 17, 19, 51, 54,  9, 12, 58, 62,  2,  6, 64, 69,         71,             77,             84                                                                                             ],
	[ 39, 40, 25, 26, 46, 48, 18, 20, 52, 55, 10, 13, 59,      3,     65,             72,             78,             85,             91                                                                             ],
	[ 40, 41, 26, 27, 47,     19,     53,     11,     60,      4,     66,             73,             79,             86,             92                                                                             ],
	[ 42, 43, 28, 29,     50,     22,     58,     16,     65,      9,     73,      3,     80,             88,             95                                                                                         ],
	[ 43, 44, 29, 30, 49, 51, 21, 23, 56, 59, 14, 17,     66,     10,     74,      4,     81,             89,             96                                                                                         ],
	[ 44, 45, 30, 31, 50, 52, 22, 24, 57, 60, 15, 18, 63, 67,  7, 11, 70, 75,  0,  5,     82,             90,             97                                                                                         ],
	[ 45, 46, 31, 32, 51, 53, 23, 25, 58, 61, 16, 19, 64, 68,  8, 12, 71, 76,  1,  6, 77, 83,         84                                                                                                             ],
	[ 46, 47, 32, 33, 52, 54, 24, 26, 59, 62, 17, 20, 65, 69,  9, 13, 72,      2,     78,             85,             91                                                                                             ],
	[ 47, 48, 33, 34, 53, 55, 25, 27, 60,     18,     66,     10,     73,      3,     79,             86,             92                                                                                             ],
	[ 48,     34,     54,     26,     61,     19,     67,     11,     74,      4,     80,             87,             93                                                                                             ],
	[     49,     35,     57,     29,     64,     22,     72,     16,     79,      9,     87,      3,     94                                                                                                         ],
	[ 49, 50, 35, 36, 56, 58, 28, 30,     65,     23,     73,     17,     80,     10,     88,      4,     95                                                                                                         ],
	[ 50, 51, 36, 37, 57, 59, 29, 31, 63, 66, 21, 24, 70, 74, 14, 18,     81,     11,     89,      5,     96                                                                                                         ],
	[ 51, 52, 37, 38, 58, 60, 30, 32, 64, 67, 22, 25, 71, 75, 15, 19, 77, 82,  7, 12, 84, 90,  0,  6,     97                                                                                                         ],
	[ 52, 53, 38, 39, 59, 61, 31, 33, 65, 68, 23, 26, 72, 76, 16, 20, 78, 83,  8, 13, 85,      1,     91                                                                                                             ],
	[ 53, 54, 39, 40, 60, 62, 32, 34, 66, 69, 24, 27, 73,     17,     79,      9,     86,      2,     92                                                                                                             ],
	[ 54, 55, 40, 41, 61,     33,     67,     25,     74,     18,     80,     10,     87,      3,     93                                                                                                             ],
	[ 56, 57, 42, 43,     64,     36,     72,     30,     79,     23,     87,     17,     94,     10,              4                                                                                                 ],
	[ 57, 58, 43, 44, 63, 65, 35, 37, 70, 73, 28, 31,     80,     24,     88,     18,     95,     11,              5                                                                                                 ],
	[ 58, 59, 44, 45, 64, 66, 36, 38, 71, 74, 29, 32, 77, 81, 21, 25, 84, 89, 14, 19,     96,     12,              6                                                                                                 ],
	[ 59, 60, 45, 46, 65, 67, 37, 39, 72, 75, 30, 33, 78, 82, 22, 26, 85, 90, 15, 20, 91, 97,  7, 13,          0                                                                                                     ],
	[ 60, 61, 46, 47, 66, 68, 38, 40, 73, 76, 31, 34, 79, 83, 23, 27, 86,     16,     92,      8,              1                                                                                                     ],
	[ 61, 62, 47, 48, 67, 69, 39, 41, 74,     32,     80,     24,     87,     17,     93,      9,              2                                                                                                     ],
	[ 62,     48,     68,     40,     75,     33,     81,     25,     88,     18,     94,     10,              3                                                                                                     ],
	[     63,     49,     71,     43,     78,     36,     86,     30,     93,     23,             17,             10,              4                                                                                 ],
	[ 63, 64, 49, 50, 70, 72, 42, 44,     79,     37,     87,     31,     94,     24,             18,             11,              5                                                                                 ],
	[ 64, 65, 50, 51, 71, 73, 43, 45, 77, 80, 35, 38, 84, 88, 28, 32,     95,     25,             19,             12,              6                                                                                 ],
	[ 65, 66, 51, 52, 72, 74, 44, 46, 78, 81, 36, 39, 85, 89, 29, 33, 91, 96, 21, 26,         14, 20,             13                                                                                                 ],
	[ 66, 67, 52, 53, 73, 75, 45, 47, 79, 82, 37, 40, 86, 90, 30, 34, 92, 97, 22, 27,         15,              7,              0                                                                                     ],
	[ 67, 68, 53, 54, 74, 76, 46, 48, 80, 83, 38, 41, 87,     31,     93,     23,             16,              8,              1                                                                                     ],
	[ 68, 69, 54, 55, 75,     47,     81,     39,     88,     32,     94,     24,             17,              9,              2                                                                                     ],
	[ 70, 71, 56, 57,     78,     50,     86,     44,     93,     37,             31,             24,             18,             11,              5                                                                 ],
	[ 71, 72, 57, 58, 77, 79, 49, 51, 84, 87, 42, 45,     94,     38,             32,             25,             19,             12,              6                                                                 ],
	[ 72, 73, 58, 59, 78, 80, 50, 52, 85, 88, 43, 46, 91, 95, 35, 39,         28, 33,             26,             20,             13                                                                                 ],
	[ 73, 74, 59, 60, 79, 81, 51, 53, 86, 89, 44, 47, 92, 96, 36, 40,         29, 34,         21, 27,         14                                                                                                     ],
	[ 74, 75, 60, 61, 80, 82, 52, 54, 87, 90, 45, 48, 93, 97, 37, 41,         30,             22,             15,              7,              0                                                                     ],
	[ 75, 76, 61, 62, 81, 83, 53, 55, 88,     46,     94,     38,             31,             23,             16,              8,              1                                                                     ],
	[ 76,     62,     82,     54,     89,     47,     95,     39,             32,             24,             17,              9,              2                                                                     ],
	[     77,     63,     85,     57,     92,     50,             44,             37,             31,             24,             18,             11,              5                                                 ],
	[ 77, 78, 63, 64, 84, 86, 56, 58,     93,     51,             45,             38,             32,             25,             19,             12,              6                                                 ],
	[ 78, 79, 64, 65, 85, 87, 57, 59, 91, 94, 49, 52,         42, 46,             39,             33,             26,             20,             13                                                                 ],
	[ 79, 80, 65, 66, 86, 88, 58, 60, 92, 95, 50, 53,         43, 47,         35, 40,         28, 34,             27                                                                                                 ],
	[ 80, 81, 66, 67, 87, 89, 59, 61, 93, 96, 51, 54,         44, 48,         36, 41,         29,             21,             14                                                                                     ],
	[ 81, 82, 67, 68, 88, 90, 60, 62, 94, 97, 52, 55,         45,             37,             30,             22,             15,              7,              0                                                     ],
	[ 82, 83, 68, 69, 89,     61,     95,     53,             46,             38,             31,             23,             16,              8,              1                                                     ],
	[ 84, 85, 70, 71,     92,     64,             58,             51,             45,             38,             32,             25,             19,             12,              6                                 ],
	[ 85, 86, 71, 72, 91, 93, 63, 65,         56, 59,             52,             46,             39,             33,             26,             20,             13                                                 ],
	[ 86, 87, 72, 73, 92, 94, 64, 66,         57, 60,         49, 53,         42, 47,             40,             34,             27                                                                                 ],
	[ 87, 88, 73, 74, 93, 95, 65, 67,         58, 61,         50, 54,         43, 48,         35, 41,         28                                                                                                     ],
	[ 88, 89, 74, 75, 94, 96, 66, 68,         59, 62,         51, 55,         44,             36,             29,             21,             14                                                                     ],
	[ 89, 90, 75, 76, 95, 97, 67, 69,         60,             52,             45,             37,             30,             22,             15,              7,              0                                     ],
	[ 90,     76,     96,     68,             61,             53,             46,             38,             31,             23,             16,              8,              1                                     ],
	[     91,     77,             71,             64,             58,             51,             45,             38,             32,             25,             19,             12,              6                 ],
	[ 91, 92, 77, 78,         70, 72,             65,             59,             52,             46,             39,             33,             26,             20,             13                                 ],
	[ 92, 93, 78, 79,         71, 73,         63, 66,         56, 60,             53,             47,             40,             34,             27                                                                 ],
	[ 93, 94, 79, 80,         72, 74,         64, 67,         57, 61,         49, 54,         42, 48,             41                                                                                                 ],
	[ 94, 95, 80, 81,         73, 75,         65, 68,         58, 62,         50, 55,         43,             35,             28                                                                                     ],
	[ 95, 96, 81, 82,         74, 76,         66, 69,         59,             51,             44,             36,             29,             21,             14                                                     ],
	[ 96, 97, 82, 83,         75,             67,             60,             52,             45,             37,             30,             22,             15,              7,              0                     ],
	[         84, 85,             78,             72,             65,             59,             52,             46,             39,             33,             26,             20,             13                 ],
	[         85, 86,         77, 79,         70, 73,             66,             60,             53,             47,             40,             34,             27                                                 ],
	[         86, 87,         78, 80,         71, 74,         63, 67,         56, 61,             54,             48,             41                                                                                 ],
	[         87, 88,         79, 81,         72, 75,         64, 68,         57, 62,         49, 55,         42                                                                                                     ],
	[         88, 89,         80, 82,         73, 76,         65, 69,         58,             50,             43,             35,             28                                                                     ],
	[         89, 90,         81, 83,         74,             66,             59,             51,             44,             36,             29,             21,             14                                     ],
	[         90,             82,             75,             67,             60,             52,             45,             37,             30,             22,             15,              7,              0     ],
];

use constant king_beat => [
	[     15,             22,             30,             37,             45,             52,             60,             67,             75,             82,             90,             97         ],
	[ 14, 16,             23,             31,             38,             46,             53,             61,             68,             76,             83                                         ],
	[ 15, 17,         21, 24,         28, 32,             39,             47,             54,             62,             69                                                                         ],
	[ 16, 18,         22, 25,         29, 33,         35, 40,         42, 48,             55                                                                                                         ],
	[ 17, 19,         23, 26,         30, 34,         36, 41,         43,             49,             56                                                                                             ],
	[ 18, 20,         24, 27,         31,             37,             44,             50,             57,             63,             70                                                             ],
	[ 19,             25,             32,             38,             45,             51,             58,             64,             71,             77,             84                             ],
	[     22,             30,             37,             45,             52,             60,             67,             75,             82,             90,             97                         ],
	[ 21, 23,         28, 31,             38,             46,             53,             61,             68,             76,             83                                                         ],
	[ 22, 24,         29, 32,         35, 39,         42, 47,             54,             62,             69                                                                                         ],
	[ 23, 25,         30, 33,         36, 40,         43, 48,         49, 55,         56                                                                                                             ],
	[ 24, 26,         31, 34,         37, 41,         44,             50,             57,             63,             70                                                                             ],
	[ 25, 27,         32,             38,             45,             51,             58,             64,             71,             77,             84                                             ],
	[ 26,             33,             39,             46,             52,             59,             65,             72,             78,             85,             91                             ],
	[     29,      1,     36,             44,             51,             59,             66,             74,             81,             89,             96                                         ],
	[ 28, 30,  0,  2,     37,             45,             52,             60,             67,             75,             82,             90,             97                                         ],
	[ 29, 31,  1,  3, 35, 38,         42, 46,             53,             61,             68,             76,             83                                                                         ],
	[ 30, 32,  2,  4, 36, 39,         43, 47,         49, 54,         56, 62,             69                                                                                                         ],
	[ 31, 33,  3,  5, 37, 40,         44, 48,         50, 55,         57,             63,             70                                                                                             ],
	[ 32, 34,  4,  6, 38, 41,         45,             51,             58,             64,             71,             77,             84                                                             ],
	[ 33,      5,     39,             46,             52,             59,             65,             72,             78,             85,             91                                             ],
	[     36,      8,     44,      2,     51,             59,             66,             74,             81,             89,             96                                                         ],
	[ 35, 37,  7,  9, 42, 45,  0,  3,     52,             60,             67,             75,             82,             90,             97                                                         ],
	[ 36, 38,  8, 10, 43, 46,  1,  4, 49, 53,         56, 61,             68,             76,             83                                                                                         ],
	[ 37, 39,  9, 11, 44, 47,  2,  5, 50, 54,         57, 62,         63, 69,         70                                                                                                             ],
	[ 38, 40, 10, 12, 45, 48,  3,  6, 51, 55,         58,             64,             71,             77,             84                                                                             ],
	[ 39, 41, 11, 13, 46,      4,     52,             59,             65,             72,             78,             85,             91                                                             ],
	[ 40,     12,     47,      5,     53,             60,             66,             73,             79,             86,             92                                                             ],
	[     43,     15,     50,      8,     58,      2,     65,             73,             80,             88,             95                                                                         ],
	[ 42, 44, 14, 16,     51,      9,     59,      3,     66,             74,             81,             89,             96                                                                         ],
	[ 43, 45, 15, 17, 49, 52,  7, 10, 56, 60,  0,  4,     67,             75,             82,             90,             97                                                                         ],
	[ 44, 46, 16, 18, 50, 53,  8, 11, 57, 61,  1,  5, 63, 68,         70, 76,             83                                                                                                         ],
	[ 45, 47, 17, 19, 51, 54,  9, 12, 58, 62,  2,  6, 64, 69,         71,             77,             84                                                                                             ],
	[ 46, 48, 18, 20, 52, 55, 10, 13, 59,      3,     65,             72,             78,             85,             91                                                                             ],
	[ 47,     19,     53,     11,     60,      4,     66,             73,             79,             86,             92                                                                             ],
	[     50,     22,     58,     16,     65,      9,     73,      3,     80,             88,             95                                                                                         ],
	[ 49, 51, 21, 23, 56, 59, 14, 17,     66,     10,     74,      4,     81,             89,             96                                                                                         ],
	[ 50, 52, 22, 24, 57, 60, 15, 18, 63, 67,  7, 11, 70, 75,  0,  5,     82,             90,             97                                                                                         ],
	[ 51, 53, 23, 25, 58, 61, 16, 19, 64, 68,  8, 12, 71, 76,  1,  6, 77, 83,         84                                                                                                             ],
	[ 52, 54, 24, 26, 59, 62, 17, 20, 65, 69,  9, 13, 72,      2,     78,             85,             91                                                                                             ],
	[ 53, 55, 25, 27, 60,     18,     66,     10,     73,      3,     79,             86,             92                                                                                             ],
	[ 54,     26,     61,     19,     67,     11,     74,      4,     80,             87,             93                                                                                             ],
	[     57,     29,     64,     22,     72,     16,     79,      9,     87,      3,     94                                                                                                         ],
	[ 56, 58, 28, 30,     65,     23,     73,     17,     80,     10,     88,      4,     95                                                                                                         ],
	[ 57, 59, 29, 31, 63, 66, 21, 24, 70, 74, 14, 18,     81,     11,     89,      5,     96                                                                                                         ],
	[ 58, 60, 30, 32, 64, 67, 22, 25, 71, 75, 15, 19, 77, 82,  7, 12, 84, 90,  0,  6,     97                                                                                                         ],
	[ 59, 61, 31, 33, 65, 68, 23, 26, 72, 76, 16, 20, 78, 83,  8, 13, 85,      1,     91                                                                                                             ],
	[ 60, 62, 32, 34, 66, 69, 24, 27, 73,     17,     79,      9,     86,      2,     92                                                                                                             ],
	[ 61,     33,     67,     25,     74,     18,     80,     10,     87,      3,     93                                                                                                             ],
	[     64,     36,     72,     30,     79,     23,     87,     17,     94,     10,              4                                                                                                 ],
	[ 63, 65, 35, 37, 70, 73, 28, 31,     80,     24,     88,     18,     95,     11,              5                                                                                                 ],
	[ 64, 66, 36, 38, 71, 74, 29, 32, 77, 81, 21, 25, 84, 89, 14, 19,     96,     12,              6                                                                                                 ],
	[ 65, 67, 37, 39, 72, 75, 30, 33, 78, 82, 22, 26, 85, 90, 15, 20, 91, 97,  7, 13,          0                                                                                                     ],
	[ 66, 68, 38, 40, 73, 76, 31, 34, 79, 83, 23, 27, 86,     16,     92,      8,              1                                                                                                     ],
	[ 67, 69, 39, 41, 74,     32,     80,     24,     87,     17,     93,      9,              2                                                                                                     ],
	[ 68,     40,     75,     33,     81,     25,     88,     18,     94,     10,              3                                                                                                     ],
	[     71,     43,     78,     36,     86,     30,     93,     23,             17,             10,              4                                                                                 ],
	[ 70, 72, 42, 44,     79,     37,     87,     31,     94,     24,             18,             11,              5                                                                                 ],
	[ 71, 73, 43, 45, 77, 80, 35, 38, 84, 88, 28, 32,     95,     25,             19,             12,              6                                                                                 ],
	[ 72, 74, 44, 46, 78, 81, 36, 39, 85, 89, 29, 33, 91, 96, 21, 26,         14, 20,             13                                                                                                 ],
	[ 73, 75, 45, 47, 79, 82, 37, 40, 86, 90, 30, 34, 92, 97, 22, 27,         15,              7,              0                                                                                     ],
	[ 74, 76, 46, 48, 80, 83, 38, 41, 87,     31,     93,     23,             16,              8,              1                                                                                     ],
	[ 75,     47,     81,     39,     88,     32,     94,     24,             17,              9,              2                                                                                     ],
	[     78,     50,     86,     44,     93,     37,             31,             24,             18,             11,              5                                                                 ],
	[ 77, 79, 49, 51, 84, 87, 42, 45,     94,     38,             32,             25,             19,             12,              6                                                                 ],
	[ 78, 80, 50, 52, 85, 88, 43, 46, 91, 95, 35, 39,         28, 33,             26,             20,             13                                                                                 ],
	[ 79, 81, 51, 53, 86, 89, 44, 47, 92, 96, 36, 40,         29, 34,         21, 27,         14                                                                                                     ],
	[ 80, 82, 52, 54, 87, 90, 45, 48, 93, 97, 37, 41,         30,             22,             15,              7,              0                                                                     ],
	[ 81, 83, 53, 55, 88,     46,     94,     38,             31,             23,             16,              8,              1                                                                     ],
	[ 82,     54,     89,     47,     95,     39,             32,             24,             17,              9,              2                                                                     ],
	[     85,     57,     92,     50,             44,             37,             31,             24,             18,             11,              5                                                 ],
	[ 84, 86, 56, 58,     93,     51,             45,             38,             32,             25,             19,             12,              6                                                 ],
	[ 85, 87, 57, 59, 91, 94, 49, 52,         42, 46,             39,             33,             26,             20,             13                                                                 ],
	[ 86, 88, 58, 60, 92, 95, 50, 53,         43, 47,         35, 40,         28, 34,             27                                                                                                 ],
	[ 87, 89, 59, 61, 93, 96, 51, 54,         44, 48,         36, 41,         29,             21,             14                                                                                     ],
	[ 88, 90, 60, 62, 94, 97, 52, 55,         45,             37,             30,             22,             15,              7,              0                                                     ],
	[ 89,     61,     95,     53,             46,             38,             31,             23,             16,              8,              1                                                     ],
	[     92,     64,             58,             51,             45,             38,             32,             25,             19,             12,              6                                 ],
	[ 91, 93, 63, 65,         56, 59,             52,             46,             39,             33,             26,             20,             13                                                 ],
	[ 92, 94, 64, 66,         57, 60,         49, 53,         42, 47,             40,             34,             27                                                                                 ],
	[ 93, 95, 65, 67,         58, 61,         50, 54,         43, 48,         35, 41,         28                                                                                                     ],
	[ 94, 96, 66, 68,         59, 62,         51, 55,         44,             36,             29,             21,             14                                                                     ],
	[ 95, 97, 67, 69,         60,             52,             45,             37,             30,             22,             15,              7,              0                                     ],
	[ 96,     68,             61,             53,             46,             38,             31,             23,             16,              8,              1                                     ],
	[             71,             64,             58,             51,             45,             38,             32,             25,             19,             12,              6                 ],
	[         70, 72,             65,             59,             52,             46,             39,             33,             26,             20,             13                                 ],
	[         71, 73,         63, 66,         56, 60,             53,             47,             40,             34,             27                                                                 ],
	[         72, 74,         64, 67,         57, 61,         49, 54,         42, 48,             41                                                                                                 ],
	[         73, 75,         65, 68,         58, 62,         50, 55,         43,             35,             28                                                                                     ],
	[         74, 76,         66, 69,         59,             51,             44,             36,             29,             21,             14                                                     ],
	[         75,             67,             60,             52,             45,             37,             30,             22,             15,              7,              0                     ],
	[             78,             72,             65,             59,             52,             46,             39,             33,             26,             20,             13                 ],
	[         77, 79,         70, 73,             66,             60,             53,             47,             40,             34,             27                                                 ],
	[         78, 80,         71, 74,         63, 67,         56, 61,             54,             48,             41                                                                                 ],
	[         79, 81,         72, 75,         64, 68,         57, 62,         49, 55,         42                                                                                                     ],
	[         80, 82,         73, 76,         65, 69,         58,             50,             43,             35,             28                                                                     ],
	[         81, 83,         74,             66,             59,             51,             44,             36,             29,             21,             14                                     ],
	[         82,             75,             67,             60,             52,             45,             37,             30,             22,             15,              7,              0     ],
];

use constant king_step_short => [
	[      7         ], [  7,  8         ], [  8,  9         ], [  9, 10         ], [ 10, 11         ], [ 11, 12         ], [ 12, 13         ],
	[ 14, 15,  0,  1 ], [ 15, 16,  1,  2 ], [ 16, 17,  2,  3 ], [ 17, 18,  3,  4 ], [ 18, 19,  4,  5 ], [ 19, 20,  5,  6 ], [ 20,      6     ],
	[     21,      7 ], [ 21, 22,  7,  8 ], [ 22, 23,  8,  9 ], [ 23, 24,  9, 10 ], [ 24, 25, 10, 11 ], [ 25, 26, 11, 12 ], [ 26, 27, 12, 13 ],
	[ 28, 29, 14, 15 ], [ 29, 30, 15, 16 ], [ 30, 31, 16, 17 ], [ 31, 32, 17, 18 ], [ 32, 33, 18, 19 ], [ 33, 34, 19, 20 ], [ 34,     20     ],
	[     35,     21 ], [ 35, 36, 21, 22 ], [ 36, 37, 22, 23 ], [ 37, 38, 23, 24 ], [ 38, 39, 24, 25 ], [ 39, 40, 25, 26 ], [ 40, 41, 26, 27 ],
	[ 42, 43, 28, 29 ], [ 43, 44, 29, 30 ], [ 44, 45, 30, 31 ], [ 45, 46, 31, 32 ], [ 46, 47, 32, 33 ], [ 47, 48, 33, 34 ], [ 48,     34     ],
	[     49,     35 ], [ 49, 50, 35, 36 ], [ 50, 51, 36, 37 ], [ 51, 52, 37, 38 ], [ 52, 53, 38, 39 ], [ 53, 54, 39, 40 ], [ 54, 55, 40, 41 ],
	[ 56, 57, 42, 43 ], [ 57, 58, 43, 44 ], [ 58, 59, 44, 45 ], [ 59, 60, 45, 46 ], [ 60, 61, 46, 47 ], [ 61, 62, 47, 48 ], [ 62,     48     ],
	[     63,     49 ], [ 63, 64, 49, 50 ], [ 64, 65, 50, 51 ], [ 65, 66, 51, 52 ], [ 66, 67, 52, 53 ], [ 67, 68, 53, 54 ], [ 68, 69, 54, 55 ],
	[ 70, 71, 56, 57 ], [ 71, 72, 57, 58 ], [ 72, 73, 58, 59 ], [ 73, 74, 59, 60 ], [ 74, 75, 60, 61 ], [ 75, 76, 61, 62 ], [ 76,     62     ],
	[     77,     63 ], [ 77, 78, 63, 64 ], [ 78, 79, 64, 65 ], [ 79, 80, 65, 66 ], [ 80, 81, 66, 67 ], [ 81, 82, 67, 68 ], [ 82, 83, 68, 69 ],
	[ 84, 85, 70, 71 ], [ 85, 86, 71, 72 ], [ 86, 87, 72, 73 ], [ 87, 88, 73, 74 ], [ 88, 89, 74, 75 ], [ 89, 90, 75, 76 ], [ 90,     76     ],
	[     91,     77 ], [ 91, 92, 77, 78 ], [ 92, 93, 78, 79 ], [ 93, 94, 79, 80 ], [ 94, 95, 80, 81 ], [ 95, 96, 81, 82 ], [ 96, 97, 82, 83 ],
	[         84, 85 ], [         85, 86 ], [         86, 87 ], [         87, 88 ], [         88, 89 ], [         89, 90 ], [         90     ],
];

use constant king_beat_short => [
	[     15         ], [ 14, 16         ], [ 15, 17         ], [ 16, 18         ], [ 17, 19         ], [ 18, 20         ], [ 19             ],
	[     22         ], [ 21, 23         ], [ 22, 24         ], [ 23, 25         ], [ 24, 26         ], [ 25, 27         ], [ 26             ],
	[     29,      1 ], [ 28, 30,  0,  2 ], [ 29, 31,  1,  3 ], [ 30, 32,  2,  4 ], [ 31, 33,  3,  5 ], [ 32, 34,  4,  6 ], [ 33,      5     ],
	[     36,      8 ], [ 35, 37,  7,  9 ], [ 36, 38,  8, 10 ], [ 37, 39,  9, 11 ], [ 38, 40, 10, 12 ], [ 39, 41, 11, 13 ], [ 40,     12     ],
	[     43,     15 ], [ 42, 44, 14, 16 ], [ 43, 45, 15, 17 ], [ 44, 46, 16, 18 ], [ 45, 47, 17, 19 ], [ 46, 48, 18, 20 ], [ 47,     19     ],
	[     50,     22 ], [ 49, 51, 21, 23 ], [ 50, 52, 22, 24 ], [ 51, 53, 23, 25 ], [ 52, 54, 24, 26 ], [ 53, 55, 25, 27 ], [ 54,     26     ],
	[     57,     29 ], [ 56, 58, 28, 30 ], [ 57, 59, 29, 31 ], [ 58, 60, 30, 32 ], [ 59, 61, 31, 33 ], [ 60, 62, 32, 34 ], [ 61,     33     ],
	[     64,     36 ], [ 63, 65, 35, 37 ], [ 64, 66, 36, 38 ], [ 65, 67, 37, 39 ], [ 66, 68, 38, 40 ], [ 67, 69, 39, 41 ], [ 68,     40     ],
	[     71,     43 ], [ 70, 72, 42, 44 ], [ 71, 73, 43, 45 ], [ 72, 74, 44, 46 ], [ 73, 75, 45, 47 ], [ 74, 76, 46, 48 ], [ 75,     47     ],
	[     78,     50 ], [ 77, 79, 49, 51 ], [ 78, 80, 50, 52 ], [ 79, 81, 51, 53 ], [ 80, 82, 52, 54 ], [ 81, 83, 53, 55 ], [ 82,     54     ],
	[     85,     57 ], [ 84, 86, 56, 58 ], [ 85, 87, 57, 59 ], [ 86, 88, 58, 60 ], [ 87, 89, 59, 61 ], [ 88, 90, 60, 62 ], [ 89,     61     ],
	[     92,     64 ], [ 91, 93, 63, 65 ], [ 92, 94, 64, 66 ], [ 93, 95, 65, 67 ], [ 94, 96, 66, 68 ], [ 95, 97, 67, 69 ], [ 96,     68     ],
	[             71 ], [         70, 72 ], [         71, 73 ], [         72, 74 ], [         73, 75 ], [         74, 76 ], [         75     ],
	[             78 ], [         77, 79 ], [         78, 80 ], [         79, 81 ], [         80, 82 ], [         81, 83 ], [         82     ],
];

use constant king_beat_8dirs => [
	[     15,                 28,  2,     22,                 42,  3,     30,                 56,  4,     37,                 70,  5,     45,                 84,  6,     52,                             60,                             67,                             75,                             82,                             90,                             97                         ],
	[ 14, 16,                 29,  3,     23,                 43,  4,     31,                 57,  5,     38,                 71,  6,     46,                 85,         53,                             61,                             68,                             76,                             83                                                                                         ],
	[ 15, 17,              0, 30,  4, 21, 24,                 44,  5, 28, 32,                 58,  6,     39,                 72,         47,                 86,         54,                             62,                             69                                                                                                                                                         ],
	[ 16, 18,              1, 31,  5, 22, 25,              0, 45,  6, 29, 33,                 59,     35, 40,                 73,     42, 48,                 87,         55                                                                                                                                                                                                                         ],
	[ 17, 19,              2, 32,  6, 23, 26,              1, 46,     30, 34,              0, 60,     36, 41,                 74,     43,                     88,     49,                             56                                                                                                                                                                                             ],
	[ 18, 20,              3, 33,     24, 27,              2, 47,     31,                  1, 61,     37,                  0, 75,     44,                     89,     50,                             57,                             63,                             70                                                                                                                             ],
	[ 19,                  4, 34,     25,                  3, 48,     32,                  2, 62,     38,                  1, 76,     45,                  0, 90,     51,                             58,                             64,                             71,                             77,                             84                                                             ],
	[     22,                 35,  9,     30,                 49, 10,     37,                 63, 11,     45,                 77, 12,     52,                 91, 13,     60,                             67,                             75,                             82,                             90,                             97                                                         ],
	[ 21, 23,                 36, 10, 28, 31,                 50, 11,     38,                 64, 12,     46,                 78, 13,     53,                 92,         61,                             68,                             76,                             83                                                                                                                         ],
	[ 22, 24,              7, 37, 11, 29, 32,                 51, 12, 35, 39,                 65, 13, 42, 47,                 79,         54,                 93,         62,                             69                                                                                                                                                                                         ],
	[ 23, 25,              8, 38, 12, 30, 33,              7, 52, 13, 36, 40,                 66,     43, 48,                 80,     49, 55,                 94,     56                                                                                                                                                                                                                             ],
	[ 24, 26,              9, 39, 13, 31, 34,              8, 53,     37, 41,              7, 67,     44,                     81,     50,                     95,     57,                             63,                             70                                                                                                                                                             ],
	[ 25, 27,             10, 40,     32,                  9, 54,     38,                  8, 68,     45,                  7, 82,     51,                     96,     58,                             64,                             71,                             77,                             84                                                                                             ],
	[ 26,                 11, 41,     33,                 10, 55,     39,                  9, 69,     46,                  8, 83,     52,                  7, 97,     59,                             65,                             72,                             78,                             85,                             91                                                             ],
	[     29,      1,         42, 16,     36,                 56, 17,     44,                 70, 18,     51,                 84, 19,     59,                     20,     66,                             74,                             81,                             89,                             96                                                                                         ],
	[ 28, 30,  0,  2,         43, 17,     37,                 57, 18,     45,                 71, 19,     52,                 85, 20,     60,                             67,                             75,                             82,                             90,                             97                                                                                         ],
	[ 29, 31,  1,  3,     14, 44, 18, 35, 38,                 58, 19, 42, 46,                 72, 20,     53,                 86,         61,                             68,                             76,                             83                                                                                                                                                         ],
	[ 30, 32,  2,  4,     15, 45, 19, 36, 39,             14, 59, 20, 43, 47,                 73,     49, 54,                 87,     56, 62,                             69                                                                                                                                                                                                                         ],
	[ 31, 33,  3,  5,     16, 46, 20, 37, 40,             15, 60,     44, 48,             14, 74,     50, 55,                 88,     57,                             63,                             70                                                                                                                                                                                             ],
	[ 32, 34,  4,  6,     17, 47,     38, 41,             16, 61,     45,                 15, 75,     51,                 14, 89,     58,                             64,                             71,                             77,                             84                                                                                                                             ],
	[ 33,      5,         18, 48,     39,                 17, 62,     46,                 16, 76,     52,                 15, 90,     59,                 14,         65,                             72,                             78,                             85,                             91                                                                                             ],
	[     36,      8,         49, 23,     44,      2,         63, 24,     51,                 77, 25,     59,                 91, 26,     66,                     27,     74,                             81,                             89,                             96                                                                                                                         ],
	[ 35, 37,  7,  9,         50, 24, 42, 45,  0,  3,         64, 25,     52,                 78, 26,     60,                 92, 27,     67,                             75,                             82,                             90,                             97                                                                                                                         ],
	[ 36, 38,  8, 10,     21, 51, 25, 43, 46,  1,  4,         65, 26, 49, 53,                 79, 27, 56, 61,                 93,         68,                             76,                             83                                                                                                                                                                                         ],
	[ 37, 39,  9, 11,     22, 52, 26, 44, 47,  2,  5,     21, 66, 27, 50, 54,                 80,     57, 62,                 94,     63, 69,                         70                                                                                                                                                                                                                             ],
	[ 38, 40, 10, 12,     23, 53, 27, 45, 48,  3,  6,     22, 67,     51, 55,             21, 81,     58,                     95,     64,                             71,                             77,                             84                                                                                                                                                             ],
	[ 39, 41, 11, 13,     24, 54,     46,      4,         23, 68,     52,                 22, 82,     59,                 21, 96,     65,                             72,                             78,                             85,                             91                                                                                                                             ],
	[ 40,     12,         25, 55,     47,      5,         24, 69,     53,                 23, 83,     60,                 22, 97,     66,                 21,         73,                             79,                             86,                             92                                                                                                                             ],
	[     43,     15,  0,     56, 30,     50,      8,         70, 31,     58,      2,         84, 32,     65,                     33,     73,                     34,     80,                             88,                             95                                                                                                                                                         ],
	[ 42, 44, 14, 16,  1,     57, 31,     51,      9,         71, 32,     59,      3,         85, 33,     66,                     34,     74,                             81,                             89,                             96                                                                                                                                                         ],
	[ 43, 45, 15, 17,  2, 28, 58, 32, 49, 52,  7, 10,         72, 33, 56, 60,  0,  4,         86, 34,     67,                             75,                             82,                             90,                             97                                                                                                                                                         ],
	[ 44, 46, 16, 18,  3, 29, 59, 33, 50, 53,  8, 11,     28, 73, 34, 57, 61,  1,  5,         87,     63, 68,                         70, 76,                             83                                                                                                                                                                                                                         ],
	[ 45, 47, 17, 19,  4, 30, 60, 34, 51, 54,  9, 12,     29, 74,     58, 62,  2,  6,     28, 88,     64, 69,                         71,                             77,                             84                                                                                                                                                                                             ],
	[ 46, 48, 18, 20,  5, 31, 61,     52, 55, 10, 13,     30, 75,     59,      3,         29, 89,     65,                 28,         72,                             78,                             85,                             91                                                                                                                                                             ],
	[ 47,     19,      6, 32, 62,     53,     11,         31, 76,     60,      4,         30, 90,     66,                 29,         73,                 28,         79,                             86,                             92                                                                                                                                                             ],
	[     50,     22,  7,     63, 37,     58,     16,         77, 38,     65,      9,         91, 39,     73,      3,             40,     80,                     41,     88,                             95                                                                                                                                                                                         ],
	[ 49, 51, 21, 23,  8,     64, 38, 56, 59, 14, 17,         78, 39,     66,     10,         92, 40,     74,      4,             41,     81,                             89,                             96                                                                                                                                                                                         ],
	[ 50, 52, 22, 24,  9, 35, 65, 39, 57, 60, 15, 18,         79, 40, 63, 67,  7, 11,         93, 41, 70, 75,  0,  5,                     82,                             90,                             97                                                                                                                                                                                         ],
	[ 51, 53, 23, 25, 10, 36, 66, 40, 58, 61, 16, 19,     35, 80, 41, 64, 68,  8, 12,         94,     71, 76,  1,  6,                 77, 83,                         84                                                                                                                                                                                                                             ],
	[ 52, 54, 24, 26, 11, 37, 67, 41, 59, 62, 17, 20,     36, 81,     65, 69,  9, 13,     35, 95,     72,      2,                     78,                             85,                             91                                                                                                                                                                                             ],
	[ 53, 55, 25, 27, 12, 38, 68,     60,     18,         37, 82,     66,     10,         36, 96,     73,      3,         35,         79,                             86,                             92                                                                                                                                                                                             ],
	[ 54,     26,     13, 39, 69,     61,     19,         38, 83,     67,     11,         37, 97,     74,      4,         36,         80,                 35,         87,                             93                                                                                                                                                                                             ],
	[     57,     29, 14,     70, 44,     64,     22,  0,     84, 45,     72,     16,             46,     79,      9,             47,     87,      3,             48,     94                                                                                                                                                                                                                         ],
	[ 56, 58, 28, 30, 15,     71, 45,     65,     23,  1,     85, 46,     73,     17,             47,     80,     10,             48,     88,      4,                     95                                                                                                                                                                                                                         ],
	[ 57, 59, 29, 31, 16, 42, 72, 46, 63, 66, 21, 24,  2,     86, 47, 70, 74, 14, 18,             48,     81,     11,                     89,      5,                     96                                                                                                                                                                                                                         ],
	[ 58, 60, 30, 32, 17, 43, 73, 47, 64, 67, 22, 25,  3, 42, 87, 48, 71, 75, 15, 19,                 77, 82,  7, 12,                 84, 90,  0,  6,                     97                                                                                                                                                                                                                         ],
	[ 59, 61, 31, 33, 18, 44, 74, 48, 65, 68, 23, 26,  4, 43, 88,     72, 76, 16, 20,     42,         78, 83,  8, 13,                 85,      1,                     91                                                                                                                                                                                                                             ],
	[ 60, 62, 32, 34, 19, 45, 75,     66, 69, 24, 27,  5, 44, 89,     73,     17,         43,         79,      9,         42,         86,      2,                     92                                                                                                                                                                                                                             ],
	[ 61,     33,     20, 46, 76,     67,     25,      6, 45, 90,     74,     18,         44,         80,     10,         43,         87,      3,         42,         93                                                                                                                                                                                                                             ],
	[     64,     36, 21,     77, 51,     72,     30,  7,     91, 52,     79,     23,             53,     87,     17,             54,     94,     10,             55,              4                                                                                                                                                                                                                 ],
	[ 63, 65, 35, 37, 22,     78, 52, 70, 73, 28, 31,  8,     92, 53,     80,     24,             54,     88,     18,             55,     95,     11,                              5                                                                                                                                                                                                                 ],
	[ 64, 66, 36, 38, 23, 49, 79, 53, 71, 74, 29, 32,  9,     93, 54, 77, 81, 21, 25,             55, 84, 89, 14, 19,                     96,     12,                              6                                                                                                                                                                                                                 ],
	[ 65, 67, 37, 39, 24, 50, 80, 54, 72, 75, 30, 33, 10, 49, 94, 55, 78, 82, 22, 26,                 85, 90, 15, 20,                 91, 97,  7, 13,                          0                                                                                                                                                                                                                     ],
	[ 66, 68, 38, 40, 25, 51, 81, 55, 73, 76, 31, 34, 11, 50, 95,     79, 83, 23, 27,     49,         86,     16,                     92,      8,                              1                                                                                                                                                                                                                     ],
	[ 67, 69, 39, 41, 26, 52, 82,     74,     32,     12, 51, 96,     80,     24,         50,         87,     17,         49,         93,      9,                              2                                                                                                                                                                                                                     ],
	[ 68,     40,     27, 53, 83,     75,     33,     13, 52, 97,     81,     25,         51,         88,     18,         50,         94,     10,         49,                  3                                                                                                                                                                                                                     ],
	[     71,     43, 28,     84, 58,     78,     36, 14,         59,     86,     30,  0,         60,     93,     23,             61,             17,             62,             10,                              4                                                                                                                                                                                 ],
	[ 70, 72, 42, 44, 29,     85, 59,     79,     37, 15,         60,     87,     31,  1,         61,     94,     24,             62,             18,                             11,                              5                                                                                                                                                                                 ],
	[ 71, 73, 43, 45, 30, 56, 86, 60, 77, 80, 35, 38, 16,         61, 84, 88, 28, 32,  2,         62,     95,     25,                             19,                             12,                              6                                                                                                                                                                                 ],
	[ 72, 74, 44, 46, 31, 57, 87, 61, 78, 81, 36, 39, 17, 56,     62, 85, 89, 29, 33,  3,             91, 96, 21, 26,                         14, 20,                             13                                                                                                                                                                                                                 ],
	[ 73, 75, 45, 47, 32, 58, 88, 62, 79, 82, 37, 40, 18, 57,         86, 90, 30, 34,  4, 56,         92, 97, 22, 27,                         15,                              7,                              0                                                                                                                                                                                     ],
	[ 74, 76, 46, 48, 33, 59, 89,     80, 83, 38, 41, 19, 58,         87,     31,      5, 57,         93,     23,         56,                 16,                              8,                              1                                                                                                                                                                                     ],
	[ 75,     47,     34, 60, 90,     81,     39,     20, 59,         88,     32,      6, 58,         94,     24,         57,                 17,         56,                  9,                              2                                                                                                                                                                                     ],
	[     78,     50, 35,     91, 65,     86,     44, 21,         66,     93,     37,  7,         67,             31,             68,             24,             69,             18,                             11,                              5                                                                                                                                                 ],
	[ 77, 79, 49, 51, 36,     92, 66, 84, 87, 42, 45, 22,         67,     94,     38,  8,         68,             32,             69,             25,                             19,                             12,                              6                                                                                                                                                 ],
	[ 78, 80, 50, 52, 37, 63, 93, 67, 85, 88, 43, 46, 23,         68, 91, 95, 35, 39,  9,         69,         28, 33,                             26,                             20,                             13                                                                                                                                                                                 ],
	[ 79, 81, 51, 53, 38, 64, 94, 68, 86, 89, 44, 47, 24, 63,     69, 92, 96, 36, 40, 10,                     29, 34,                         21, 27,                         14                                                                                                                                                                                                                     ],
	[ 80, 82, 52, 54, 39, 65, 95, 69, 87, 90, 45, 48, 25, 64,         93, 97, 37, 41, 11, 63,                 30,                             22,                             15,                              7,                              0                                                                                                                                                     ],
	[ 81, 83, 53, 55, 40, 66, 96,     88,     46,     26, 65,         94,     38,     12, 64,                 31,         63,                 23,                             16,                              8,                              1                                                                                                                                                     ],
	[ 82,     54,     41, 67, 97,     89,     47,     27, 66,         95,     39,     13, 65,                 32,         64,                 24,         63,                 17,                              9,                              2                                                                                                                                                     ],
	[     85,     57, 42,         72,     92,     50, 28,         73,             44, 14,         74,             37,  0,         75,             31,             76,             24,                             18,                             11,                              5                                                                                                                 ],
	[ 84, 86, 56, 58, 43,         73,     93,     51, 29,         74,             45, 15,         75,             38,  1,         76,             32,                             25,                             19,                             12,                              6                                                                                                                 ],
	[ 85, 87, 57, 59, 44, 70,     74, 91, 94, 49, 52, 30,         75,         42, 46, 16,         76,             39,  2,                         33,                             26,                             20,                             13                                                                                                                                                 ],
	[ 86, 88, 58, 60, 45, 71,     75, 92, 95, 50, 53, 31, 70,     76,         43, 47, 17,                     35, 40,  3,                     28, 34,                             27                                                                                                                                                                                                                 ],
	[ 87, 89, 59, 61, 46, 72,     76, 93, 96, 51, 54, 32, 71,                 44, 48, 18, 70,                 36, 41,  4,                     29,                             21,                             14                                                                                                                                                                                     ],
	[ 88, 90, 60, 62, 47, 73,         94, 97, 52, 55, 33, 72,                 45,     19, 71,                 37,      5, 70,                 30,                             22,                             15,                              7,                              0                                                                                                                     ],
	[ 89,     61,     48, 74,         95,     53,     34, 73,                 46,     20, 72,                 38,      6, 71,                 31,         70,                 23,                             16,                              8,                              1                                                                                                                     ],
	[     92,     64, 49,         79,             58, 35,         80,             51, 21,         81,             45,  7,         82,             38,             83,             32,                             25,                             19,                             12,                              6                                                                                 ],
	[ 91, 93, 63, 65, 50,         80,         56, 59, 36,         81,             52, 22,         82,             46,  8,         83,             39,                             33,                             26,                             20,                             13                                                                                                                 ],
	[ 92, 94, 64, 66, 51, 77,     81,         57, 60, 37,         82,         49, 53, 23,         83,         42, 47,  9,                         40,                             34,                             27                                                                                                                                                                                 ],
	[ 93, 95, 65, 67, 52, 78,     82,         58, 61, 38, 77,     83,         50, 54, 24,                     43, 48, 10,                     35, 41,                         28                                                                                                                                                                                                                     ],
	[ 94, 96, 66, 68, 53, 79,     83,         59, 62, 39, 78,                 51, 55, 25, 77,                 44,     11,                     36,                             29,                             21,                             14                                                                                                                                                     ],
	[ 95, 97, 67, 69, 54, 80,                 60,     40, 79,                 52,     26, 78,                 45,     12, 77,                 37,                             30,                             22,                             15,                              7,                              0                                                                                     ],
	[ 96,     68,     55, 81,                 61,     41, 80,                 53,     27, 79,                 46,     13, 78,                 38,         77,                 31,                             23,                             16,                              8,                              1                                                                                     ],
	[             71, 56,         86,             64, 42,         87,             58, 28,         88,             51, 14,         89,             45,  0,         90,             38,                             32,                             25,                             19,                             12,                              6                                                 ],
	[         70, 72, 57,         87,             65, 43,         88,             59, 29,         89,             52, 15,         90,             46,  1,                         39,                             33,                             26,                             20,                             13                                                                                 ],
	[         71, 73, 58, 84,     88,         63, 66, 44,         89,         56, 60, 30,         90,             53, 16,                         47,  2,                         40,                             34,                             27                                                                                                                                                 ],
	[         72, 74, 59, 85,     89,         64, 67, 45, 84,     90,         57, 61, 31,                     49, 54, 17,                     42, 48,  3,                         41                                                                                                                                                                                                                 ],
	[         73, 75, 60, 86,     90,         65, 68, 46, 85,                 58, 62, 32, 84,                 50, 55, 18,                     43,      4,                     35,                             28                                                                                                                                                                                     ],
	[         74, 76, 61, 87,                 66, 69, 47, 86,                 59,     33, 85,                 51,     19, 84,                 44,      5,                     36,                             29,                             21,                             14                                                                                                                     ],
	[         75,     62, 88,                 67,     48, 87,                 60,     34, 86,                 52,     20, 85,                 45,      6, 84,                 37,                             30,                             22,                             15,                              7,                              0                                                     ],
	[             78, 63,         93,             72, 49,         94,             65, 35,         95,             59, 21,         96,             52,  7,         97,             46,                             39,                             33,                             26,                             20,                             13                                                 ],
	[         77, 79, 64,         94,         70, 73, 50,         95,             66, 36,         96,             60, 22,         97,             53,  8,                         47,                             40,                             34,                             27                                                                                                                 ],
	[         78, 80, 65, 91,     95,         71, 74, 51,         96,         63, 67, 37,         97,         56, 61, 23,                         54,  9,                         48,                             41                                                                                                                                                                                 ],
	[         79, 81, 66, 92,     96,         72, 75, 52, 91,     97,         64, 68, 38,                     57, 62, 24,                     49, 55, 10,                     42                                                                                                                                                                                                                     ],
	[         80, 82, 67, 93,     97,         73, 76, 53, 92,                 65, 69, 39, 91,                 58,     25,                     50,     11,                     43,                             35,                             28                                                                                                                                                     ],
	[         81, 83, 68, 94,                 74,     54, 93,                 66,     40, 92,                 59,     26, 91,                 51,     12,                     44,                             36,                             29,                             21,                             14                                                                                     ],
	[         82,     69, 95,                 75,     55, 94,                 67,     41, 93,                 60,     27, 92,                 52,     13, 91,                 45,                             37,                             30,                             22,                             15,                              7,                              0                     ],
];

use constant enclosed_locs => [
	{ 15 => [  7 ], 22 => [  7, 15 ], 30 => [  7, 15, 22 ], 37 => [  7, 15, 22, 30 ], 45 => [  7, 15, 22, 30, 37 ], 52 => [  7, 15, 22, 30, 37, 45 ], 60 => [  7, 15, 22, 30, 37, 45, 52 ], 67 => [  7, 15, 22, 30, 37, 45, 52, 60 ], 75 => [  7, 15, 22, 30, 37, 45, 52, 60, 67 ], 82 => [  7, 15, 22, 30, 37, 45, 52, 60, 67, 75 ], 90 => [  7, 15, 22, 30, 37, 45, 52, 60, 67, 75, 82 ], 97 => [  7, 15, 22, 30, 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{ 14 => [  7 ], 16 => [  8 ], 23 => [  8, 16 ], 31 => [  8, 16, 23 ], 38 => [  8, 16, 23, 31 ], 46 => [  8, 16, 23, 31, 38 ], 53 => [  8, 16, 23, 31, 38, 46 ], 61 => [  8, 16, 23, 31, 38, 46, 53 ], 68 => [  8, 16, 23, 31, 38, 46, 53, 61 ], 76 => [  8, 16, 23, 31, 38, 46, 53, 61, 68 ], 83 => [  8, 16, 23, 31, 38, 46, 53, 61, 68, 76 ] },
	{ 15 => [  8 ], 17 => [  9 ], 21 => [  8, 15 ], 24 => [  9, 17 ], 28 => [  8, 15, 21 ], 32 => [  9, 17, 24 ], 39 => [  9, 17, 24, 32 ], 47 => [  9, 17, 24, 32, 39 ], 54 => [  9, 17, 24, 32, 39, 47 ], 62 => [  9, 17, 24, 32, 39, 47, 54 ], 69 => [  9, 17, 24, 32, 39, 47, 54, 62 ] },
	{ 16 => [  9 ], 18 => [ 10 ], 22 => [  9, 16 ], 25 => [ 10, 18 ], 29 => [  9, 16, 22 ], 33 => [ 10, 18, 25 ], 35 => [  9, 16, 22, 29 ], 40 => [ 10, 18, 25, 33 ], 42 => [  9, 16, 22, 29, 35 ], 48 => [ 10, 18, 25, 33, 40 ], 55 => [ 10, 18, 25, 33, 40, 48 ] },
	{ 17 => [ 10 ], 19 => [ 11 ], 23 => [ 10, 17 ], 26 => [ 11, 19 ], 30 => [ 10, 17, 23 ], 34 => [ 11, 19, 26 ], 36 => [ 10, 17, 23, 30 ], 41 => [ 11, 19, 26, 34 ], 43 => [ 10, 17, 23, 30, 36 ], 49 => [ 10, 17, 23, 30, 36, 43 ], 56 => [ 10, 17, 23, 30, 36, 43, 49 ] },
	{ 18 => [ 11 ], 20 => [ 12 ], 24 => [ 11, 18 ], 27 => [ 12, 20 ], 31 => [ 11, 18, 24 ], 37 => [ 11, 18, 24, 31 ], 44 => [ 11, 18, 24, 31, 37 ], 50 => [ 11, 18, 24, 31, 37, 44 ], 57 => [ 11, 18, 24, 31, 37, 44, 50 ], 63 => [ 11, 18, 24, 31, 37, 44, 50, 57 ], 70 => [ 11, 18, 24, 31, 37, 44, 50, 57, 63 ] },
	{ 19 => [ 12 ], 25 => [ 12, 19 ], 32 => [ 12, 19, 25 ], 38 => [ 12, 19, 25, 32 ], 45 => [ 12, 19, 25, 32, 38 ], 51 => [ 12, 19, 25, 32, 38, 45 ], 58 => [ 12, 19, 25, 32, 38, 45, 51 ], 64 => [ 12, 19, 25, 32, 38, 45, 51, 58 ], 71 => [ 12, 19, 25, 32, 38, 45, 51, 58, 64 ], 77 => [ 12, 19, 25, 32, 38, 45, 51, 58, 64, 71 ], 84 => [ 12, 19, 25, 32, 38, 45, 51, 58, 64, 71, 77 ] },
	{ 22 => [ 15 ], 30 => [ 15, 22 ], 37 => [ 15, 22, 30 ], 45 => [ 15, 22, 30, 37 ], 52 => [ 15, 22, 30, 37, 45 ], 60 => [ 15, 22, 30, 37, 45, 52 ], 67 => [ 15, 22, 30, 37, 45, 52, 60 ], 75 => [ 15, 22, 30, 37, 45, 52, 60, 67 ], 82 => [ 15, 22, 30, 37, 45, 52, 60, 67, 75 ], 90 => [ 15, 22, 30, 37, 45, 52, 60, 67, 75, 82 ], 97 => [ 15, 22, 30, 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{ 21 => [ 15 ], 23 => [ 16 ], 28 => [ 15, 21 ], 31 => [ 16, 23 ], 38 => [ 16, 23, 31 ], 46 => [ 16, 23, 31, 38 ], 53 => [ 16, 23, 31, 38, 46 ], 61 => [ 16, 23, 31, 38, 46, 53 ], 68 => [ 16, 23, 31, 38, 46, 53, 61 ], 76 => [ 16, 23, 31, 38, 46, 53, 61, 68 ], 83 => [ 16, 23, 31, 38, 46, 53, 61, 68, 76 ] },
	{ 22 => [ 16 ], 24 => [ 17 ], 29 => [ 16, 22 ], 32 => [ 17, 24 ], 35 => [ 16, 22, 29 ], 39 => [ 17, 24, 32 ], 42 => [ 16, 22, 29, 35 ], 47 => [ 17, 24, 32, 39 ], 54 => [ 17, 24, 32, 39, 47 ], 62 => [ 17, 24, 32, 39, 47, 54 ], 69 => [ 17, 24, 32, 39, 47, 54, 62 ] },
	{ 23 => [ 17 ], 25 => [ 18 ], 30 => [ 17, 23 ], 33 => [ 18, 25 ], 36 => [ 17, 23, 30 ], 40 => [ 18, 25, 33 ], 43 => [ 17, 23, 30, 36 ], 48 => [ 18, 25, 33, 40 ], 49 => [ 17, 23, 30, 36, 43 ], 55 => [ 18, 25, 33, 40, 48 ], 56 => [ 17, 23, 30, 36, 43, 49 ] },
	{ 24 => [ 18 ], 26 => [ 19 ], 31 => [ 18, 24 ], 34 => [ 19, 26 ], 37 => [ 18, 24, 31 ], 41 => [ 19, 26, 34 ], 44 => [ 18, 24, 31, 37 ], 50 => [ 18, 24, 31, 37, 44 ], 57 => [ 18, 24, 31, 37, 44, 50 ], 63 => [ 18, 24, 31, 37, 44, 50, 57 ], 70 => [ 18, 24, 31, 37, 44, 50, 57, 63 ] },
	{ 25 => [ 19 ], 27 => [ 20 ], 32 => [ 19, 25 ], 38 => [ 19, 25, 32 ], 45 => [ 19, 25, 32, 38 ], 51 => [ 19, 25, 32, 38, 45 ], 58 => [ 19, 25, 32, 38, 45, 51 ], 64 => [ 19, 25, 32, 38, 45, 51, 58 ], 71 => [ 19, 25, 32, 38, 45, 51, 58, 64 ], 77 => [ 19, 25, 32, 38, 45, 51, 58, 64, 71 ], 84 => [ 19, 25, 32, 38, 45, 51, 58, 64, 71, 77 ] },
	{ 26 => [ 20 ], 33 => [ 20, 26 ], 39 => [ 20, 26, 33 ], 46 => [ 20, 26, 33, 39 ], 52 => [ 20, 26, 33, 39, 46 ], 59 => [ 20, 26, 33, 39, 46, 52 ], 65 => [ 20, 26, 33, 39, 46, 52, 59 ], 72 => [ 20, 26, 33, 39, 46, 52, 59, 65 ], 78 => [ 20, 26, 33, 39, 46, 52, 59, 65, 72 ], 85 => [ 20, 26, 33, 39, 46, 52, 59, 65, 72, 78 ], 91 => [ 20, 26, 33, 39, 46, 52, 59, 65, 72, 78, 85 ] },
	{  1 => [  7 ], 29 => [ 21 ], 36 => [ 21, 29 ], 44 => [ 21, 29, 36 ], 51 => [ 21, 29, 36, 44 ], 59 => [ 21, 29, 36, 44, 51 ], 66 => [ 21, 29, 36, 44, 51, 59 ], 74 => [ 21, 29, 36, 44, 51, 59, 66 ], 81 => [ 21, 29, 36, 44, 51, 59, 66, 74 ], 89 => [ 21, 29, 36, 44, 51, 59, 66, 74, 81 ], 96 => [ 21, 29, 36, 44, 51, 59, 66, 74, 81, 89 ] },
	{  0 => [  7 ],  2 => [  8 ], 28 => [ 21 ], 30 => [ 22 ], 37 => [ 22, 30 ], 45 => [ 22, 30, 37 ], 52 => [ 22, 30, 37, 45 ], 60 => [ 22, 30, 37, 45, 52 ], 67 => [ 22, 30, 37, 45, 52, 60 ], 75 => [ 22, 30, 37, 45, 52, 60, 67 ], 82 => [ 22, 30, 37, 45, 52, 60, 67, 75 ], 90 => [ 22, 30, 37, 45, 52, 60, 67, 75, 82 ], 97 => [ 22, 30, 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{  1 => [  8 ],  3 => [  9 ], 29 => [ 22 ], 31 => [ 23 ], 35 => [ 22, 29 ], 38 => [ 23, 31 ], 42 => [ 22, 29, 35 ], 46 => [ 23, 31, 38 ], 53 => [ 23, 31, 38, 46 ], 61 => [ 23, 31, 38, 46, 53 ], 68 => [ 23, 31, 38, 46, 53, 61 ], 76 => [ 23, 31, 38, 46, 53, 61, 68 ], 83 => [ 23, 31, 38, 46, 53, 61, 68, 76 ] },
	{  2 => [  9 ],  4 => [ 10 ], 30 => [ 23 ], 32 => [ 24 ], 36 => [ 23, 30 ], 39 => [ 24, 32 ], 43 => [ 23, 30, 36 ], 47 => [ 24, 32, 39 ], 49 => [ 23, 30, 36, 43 ], 54 => [ 24, 32, 39, 47 ], 56 => [ 23, 30, 36, 43, 49 ], 62 => [ 24, 32, 39, 47, 54 ], 69 => [ 24, 32, 39, 47, 54, 62 ] },
	{  3 => [ 10 ],  5 => [ 11 ], 31 => [ 24 ], 33 => [ 25 ], 37 => [ 24, 31 ], 40 => [ 25, 33 ], 44 => [ 24, 31, 37 ], 48 => [ 25, 33, 40 ], 50 => [ 24, 31, 37, 44 ], 55 => [ 25, 33, 40, 48 ], 57 => [ 24, 31, 37, 44, 50 ], 63 => [ 24, 31, 37, 44, 50, 57 ], 70 => [ 24, 31, 37, 44, 50, 57, 63 ] },
	{  4 => [ 11 ],  6 => [ 12 ], 32 => [ 25 ], 34 => [ 26 ], 38 => [ 25, 32 ], 41 => [ 26, 34 ], 45 => [ 25, 32, 38 ], 51 => [ 25, 32, 38, 45 ], 58 => [ 25, 32, 38, 45, 51 ], 64 => [ 25, 32, 38, 45, 51, 58 ], 71 => [ 25, 32, 38, 45, 51, 58, 64 ], 77 => [ 25, 32, 38, 45, 51, 58, 64, 71 ], 84 => [ 25, 32, 38, 45, 51, 58, 64, 71, 77 ] },
	{  5 => [ 12 ], 33 => [ 26 ], 39 => [ 26, 33 ], 46 => [ 26, 33, 39 ], 52 => [ 26, 33, 39, 46 ], 59 => [ 26, 33, 39, 46, 52 ], 65 => [ 26, 33, 39, 46, 52, 59 ], 72 => [ 26, 33, 39, 46, 52, 59, 65 ], 78 => [ 26, 33, 39, 46, 52, 59, 65, 72 ], 85 => [ 26, 33, 39, 46, 52, 59, 65, 72, 78 ], 91 => [ 26, 33, 39, 46, 52, 59, 65, 72, 78, 85 ] },
	{  2 => [ 15,  8 ],  8 => [ 15 ], 36 => [ 29 ], 44 => [ 29, 36 ], 51 => [ 29, 36, 44 ], 59 => [ 29, 36, 44, 51 ], 66 => [ 29, 36, 44, 51, 59 ], 74 => [ 29, 36, 44, 51, 59, 66 ], 81 => [ 29, 36, 44, 51, 59, 66, 74 ], 89 => [ 29, 36, 44, 51, 59, 66, 74, 81 ], 96 => [ 29, 36, 44, 51, 59, 66, 74, 81, 89 ] },
	{  0 => [ 15,  7 ],  3 => [ 16,  9 ],  7 => [ 15 ],  9 => [ 16 ], 35 => [ 29 ], 37 => [ 30 ], 42 => [ 29, 35 ], 45 => [ 30, 37 ], 52 => [ 30, 37, 45 ], 60 => [ 30, 37, 45, 52 ], 67 => [ 30, 37, 45, 52, 60 ], 75 => [ 30, 37, 45, 52, 60, 67 ], 82 => [ 30, 37, 45, 52, 60, 67, 75 ], 90 => [ 30, 37, 45, 52, 60, 67, 75, 82 ], 97 => [ 30, 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{  1 => [ 16,  8 ],  4 => [ 17, 10 ],  8 => [ 16 ], 10 => [ 17 ], 36 => [ 30 ], 38 => [ 31 ], 43 => [ 30, 36 ], 46 => [ 31, 38 ], 49 => [ 30, 36, 43 ], 53 => [ 31, 38, 46 ], 56 => [ 30, 36, 43, 49 ], 61 => [ 31, 38, 46, 53 ], 68 => [ 31, 38, 46, 53, 61 ], 76 => [ 31, 38, 46, 53, 61, 68 ], 83 => [ 31, 38, 46, 53, 61, 68, 76 ] },
	{  2 => [ 17,  9 ],  5 => [ 18, 11 ],  9 => [ 17 ], 11 => [ 18 ], 37 => [ 31 ], 39 => [ 32 ], 44 => [ 31, 37 ], 47 => [ 32, 39 ], 50 => [ 31, 37, 44 ], 54 => [ 32, 39, 47 ], 57 => [ 31, 37, 44, 50 ], 62 => [ 32, 39, 47, 54 ], 63 => [ 31, 37, 44, 50, 57 ], 69 => [ 32, 39, 47, 54, 62 ], 70 => [ 31, 37, 44, 50, 57, 63 ] },
	{  3 => [ 18, 10 ],  6 => [ 19, 12 ], 10 => [ 18 ], 12 => [ 19 ], 38 => [ 32 ], 40 => [ 33 ], 45 => [ 32, 38 ], 48 => [ 33, 40 ], 51 => [ 32, 38, 45 ], 55 => [ 33, 40, 48 ], 58 => [ 32, 38, 45, 51 ], 64 => [ 32, 38, 45, 51, 58 ], 71 => [ 32, 38, 45, 51, 58, 64 ], 77 => [ 32, 38, 45, 51, 58, 64, 71 ], 84 => [ 32, 38, 45, 51, 58, 64, 71, 77 ] },
	{  4 => [ 19, 11 ], 11 => [ 19 ], 13 => [ 20 ], 39 => [ 33 ], 41 => [ 34 ], 46 => [ 33, 39 ], 52 => [ 33, 39, 46 ], 59 => [ 33, 39, 46, 52 ], 65 => [ 33, 39, 46, 52, 59 ], 72 => [ 33, 39, 46, 52, 59, 65 ], 78 => [ 33, 39, 46, 52, 59, 65, 72 ], 85 => [ 33, 39, 46, 52, 59, 65, 72, 78 ], 91 => [ 33, 39, 46, 52, 59, 65, 72, 78, 85 ] },
	{  5 => [ 20, 12 ], 12 => [ 20 ], 40 => [ 34 ], 47 => [ 34, 40 ], 53 => [ 34, 40, 47 ], 60 => [ 34, 40, 47, 53 ], 66 => [ 34, 40, 47, 53, 60 ], 73 => [ 34, 40, 47, 53, 60, 66 ], 79 => [ 34, 40, 47, 53, 60, 66, 73 ], 86 => [ 34, 40, 47, 53, 60, 66, 73, 79 ], 92 => [ 34, 40, 47, 53, 60, 66, 73, 79, 86 ] },
	{  2 => [ 21, 15,  8 ],  8 => [ 21, 15 ], 15 => [ 21 ], 43 => [ 35 ], 50 => [ 35, 43 ], 58 => [ 35, 43, 50 ], 65 => [ 35, 43, 50, 58 ], 73 => [ 35, 43, 50, 58, 65 ], 80 => [ 35, 43, 50, 58, 65, 73 ], 88 => [ 35, 43, 50, 58, 65, 73, 80 ], 95 => [ 35, 43, 50, 58, 65, 73, 80, 88 ] },
	{  3 => [ 22, 16,  9 ],  9 => [ 22, 16 ], 14 => [ 21 ], 16 => [ 22 ], 42 => [ 35 ], 44 => [ 36 ], 51 => [ 36, 44 ], 59 => [ 36, 44, 51 ], 66 => [ 36, 44, 51, 59 ], 74 => [ 36, 44, 51, 59, 66 ], 81 => [ 36, 44, 51, 59, 66, 74 ], 89 => [ 36, 44, 51, 59, 66, 74, 81 ], 96 => [ 36, 44, 51, 59, 66, 74, 81, 89 ] },
	{  0 => [ 22, 15,  7 ],  4 => [ 23, 17, 10 ],  7 => [ 22, 15 ], 10 => [ 23, 17 ], 15 => [ 22 ], 17 => [ 23 ], 43 => [ 36 ], 45 => [ 37 ], 49 => [ 36, 43 ], 52 => [ 37, 45 ], 56 => [ 36, 43, 49 ], 60 => [ 37, 45, 52 ], 67 => [ 37, 45, 52, 60 ], 75 => [ 37, 45, 52, 60, 67 ], 82 => [ 37, 45, 52, 60, 67, 75 ], 90 => [ 37, 45, 52, 60, 67, 75, 82 ], 97 => [ 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{  1 => [ 23, 16,  8 ],  5 => [ 24, 18, 11 ],  8 => [ 23, 16 ], 11 => [ 24, 18 ], 16 => [ 23 ], 18 => [ 24 ], 44 => [ 37 ], 46 => [ 38 ], 50 => [ 37, 44 ], 53 => [ 38, 46 ], 57 => [ 37, 44, 50 ], 61 => [ 38, 46, 53 ], 63 => [ 37, 44, 50, 57 ], 68 => [ 38, 46, 53, 61 ], 70 => [ 37, 44, 50, 57, 63 ], 76 => [ 38, 46, 53, 61, 68 ], 83 => [ 38, 46, 53, 61, 68, 76 ] },
	{  2 => [ 24, 17,  9 ],  6 => [ 25, 19, 12 ],  9 => [ 24, 17 ], 12 => [ 25, 19 ], 17 => [ 24 ], 19 => [ 25 ], 45 => [ 38 ], 47 => [ 39 ], 51 => [ 38, 45 ], 54 => [ 39, 47 ], 58 => [ 38, 45, 51 ], 62 => [ 39, 47, 54 ], 64 => [ 38, 45, 51, 58 ], 69 => [ 39, 47, 54, 62 ], 71 => [ 38, 45, 51, 58, 64 ], 77 => [ 38, 45, 51, 58, 64, 71 ], 84 => [ 38, 45, 51, 58, 64, 71, 77 ] },
	{  3 => [ 25, 18, 10 ], 10 => [ 25, 18 ], 13 => [ 26, 20 ], 18 => [ 25 ], 20 => [ 26 ], 46 => [ 39 ], 48 => [ 40 ], 52 => [ 39, 46 ], 55 => [ 40, 48 ], 59 => [ 39, 46, 52 ], 65 => [ 39, 46, 52, 59 ], 72 => [ 39, 46, 52, 59, 65 ], 78 => [ 39, 46, 52, 59, 65, 72 ], 85 => [ 39, 46, 52, 59, 65, 72, 78 ], 91 => [ 39, 46, 52, 59, 65, 72, 78, 85 ] },
	{  4 => [ 26, 19, 11 ], 11 => [ 26, 19 ], 19 => [ 26 ], 47 => [ 40 ], 53 => [ 40, 47 ], 60 => [ 40, 47, 53 ], 66 => [ 40, 47, 53, 60 ], 73 => [ 40, 47, 53, 60, 66 ], 79 => [ 40, 47, 53, 60, 66, 73 ], 86 => [ 40, 47, 53, 60, 66, 73, 79 ], 92 => [ 40, 47, 53, 60, 66, 73, 79, 86 ] },
	{  3 => [ 29, 22, 16,  9 ],  9 => [ 29, 22, 16 ], 16 => [ 29, 22 ], 22 => [ 29 ], 50 => [ 43 ], 58 => [ 43, 50 ], 65 => [ 43, 50, 58 ], 73 => [ 43, 50, 58, 65 ], 80 => [ 43, 50, 58, 65, 73 ], 88 => [ 43, 50, 58, 65, 73, 80 ], 95 => [ 43, 50, 58, 65, 73, 80, 88 ] },
	{  4 => [ 30, 23, 17, 10 ], 10 => [ 30, 23, 17 ], 14 => [ 29, 21 ], 17 => [ 30, 23 ], 21 => [ 29 ], 23 => [ 30 ], 49 => [ 43 ], 51 => [ 44 ], 56 => [ 43, 49 ], 59 => [ 44, 51 ], 66 => [ 44, 51, 59 ], 74 => [ 44, 51, 59, 66 ], 81 => [ 44, 51, 59, 66, 74 ], 89 => [ 44, 51, 59, 66, 74, 81 ], 96 => [ 44, 51, 59, 66, 74, 81, 89 ] },
	{  0 => [ 30, 22, 15,  7 ],  5 => [ 31, 24, 18, 11 ],  7 => [ 30, 22, 15 ], 11 => [ 31, 24, 18 ], 15 => [ 30, 22 ], 18 => [ 31, 24 ], 22 => [ 30 ], 24 => [ 31 ], 50 => [ 44 ], 52 => [ 45 ], 57 => [ 44, 50 ], 60 => [ 45, 52 ], 63 => [ 44, 50, 57 ], 67 => [ 45, 52, 60 ], 70 => [ 44, 50, 57, 63 ], 75 => [ 45, 52, 60, 67 ], 82 => [ 45, 52, 60, 67, 75 ], 90 => [ 45, 52, 60, 67, 75, 82 ], 97 => [ 45, 52, 60, 67, 75, 82, 90 ] },
	{  1 => [ 31, 23, 16,  8 ],  6 => [ 32, 25, 19, 12 ],  8 => [ 31, 23, 16 ], 12 => [ 32, 25, 19 ], 16 => [ 31, 23 ], 19 => [ 32, 25 ], 23 => [ 31 ], 25 => [ 32 ], 51 => [ 45 ], 53 => [ 46 ], 58 => [ 45, 51 ], 61 => [ 46, 53 ], 64 => [ 45, 51, 58 ], 68 => [ 46, 53, 61 ], 71 => [ 45, 51, 58, 64 ], 76 => [ 46, 53, 61, 68 ], 77 => [ 45, 51, 58, 64, 71 ], 83 => [ 46, 53, 61, 68, 76 ], 84 => [ 45, 51, 58, 64, 71, 77 ] },
	{  2 => [ 32, 24, 17,  9 ],  9 => [ 32, 24, 17 ], 13 => [ 33, 26, 20 ], 17 => [ 32, 24 ], 20 => [ 33, 26 ], 24 => [ 32 ], 26 => [ 33 ], 52 => [ 46 ], 54 => [ 47 ], 59 => [ 46, 52 ], 62 => [ 47, 54 ], 65 => [ 46, 52, 59 ], 69 => [ 47, 54, 62 ], 72 => [ 46, 52, 59, 65 ], 78 => [ 46, 52, 59, 65, 72 ], 85 => [ 46, 52, 59, 65, 72, 78 ], 91 => [ 46, 52, 59, 65, 72, 78, 85 ] },
	{  3 => [ 33, 25, 18, 10 ], 10 => [ 33, 25, 18 ], 18 => [ 33, 25 ], 25 => [ 33 ], 27 => [ 34 ], 53 => [ 47 ], 55 => [ 48 ], 60 => [ 47, 53 ], 66 => [ 47, 53, 60 ], 73 => [ 47, 53, 60, 66 ], 79 => [ 47, 53, 60, 66, 73 ], 86 => [ 47, 53, 60, 66, 73, 79 ], 92 => [ 47, 53, 60, 66, 73, 79, 86 ] },
	{  4 => [ 34, 26, 19, 11 ], 11 => [ 34, 26, 19 ], 19 => [ 34, 26 ], 26 => [ 34 ], 54 => [ 48 ], 61 => [ 48, 54 ], 67 => [ 48, 54, 61 ], 74 => [ 48, 54, 61, 67 ], 80 => [ 48, 54, 61, 67, 74 ], 87 => [ 48, 54, 61, 67, 74, 80 ], 93 => [ 48, 54, 61, 67, 74, 80, 87 ] },
	{  3 => [ 35, 29, 22, 16,  9 ],  9 => [ 35, 29, 22, 16 ], 16 => [ 35, 29, 22 ], 22 => [ 35, 29 ], 29 => [ 35 ], 57 => [ 49 ], 64 => [ 49, 57 ], 72 => [ 49, 57, 64 ], 79 => [ 49, 57, 64, 72 ], 87 => [ 49, 57, 64, 72, 79 ], 94 => [ 49, 57, 64, 72, 79, 87 ] },
	{  4 => [ 36, 30, 23, 17, 10 ], 10 => [ 36, 30, 23, 17 ], 17 => [ 36, 30, 23 ], 23 => [ 36, 30 ], 28 => [ 35 ], 30 => [ 36 ], 56 => [ 49 ], 58 => [ 50 ], 65 => [ 50, 58 ], 73 => [ 50, 58, 65 ], 80 => [ 50, 58, 65, 73 ], 88 => [ 50, 58, 65, 73, 80 ], 95 => [ 50, 58, 65, 73, 80, 88 ] },
	{  5 => [ 37, 31, 24, 18, 11 ], 11 => [ 37, 31, 24, 18 ], 14 => [ 36, 29, 21 ], 18 => [ 37, 31, 24 ], 21 => [ 36, 29 ], 24 => [ 37, 31 ], 29 => [ 36 ], 31 => [ 37 ], 57 => [ 50 ], 59 => [ 51 ], 63 => [ 50, 57 ], 66 => [ 51, 59 ], 70 => [ 50, 57, 63 ], 74 => [ 51, 59, 66 ], 81 => [ 51, 59, 66, 74 ], 89 => [ 51, 59, 66, 74, 81 ], 96 => [ 51, 59, 66, 74, 81, 89 ] },
	{  0 => [ 37, 30, 22, 15,  7 ],  6 => [ 38, 32, 25, 19, 12 ],  7 => [ 37, 30, 22, 15 ], 12 => [ 38, 32, 25, 19 ], 15 => [ 37, 30, 22 ], 19 => [ 38, 32, 25 ], 22 => [ 37, 30 ], 25 => [ 38, 32 ], 30 => [ 37 ], 32 => [ 38 ], 58 => [ 51 ], 60 => [ 52 ], 64 => [ 51, 58 ], 67 => [ 52, 60 ], 71 => [ 51, 58, 64 ], 75 => [ 52, 60, 67 ], 77 => [ 51, 58, 64, 71 ], 82 => [ 52, 60, 67, 75 ], 84 => [ 51, 58, 64, 71, 77 ], 90 => [ 52, 60, 67, 75, 82 ], 97 => [ 52, 60, 67, 75, 82, 90 ] },
	{  1 => [ 38, 31, 23, 16,  8 ],  8 => [ 38, 31, 23, 16 ], 13 => [ 39, 33, 26, 20 ], 16 => [ 38, 31, 23 ], 20 => [ 39, 33, 26 ], 23 => [ 38, 31 ], 26 => [ 39, 33 ], 31 => [ 38 ], 33 => [ 39 ], 59 => [ 52 ], 61 => [ 53 ], 65 => [ 52, 59 ], 68 => [ 53, 61 ], 72 => [ 52, 59, 65 ], 76 => [ 53, 61, 68 ], 78 => [ 52, 59, 65, 72 ], 83 => [ 53, 61, 68, 76 ], 85 => [ 52, 59, 65, 72, 78 ], 91 => [ 52, 59, 65, 72, 78, 85 ] },
	{  2 => [ 39, 32, 24, 17,  9 ],  9 => [ 39, 32, 24, 17 ], 17 => [ 39, 32, 24 ], 24 => [ 39, 32 ], 27 => [ 40, 34 ], 32 => [ 39 ], 34 => [ 40 ], 60 => [ 53 ], 62 => [ 54 ], 66 => [ 53, 60 ], 69 => [ 54, 62 ], 73 => [ 53, 60, 66 ], 79 => [ 53, 60, 66, 73 ], 86 => [ 53, 60, 66, 73, 79 ], 92 => [ 53, 60, 66, 73, 79, 86 ] },
	{  3 => [ 40, 33, 25, 18, 10 ], 10 => [ 40, 33, 25, 18 ], 18 => [ 40, 33, 25 ], 25 => [ 40, 33 ], 33 => [ 40 ], 61 => [ 54 ], 67 => [ 54, 61 ], 74 => [ 54, 61, 67 ], 80 => [ 54, 61, 67, 74 ], 87 => [ 54, 61, 67, 74, 80 ], 93 => [ 54, 61, 67, 74, 80, 87 ] },
	{  4 => [ 43, 36, 30, 23, 17, 10 ], 10 => [ 43, 36, 30, 23, 17 ], 17 => [ 43, 36, 30, 23 ], 23 => [ 43, 36, 30 ], 30 => [ 43, 36 ], 36 => [ 43 ], 64 => [ 57 ], 72 => [ 57, 64 ], 79 => [ 57, 64, 72 ], 87 => [ 57, 64, 72, 79 ], 94 => [ 57, 64, 72, 79, 87 ] },
	{  5 => [ 44, 37, 31, 24, 18, 11 ], 11 => [ 44, 37, 31, 24, 18 ], 18 => [ 44, 37, 31, 24 ], 24 => [ 44, 37, 31 ], 28 => [ 43, 35 ], 31 => [ 44, 37 ], 35 => [ 43 ], 37 => [ 44 ], 63 => [ 57 ], 65 => [ 58 ], 70 => [ 57, 63 ], 73 => [ 58, 65 ], 80 => [ 58, 65, 73 ], 88 => [ 58, 65, 73, 80 ], 95 => [ 58, 65, 73, 80, 88 ] },
	{  6 => [ 45, 38, 32, 25, 19, 12 ], 12 => [ 45, 38, 32, 25, 19 ], 14 => [ 44, 36, 29, 21 ], 19 => [ 45, 38, 32, 25 ], 21 => [ 44, 36, 29 ], 25 => [ 45, 38, 32 ], 29 => [ 44, 36 ], 32 => [ 45, 38 ], 36 => [ 44 ], 38 => [ 45 ], 64 => [ 58 ], 66 => [ 59 ], 71 => [ 58, 64 ], 74 => [ 59, 66 ], 77 => [ 58, 64, 71 ], 81 => [ 59, 66, 74 ], 84 => [ 58, 64, 71, 77 ], 89 => [ 59, 66, 74, 81 ], 96 => [ 59, 66, 74, 81, 89 ] },
	{  0 => [ 45, 37, 30, 22, 15,  7 ],  7 => [ 45, 37, 30, 22, 15 ], 13 => [ 46, 39, 33, 26, 20 ], 15 => [ 45, 37, 30, 22 ], 20 => [ 46, 39, 33, 26 ], 22 => [ 45, 37, 30 ], 26 => [ 46, 39, 33 ], 30 => [ 45, 37 ], 33 => [ 46, 39 ], 37 => [ 45 ], 39 => [ 46 ], 65 => [ 59 ], 67 => [ 60 ], 72 => [ 59, 65 ], 75 => [ 60, 67 ], 78 => [ 59, 65, 72 ], 82 => [ 60, 67, 75 ], 85 => [ 59, 65, 72, 78 ], 90 => [ 60, 67, 75, 82 ], 91 => [ 59, 65, 72, 78, 85 ], 97 => [ 60, 67, 75, 82, 90 ] },
	{  1 => [ 46, 38, 31, 23, 16,  8 ],  8 => [ 46, 38, 31, 23, 16 ], 16 => [ 46, 38, 31, 23 ], 23 => [ 46, 38, 31 ], 27 => [ 47, 40, 34 ], 31 => [ 46, 38 ], 34 => [ 47, 40 ], 38 => [ 46 ], 40 => [ 47 ], 66 => [ 60 ], 68 => [ 61 ], 73 => [ 60, 66 ], 76 => [ 61, 68 ], 79 => [ 60, 66, 73 ], 83 => [ 61, 68, 76 ], 86 => [ 60, 66, 73, 79 ], 92 => [ 60, 66, 73, 79, 86 ] },
	{  2 => [ 47, 39, 32, 24, 17,  9 ],  9 => [ 47, 39, 32, 24, 17 ], 17 => [ 47, 39, 32, 24 ], 24 => [ 47, 39, 32 ], 32 => [ 47, 39 ], 39 => [ 47 ], 41 => [ 48 ], 67 => [ 61 ], 69 => [ 62 ], 74 => [ 61, 67 ], 80 => [ 61, 67, 74 ], 87 => [ 61, 67, 74, 80 ], 93 => [ 61, 67, 74, 80, 87 ] },
	{  3 => [ 48, 40, 33, 25, 18, 10 ], 10 => [ 48, 40, 33, 25, 18 ], 18 => [ 48, 40, 33, 25 ], 25 => [ 48, 40, 33 ], 33 => [ 48, 40 ], 40 => [ 48 ], 68 => [ 62 ], 75 => [ 62, 68 ], 81 => [ 62, 68, 75 ], 88 => [ 62, 68, 75, 81 ], 94 => [ 62, 68, 75, 81, 88 ] },
	{  4 => [ 49, 43, 36, 30, 23, 17, 10 ], 10 => [ 49, 43, 36, 30, 23, 17 ], 17 => [ 49, 43, 36, 30, 23 ], 23 => [ 49, 43, 36, 30 ], 30 => [ 49, 43, 36 ], 36 => [ 49, 43 ], 43 => [ 49 ], 71 => [ 63 ], 78 => [ 63, 71 ], 86 => [ 63, 71, 78 ], 93 => [ 63, 71, 78, 86 ] },
	{  5 => [ 50, 44, 37, 31, 24, 18, 11 ], 11 => [ 50, 44, 37, 31, 24, 18 ], 18 => [ 50, 44, 37, 31, 24 ], 24 => [ 50, 44, 37, 31 ], 31 => [ 50, 44, 37 ], 37 => [ 50, 44 ], 42 => [ 49 ], 44 => [ 50 ], 70 => [ 63 ], 72 => [ 64 ], 79 => [ 64, 72 ], 87 => [ 64, 72, 79 ], 94 => [ 64, 72, 79, 87 ] },
	{  6 => [ 51, 45, 38, 32, 25, 19, 12 ], 12 => [ 51, 45, 38, 32, 25, 19 ], 19 => [ 51, 45, 38, 32, 25 ], 25 => [ 51, 45, 38, 32 ], 28 => [ 50, 43, 35 ], 32 => [ 51, 45, 38 ], 35 => [ 50, 43 ], 38 => [ 51, 45 ], 43 => [ 50 ], 45 => [ 51 ], 71 => [ 64 ], 73 => [ 65 ], 77 => [ 64, 71 ], 80 => [ 65, 73 ], 84 => [ 64, 71, 77 ], 88 => [ 65, 73, 80 ], 95 => [ 65, 73, 80, 88 ] },
	{ 13 => [ 52, 46, 39, 33, 26, 20 ], 14 => [ 51, 44, 36, 29, 21 ], 20 => [ 52, 46, 39, 33, 26 ], 21 => [ 51, 44, 36, 29 ], 26 => [ 52, 46, 39, 33 ], 29 => [ 51, 44, 36 ], 33 => [ 52, 46, 39 ], 36 => [ 51, 44 ], 39 => [ 52, 46 ], 44 => [ 51 ], 46 => [ 52 ], 72 => [ 65 ], 74 => [ 66 ], 78 => [ 65, 72 ], 81 => [ 66, 74 ], 85 => [ 65, 72, 78 ], 89 => [ 66, 74, 81 ], 91 => [ 65, 72, 78, 85 ], 96 => [ 66, 74, 81, 89 ] },
	{  0 => [ 52, 45, 37, 30, 22, 15,  7 ],  7 => [ 52, 45, 37, 30, 22, 15 ], 15 => [ 52, 45, 37, 30, 22 ], 22 => [ 52, 45, 37, 30 ], 27 => [ 53, 47, 40, 34 ], 30 => [ 52, 45, 37 ], 34 => [ 53, 47, 40 ], 37 => [ 52, 45 ], 40 => [ 53, 47 ], 45 => [ 52 ], 47 => [ 53 ], 73 => [ 66 ], 75 => [ 67 ], 79 => [ 66, 73 ], 82 => [ 67, 75 ], 86 => [ 66, 73, 79 ], 90 => [ 67, 75, 82 ], 92 => [ 66, 73, 79, 86 ], 97 => [ 67, 75, 82, 90 ] },
	{  1 => [ 53, 46, 38, 31, 23, 16,  8 ],  8 => [ 53, 46, 38, 31, 23, 16 ], 16 => [ 53, 46, 38, 31, 23 ], 23 => [ 53, 46, 38, 31 ], 31 => [ 53, 46, 38 ], 38 => [ 53, 46 ], 41 => [ 54, 48 ], 46 => [ 53 ], 48 => [ 54 ], 74 => [ 67 ], 76 => [ 68 ], 80 => [ 67, 74 ], 83 => [ 68, 76 ], 87 => [ 67, 74, 80 ], 93 => [ 67, 74, 80, 87 ] },
	{  2 => [ 54, 47, 39, 32, 24, 17,  9 ],  9 => [ 54, 47, 39, 32, 24, 17 ], 17 => [ 54, 47, 39, 32, 24 ], 24 => [ 54, 47, 39, 32 ], 32 => [ 54, 47, 39 ], 39 => [ 54, 47 ], 47 => [ 54 ], 75 => [ 68 ], 81 => [ 68, 75 ], 88 => [ 68, 75, 81 ], 94 => [ 68, 75, 81, 88 ] },
	{  5 => [ 57, 50, 44, 37, 31, 24, 18, 11 ], 11 => [ 57, 50, 44, 37, 31, 24, 18 ], 18 => [ 57, 50, 44, 37, 31, 24 ], 24 => [ 57, 50, 44, 37, 31 ], 31 => [ 57, 50, 44, 37 ], 37 => [ 57, 50, 44 ], 44 => [ 57, 50 ], 50 => [ 57 ], 78 => [ 71 ], 86 => [ 71, 78 ], 93 => [ 71, 78, 86 ] },
	{  6 => [ 58, 51, 45, 38, 32, 25, 19, 12 ], 12 => [ 58, 51, 45, 38, 32, 25, 19 ], 19 => [ 58, 51, 45, 38, 32, 25 ], 25 => [ 58, 51, 45, 38, 32 ], 32 => [ 58, 51, 45, 38 ], 38 => [ 58, 51, 45 ], 42 => [ 57, 49 ], 45 => [ 58, 51 ], 49 => [ 57 ], 51 => [ 58 ], 77 => [ 71 ], 79 => [ 72 ], 84 => [ 71, 77 ], 87 => [ 72, 79 ], 94 => [ 72, 79, 87 ] },
	{ 13 => [ 59, 52, 46, 39, 33, 26, 20 ], 20 => [ 59, 52, 46, 39, 33, 26 ], 26 => [ 59, 52, 46, 39, 33 ], 28 => [ 58, 50, 43, 35 ], 33 => [ 59, 52, 46, 39 ], 35 => [ 58, 50, 43 ], 39 => [ 59, 52, 46 ], 43 => [ 58, 50 ], 46 => [ 59, 52 ], 50 => [ 58 ], 52 => [ 59 ], 78 => [ 72 ], 80 => [ 73 ], 85 => [ 72, 78 ], 88 => [ 73, 80 ], 91 => [ 72, 78, 85 ], 95 => [ 73, 80, 88 ] },
	{ 14 => [ 59, 51, 44, 36, 29, 21 ], 21 => [ 59, 51, 44, 36, 29 ], 27 => [ 60, 53, 47, 40, 34 ], 29 => [ 59, 51, 44, 36 ], 34 => [ 60, 53, 47, 40 ], 36 => [ 59, 51, 44 ], 40 => [ 60, 53, 47 ], 44 => [ 59, 51 ], 47 => [ 60, 53 ], 51 => [ 59 ], 53 => [ 60 ], 79 => [ 73 ], 81 => [ 74 ], 86 => [ 73, 79 ], 89 => [ 74, 81 ], 92 => [ 73, 79, 86 ], 96 => [ 74, 81, 89 ] },
	{  0 => [ 60, 52, 45, 37, 30, 22, 15,  7 ],  7 => [ 60, 52, 45, 37, 30, 22, 15 ], 15 => [ 60, 52, 45, 37, 30, 22 ], 22 => [ 60, 52, 45, 37, 30 ], 30 => [ 60, 52, 45, 37 ], 37 => [ 60, 52, 45 ], 41 => [ 61, 54, 48 ], 45 => [ 60, 52 ], 48 => [ 61, 54 ], 52 => [ 60 ], 54 => [ 61 ], 80 => [ 74 ], 82 => [ 75 ], 87 => [ 74, 80 ], 90 => [ 75, 82 ], 93 => [ 74, 80, 87 ], 97 => [ 75, 82, 90 ] },
	{  1 => [ 61, 53, 46, 38, 31, 23, 16,  8 ],  8 => [ 61, 53, 46, 38, 31, 23, 16 ], 16 => [ 61, 53, 46, 38, 31, 23 ], 23 => [ 61, 53, 46, 38, 31 ], 31 => [ 61, 53, 46, 38 ], 38 => [ 61, 53, 46 ], 46 => [ 61, 53 ], 53 => [ 61 ], 55 => [ 62 ], 81 => [ 75 ], 83 => [ 76 ], 88 => [ 75, 81 ], 94 => [ 75, 81, 88 ] },
	{  2 => [ 62, 54, 47, 39, 32, 24, 17,  9 ],  9 => [ 62, 54, 47, 39, 32, 24, 17 ], 17 => [ 62, 54, 47, 39, 32, 24 ], 24 => [ 62, 54, 47, 39, 32 ], 32 => [ 62, 54, 47, 39 ], 39 => [ 62, 54, 47 ], 47 => [ 62, 54 ], 54 => [ 62 ], 82 => [ 76 ], 89 => [ 76, 82 ], 95 => [ 76, 82, 89 ] },
	{  5 => [ 63, 57, 50, 44, 37, 31, 24, 18, 11 ], 11 => [ 63, 57, 50, 44, 37, 31, 24, 18 ], 18 => [ 63, 57, 50, 44, 37, 31, 24 ], 24 => [ 63, 57, 50, 44, 37, 31 ], 31 => [ 63, 57, 50, 44, 37 ], 37 => [ 63, 57, 50, 44 ], 44 => [ 63, 57, 50 ], 50 => [ 63, 57 ], 57 => [ 63 ], 85 => [ 77 ], 92 => [ 77, 85 ] },
	{  6 => [ 64, 58, 51, 45, 38, 32, 25, 19, 12 ], 12 => [ 64, 58, 51, 45, 38, 32, 25, 19 ], 19 => [ 64, 58, 51, 45, 38, 32, 25 ], 25 => [ 64, 58, 51, 45, 38, 32 ], 32 => [ 64, 58, 51, 45, 38 ], 38 => [ 64, 58, 51, 45 ], 45 => [ 64, 58, 51 ], 51 => [ 64, 58 ], 56 => [ 63 ], 58 => [ 64 ], 84 => [ 77 ], 86 => [ 78 ], 93 => [ 78, 86 ] },
	{ 13 => [ 65, 59, 52, 46, 39, 33, 26, 20 ], 20 => [ 65, 59, 52, 46, 39, 33, 26 ], 26 => [ 65, 59, 52, 46, 39, 33 ], 33 => [ 65, 59, 52, 46, 39 ], 39 => [ 65, 59, 52, 46 ], 42 => [ 64, 57, 49 ], 46 => [ 65, 59, 52 ], 49 => [ 64, 57 ], 52 => [ 65, 59 ], 57 => [ 64 ], 59 => [ 65 ], 85 => [ 78 ], 87 => [ 79 ], 91 => [ 78, 85 ], 94 => [ 79, 87 ] },
	{ 27 => [ 66, 60, 53, 47, 40, 34 ], 28 => [ 65, 58, 50, 43, 35 ], 34 => [ 66, 60, 53, 47, 40 ], 35 => [ 65, 58, 50, 43 ], 40 => [ 66, 60, 53, 47 ], 43 => [ 65, 58, 50 ], 47 => [ 66, 60, 53 ], 50 => [ 65, 58 ], 53 => [ 66, 60 ], 58 => [ 65 ], 60 => [ 66 ], 86 => [ 79 ], 88 => [ 80 ], 92 => [ 79, 86 ], 95 => [ 80, 88 ] },
	{ 14 => [ 66, 59, 51, 44, 36, 29, 21 ], 21 => [ 66, 59, 51, 44, 36, 29 ], 29 => [ 66, 59, 51, 44, 36 ], 36 => [ 66, 59, 51, 44 ], 41 => [ 67, 61, 54, 48 ], 44 => [ 66, 59, 51 ], 48 => [ 67, 61, 54 ], 51 => [ 66, 59 ], 54 => [ 67, 61 ], 59 => [ 66 ], 61 => [ 67 ], 87 => [ 80 ], 89 => [ 81 ], 93 => [ 80, 87 ], 96 => [ 81, 89 ] },
	{  0 => [ 67, 60, 52, 45, 37, 30, 22, 15,  7 ],  7 => [ 67, 60, 52, 45, 37, 30, 22, 15 ], 15 => [ 67, 60, 52, 45, 37, 30, 22 ], 22 => [ 67, 60, 52, 45, 37, 30 ], 30 => [ 67, 60, 52, 45, 37 ], 37 => [ 67, 60, 52, 45 ], 45 => [ 67, 60, 52 ], 52 => [ 67, 60 ], 55 => [ 68, 62 ], 60 => [ 67 ], 62 => [ 68 ], 88 => [ 81 ], 90 => [ 82 ], 94 => [ 81, 88 ], 97 => [ 82, 90 ] },
	{  1 => [ 68, 61, 53, 46, 38, 31, 23, 16,  8 ],  8 => [ 68, 61, 53, 46, 38, 31, 23, 16 ], 16 => [ 68, 61, 53, 46, 38, 31, 23 ], 23 => [ 68, 61, 53, 46, 38, 31 ], 31 => [ 68, 61, 53, 46, 38 ], 38 => [ 68, 61, 53, 46 ], 46 => [ 68, 61, 53 ], 53 => [ 68, 61 ], 61 => [ 68 ], 89 => [ 82 ], 95 => [ 82, 89 ] },
	{  6 => [ 71, 64, 58, 51, 45, 38, 32, 25, 19, 12 ], 12 => [ 71, 64, 58, 51, 45, 38, 32, 25, 19 ], 19 => [ 71, 64, 58, 51, 45, 38, 32, 25 ], 25 => [ 71, 64, 58, 51, 45, 38, 32 ], 32 => [ 71, 64, 58, 51, 45, 38 ], 38 => [ 71, 64, 58, 51, 45 ], 45 => [ 71, 64, 58, 51 ], 51 => [ 71, 64, 58 ], 58 => [ 71, 64 ], 64 => [ 71 ], 92 => [ 85 ] },
	{ 13 => [ 72, 65, 59, 52, 46, 39, 33, 26, 20 ], 20 => [ 72, 65, 59, 52, 46, 39, 33, 26 ], 26 => [ 72, 65, 59, 52, 46, 39, 33 ], 33 => [ 72, 65, 59, 52, 46, 39 ], 39 => [ 72, 65, 59, 52, 46 ], 46 => [ 72, 65, 59, 52 ], 52 => [ 72, 65, 59 ], 56 => [ 71, 63 ], 59 => [ 72, 65 ], 63 => [ 71 ], 65 => [ 72 ], 91 => [ 85 ], 93 => [ 86 ] },
	{ 27 => [ 73, 66, 60, 53, 47, 40, 34 ], 34 => [ 73, 66, 60, 53, 47, 40 ], 40 => [ 73, 66, 60, 53, 47 ], 42 => [ 72, 64, 57, 49 ], 47 => [ 73, 66, 60, 53 ], 49 => [ 72, 64, 57 ], 53 => [ 73, 66, 60 ], 57 => [ 72, 64 ], 60 => [ 73, 66 ], 64 => [ 72 ], 66 => [ 73 ], 92 => [ 86 ], 94 => [ 87 ] },
	{ 28 => [ 73, 65, 58, 50, 43, 35 ], 35 => [ 73, 65, 58, 50, 43 ], 41 => [ 74, 67, 61, 54, 48 ], 43 => [ 73, 65, 58, 50 ], 48 => [ 74, 67, 61, 54 ], 50 => [ 73, 65, 58 ], 54 => [ 74, 67, 61 ], 58 => [ 73, 65 ], 61 => [ 74, 67 ], 65 => [ 73 ], 67 => [ 74 ], 93 => [ 87 ], 95 => [ 88 ] },
	{ 14 => [ 74, 66, 59, 51, 44, 36, 29, 21 ], 21 => [ 74, 66, 59, 51, 44, 36, 29 ], 29 => [ 74, 66, 59, 51, 44, 36 ], 36 => [ 74, 66, 59, 51, 44 ], 44 => [ 74, 66, 59, 51 ], 51 => [ 74, 66, 59 ], 55 => [ 75, 68, 62 ], 59 => [ 74, 66 ], 62 => [ 75, 68 ], 66 => [ 74 ], 68 => [ 75 ], 94 => [ 88 ], 96 => [ 89 ] },
	{  0 => [ 75, 67, 60, 52, 45, 37, 30, 22, 15,  7 ],  7 => [ 75, 67, 60, 52, 45, 37, 30, 22, 15 ], 15 => [ 75, 67, 60, 52, 45, 37, 30, 22 ], 22 => [ 75, 67, 60, 52, 45, 37, 30 ], 30 => [ 75, 67, 60, 52, 45, 37 ], 37 => [ 75, 67, 60, 52, 45 ], 45 => [ 75, 67, 60, 52 ], 52 => [ 75, 67, 60 ], 60 => [ 75, 67 ], 67 => [ 75 ], 69 => [ 76 ], 95 => [ 89 ], 97 => [ 90 ] },
	{  1 => [ 76, 68, 61, 53, 46, 38, 31, 23, 16,  8 ],  8 => [ 76, 68, 61, 53, 46, 38, 31, 23, 16 ], 16 => [ 76, 68, 61, 53, 46, 38, 31, 23 ], 23 => [ 76, 68, 61, 53, 46, 38, 31 ], 31 => [ 76, 68, 61, 53, 46, 38 ], 38 => [ 76, 68, 61, 53, 46 ], 46 => [ 76, 68, 61, 53 ], 53 => [ 76, 68, 61 ], 61 => [ 76, 68 ], 68 => [ 76 ], 96 => [ 90 ] },
	{  6 => [ 77, 71, 64, 58, 51, 45, 38, 32, 25, 19, 12 ], 12 => [ 77, 71, 64, 58, 51, 45, 38, 32, 25, 19 ], 19 => [ 77, 71, 64, 58, 51, 45, 38, 32, 25 ], 25 => [ 77, 71, 64, 58, 51, 45, 38, 32 ], 32 => [ 77, 71, 64, 58, 51, 45, 38 ], 38 => [ 77, 71, 64, 58, 51, 45 ], 45 => [ 77, 71, 64, 58, 51 ], 51 => [ 77, 71, 64, 58 ], 58 => [ 77, 71, 64 ], 64 => [ 77, 71 ], 71 => [ 77 ] },
	{ 13 => [ 78, 72, 65, 59, 52, 46, 39, 33, 26, 20 ], 20 => [ 78, 72, 65, 59, 52, 46, 39, 33, 26 ], 26 => [ 78, 72, 65, 59, 52, 46, 39, 33 ], 33 => [ 78, 72, 65, 59, 52, 46, 39 ], 39 => [ 78, 72, 65, 59, 52, 46 ], 46 => [ 78, 72, 65, 59, 52 ], 52 => [ 78, 72, 65, 59 ], 59 => [ 78, 72, 65 ], 65 => [ 78, 72 ], 70 => [ 77 ], 72 => [ 78 ] },
	{ 27 => [ 79, 73, 66, 60, 53, 47, 40, 34 ], 34 => [ 79, 73, 66, 60, 53, 47, 40 ], 40 => [ 79, 73, 66, 60, 53, 47 ], 47 => [ 79, 73, 66, 60, 53 ], 53 => [ 79, 73, 66, 60 ], 56 => [ 78, 71, 63 ], 60 => [ 79, 73, 66 ], 63 => [ 78, 71 ], 66 => [ 79, 73 ], 71 => [ 78 ], 73 => [ 79 ] },
	{ 41 => [ 80, 74, 67, 61, 54, 48 ], 42 => [ 79, 72, 64, 57, 49 ], 48 => [ 80, 74, 67, 61, 54 ], 49 => [ 79, 72, 64, 57 ], 54 => [ 80, 74, 67, 61 ], 57 => [ 79, 72, 64 ], 61 => [ 80, 74, 67 ], 64 => [ 79, 72 ], 67 => [ 80, 74 ], 72 => [ 79 ], 74 => [ 80 ] },
	{ 28 => [ 80, 73, 65, 58, 50, 43, 35 ], 35 => [ 80, 73, 65, 58, 50, 43 ], 43 => [ 80, 73, 65, 58, 50 ], 50 => [ 80, 73, 65, 58 ], 55 => [ 81, 75, 68, 62 ], 58 => [ 80, 73, 65 ], 62 => [ 81, 75, 68 ], 65 => [ 80, 73 ], 68 => [ 81, 75 ], 73 => [ 80 ], 75 => [ 81 ] },
	{ 14 => [ 81, 74, 66, 59, 51, 44, 36, 29, 21 ], 21 => [ 81, 74, 66, 59, 51, 44, 36, 29 ], 29 => [ 81, 74, 66, 59, 51, 44, 36 ], 36 => [ 81, 74, 66, 59, 51, 44 ], 44 => [ 81, 74, 66, 59, 51 ], 51 => [ 81, 74, 66, 59 ], 59 => [ 81, 74, 66 ], 66 => [ 81, 74 ], 69 => [ 82, 76 ], 74 => [ 81 ], 76 => [ 82 ] },
	{  0 => [ 82, 75, 67, 60, 52, 45, 37, 30, 22, 15,  7 ],  7 => [ 82, 75, 67, 60, 52, 45, 37, 30, 22, 15 ], 15 => [ 82, 75, 67, 60, 52, 45, 37, 30, 22 ], 22 => [ 82, 75, 67, 60, 52, 45, 37, 30 ], 30 => [ 82, 75, 67, 60, 52, 45, 37 ], 37 => [ 82, 75, 67, 60, 52, 45 ], 45 => [ 82, 75, 67, 60, 52 ], 52 => [ 82, 75, 67, 60 ], 60 => [ 82, 75, 67 ], 67 => [ 82, 75 ], 75 => [ 82 ] },
	{ 13 => [ 85, 78, 72, 65, 59, 52, 46, 39, 33, 26, 20 ], 20 => [ 85, 78, 72, 65, 59, 52, 46, 39, 33, 26 ], 26 => [ 85, 78, 72, 65, 59, 52, 46, 39, 33 ], 33 => [ 85, 78, 72, 65, 59, 52, 46, 39 ], 39 => [ 85, 78, 72, 65, 59, 52, 46 ], 46 => [ 85, 78, 72, 65, 59, 52 ], 52 => [ 85, 78, 72, 65, 59 ], 59 => [ 85, 78, 72, 65 ], 65 => [ 85, 78, 72 ], 72 => [ 85, 78 ], 78 => [ 85 ] },
	{ 27 => [ 86, 79, 73, 66, 60, 53, 47, 40, 34 ], 34 => [ 86, 79, 73, 66, 60, 53, 47, 40 ], 40 => [ 86, 79, 73, 66, 60, 53, 47 ], 47 => [ 86, 79, 73, 66, 60, 53 ], 53 => [ 86, 79, 73, 66, 60 ], 60 => [ 86, 79, 73, 66 ], 66 => [ 86, 79, 73 ], 70 => [ 85, 77 ], 73 => [ 86, 79 ], 77 => [ 85 ], 79 => [ 86 ] },
	{ 41 => [ 87, 80, 74, 67, 61, 54, 48 ], 48 => [ 87, 80, 74, 67, 61, 54 ], 54 => [ 87, 80, 74, 67, 61 ], 56 => [ 86, 78, 71, 63 ], 61 => [ 87, 80, 74, 67 ], 63 => [ 86, 78, 71 ], 67 => [ 87, 80, 74 ], 71 => [ 86, 78 ], 74 => [ 87, 80 ], 78 => [ 86 ], 80 => [ 87 ] },
	{ 42 => [ 87, 79, 72, 64, 57, 49 ], 49 => [ 87, 79, 72, 64, 57 ], 55 => [ 88, 81, 75, 68, 62 ], 57 => [ 87, 79, 72, 64 ], 62 => [ 88, 81, 75, 68 ], 64 => [ 87, 79, 72 ], 68 => [ 88, 81, 75 ], 72 => [ 87, 79 ], 75 => [ 88, 81 ], 79 => [ 87 ], 81 => [ 88 ] },
	{ 28 => [ 88, 80, 73, 65, 58, 50, 43, 35 ], 35 => [ 88, 80, 73, 65, 58, 50, 43 ], 43 => [ 88, 80, 73, 65, 58, 50 ], 50 => [ 88, 80, 73, 65, 58 ], 58 => [ 88, 80, 73, 65 ], 65 => [ 88, 80, 73 ], 69 => [ 89, 82, 76 ], 73 => [ 88, 80 ], 76 => [ 89, 82 ], 80 => [ 88 ], 82 => [ 89 ] },
	{ 14 => [ 89, 81, 74, 66, 59, 51, 44, 36, 29, 21 ], 21 => [ 89, 81, 74, 66, 59, 51, 44, 36, 29 ], 29 => [ 89, 81, 74, 66, 59, 51, 44, 36 ], 36 => [ 89, 81, 74, 66, 59, 51, 44 ], 44 => [ 89, 81, 74, 66, 59, 51 ], 51 => [ 89, 81, 74, 66, 59 ], 59 => [ 89, 81, 74, 66 ], 66 => [ 89, 81, 74 ], 74 => [ 89, 81 ], 81 => [ 89 ], 83 => [ 90 ] },
	{  0 => [ 90, 82, 75, 67, 60, 52, 45, 37, 30, 22, 15,  7 ],  7 => [ 90, 82, 75, 67, 60, 52, 45, 37, 30, 22, 15 ], 15 => [ 90, 82, 75, 67, 60, 52, 45, 37, 30, 22 ], 22 => [ 90, 82, 75, 67, 60, 52, 45, 37, 30 ], 30 => [ 90, 82, 75, 67, 60, 52, 45, 37 ], 37 => [ 90, 82, 75, 67, 60, 52, 45 ], 45 => [ 90, 82, 75, 67, 60, 52 ], 52 => [ 90, 82, 75, 67, 60 ], 60 => [ 90, 82, 75, 67 ], 67 => [ 90, 82, 75 ], 75 => [ 90, 82 ], 82 => [ 90 ] },
];

use constant enclosed_8dirs_locs => [
	{  2 => [  1 ],  3 => [  1,  2 ],  4 => [  1,  2,  3 ],  5 => [  1,  2,  3,  4 ],  6 => [  1,  2,  3,  4,  5 ], 15 => [  7 ], 22 => [  7, 15 ], 28 => [ 14 ], 30 => [  7, 15, 22 ], 37 => [  7, 15, 22, 30 ], 42 => [ 14, 28 ], 45 => [  7, 15, 22, 30, 37 ], 52 => [  7, 15, 22, 30, 37, 45 ], 56 => [ 14, 28, 42 ], 60 => [  7, 15, 22, 30, 37, 45, 52 ], 67 => [  7, 15, 22, 30, 37, 45, 52, 60 ], 70 => [ 14, 28, 42, 56 ], 75 => [  7, 15, 22, 30, 37, 45, 52, 60, 67 ], 82 => [  7, 15, 22, 30, 37, 45, 52, 60, 67, 75 ], 84 => [ 14, 28, 42, 56, 70 ], 90 => [  7, 15, 22, 30, 37, 45, 52, 60, 67, 75, 82 ], 97 => [  7, 15, 22, 30, 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{  3 => [  2 ],  4 => [  2,  3 ],  5 => [  2,  3,  4 ],  6 => [  2,  3,  4,  5 ], 14 => [  7 ], 16 => [  8 ], 23 => [  8, 16 ], 29 => [ 15 ], 31 => [  8, 16, 23 ], 38 => [  8, 16, 23, 31 ], 43 => [ 15, 29 ], 46 => [  8, 16, 23, 31, 38 ], 53 => [  8, 16, 23, 31, 38, 46 ], 57 => [ 15, 29, 43 ], 61 => [  8, 16, 23, 31, 38, 46, 53 ], 68 => [  8, 16, 23, 31, 38, 46, 53, 61 ], 71 => [ 15, 29, 43, 57 ], 76 => [  8, 16, 23, 31, 38, 46, 53, 61, 68 ], 83 => [  8, 16, 23, 31, 38, 46, 53, 61, 68, 76 ], 85 => [ 15, 29, 43, 57, 71 ] },
	{  0 => [  1 ],  4 => [  3 ],  5 => [  3,  4 ],  6 => [  3,  4,  5 ], 15 => [  8 ], 17 => [  9 ], 21 => [  8, 15 ], 24 => [  9, 17 ], 28 => [  8, 15, 21 ], 30 => [ 16 ], 32 => [  9, 17, 24 ], 39 => [  9, 17, 24, 32 ], 44 => [ 16, 30 ], 47 => [  9, 17, 24, 32, 39 ], 54 => [  9, 17, 24, 32, 39, 47 ], 58 => [ 16, 30, 44 ], 62 => [  9, 17, 24, 32, 39, 47, 54 ], 69 => [  9, 17, 24, 32, 39, 47, 54, 62 ], 72 => [ 16, 30, 44, 58 ], 86 => [ 16, 30, 44, 58, 72 ] },
	{  0 => [  2,  1 ],  1 => [  2 ],  5 => [  4 ],  6 => [  4,  5 ], 16 => [  9 ], 18 => [ 10 ], 22 => [  9, 16 ], 25 => [ 10, 18 ], 29 => [  9, 16, 22 ], 31 => [ 17 ], 33 => [ 10, 18, 25 ], 35 => [  9, 16, 22, 29 ], 40 => [ 10, 18, 25, 33 ], 42 => [  9, 16, 22, 29, 35 ], 45 => [ 17, 31 ], 48 => [ 10, 18, 25, 33, 40 ], 55 => [ 10, 18, 25, 33, 40, 48 ], 59 => [ 17, 31, 45 ], 73 => [ 17, 31, 45, 59 ], 87 => [ 17, 31, 45, 59, 73 ] },
	{  0 => [  3,  2,  1 ],  1 => [  3,  2 ],  2 => [  3 ],  6 => [  5 ], 17 => [ 10 ], 19 => [ 11 ], 23 => [ 10, 17 ], 26 => [ 11, 19 ], 30 => [ 10, 17, 23 ], 32 => [ 18 ], 34 => [ 11, 19, 26 ], 36 => [ 10, 17, 23, 30 ], 41 => [ 11, 19, 26, 34 ], 43 => [ 10, 17, 23, 30, 36 ], 46 => [ 18, 32 ], 49 => [ 10, 17, 23, 30, 36, 43 ], 56 => [ 10, 17, 23, 30, 36, 43, 49 ], 60 => [ 18, 32, 46 ], 74 => [ 18, 32, 46, 60 ], 88 => [ 18, 32, 46, 60, 74 ] },
	{  0 => [  4,  3,  2,  1 ],  1 => [  4,  3,  2 ],  2 => [  4,  3 ],  3 => [  4 ], 18 => [ 11 ], 20 => [ 12 ], 24 => [ 11, 18 ], 27 => [ 12, 20 ], 31 => [ 11, 18, 24 ], 33 => [ 19 ], 37 => [ 11, 18, 24, 31 ], 44 => [ 11, 18, 24, 31, 37 ], 47 => [ 19, 33 ], 50 => [ 11, 18, 24, 31, 37, 44 ], 57 => [ 11, 18, 24, 31, 37, 44, 50 ], 61 => [ 19, 33, 47 ], 63 => [ 11, 18, 24, 31, 37, 44, 50, 57 ], 70 => [ 11, 18, 24, 31, 37, 44, 50, 57, 63 ], 75 => [ 19, 33, 47, 61 ], 89 => [ 19, 33, 47, 61, 75 ] },
	{  0 => [  5,  4,  3,  2,  1 ],  1 => [  5,  4,  3,  2 ],  2 => [  5,  4,  3 ],  3 => [  5,  4 ],  4 => [  5 ], 19 => [ 12 ], 25 => [ 12, 19 ], 32 => [ 12, 19, 25 ], 34 => [ 20 ], 38 => [ 12, 19, 25, 32 ], 45 => [ 12, 19, 25, 32, 38 ], 48 => [ 20, 34 ], 51 => [ 12, 19, 25, 32, 38, 45 ], 58 => [ 12, 19, 25, 32, 38, 45, 51 ], 62 => [ 20, 34, 48 ], 64 => [ 12, 19, 25, 32, 38, 45, 51, 58 ], 71 => [ 12, 19, 25, 32, 38, 45, 51, 58, 64 ], 76 => [ 20, 34, 48, 62 ], 77 => [ 12, 19, 25, 32, 38, 45, 51, 58, 64, 71 ], 84 => [ 12, 19, 25, 32, 38, 45, 51, 58, 64, 71, 77 ], 90 => [ 20, 34, 48, 62, 76 ] },
	{  9 => [  8 ], 10 => [  8,  9 ], 11 => [  8,  9, 10 ], 12 => [  8,  9, 10, 11 ], 13 => [  8,  9, 10, 11, 12 ], 22 => [ 15 ], 30 => [ 15, 22 ], 35 => [ 21 ], 37 => [ 15, 22, 30 ], 45 => [ 15, 22, 30, 37 ], 49 => [ 21, 35 ], 52 => [ 15, 22, 30, 37, 45 ], 60 => [ 15, 22, 30, 37, 45, 52 ], 63 => [ 21, 35, 49 ], 67 => [ 15, 22, 30, 37, 45, 52, 60 ], 75 => [ 15, 22, 30, 37, 45, 52, 60, 67 ], 77 => [ 21, 35, 49, 63 ], 82 => [ 15, 22, 30, 37, 45, 52, 60, 67, 75 ], 90 => [ 15, 22, 30, 37, 45, 52, 60, 67, 75, 82 ], 91 => [ 21, 35, 49, 63, 77 ], 97 => [ 15, 22, 30, 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{ 10 => [  9 ], 11 => [  9, 10 ], 12 => [  9, 10, 11 ], 13 => [  9, 10, 11, 12 ], 21 => [ 15 ], 23 => [ 16 ], 28 => [ 15, 21 ], 31 => [ 16, 23 ], 36 => [ 22 ], 38 => [ 16, 23, 31 ], 46 => [ 16, 23, 31, 38 ], 50 => [ 22, 36 ], 53 => [ 16, 23, 31, 38, 46 ], 61 => [ 16, 23, 31, 38, 46, 53 ], 64 => [ 22, 36, 50 ], 68 => [ 16, 23, 31, 38, 46, 53, 61 ], 76 => [ 16, 23, 31, 38, 46, 53, 61, 68 ], 78 => [ 22, 36, 50, 64 ], 83 => [ 16, 23, 31, 38, 46, 53, 61, 68, 76 ], 92 => [ 22, 36, 50, 64, 78 ] },
	{  7 => [  8 ], 11 => [ 10 ], 12 => [ 10, 11 ], 13 => [ 10, 11, 12 ], 22 => [ 16 ], 24 => [ 17 ], 29 => [ 16, 22 ], 32 => [ 17, 24 ], 35 => [ 16, 22, 29 ], 37 => [ 23 ], 39 => [ 17, 24, 32 ], 42 => [ 16, 22, 29, 35 ], 47 => [ 17, 24, 32, 39 ], 51 => [ 23, 37 ], 54 => [ 17, 24, 32, 39, 47 ], 62 => [ 17, 24, 32, 39, 47, 54 ], 65 => [ 23, 37, 51 ], 69 => [ 17, 24, 32, 39, 47, 54, 62 ], 79 => [ 23, 37, 51, 65 ], 93 => [ 23, 37, 51, 65, 79 ] },
	{  7 => [  9,  8 ],  8 => [  9 ], 12 => [ 11 ], 13 => [ 11, 12 ], 23 => [ 17 ], 25 => [ 18 ], 30 => [ 17, 23 ], 33 => [ 18, 25 ], 36 => [ 17, 23, 30 ], 38 => [ 24 ], 40 => [ 18, 25, 33 ], 43 => [ 17, 23, 30, 36 ], 48 => [ 18, 25, 33, 40 ], 49 => [ 17, 23, 30, 36, 43 ], 52 => [ 24, 38 ], 55 => [ 18, 25, 33, 40, 48 ], 56 => [ 17, 23, 30, 36, 43, 49 ], 66 => [ 24, 38, 52 ], 80 => [ 24, 38, 52, 66 ], 94 => [ 24, 38, 52, 66, 80 ] },
	{  7 => [ 10,  9,  8 ],  8 => [ 10,  9 ],  9 => [ 10 ], 13 => [ 12 ], 24 => [ 18 ], 26 => [ 19 ], 31 => [ 18, 24 ], 34 => [ 19, 26 ], 37 => [ 18, 24, 31 ], 39 => [ 25 ], 41 => [ 19, 26, 34 ], 44 => [ 18, 24, 31, 37 ], 50 => [ 18, 24, 31, 37, 44 ], 53 => [ 25, 39 ], 57 => [ 18, 24, 31, 37, 44, 50 ], 63 => [ 18, 24, 31, 37, 44, 50, 57 ], 67 => [ 25, 39, 53 ], 70 => [ 18, 24, 31, 37, 44, 50, 57, 63 ], 81 => [ 25, 39, 53, 67 ], 95 => [ 25, 39, 53, 67, 81 ] },
	{  7 => [ 11, 10,  9,  8 ],  8 => [ 11, 10,  9 ],  9 => [ 11, 10 ], 10 => [ 11 ], 25 => [ 19 ], 27 => [ 20 ], 32 => [ 19, 25 ], 38 => [ 19, 25, 32 ], 40 => [ 26 ], 45 => [ 19, 25, 32, 38 ], 51 => [ 19, 25, 32, 38, 45 ], 54 => [ 26, 40 ], 58 => [ 19, 25, 32, 38, 45, 51 ], 64 => [ 19, 25, 32, 38, 45, 51, 58 ], 68 => [ 26, 40, 54 ], 71 => [ 19, 25, 32, 38, 45, 51, 58, 64 ], 77 => [ 19, 25, 32, 38, 45, 51, 58, 64, 71 ], 82 => [ 26, 40, 54, 68 ], 84 => [ 19, 25, 32, 38, 45, 51, 58, 64, 71, 77 ], 96 => [ 26, 40, 54, 68, 82 ] },
	{  7 => [ 12, 11, 10,  9,  8 ],  8 => [ 12, 11, 10,  9 ],  9 => [ 12, 11, 10 ], 10 => [ 12, 11 ], 11 => [ 12 ], 26 => [ 20 ], 33 => [ 20, 26 ], 39 => [ 20, 26, 33 ], 41 => [ 27 ], 46 => [ 20, 26, 33, 39 ], 52 => [ 20, 26, 33, 39, 46 ], 55 => [ 27, 41 ], 59 => [ 20, 26, 33, 39, 46, 52 ], 65 => [ 20, 26, 33, 39, 46, 52, 59 ], 69 => [ 27, 41, 55 ], 72 => [ 20, 26, 33, 39, 46, 52, 59, 65 ], 78 => [ 20, 26, 33, 39, 46, 52, 59, 65, 72 ], 83 => [ 27, 41, 55, 69 ], 85 => [ 20, 26, 33, 39, 46, 52, 59, 65, 72, 78 ], 91 => [ 20, 26, 33, 39, 46, 52, 59, 65, 72, 78, 85 ], 97 => [ 27, 41, 55, 69, 83 ] },
	{  1 => [  7 ], 16 => [ 15 ], 17 => [ 15, 16 ], 18 => [ 15, 16, 17 ], 19 => [ 15, 16, 17, 18 ], 20 => [ 15, 16, 17, 18, 19 ], 29 => [ 21 ], 36 => [ 21, 29 ], 42 => [ 28 ], 44 => [ 21, 29, 36 ], 51 => [ 21, 29, 36, 44 ], 56 => [ 28, 42 ], 59 => [ 21, 29, 36, 44, 51 ], 66 => [ 21, 29, 36, 44, 51, 59 ], 70 => [ 28, 42, 56 ], 74 => [ 21, 29, 36, 44, 51, 59, 66 ], 81 => [ 21, 29, 36, 44, 51, 59, 66, 74 ], 84 => [ 28, 42, 56, 70 ], 89 => [ 21, 29, 36, 44, 51, 59, 66, 74, 81 ], 96 => [ 21, 29, 36, 44, 51, 59, 66, 74, 81, 89 ] },
	{  0 => [  7 ],  2 => [  8 ], 17 => [ 16 ], 18 => [ 16, 17 ], 19 => [ 16, 17, 18 ], 20 => [ 16, 17, 18, 19 ], 28 => [ 21 ], 30 => [ 22 ], 37 => [ 22, 30 ], 43 => [ 29 ], 45 => [ 22, 30, 37 ], 52 => [ 22, 30, 37, 45 ], 57 => [ 29, 43 ], 60 => [ 22, 30, 37, 45, 52 ], 67 => [ 22, 30, 37, 45, 52, 60 ], 71 => [ 29, 43, 57 ], 75 => [ 22, 30, 37, 45, 52, 60, 67 ], 82 => [ 22, 30, 37, 45, 52, 60, 67, 75 ], 85 => [ 29, 43, 57, 71 ], 90 => [ 22, 30, 37, 45, 52, 60, 67, 75, 82 ], 97 => [ 22, 30, 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{  1 => [  8 ],  3 => [  9 ], 14 => [ 15 ], 18 => [ 17 ], 19 => [ 17, 18 ], 20 => [ 17, 18, 19 ], 29 => [ 22 ], 31 => [ 23 ], 35 => [ 22, 29 ], 38 => [ 23, 31 ], 42 => [ 22, 29, 35 ], 44 => [ 30 ], 46 => [ 23, 31, 38 ], 53 => [ 23, 31, 38, 46 ], 58 => [ 30, 44 ], 61 => [ 23, 31, 38, 46, 53 ], 68 => [ 23, 31, 38, 46, 53, 61 ], 72 => [ 30, 44, 58 ], 76 => [ 23, 31, 38, 46, 53, 61, 68 ], 83 => [ 23, 31, 38, 46, 53, 61, 68, 76 ], 86 => [ 30, 44, 58, 72 ] },
	{  2 => [  9 ],  4 => [ 10 ], 14 => [ 16, 15 ], 15 => [ 16 ], 19 => [ 18 ], 20 => [ 18, 19 ], 30 => [ 23 ], 32 => [ 24 ], 36 => [ 23, 30 ], 39 => [ 24, 32 ], 43 => [ 23, 30, 36 ], 45 => [ 31 ], 47 => [ 24, 32, 39 ], 49 => [ 23, 30, 36, 43 ], 54 => [ 24, 32, 39, 47 ], 56 => [ 23, 30, 36, 43, 49 ], 59 => [ 31, 45 ], 62 => [ 24, 32, 39, 47, 54 ], 69 => [ 24, 32, 39, 47, 54, 62 ], 73 => [ 31, 45, 59 ], 87 => [ 31, 45, 59, 73 ] },
	{  3 => [ 10 ],  5 => [ 11 ], 14 => [ 17, 16, 15 ], 15 => [ 17, 16 ], 16 => [ 17 ], 20 => [ 19 ], 31 => [ 24 ], 33 => [ 25 ], 37 => [ 24, 31 ], 40 => [ 25, 33 ], 44 => [ 24, 31, 37 ], 46 => [ 32 ], 48 => [ 25, 33, 40 ], 50 => [ 24, 31, 37, 44 ], 55 => [ 25, 33, 40, 48 ], 57 => [ 24, 31, 37, 44, 50 ], 60 => [ 32, 46 ], 63 => [ 24, 31, 37, 44, 50, 57 ], 70 => [ 24, 31, 37, 44, 50, 57, 63 ], 74 => [ 32, 46, 60 ], 88 => [ 32, 46, 60, 74 ] },
	{  4 => [ 11 ],  6 => [ 12 ], 14 => [ 18, 17, 16, 15 ], 15 => [ 18, 17, 16 ], 16 => [ 18, 17 ], 17 => [ 18 ], 32 => [ 25 ], 34 => [ 26 ], 38 => [ 25, 32 ], 41 => [ 26, 34 ], 45 => [ 25, 32, 38 ], 47 => [ 33 ], 51 => [ 25, 32, 38, 45 ], 58 => [ 25, 32, 38, 45, 51 ], 61 => [ 33, 47 ], 64 => [ 25, 32, 38, 45, 51, 58 ], 71 => [ 25, 32, 38, 45, 51, 58, 64 ], 75 => [ 33, 47, 61 ], 77 => [ 25, 32, 38, 45, 51, 58, 64, 71 ], 84 => [ 25, 32, 38, 45, 51, 58, 64, 71, 77 ], 89 => [ 33, 47, 61, 75 ] },
	{  5 => [ 12 ], 14 => [ 19, 18, 17, 16, 15 ], 15 => [ 19, 18, 17, 16 ], 16 => [ 19, 18, 17 ], 17 => [ 19, 18 ], 18 => [ 19 ], 33 => [ 26 ], 39 => [ 26, 33 ], 46 => [ 26, 33, 39 ], 48 => [ 34 ], 52 => [ 26, 33, 39, 46 ], 59 => [ 26, 33, 39, 46, 52 ], 62 => [ 34, 48 ], 65 => [ 26, 33, 39, 46, 52, 59 ], 72 => [ 26, 33, 39, 46, 52, 59, 65 ], 76 => [ 34, 48, 62 ], 78 => [ 26, 33, 39, 46, 52, 59, 65, 72 ], 85 => [ 26, 33, 39, 46, 52, 59, 65, 72, 78 ], 90 => [ 34, 48, 62, 76 ], 91 => [ 26, 33, 39, 46, 52, 59, 65, 72, 78, 85 ] },
	{  2 => [ 15,  8 ],  8 => [ 15 ], 23 => [ 22 ], 24 => [ 22, 23 ], 25 => [ 22, 23, 24 ], 26 => [ 22, 23, 24, 25 ], 27 => [ 22, 23, 24, 25, 26 ], 36 => [ 29 ], 44 => [ 29, 36 ], 49 => [ 35 ], 51 => [ 29, 36, 44 ], 59 => [ 29, 36, 44, 51 ], 63 => [ 35, 49 ], 66 => [ 29, 36, 44, 51, 59 ], 74 => [ 29, 36, 44, 51, 59, 66 ], 77 => [ 35, 49, 63 ], 81 => [ 29, 36, 44, 51, 59, 66, 74 ], 89 => [ 29, 36, 44, 51, 59, 66, 74, 81 ], 91 => [ 35, 49, 63, 77 ], 96 => [ 29, 36, 44, 51, 59, 66, 74, 81, 89 ] },
	{  0 => [ 15,  7 ],  3 => [ 16,  9 ],  7 => [ 15 ],  9 => [ 16 ], 24 => [ 23 ], 25 => [ 23, 24 ], 26 => [ 23, 24, 25 ], 27 => [ 23, 24, 25, 26 ], 35 => [ 29 ], 37 => [ 30 ], 42 => [ 29, 35 ], 45 => [ 30, 37 ], 50 => [ 36 ], 52 => [ 30, 37, 45 ], 60 => [ 30, 37, 45, 52 ], 64 => [ 36, 50 ], 67 => [ 30, 37, 45, 52, 60 ], 75 => [ 30, 37, 45, 52, 60, 67 ], 78 => [ 36, 50, 64 ], 82 => [ 30, 37, 45, 52, 60, 67, 75 ], 90 => [ 30, 37, 45, 52, 60, 67, 75, 82 ], 92 => [ 36, 50, 64, 78 ], 97 => [ 30, 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{  1 => [ 16,  8 ],  4 => [ 17, 10 ],  8 => [ 16 ], 10 => [ 17 ], 21 => [ 22 ], 25 => [ 24 ], 26 => [ 24, 25 ], 27 => [ 24, 25, 26 ], 36 => [ 30 ], 38 => [ 31 ], 43 => [ 30, 36 ], 46 => [ 31, 38 ], 49 => [ 30, 36, 43 ], 51 => [ 37 ], 53 => [ 31, 38, 46 ], 56 => [ 30, 36, 43, 49 ], 61 => [ 31, 38, 46, 53 ], 65 => [ 37, 51 ], 68 => [ 31, 38, 46, 53, 61 ], 76 => [ 31, 38, 46, 53, 61, 68 ], 79 => [ 37, 51, 65 ], 83 => [ 31, 38, 46, 53, 61, 68, 76 ], 93 => [ 37, 51, 65, 79 ] },
	{  2 => [ 17,  9 ],  5 => [ 18, 11 ],  9 => [ 17 ], 11 => [ 18 ], 21 => [ 23, 22 ], 22 => [ 23 ], 26 => [ 25 ], 27 => [ 25, 26 ], 37 => [ 31 ], 39 => [ 32 ], 44 => [ 31, 37 ], 47 => [ 32, 39 ], 50 => [ 31, 37, 44 ], 52 => [ 38 ], 54 => [ 32, 39, 47 ], 57 => [ 31, 37, 44, 50 ], 62 => [ 32, 39, 47, 54 ], 63 => [ 31, 37, 44, 50, 57 ], 66 => [ 38, 52 ], 69 => [ 32, 39, 47, 54, 62 ], 70 => [ 31, 37, 44, 50, 57, 63 ], 80 => [ 38, 52, 66 ], 94 => [ 38, 52, 66, 80 ] },
	{  3 => [ 18, 10 ],  6 => [ 19, 12 ], 10 => [ 18 ], 12 => [ 19 ], 21 => [ 24, 23, 22 ], 22 => [ 24, 23 ], 23 => [ 24 ], 27 => [ 26 ], 38 => [ 32 ], 40 => [ 33 ], 45 => [ 32, 38 ], 48 => [ 33, 40 ], 51 => [ 32, 38, 45 ], 53 => [ 39 ], 55 => [ 33, 40, 48 ], 58 => [ 32, 38, 45, 51 ], 64 => [ 32, 38, 45, 51, 58 ], 67 => [ 39, 53 ], 71 => [ 32, 38, 45, 51, 58, 64 ], 77 => [ 32, 38, 45, 51, 58, 64, 71 ], 81 => [ 39, 53, 67 ], 84 => [ 32, 38, 45, 51, 58, 64, 71, 77 ], 95 => [ 39, 53, 67, 81 ] },
	{  4 => [ 19, 11 ], 11 => [ 19 ], 13 => [ 20 ], 21 => [ 25, 24, 23, 22 ], 22 => [ 25, 24, 23 ], 23 => [ 25, 24 ], 24 => [ 25 ], 39 => [ 33 ], 41 => [ 34 ], 46 => [ 33, 39 ], 52 => [ 33, 39, 46 ], 54 => [ 40 ], 59 => [ 33, 39, 46, 52 ], 65 => [ 33, 39, 46, 52, 59 ], 68 => [ 40, 54 ], 72 => [ 33, 39, 46, 52, 59, 65 ], 78 => [ 33, 39, 46, 52, 59, 65, 72 ], 82 => [ 40, 54, 68 ], 85 => [ 33, 39, 46, 52, 59, 65, 72, 78 ], 91 => [ 33, 39, 46, 52, 59, 65, 72, 78, 85 ], 96 => [ 40, 54, 68, 82 ] },
	{  5 => [ 20, 12 ], 12 => [ 20 ], 21 => [ 26, 25, 24, 23, 22 ], 22 => [ 26, 25, 24, 23 ], 23 => [ 26, 25, 24 ], 24 => [ 26, 25 ], 25 => [ 26 ], 40 => [ 34 ], 47 => [ 34, 40 ], 53 => [ 34, 40, 47 ], 55 => [ 41 ], 60 => [ 34, 40, 47, 53 ], 66 => [ 34, 40, 47, 53, 60 ], 69 => [ 41, 55 ], 73 => [ 34, 40, 47, 53, 60, 66 ], 79 => [ 34, 40, 47, 53, 60, 66, 73 ], 83 => [ 41, 55, 69 ], 86 => [ 34, 40, 47, 53, 60, 66, 73, 79 ], 92 => [ 34, 40, 47, 53, 60, 66, 73, 79, 86 ], 97 => [ 41, 55, 69, 83 ] },
	{  0 => [ 14 ],  2 => [ 21, 15,  8 ],  8 => [ 21, 15 ], 15 => [ 21 ], 30 => [ 29 ], 31 => [ 29, 30 ], 32 => [ 29, 30, 31 ], 33 => [ 29, 30, 31, 32 ], 34 => [ 29, 30, 31, 32, 33 ], 43 => [ 35 ], 50 => [ 35, 43 ], 56 => [ 42 ], 58 => [ 35, 43, 50 ], 65 => [ 35, 43, 50, 58 ], 70 => [ 42, 56 ], 73 => [ 35, 43, 50, 58, 65 ], 80 => [ 35, 43, 50, 58, 65, 73 ], 84 => [ 42, 56, 70 ], 88 => [ 35, 43, 50, 58, 65, 73, 80 ], 95 => [ 35, 43, 50, 58, 65, 73, 80, 88 ] },
	{  1 => [ 15 ],  3 => [ 22, 16,  9 ],  9 => [ 22, 16 ], 14 => [ 21 ], 16 => [ 22 ], 31 => [ 30 ], 32 => [ 30, 31 ], 33 => [ 30, 31, 32 ], 34 => [ 30, 31, 32, 33 ], 42 => [ 35 ], 44 => [ 36 ], 51 => [ 36, 44 ], 57 => [ 43 ], 59 => [ 36, 44, 51 ], 66 => [ 36, 44, 51, 59 ], 71 => [ 43, 57 ], 74 => [ 36, 44, 51, 59, 66 ], 81 => [ 36, 44, 51, 59, 66, 74 ], 85 => [ 43, 57, 71 ], 89 => [ 36, 44, 51, 59, 66, 74, 81 ], 96 => [ 36, 44, 51, 59, 66, 74, 81, 89 ] },
	{  0 => [ 22, 15,  7 ],  2 => [ 16 ],  4 => [ 23, 17, 10 ],  7 => [ 22, 15 ], 10 => [ 23, 17 ], 15 => [ 22 ], 17 => [ 23 ], 28 => [ 29 ], 32 => [ 31 ], 33 => [ 31, 32 ], 34 => [ 31, 32, 33 ], 43 => [ 36 ], 45 => [ 37 ], 49 => [ 36, 43 ], 52 => [ 37, 45 ], 56 => [ 36, 43, 49 ], 58 => [ 44 ], 60 => [ 37, 45, 52 ], 67 => [ 37, 45, 52, 60 ], 72 => [ 44, 58 ], 75 => [ 37, 45, 52, 60, 67 ], 82 => [ 37, 45, 52, 60, 67, 75 ], 86 => [ 44, 58, 72 ], 90 => [ 37, 45, 52, 60, 67, 75, 82 ], 97 => [ 37, 45, 52, 60, 67, 75, 82, 90 ] },
	{  1 => [ 23, 16,  8 ],  3 => [ 17 ],  5 => [ 24, 18, 11 ],  8 => [ 23, 16 ], 11 => [ 24, 18 ], 16 => [ 23 ], 18 => [ 24 ], 28 => [ 30, 29 ], 29 => [ 30 ], 33 => [ 32 ], 34 => [ 32, 33 ], 44 => [ 37 ], 46 => [ 38 ], 50 => [ 37, 44 ], 53 => [ 38, 46 ], 57 => [ 37, 44, 50 ], 59 => [ 45 ], 61 => [ 38, 46, 53 ], 63 => [ 37, 44, 50, 57 ], 68 => [ 38, 46, 53, 61 ], 70 => [ 37, 44, 50, 57, 63 ], 73 => [ 45, 59 ], 76 => [ 38, 46, 53, 61, 68 ], 83 => [ 38, 46, 53, 61, 68, 76 ], 87 => [ 45, 59, 73 ] },
	{  2 => [ 24, 17,  9 ],  4 => [ 18 ],  6 => [ 25, 19, 12 ],  9 => [ 24, 17 ], 12 => [ 25, 19 ], 17 => [ 24 ], 19 => [ 25 ], 28 => [ 31, 30, 29 ], 29 => [ 31, 30 ], 30 => [ 31 ], 34 => [ 33 ], 45 => [ 38 ], 47 => [ 39 ], 51 => [ 38, 45 ], 54 => [ 39, 47 ], 58 => [ 38, 45, 51 ], 60 => [ 46 ], 62 => [ 39, 47, 54 ], 64 => [ 38, 45, 51, 58 ], 69 => [ 39, 47, 54, 62 ], 71 => [ 38, 45, 51, 58, 64 ], 74 => [ 46, 60 ], 77 => [ 38, 45, 51, 58, 64, 71 ], 84 => [ 38, 45, 51, 58, 64, 71, 77 ], 88 => [ 46, 60, 74 ] },
	{  3 => [ 25, 18, 10 ],  5 => [ 19 ], 10 => [ 25, 18 ], 13 => [ 26, 20 ], 18 => [ 25 ], 20 => [ 26 ], 28 => [ 32, 31, 30, 29 ], 29 => [ 32, 31, 30 ], 30 => [ 32, 31 ], 31 => [ 32 ], 46 => [ 39 ], 48 => [ 40 ], 52 => [ 39, 46 ], 55 => [ 40, 48 ], 59 => [ 39, 46, 52 ], 61 => [ 47 ], 65 => [ 39, 46, 52, 59 ], 72 => [ 39, 46, 52, 59, 65 ], 75 => [ 47, 61 ], 78 => [ 39, 46, 52, 59, 65, 72 ], 85 => [ 39, 46, 52, 59, 65, 72, 78 ], 89 => [ 47, 61, 75 ], 91 => [ 39, 46, 52, 59, 65, 72, 78, 85 ] },
	{  4 => [ 26, 19, 11 ],  6 => [ 20 ], 11 => [ 26, 19 ], 19 => [ 26 ], 28 => [ 33, 32, 31, 30, 29 ], 29 => [ 33, 32, 31, 30 ], 30 => [ 33, 32, 31 ], 31 => [ 33, 32 ], 32 => [ 33 ], 47 => [ 40 ], 53 => [ 40, 47 ], 60 => [ 40, 47, 53 ], 62 => [ 48 ], 66 => [ 40, 47, 53, 60 ], 73 => [ 40, 47, 53, 60, 66 ], 76 => [ 48, 62 ], 79 => [ 40, 47, 53, 60, 66, 73 ], 86 => [ 40, 47, 53, 60, 66, 73, 79 ], 90 => [ 48, 62, 76 ], 92 => [ 40, 47, 53, 60, 66, 73, 79, 86 ] },
	{  3 => [ 29, 22, 16,  9 ],  7 => [ 21 ],  9 => [ 29, 22, 16 ], 16 => [ 29, 22 ], 22 => [ 29 ], 37 => [ 36 ], 38 => [ 36, 37 ], 39 => [ 36, 37, 38 ], 40 => [ 36, 37, 38, 39 ], 41 => [ 36, 37, 38, 39, 40 ], 50 => [ 43 ], 58 => [ 43, 50 ], 63 => [ 49 ], 65 => [ 43, 50, 58 ], 73 => [ 43, 50, 58, 65 ], 77 => [ 49, 63 ], 80 => [ 43, 50, 58, 65, 73 ], 88 => [ 43, 50, 58, 65, 73, 80 ], 91 => [ 49, 63, 77 ], 95 => [ 43, 50, 58, 65, 73, 80, 88 ] },
	{  4 => [ 30, 23, 17, 10 ],  8 => [ 22 ], 10 => [ 30, 23, 17 ], 14 => [ 29, 21 ], 17 => [ 30, 23 ], 21 => [ 29 ], 23 => [ 30 ], 38 => [ 37 ], 39 => [ 37, 38 ], 40 => [ 37, 38, 39 ], 41 => [ 37, 38, 39, 40 ], 49 => [ 43 ], 51 => [ 44 ], 56 => [ 43, 49 ], 59 => [ 44, 51 ], 64 => [ 50 ], 66 => [ 44, 51, 59 ], 74 => [ 44, 51, 59, 66 ], 78 => [ 50, 64 ], 81 => [ 44, 51, 59, 66, 74 ], 89 => [ 44, 51, 59, 66, 74, 81 ], 92 => [ 50, 64, 78 ], 96 => [ 44, 51, 59, 66, 74, 81, 89 ] },
	{  0 => [ 30, 22, 15,  7 ],  5 => [ 31, 24, 18, 11 ],  7 => [ 30, 22, 15 ],  9 => [ 23 ], 11 => [ 31, 24, 18 ], 15 => [ 30, 22 ], 18 => [ 31, 24 ], 22 => [ 30 ], 24 => [ 31 ], 35 => [ 36 ], 39 => [ 38 ], 40 => [ 38, 39 ], 41 => [ 38, 39, 40 ], 50 => [ 44 ], 52 => [ 45 ], 57 => [ 44, 50 ], 60 => [ 45, 52 ], 63 => [ 44, 50, 57 ], 65 => [ 51 ], 67 => [ 45, 52, 60 ], 70 => [ 44, 50, 57, 63 ], 75 => [ 45, 52, 60, 67 ], 79 => [ 51, 65 ], 82 => [ 45, 52, 60, 67, 75 ], 90 => [ 45, 52, 60, 67, 75, 82 ], 93 => [ 51, 65, 79 ], 97 => [ 45, 52, 60, 67, 75, 82, 90 ] },
	{  1 => [ 31, 23, 16,  8 ],  6 => [ 32, 25, 19, 12 ],  8 => [ 31, 23, 16 ], 10 => [ 24 ], 12 => [ 32, 25, 19 ], 16 => [ 31, 23 ], 19 => [ 32, 25 ], 23 => [ 31 ], 25 => [ 32 ], 35 => [ 37, 36 ], 36 => [ 37 ], 40 => [ 39 ], 41 => [ 39, 40 ], 51 => [ 45 ], 53 => [ 46 ], 58 => [ 45, 51 ], 61 => [ 46, 53 ], 64 => [ 45, 51, 58 ], 66 => [ 52 ], 68 => [ 46, 53, 61 ], 71 => [ 45, 51, 58, 64 ], 76 => [ 46, 53, 61, 68 ], 77 => [ 45, 51, 58, 64, 71 ], 80 => [ 52, 66 ], 83 => [ 46, 53, 61, 68, 76 ], 84 => [ 45, 51, 58, 64, 71, 77 ], 94 => [ 52, 66, 80 ] },
	{  2 => [ 32, 24, 17,  9 ],  9 => [ 32, 24, 17 ], 11 => [ 25 ], 13 => [ 33, 26, 20 ], 17 => [ 32, 24 ], 20 => [ 33, 26 ], 24 => [ 32 ], 26 => [ 33 ], 35 => [ 38, 37, 36 ], 36 => [ 38, 37 ], 37 => [ 38 ], 41 => [ 40 ], 52 => [ 46 ], 54 => [ 47 ], 59 => [ 46, 52 ], 62 => [ 47, 54 ], 65 => [ 46, 52, 59 ], 67 => [ 53 ], 69 => [ 47, 54, 62 ], 72 => [ 46, 52, 59, 65 ], 78 => [ 46, 52, 59, 65, 72 ], 81 => [ 53, 67 ], 85 => [ 46, 52, 59, 65, 72, 78 ], 91 => [ 46, 52, 59, 65, 72, 78, 85 ], 95 => [ 53, 67, 81 ] },
	{  3 => [ 33, 25, 18, 10 ], 10 => [ 33, 25, 18 ], 12 => [ 26 ], 18 => [ 33, 25 ], 25 => [ 33 ], 27 => [ 34 ], 35 => [ 39, 38, 37, 36 ], 36 => [ 39, 38, 37 ], 37 => [ 39, 38 ], 38 => [ 39 ], 53 => [ 47 ], 55 => [ 48 ], 60 => [ 47, 53 ], 66 => [ 47, 53, 60 ], 68 => [ 54 ], 73 => [ 47, 53, 60, 66 ], 79 => [ 47, 53, 60, 66, 73 ], 82 => [ 54, 68 ], 86 => [ 47, 53, 60, 66, 73, 79 ], 92 => [ 47, 53, 60, 66, 73, 79, 86 ], 96 => [ 54, 68, 82 ] },
	{  4 => [ 34, 26, 19, 11 ], 11 => [ 34, 26, 19 ], 13 => [ 27 ], 19 => [ 34, 26 ], 26 => [ 34 ], 35 => [ 40, 39, 38, 37, 36 ], 36 => [ 40, 39, 38, 37 ], 37 => [ 40, 39, 38 ], 38 => [ 40, 39 ], 39 => [ 40 ], 54 => [ 48 ], 61 => [ 48, 54 ], 67 => [ 48, 54, 61 ], 69 => [ 55 ], 74 => [ 48, 54, 61, 67 ], 80 => [ 48, 54, 61, 67, 74 ], 83 => [ 55, 69 ], 87 => [ 48, 54, 61, 67, 74, 80 ], 93 => [ 48, 54, 61, 67, 74, 80, 87 ], 97 => [ 55, 69, 83 ] },
	{  0 => [ 28, 14 ],  3 => [ 35, 29, 22, 16,  9 ],  9 => [ 35, 29, 22, 16 ], 14 => [ 28 ], 16 => [ 35, 29, 22 ], 22 => [ 35, 29 ], 29 => [ 35 ], 44 => [ 43 ], 45 => [ 43, 44 ], 46 => [ 43, 44, 45 ], 47 => [ 43, 44, 45, 46 ], 48 => [ 43, 44, 45, 46, 47 ], 57 => [ 49 ], 64 => [ 49, 57 ], 70 => [ 56 ], 72 => [ 49, 57, 64 ], 79 => [ 49, 57, 64, 72 ], 84 => [ 56, 70 ], 87 => [ 49, 57, 64, 72, 79 ], 94 => [ 49, 57, 64, 72, 79, 87 ] },
	{  1 => [ 29, 15 ],  4 => [ 36, 30, 23, 17, 10 ], 10 => [ 36, 30, 23, 17 ], 15 => [ 29 ], 17 => [ 36, 30, 23 ], 23 => [ 36, 30 ], 28 => [ 35 ], 30 => [ 36 ], 45 => [ 44 ], 46 => [ 44, 45 ], 47 => [ 44, 45, 46 ], 48 => [ 44, 45, 46, 47 ], 56 => [ 49 ], 58 => [ 50 ], 65 => [ 50, 58 ], 71 => [ 57 ], 73 => [ 50, 58, 65 ], 80 => [ 50, 58, 65, 73 ], 85 => [ 57, 71 ], 88 => [ 50, 58, 65, 73, 80 ], 95 => [ 50, 58, 65, 73, 80, 88 ] },
	{  2 => [ 30, 16 ],  5 => [ 37, 31, 24, 18, 11 ], 11 => [ 37, 31, 24, 18 ], 14 => [ 36, 29, 21 ], 16 => [ 30 ], 18 => [ 37, 31, 24 ], 21 => [ 36, 29 ], 24 => [ 37, 31 ], 29 => [ 36 ], 31 => [ 37 ], 42 => [ 43 ], 46 => [ 45 ], 47 => [ 45, 46 ], 48 => [ 45, 46, 47 ], 57 => [ 50 ], 59 => [ 51 ], 63 => [ 50, 57 ], 66 => [ 51, 59 ], 70 => [ 50, 57, 63 ], 72 => [ 58 ], 74 => [ 51, 59, 66 ], 81 => [ 51, 59, 66, 74 ], 86 => [ 58, 72 ], 89 => [ 51, 59, 66, 74, 81 ], 96 => [ 51, 59, 66, 74, 81, 89 ] },
	{  0 => [ 37, 30, 22, 15,  7 ],  3 => [ 31, 17 ],  6 => [ 38, 32, 25, 19, 12 ],  7 => [ 37, 30, 22, 15 ], 12 => [ 38, 32, 25, 19 ], 15 => [ 37, 30, 22 ], 17 => [ 31 ], 19 => [ 38, 32, 25 ], 22 => [ 37, 30 ], 25 => [ 38, 32 ], 30 => [ 37 ], 32 => [ 38 ], 42 => [ 44, 43 ], 43 => [ 44 ], 47 => [ 46 ], 48 => [ 46, 47 ], 58 => [ 51 ], 60 => [ 52 ], 64 => [ 51, 58 ], 67 => [ 52, 60 ], 71 => [ 51, 58, 64 ], 73 => [ 59 ], 75 => [ 52, 60, 67 ], 77 => [ 51, 58, 64, 71 ], 82 => [ 52, 60, 67, 75 ], 84 => [ 51, 58, 64, 71, 77 ], 87 => [ 59, 73 ], 90 => [ 52, 60, 67, 75, 82 ], 97 => [ 52, 60, 67, 75, 82, 90 ] },
	{  1 => [ 38, 31, 23, 16,  8 ],  4 => [ 32, 18 ],  8 => [ 38, 31, 23, 16 ], 13 => [ 39, 33, 26, 20 ], 16 => [ 38, 31, 23 ], 18 => [ 32 ], 20 => [ 39, 33, 26 ], 23 => [ 38, 31 ], 26 => [ 39, 33 ], 31 => [ 38 ], 33 => [ 39 ], 42 => [ 45, 44, 43 ], 43 => [ 45, 44 ], 44 => [ 45 ], 48 => [ 47 ], 59 => [ 52 ], 61 => [ 53 ], 65 => [ 52, 59 ], 68 => [ 53, 61 ], 72 => [ 52, 59, 65 ], 74 => [ 60 ], 76 => [ 53, 61, 68 ], 78 => [ 52, 59, 65, 72 ], 83 => [ 53, 61, 68, 76 ], 85 => [ 52, 59, 65, 72, 78 ], 88 => [ 60, 74 ], 91 => [ 52, 59, 65, 72, 78, 85 ] },
	{  2 => [ 39, 32, 24, 17,  9 ],  5 => [ 33, 19 ],  9 => [ 39, 32, 24, 17 ], 17 => [ 39, 32, 24 ], 19 => [ 33 ], 24 => [ 39, 32 ], 27 => [ 40, 34 ], 32 => [ 39 ], 34 => [ 40 ], 42 => [ 46, 45, 44, 43 ], 43 => [ 46, 45, 44 ], 44 => [ 46, 45 ], 45 => [ 46 ], 60 => [ 53 ], 62 => [ 54 ], 66 => [ 53, 60 ], 69 => [ 54, 62 ], 73 => [ 53, 60, 66 ], 75 => [ 61 ], 79 => [ 53, 60, 66, 73 ], 86 => [ 53, 60, 66, 73, 79 ], 89 => [ 61, 75 ], 92 => [ 53, 60, 66, 73, 79, 86 ] },
	{  3 => [ 40, 33, 25, 18, 10 ],  6 => [ 34, 20 ], 10 => [ 40, 33, 25, 18 ], 18 => [ 40, 33, 25 ], 20 => [ 34 ], 25 => [ 40, 33 ], 33 => [ 40 ], 42 => [ 47, 46, 45, 44, 43 ], 43 => [ 47, 46, 45, 44 ], 44 => [ 47, 46, 45 ], 45 => [ 47, 46 ], 46 => [ 47 ], 61 => [ 54 ], 67 => [ 54, 61 ], 74 => [ 54, 61, 67 ], 76 => [ 62 ], 80 => [ 54, 61, 67, 74 ], 87 => [ 54, 61, 67, 74, 80 ], 90 => [ 62, 76 ], 93 => [ 54, 61, 67, 74, 80, 87 ] },
	{  4 => [ 43, 36, 30, 23, 17, 10 ],  7 => [ 35, 21 ], 10 => [ 43, 36, 30, 23, 17 ], 17 => [ 43, 36, 30, 23 ], 21 => [ 35 ], 23 => [ 43, 36, 30 ], 30 => [ 43, 36 ], 36 => [ 43 ], 51 => [ 50 ], 52 => [ 50, 51 ], 53 => [ 50, 51, 52 ], 54 => [ 50, 51, 52, 53 ], 55 => [ 50, 51, 52, 53, 54 ], 64 => [ 57 ], 72 => [ 57, 64 ], 77 => [ 63 ], 79 => [ 57, 64, 72 ], 87 => [ 57, 64, 72, 79 ], 91 => [ 63, 77 ], 94 => [ 57, 64, 72, 79, 87 ] },
	{  5 => [ 44, 37, 31, 24, 18, 11 ],  8 => [ 36, 22 ], 11 => [ 44, 37, 31, 24, 18 ], 18 => [ 44, 37, 31, 24 ], 22 => [ 36 ], 24 => [ 44, 37, 31 ], 28 => [ 43, 35 ], 31 => [ 44, 37 ], 35 => [ 43 ], 37 => [ 44 ], 52 => [ 51 ], 53 => [ 51, 52 ], 54 => [ 51, 52, 53 ], 55 => [ 51, 52, 53, 54 ], 63 => [ 57 ], 65 => [ 58 ], 70 => [ 57, 63 ], 73 => [ 58, 65 ], 78 => [ 64 ], 80 => [ 58, 65, 73 ], 88 => [ 58, 65, 73, 80 ], 92 => [ 64, 78 ], 95 => [ 58, 65, 73, 80, 88 ] },
	{  6 => [ 45, 38, 32, 25, 19, 12 ],  9 => [ 37, 23 ], 12 => [ 45, 38, 32, 25, 19 ], 14 => [ 44, 36, 29, 21 ], 19 => [ 45, 38, 32, 25 ], 21 => [ 44, 36, 29 ], 23 => [ 37 ], 25 => [ 45, 38, 32 ], 29 => [ 44, 36 ], 32 => [ 45, 38 ], 36 => [ 44 ], 38 => [ 45 ], 49 => [ 50 ], 53 => [ 52 ], 54 => [ 52, 53 ], 55 => [ 52, 53, 54 ], 64 => [ 58 ], 66 => [ 59 ], 71 => [ 58, 64 ], 74 => [ 59, 66 ], 77 => [ 58, 64, 71 ], 79 => [ 65 ], 81 => [ 59, 66, 74 ], 84 => [ 58, 64, 71, 77 ], 89 => [ 59, 66, 74, 81 ], 93 => [ 65, 79 ], 96 => [ 59, 66, 74, 81, 89 ] },
	{  0 => [ 45, 37, 30, 22, 15,  7 ],  7 => [ 45, 37, 30, 22, 15 ], 10 => [ 38, 24 ], 13 => [ 46, 39, 33, 26, 20 ], 15 => [ 45, 37, 30, 22 ], 20 => [ 46, 39, 33, 26 ], 22 => [ 45, 37, 30 ], 24 => [ 38 ], 26 => [ 46, 39, 33 ], 30 => [ 45, 37 ], 33 => [ 46, 39 ], 37 => [ 45 ], 39 => [ 46 ], 49 => [ 51, 50 ], 50 => [ 51 ], 54 => [ 53 ], 55 => [ 53, 54 ], 65 => [ 59 ], 67 => [ 60 ], 72 => [ 59, 65 ], 75 => [ 60, 67 ], 78 => [ 59, 65, 72 ], 80 => [ 66 ], 82 => [ 60, 67, 75 ], 85 => [ 59, 65, 72, 78 ], 90 => [ 60, 67, 75, 82 ], 91 => [ 59, 65, 72, 78, 85 ], 94 => [ 66, 80 ], 97 => [ 60, 67, 75, 82, 90 ] },
	{  1 => [ 46, 38, 31, 23, 16,  8 ],  8 => [ 46, 38, 31, 23, 16 ], 11 => [ 39, 25 ], 16 => [ 46, 38, 31, 23 ], 23 => [ 46, 38, 31 ], 25 => [ 39 ], 27 => [ 47, 40, 34 ], 31 => [ 46, 38 ], 34 => [ 47, 40 ], 38 => [ 46 ], 40 => [ 47 ], 49 => [ 52, 51, 50 ], 50 => [ 52, 51 ], 51 => [ 52 ], 55 => [ 54 ], 66 => [ 60 ], 68 => [ 61 ], 73 => [ 60, 66 ], 76 => [ 61, 68 ], 79 => [ 60, 66, 73 ], 81 => [ 67 ], 83 => [ 61, 68, 76 ], 86 => [ 60, 66, 73, 79 ], 92 => [ 60, 66, 73, 79, 86 ], 95 => [ 67, 81 ] },
	{  2 => [ 47, 39, 32, 24, 17,  9 ],  9 => [ 47, 39, 32, 24, 17 ], 12 => [ 40, 26 ], 17 => [ 47, 39, 32, 24 ], 24 => [ 47, 39, 32 ], 26 => [ 40 ], 32 => [ 47, 39 ], 39 => [ 47 ], 41 => [ 48 ], 49 => [ 53, 52, 51, 50 ], 50 => [ 53, 52, 51 ], 51 => [ 53, 52 ], 52 => [ 53 ], 67 => [ 61 ], 69 => [ 62 ], 74 => [ 61, 67 ], 80 => [ 61, 67, 74 ], 82 => [ 68 ], 87 => [ 61, 67, 74, 80 ], 93 => [ 61, 67, 74, 80, 87 ], 96 => [ 68, 82 ] },
	{  3 => [ 48, 40, 33, 25, 18, 10 ], 10 => [ 48, 40, 33, 25, 18 ], 13 => [ 41, 27 ], 18 => [ 48, 40, 33, 25 ], 25 => [ 48, 40, 33 ], 27 => [ 41 ], 33 => [ 48, 40 ], 40 => [ 48 ], 49 => [ 54, 53, 52, 51, 50 ], 50 => [ 54, 53, 52, 51 ], 51 => [ 54, 53, 52 ], 52 => [ 54, 53 ], 53 => [ 54 ], 68 => [ 62 ], 75 => [ 62, 68 ], 81 => [ 62, 68, 75 ], 83 => [ 69 ], 88 => [ 62, 68, 75, 81 ], 94 => [ 62, 68, 75, 81, 88 ], 97 => [ 69, 83 ] },
	{  0 => [ 42, 28, 14 ],  4 => [ 49, 43, 36, 30, 23, 17, 10 ], 10 => [ 49, 43, 36, 30, 23, 17 ], 14 => [ 42, 28 ], 17 => [ 49, 43, 36, 30, 23 ], 23 => [ 49, 43, 36, 30 ], 28 => [ 42 ], 30 => [ 49, 43, 36 ], 36 => [ 49, 43 ], 43 => [ 49 ], 58 => [ 57 ], 59 => [ 57, 58 ], 60 => [ 57, 58, 59 ], 61 => [ 57, 58, 59, 60 ], 62 => [ 57, 58, 59, 60, 61 ], 71 => [ 63 ], 78 => [ 63, 71 ], 84 => [ 70 ], 86 => [ 63, 71, 78 ], 93 => [ 63, 71, 78, 86 ] },
	{  1 => [ 43, 29, 15 ],  5 => [ 50, 44, 37, 31, 24, 18, 11 ], 11 => [ 50, 44, 37, 31, 24, 18 ], 15 => [ 43, 29 ], 18 => [ 50, 44, 37, 31, 24 ], 24 => [ 50, 44, 37, 31 ], 29 => [ 43 ], 31 => [ 50, 44, 37 ], 37 => [ 50, 44 ], 42 => [ 49 ], 44 => [ 50 ], 59 => [ 58 ], 60 => [ 58, 59 ], 61 => [ 58, 59, 60 ], 62 => [ 58, 59, 60, 61 ], 70 => [ 63 ], 72 => [ 64 ], 79 => [ 64, 72 ], 85 => [ 71 ], 87 => [ 64, 72, 79 ], 94 => [ 64, 72, 79, 87 ] },
	{  2 => [ 44, 30, 16 ],  6 => [ 51, 45, 38, 32, 25, 19, 12 ], 12 => [ 51, 45, 38, 32, 25, 19 ], 16 => [ 44, 30 ], 19 => [ 51, 45, 38, 32, 25 ], 25 => [ 51, 45, 38, 32 ], 28 => [ 50, 43, 35 ], 30 => [ 44 ], 32 => [ 51, 45, 38 ], 35 => [ 50, 43 ], 38 => [ 51, 45 ], 43 => [ 50 ], 45 => [ 51 ], 56 => [ 57 ], 60 => [ 59 ], 61 => [ 59, 60 ], 62 => [ 59, 60, 61 ], 71 => [ 64 ], 73 => [ 65 ], 77 => [ 64, 71 ], 80 => [ 65, 73 ], 84 => [ 64, 71, 77 ], 86 => [ 72 ], 88 => [ 65, 73, 80 ], 95 => [ 65, 73, 80, 88 ] },
	{  3 => [ 45, 31, 17 ], 13 => [ 52, 46, 39, 33, 26, 20 ], 14 => [ 51, 44, 36, 29, 21 ], 17 => [ 45, 31 ], 20 => [ 52, 46, 39, 33, 26 ], 21 => [ 51, 44, 36, 29 ], 26 => [ 52, 46, 39, 33 ], 29 => [ 51, 44, 36 ], 31 => [ 45 ], 33 => [ 52, 46, 39 ], 36 => [ 51, 44 ], 39 => [ 52, 46 ], 44 => [ 51 ], 46 => [ 52 ], 56 => [ 58, 57 ], 57 => [ 58 ], 61 => [ 60 ], 62 => [ 60, 61 ], 72 => [ 65 ], 74 => [ 66 ], 78 => [ 65, 72 ], 81 => [ 66, 74 ], 85 => [ 65, 72, 78 ], 87 => [ 73 ], 89 => [ 66, 74, 81 ], 91 => [ 65, 72, 78, 85 ], 96 => [ 66, 74, 81, 89 ] },
	{  0 => [ 52, 45, 37, 30, 22, 15,  7 ],  4 => [ 46, 32, 18 ],  7 => [ 52, 45, 37, 30, 22, 15 ], 15 => [ 52, 45, 37, 30, 22 ], 18 => [ 46, 32 ], 22 => [ 52, 45, 37, 30 ], 27 => [ 53, 47, 40, 34 ], 30 => [ 52, 45, 37 ], 32 => [ 46 ], 34 => [ 53, 47, 40 ], 37 => [ 52, 45 ], 40 => [ 53, 47 ], 45 => [ 52 ], 47 => [ 53 ], 56 => [ 59, 58, 57 ], 57 => [ 59, 58 ], 58 => [ 59 ], 62 => [ 61 ], 73 => [ 66 ], 75 => [ 67 ], 79 => [ 66, 73 ], 82 => [ 67, 75 ], 86 => [ 66, 73, 79 ], 88 => [ 74 ], 90 => [ 67, 75, 82 ], 92 => [ 66, 73, 79, 86 ], 97 => [ 67, 75, 82, 90 ] },
	{  1 => [ 53, 46, 38, 31, 23, 16,  8 ],  5 => [ 47, 33, 19 ],  8 => [ 53, 46, 38, 31, 23, 16 ], 16 => [ 53, 46, 38, 31, 23 ], 19 => [ 47, 33 ], 23 => [ 53, 46, 38, 31 ], 31 => [ 53, 46, 38 ], 33 => [ 47 ], 38 => [ 53, 46 ], 41 => [ 54, 48 ], 46 => [ 53 ], 48 => [ 54 ], 56 => [ 60, 59, 58, 57 ], 57 => [ 60, 59, 58 ], 58 => [ 60, 59 ], 59 => [ 60 ], 74 => [ 67 ], 76 => [ 68 ], 80 => [ 67, 74 ], 83 => [ 68, 76 ], 87 => [ 67, 74, 80 ], 89 => [ 75 ], 93 => [ 67, 74, 80, 87 ] },
	{  2 => [ 54, 47, 39, 32, 24, 17,  9 ],  6 => [ 48, 34, 20 ],  9 => [ 54, 47, 39, 32, 24, 17 ], 17 => [ 54, 47, 39, 32, 24 ], 20 => [ 48, 34 ], 24 => [ 54, 47, 39, 32 ], 32 => [ 54, 47, 39 ], 34 => [ 48 ], 39 => [ 54, 47 ], 47 => [ 54 ], 56 => [ 61, 60, 59, 58, 57 ], 57 => [ 61, 60, 59, 58 ], 58 => [ 61, 60, 59 ], 59 => [ 61, 60 ], 60 => [ 61 ], 75 => [ 68 ], 81 => [ 68, 75 ], 88 => [ 68, 75, 81 ], 90 => [ 76 ], 94 => [ 68, 75, 81, 88 ] },
	{  5 => [ 57, 50, 44, 37, 31, 24, 18, 11 ],  7 => [ 49, 35, 21 ], 11 => [ 57, 50, 44, 37, 31, 24, 18 ], 18 => [ 57, 50, 44, 37, 31, 24 ], 21 => [ 49, 35 ], 24 => [ 57, 50, 44, 37, 31 ], 31 => [ 57, 50, 44, 37 ], 35 => [ 49 ], 37 => [ 57, 50, 44 ], 44 => [ 57, 50 ], 50 => [ 57 ], 65 => [ 64 ], 66 => [ 64, 65 ], 67 => [ 64, 65, 66 ], 68 => [ 64, 65, 66, 67 ], 69 => [ 64, 65, 66, 67, 68 ], 78 => [ 71 ], 86 => [ 71, 78 ], 91 => [ 77 ], 93 => [ 71, 78, 86 ] },
	{  6 => [ 58, 51, 45, 38, 32, 25, 19, 12 ],  8 => [ 50, 36, 22 ], 12 => [ 58, 51, 45, 38, 32, 25, 19 ], 19 => [ 58, 51, 45, 38, 32, 25 ], 22 => [ 50, 36 ], 25 => [ 58, 51, 45, 38, 32 ], 32 => [ 58, 51, 45, 38 ], 36 => [ 50 ], 38 => [ 58, 51, 45 ], 42 => [ 57, 49 ], 45 => [ 58, 51 ], 49 => [ 57 ], 51 => [ 58 ], 66 => [ 65 ], 67 => [ 65, 66 ], 68 => [ 65, 66, 67 ], 69 => [ 65, 66, 67, 68 ], 77 => [ 71 ], 79 => [ 72 ], 84 => [ 71, 77 ], 87 => [ 72, 79 ], 92 => [ 78 ], 94 => [ 72, 79, 87 ] },
	{  9 => [ 51, 37, 23 ], 13 => [ 59, 52, 46, 39, 33, 26, 20 ], 20 => [ 59, 52, 46, 39, 33, 26 ], 23 => [ 51, 37 ], 26 => [ 59, 52, 46, 39, 33 ], 28 => [ 58, 50, 43, 35 ], 33 => [ 59, 52, 46, 39 ], 35 => [ 58, 50, 43 ], 37 => [ 51 ], 39 => [ 59, 52, 46 ], 43 => [ 58, 50 ], 46 => [ 59, 52 ], 50 => [ 58 ], 52 => [ 59 ], 63 => [ 64 ], 67 => [ 66 ], 68 => [ 66, 67 ], 69 => [ 66, 67, 68 ], 78 => [ 72 ], 80 => [ 73 ], 85 => [ 72, 78 ], 88 => [ 73, 80 ], 91 => [ 72, 78, 85 ], 93 => [ 79 ], 95 => [ 73, 80, 88 ] },
	{ 10 => [ 52, 38, 24 ], 14 => [ 59, 51, 44, 36, 29, 21 ], 21 => [ 59, 51, 44, 36, 29 ], 24 => [ 52, 38 ], 27 => [ 60, 53, 47, 40, 34 ], 29 => [ 59, 51, 44, 36 ], 34 => [ 60, 53, 47, 40 ], 36 => [ 59, 51, 44 ], 38 => [ 52 ], 40 => [ 60, 53, 47 ], 44 => [ 59, 51 ], 47 => [ 60, 53 ], 51 => [ 59 ], 53 => [ 60 ], 63 => [ 65, 64 ], 64 => [ 65 ], 68 => [ 67 ], 69 => [ 67, 68 ], 79 => [ 73 ], 81 => [ 74 ], 86 => [ 73, 79 ], 89 => [ 74, 81 ], 92 => [ 73, 79, 86 ], 94 => [ 80 ], 96 => [ 74, 81, 89 ] },
	{  0 => [ 60, 52, 45, 37, 30, 22, 15,  7 ],  7 => [ 60, 52, 45, 37, 30, 22, 15 ], 11 => [ 53, 39, 25 ], 15 => [ 60, 52, 45, 37, 30, 22 ], 22 => [ 60, 52, 45, 37, 30 ], 25 => [ 53, 39 ], 30 => [ 60, 52, 45, 37 ], 37 => [ 60, 52, 45 ], 39 => [ 53 ], 41 => [ 61, 54, 48 ], 45 => [ 60, 52 ], 48 => [ 61, 54 ], 52 => [ 60 ], 54 => [ 61 ], 63 => [ 66, 65, 64 ], 64 => [ 66, 65 ], 65 => [ 66 ], 69 => [ 68 ], 80 => [ 74 ], 82 => [ 75 ], 87 => [ 74, 80 ], 90 => [ 75, 82 ], 93 => [ 74, 80, 87 ], 95 => [ 81 ], 97 => [ 75, 82, 90 ] },
	{  1 => [ 61, 53, 46, 38, 31, 23, 16,  8 ],  8 => [ 61, 53, 46, 38, 31, 23, 16 ], 12 => [ 54, 40, 26 ], 16 => [ 61, 53, 46, 38, 31, 23 ], 23 => [ 61, 53, 46, 38, 31 ], 26 => [ 54, 40 ], 31 => [ 61, 53, 46, 38 ], 38 => [ 61, 53, 46 ], 40 => [ 54 ], 46 => [ 61, 53 ], 53 => [ 61 ], 55 => [ 62 ], 63 => [ 67, 66, 65, 64 ], 64 => [ 67, 66, 65 ], 65 => [ 67, 66 ], 66 => [ 67 ], 81 => [ 75 ], 83 => [ 76 ], 88 => [ 75, 81 ], 94 => [ 75, 81, 88 ], 96 => [ 82 ] },
	{  2 => [ 62, 54, 47, 39, 32, 24, 17,  9 ],  9 => [ 62, 54, 47, 39, 32, 24, 17 ], 13 => [ 55, 41, 27 ], 17 => [ 62, 54, 47, 39, 32, 24 ], 24 => [ 62, 54, 47, 39, 32 ], 27 => [ 55, 41 ], 32 => [ 62, 54, 47, 39 ], 39 => [ 62, 54, 47 ], 41 => [ 55 ], 47 => [ 62, 54 ], 54 => [ 62 ], 63 => [ 68, 67, 66, 65, 64 ], 64 => [ 68, 67, 66, 65 ], 65 => [ 68, 67, 66 ], 66 => [ 68, 67 ], 67 => [ 68 ], 82 => [ 76 ], 89 => [ 76, 82 ], 95 => [ 76, 82, 89 ], 97 => [ 83 ] },
	{  0 => [ 56, 42, 28, 14 ],  5 => [ 63, 57, 50, 44, 37, 31, 24, 18, 11 ], 11 => [ 63, 57, 50, 44, 37, 31, 24, 18 ], 14 => [ 56, 42, 28 ], 18 => [ 63, 57, 50, 44, 37, 31, 24 ], 24 => [ 63, 57, 50, 44, 37, 31 ], 28 => [ 56, 42 ], 31 => [ 63, 57, 50, 44, 37 ], 37 => [ 63, 57, 50, 44 ], 42 => [ 56 ], 44 => [ 63, 57, 50 ], 50 => [ 63, 57 ], 57 => [ 63 ], 72 => [ 71 ], 73 => [ 71, 72 ], 74 => [ 71, 72, 73 ], 75 => [ 71, 72, 73, 74 ], 76 => [ 71, 72, 73, 74, 75 ], 85 => [ 77 ], 92 => [ 77, 85 ] },
	{  1 => [ 57, 43, 29, 15 ],  6 => [ 64, 58, 51, 45, 38, 32, 25, 19, 12 ], 12 => [ 64, 58, 51, 45, 38, 32, 25, 19 ], 15 => [ 57, 43, 29 ], 19 => [ 64, 58, 51, 45, 38, 32, 25 ], 25 => [ 64, 58, 51, 45, 38, 32 ], 29 => [ 57, 43 ], 32 => [ 64, 58, 51, 45, 38 ], 38 => [ 64, 58, 51, 45 ], 43 => [ 57 ], 45 => [ 64, 58, 51 ], 51 => [ 64, 58 ], 56 => [ 63 ], 58 => [ 64 ], 73 => [ 72 ], 74 => [ 72, 73 ], 75 => [ 72, 73, 74 ], 76 => [ 72, 73, 74, 75 ], 84 => [ 77 ], 86 => [ 78 ], 93 => [ 78, 86 ] },
	{  2 => [ 58, 44, 30, 16 ], 13 => [ 65, 59, 52, 46, 39, 33, 26, 20 ], 16 => [ 58, 44, 30 ], 20 => [ 65, 59, 52, 46, 39, 33, 26 ], 26 => [ 65, 59, 52, 46, 39, 33 ], 30 => [ 58, 44 ], 33 => [ 65, 59, 52, 46, 39 ], 39 => [ 65, 59, 52, 46 ], 42 => [ 64, 57, 49 ], 44 => [ 58 ], 46 => [ 65, 59, 52 ], 49 => [ 64, 57 ], 52 => [ 65, 59 ], 57 => [ 64 ], 59 => [ 65 ], 70 => [ 71 ], 74 => [ 73 ], 75 => [ 73, 74 ], 76 => [ 73, 74, 75 ], 85 => [ 78 ], 87 => [ 79 ], 91 => [ 78, 85 ], 94 => [ 79, 87 ] },
	{  3 => [ 59, 45, 31, 17 ], 17 => [ 59, 45, 31 ], 27 => [ 66, 60, 53, 47, 40, 34 ], 28 => [ 65, 58, 50, 43, 35 ], 31 => [ 59, 45 ], 34 => [ 66, 60, 53, 47, 40 ], 35 => [ 65, 58, 50, 43 ], 40 => [ 66, 60, 53, 47 ], 43 => [ 65, 58, 50 ], 45 => [ 59 ], 47 => [ 66, 60, 53 ], 50 => [ 65, 58 ], 53 => [ 66, 60 ], 58 => [ 65 ], 60 => [ 66 ], 70 => [ 72, 71 ], 71 => [ 72 ], 75 => [ 74 ], 76 => [ 74, 75 ], 86 => [ 79 ], 88 => [ 80 ], 92 => [ 79, 86 ], 95 => [ 80, 88 ] },
	{  4 => [ 60, 46, 32, 18 ], 14 => [ 66, 59, 51, 44, 36, 29, 21 ], 18 => [ 60, 46, 32 ], 21 => [ 66, 59, 51, 44, 36, 29 ], 29 => [ 66, 59, 51, 44, 36 ], 32 => [ 60, 46 ], 36 => [ 66, 59, 51, 44 ], 41 => [ 67, 61, 54, 48 ], 44 => [ 66, 59, 51 ], 46 => [ 60 ], 48 => [ 67, 61, 54 ], 51 => [ 66, 59 ], 54 => [ 67, 61 ], 59 => [ 66 ], 61 => [ 67 ], 70 => [ 73, 72, 71 ], 71 => [ 73, 72 ], 72 => [ 73 ], 76 => [ 75 ], 87 => [ 80 ], 89 => [ 81 ], 93 => [ 80, 87 ], 96 => [ 81, 89 ] },
	{  0 => [ 67, 60, 52, 45, 37, 30, 22, 15,  7 ],  5 => [ 61, 47, 33, 19 ],  7 => [ 67, 60, 52, 45, 37, 30, 22, 15 ], 15 => [ 67, 60, 52, 45, 37, 30, 22 ], 19 => [ 61, 47, 33 ], 22 => [ 67, 60, 52, 45, 37, 30 ], 30 => [ 67, 60, 52, 45, 37 ], 33 => [ 61, 47 ], 37 => [ 67, 60, 52, 45 ], 45 => [ 67, 60, 52 ], 47 => [ 61 ], 52 => [ 67, 60 ], 55 => [ 68, 62 ], 60 => [ 67 ], 62 => [ 68 ], 70 => [ 74, 73, 72, 71 ], 71 => [ 74, 73, 72 ], 72 => [ 74, 73 ], 73 => [ 74 ], 88 => [ 81 ], 90 => [ 82 ], 94 => [ 81, 88 ], 97 => [ 82, 90 ] },
	{  1 => [ 68, 61, 53, 46, 38, 31, 23, 16,  8 ],  6 => [ 62, 48, 34, 20 ],  8 => [ 68, 61, 53, 46, 38, 31, 23, 16 ], 16 => [ 68, 61, 53, 46, 38, 31, 23 ], 20 => [ 62, 48, 34 ], 23 => [ 68, 61, 53, 46, 38, 31 ], 31 => [ 68, 61, 53, 46, 38 ], 34 => [ 62, 48 ], 38 => [ 68, 61, 53, 46 ], 46 => [ 68, 61, 53 ], 48 => [ 62 ], 53 => [ 68, 61 ], 61 => [ 68 ], 70 => [ 75, 74, 73, 72, 71 ], 71 => [ 75, 74, 73, 72 ], 72 => [ 75, 74, 73 ], 73 => [ 75, 74 ], 74 => [ 75 ], 89 => [ 82 ], 95 => [ 82, 89 ] },
	{  6 => [ 71, 64, 58, 51, 45, 38, 32, 25, 19, 12 ],  7 => [ 63, 49, 35, 21 ], 12 => [ 71, 64, 58, 51, 45, 38, 32, 25, 19 ], 19 => [ 71, 64, 58, 51, 45, 38, 32, 25 ], 21 => [ 63, 49, 35 ], 25 => [ 71, 64, 58, 51, 45, 38, 32 ], 32 => [ 71, 64, 58, 51, 45, 38 ], 35 => [ 63, 49 ], 38 => [ 71, 64, 58, 51, 45 ], 45 => [ 71, 64, 58, 51 ], 49 => [ 63 ], 51 => [ 71, 64, 58 ], 58 => [ 71, 64 ], 64 => [ 71 ], 79 => [ 78 ], 80 => [ 78, 79 ], 81 => [ 78, 79, 80 ], 82 => [ 78, 79, 80, 81 ], 83 => [ 78, 79, 80, 81, 82 ], 92 => [ 85 ] },
	{  8 => [ 64, 50, 36, 22 ], 13 => [ 72, 65, 59, 52, 46, 39, 33, 26, 20 ], 20 => [ 72, 65, 59, 52, 46, 39, 33, 26 ], 22 => [ 64, 50, 36 ], 26 => [ 72, 65, 59, 52, 46, 39, 33 ], 33 => [ 72, 65, 59, 52, 46, 39 ], 36 => [ 64, 50 ], 39 => [ 72, 65, 59, 52, 46 ], 46 => [ 72, 65, 59, 52 ], 50 => [ 64 ], 52 => [ 72, 65, 59 ], 56 => [ 71, 63 ], 59 => [ 72, 65 ], 63 => [ 71 ], 65 => [ 72 ], 80 => [ 79 ], 81 => [ 79, 80 ], 82 => [ 79, 80, 81 ], 83 => [ 79, 80, 81, 82 ], 91 => [ 85 ], 93 => [ 86 ] },
	{  9 => [ 65, 51, 37, 23 ], 23 => [ 65, 51, 37 ], 27 => [ 73, 66, 60, 53, 47, 40, 34 ], 34 => [ 73, 66, 60, 53, 47, 40 ], 37 => [ 65, 51 ], 40 => [ 73, 66, 60, 53, 47 ], 42 => [ 72, 64, 57, 49 ], 47 => [ 73, 66, 60, 53 ], 49 => [ 72, 64, 57 ], 51 => [ 65 ], 53 => [ 73, 66, 60 ], 57 => [ 72, 64 ], 60 => [ 73, 66 ], 64 => [ 72 ], 66 => [ 73 ], 77 => [ 78 ], 81 => [ 80 ], 82 => [ 80, 81 ], 83 => [ 80, 81, 82 ], 92 => [ 86 ], 94 => [ 87 ] },
	{ 10 => [ 66, 52, 38, 24 ], 24 => [ 66, 52, 38 ], 28 => [ 73, 65, 58, 50, 43, 35 ], 35 => [ 73, 65, 58, 50, 43 ], 38 => [ 66, 52 ], 41 => [ 74, 67, 61, 54, 48 ], 43 => [ 73, 65, 58, 50 ], 48 => [ 74, 67, 61, 54 ], 50 => [ 73, 65, 58 ], 52 => [ 66 ], 54 => [ 74, 67, 61 ], 58 => [ 73, 65 ], 61 => [ 74, 67 ], 65 => [ 73 ], 67 => [ 74 ], 77 => [ 79, 78 ], 78 => [ 79 ], 82 => [ 81 ], 83 => [ 81, 82 ], 93 => [ 87 ], 95 => [ 88 ] },
	{ 11 => [ 67, 53, 39, 25 ], 14 => [ 74, 66, 59, 51, 44, 36, 29, 21 ], 21 => [ 74, 66, 59, 51, 44, 36, 29 ], 25 => [ 67, 53, 39 ], 29 => [ 74, 66, 59, 51, 44, 36 ], 36 => [ 74, 66, 59, 51, 44 ], 39 => [ 67, 53 ], 44 => [ 74, 66, 59, 51 ], 51 => [ 74, 66, 59 ], 53 => [ 67 ], 55 => [ 75, 68, 62 ], 59 => [ 74, 66 ], 62 => [ 75, 68 ], 66 => [ 74 ], 68 => [ 75 ], 77 => [ 80, 79, 78 ], 78 => [ 80, 79 ], 79 => [ 80 ], 83 => [ 82 ], 94 => [ 88 ], 96 => [ 89 ] },
	{  0 => [ 75, 67, 60, 52, 45, 37, 30, 22, 15,  7 ],  7 => [ 75, 67, 60, 52, 45, 37, 30, 22, 15 ], 12 => [ 68, 54, 40, 26 ], 15 => [ 75, 67, 60, 52, 45, 37, 30, 22 ], 22 => [ 75, 67, 60, 52, 45, 37, 30 ], 26 => [ 68, 54, 40 ], 30 => [ 75, 67, 60, 52, 45, 37 ], 37 => [ 75, 67, 60, 52, 45 ], 40 => [ 68, 54 ], 45 => [ 75, 67, 60, 52 ], 52 => [ 75, 67, 60 ], 54 => [ 68 ], 60 => [ 75, 67 ], 67 => [ 75 ], 69 => [ 76 ], 77 => [ 81, 80, 79, 78 ], 78 => [ 81, 80, 79 ], 79 => [ 81, 80 ], 80 => [ 81 ], 95 => [ 89 ], 97 => [ 90 ] },
	{  1 => [ 76, 68, 61, 53, 46, 38, 31, 23, 16,  8 ],  8 => [ 76, 68, 61, 53, 46, 38, 31, 23, 16 ], 13 => [ 69, 55, 41, 27 ], 16 => [ 76, 68, 61, 53, 46, 38, 31, 23 ], 23 => [ 76, 68, 61, 53, 46, 38, 31 ], 27 => [ 69, 55, 41 ], 31 => [ 76, 68, 61, 53, 46, 38 ], 38 => [ 76, 68, 61, 53, 46 ], 41 => [ 69, 55 ], 46 => [ 76, 68, 61, 53 ], 53 => [ 76, 68, 61 ], 55 => [ 69 ], 61 => [ 76, 68 ], 68 => [ 76 ], 77 => [ 82, 81, 80, 79, 78 ], 78 => [ 82, 81, 80, 79 ], 79 => [ 82, 81, 80 ], 80 => [ 82, 81 ], 81 => [ 82 ], 96 => [ 90 ] },
	{  0 => [ 70, 56, 42, 28, 14 ],  6 => [ 77, 71, 64, 58, 51, 45, 38, 32, 25, 19, 12 ], 12 => [ 77, 71, 64, 58, 51, 45, 38, 32, 25, 19 ], 14 => [ 70, 56, 42, 28 ], 19 => [ 77, 71, 64, 58, 51, 45, 38, 32, 25 ], 25 => [ 77, 71, 64, 58, 51, 45, 38, 32 ], 28 => [ 70, 56, 42 ], 32 => [ 77, 71, 64, 58, 51, 45, 38 ], 38 => [ 77, 71, 64, 58, 51, 45 ], 42 => [ 70, 56 ], 45 => [ 77, 71, 64, 58, 51 ], 51 => [ 77, 71, 64, 58 ], 56 => [ 70 ], 58 => [ 77, 71, 64 ], 64 => [ 77, 71 ], 71 => [ 77 ], 86 => [ 85 ], 87 => [ 85, 86 ], 88 => [ 85, 86, 87 ], 89 => [ 85, 86, 87, 88 ], 90 => [ 85, 86, 87, 88, 89 ] },
	{  1 => [ 71, 57, 43, 29, 15 ], 13 => [ 78, 72, 65, 59, 52, 46, 39, 33, 26, 20 ], 15 => [ 71, 57, 43, 29 ], 20 => [ 78, 72, 65, 59, 52, 46, 39, 33, 26 ], 26 => [ 78, 72, 65, 59, 52, 46, 39, 33 ], 29 => [ 71, 57, 43 ], 33 => [ 78, 72, 65, 59, 52, 46, 39 ], 39 => [ 78, 72, 65, 59, 52, 46 ], 43 => [ 71, 57 ], 46 => [ 78, 72, 65, 59, 52 ], 52 => [ 78, 72, 65, 59 ], 57 => [ 71 ], 59 => [ 78, 72, 65 ], 65 => [ 78, 72 ], 70 => [ 77 ], 72 => [ 78 ], 87 => [ 86 ], 88 => [ 86, 87 ], 89 => [ 86, 87, 88 ], 90 => [ 86, 87, 88, 89 ] },
	{  2 => [ 72, 58, 44, 30, 16 ], 16 => [ 72, 58, 44, 30 ], 27 => [ 79, 73, 66, 60, 53, 47, 40, 34 ], 30 => [ 72, 58, 44 ], 34 => [ 79, 73, 66, 60, 53, 47, 40 ], 40 => [ 79, 73, 66, 60, 53, 47 ], 44 => [ 72, 58 ], 47 => [ 79, 73, 66, 60, 53 ], 53 => [ 79, 73, 66, 60 ], 56 => [ 78, 71, 63 ], 58 => [ 72 ], 60 => [ 79, 73, 66 ], 63 => [ 78, 71 ], 66 => [ 79, 73 ], 71 => [ 78 ], 73 => [ 79 ], 84 => [ 85 ], 88 => [ 87 ], 89 => [ 87, 88 ], 90 => [ 87, 88, 89 ] },
	{  3 => [ 73, 59, 45, 31, 17 ], 17 => [ 73, 59, 45, 31 ], 31 => [ 73, 59, 45 ], 41 => [ 80, 74, 67, 61, 54, 48 ], 42 => [ 79, 72, 64, 57, 49 ], 45 => [ 73, 59 ], 48 => [ 80, 74, 67, 61, 54 ], 49 => [ 79, 72, 64, 57 ], 54 => [ 80, 74, 67, 61 ], 57 => [ 79, 72, 64 ], 59 => [ 73 ], 61 => [ 80, 74, 67 ], 64 => [ 79, 72 ], 67 => [ 80, 74 ], 72 => [ 79 ], 74 => [ 80 ], 84 => [ 86, 85 ], 85 => [ 86 ], 89 => [ 88 ], 90 => [ 88, 89 ] },
	{  4 => [ 74, 60, 46, 32, 18 ], 18 => [ 74, 60, 46, 32 ], 28 => [ 80, 73, 65, 58, 50, 43, 35 ], 32 => [ 74, 60, 46 ], 35 => [ 80, 73, 65, 58, 50, 43 ], 43 => [ 80, 73, 65, 58, 50 ], 46 => [ 74, 60 ], 50 => [ 80, 73, 65, 58 ], 55 => [ 81, 75, 68, 62 ], 58 => [ 80, 73, 65 ], 60 => [ 74 ], 62 => [ 81, 75, 68 ], 65 => [ 80, 73 ], 68 => [ 81, 75 ], 73 => [ 80 ], 75 => [ 81 ], 84 => [ 87, 86, 85 ], 85 => [ 87, 86 ], 86 => [ 87 ], 90 => [ 89 ] },
	{  5 => [ 75, 61, 47, 33, 19 ], 14 => [ 81, 74, 66, 59, 51, 44, 36, 29, 21 ], 19 => [ 75, 61, 47, 33 ], 21 => [ 81, 74, 66, 59, 51, 44, 36, 29 ], 29 => [ 81, 74, 66, 59, 51, 44, 36 ], 33 => [ 75, 61, 47 ], 36 => [ 81, 74, 66, 59, 51, 44 ], 44 => [ 81, 74, 66, 59, 51 ], 47 => [ 75, 61 ], 51 => [ 81, 74, 66, 59 ], 59 => [ 81, 74, 66 ], 61 => [ 75 ], 66 => [ 81, 74 ], 69 => [ 82, 76 ], 74 => [ 81 ], 76 => [ 82 ], 84 => [ 88, 87, 86, 85 ], 85 => [ 88, 87, 86 ], 86 => [ 88, 87 ], 87 => [ 88 ] },
	{  0 => [ 82, 75, 67, 60, 52, 45, 37, 30, 22, 15,  7 ],  6 => [ 76, 62, 48, 34, 20 ],  7 => [ 82, 75, 67, 60, 52, 45, 37, 30, 22, 15 ], 15 => [ 82, 75, 67, 60, 52, 45, 37, 30, 22 ], 20 => [ 76, 62, 48, 34 ], 22 => [ 82, 75, 67, 60, 52, 45, 37, 30 ], 30 => [ 82, 75, 67, 60, 52, 45, 37 ], 34 => [ 76, 62, 48 ], 37 => [ 82, 75, 67, 60, 52, 45 ], 45 => [ 82, 75, 67, 60, 52 ], 48 => [ 76, 62 ], 52 => [ 82, 75, 67, 60 ], 60 => [ 82, 75, 67 ], 62 => [ 76 ], 67 => [ 82, 75 ], 75 => [ 82 ], 84 => [ 89, 88, 87, 86, 85 ], 85 => [ 89, 88, 87, 86 ], 86 => [ 89, 88, 87 ], 87 => [ 89, 88 ], 88 => [ 89 ] },
	{  7 => [ 77, 63, 49, 35, 21 ], 13 => [ 85, 78, 72, 65, 59, 52, 46, 39, 33, 26, 20 ], 20 => [ 85, 78, 72, 65, 59, 52, 46, 39, 33, 26 ], 21 => [ 77, 63, 49, 35 ], 26 => [ 85, 78, 72, 65, 59, 52, 46, 39, 33 ], 33 => [ 85, 78, 72, 65, 59, 52, 46, 39 ], 35 => [ 77, 63, 49 ], 39 => [ 85, 78, 72, 65, 59, 52, 46 ], 46 => [ 85, 78, 72, 65, 59, 52 ], 49 => [ 77, 63 ], 52 => [ 85, 78, 72, 65, 59 ], 59 => [ 85, 78, 72, 65 ], 63 => [ 77 ], 65 => [ 85, 78, 72 ], 72 => [ 85, 78 ], 78 => [ 85 ], 93 => [ 92 ], 94 => [ 92, 93 ], 95 => [ 92, 93, 94 ], 96 => [ 92, 93, 94, 95 ], 97 => [ 92, 93, 94, 95, 96 ] },
	{  8 => [ 78, 64, 50, 36, 22 ], 22 => [ 78, 64, 50, 36 ], 27 => [ 86, 79, 73, 66, 60, 53, 47, 40, 34 ], 34 => [ 86, 79, 73, 66, 60, 53, 47, 40 ], 36 => [ 78, 64, 50 ], 40 => [ 86, 79, 73, 66, 60, 53, 47 ], 47 => [ 86, 79, 73, 66, 60, 53 ], 50 => [ 78, 64 ], 53 => [ 86, 79, 73, 66, 60 ], 60 => [ 86, 79, 73, 66 ], 64 => [ 78 ], 66 => [ 86, 79, 73 ], 70 => [ 85, 77 ], 73 => [ 86, 79 ], 77 => [ 85 ], 79 => [ 86 ], 94 => [ 93 ], 95 => [ 93, 94 ], 96 => [ 93, 94, 95 ], 97 => [ 93, 94, 95, 96 ] },
	{  9 => [ 79, 65, 51, 37, 23 ], 23 => [ 79, 65, 51, 37 ], 37 => [ 79, 65, 51 ], 41 => [ 87, 80, 74, 67, 61, 54, 48 ], 48 => [ 87, 80, 74, 67, 61, 54 ], 51 => [ 79, 65 ], 54 => [ 87, 80, 74, 67, 61 ], 56 => [ 86, 78, 71, 63 ], 61 => [ 87, 80, 74, 67 ], 63 => [ 86, 78, 71 ], 65 => [ 79 ], 67 => [ 87, 80, 74 ], 71 => [ 86, 78 ], 74 => [ 87, 80 ], 78 => [ 86 ], 80 => [ 87 ], 91 => [ 92 ], 95 => [ 94 ], 96 => [ 94, 95 ], 97 => [ 94, 95, 96 ] },
	{ 10 => [ 80, 66, 52, 38, 24 ], 24 => [ 80, 66, 52, 38 ], 38 => [ 80, 66, 52 ], 42 => [ 87, 79, 72, 64, 57, 49 ], 49 => [ 87, 79, 72, 64, 57 ], 52 => [ 80, 66 ], 55 => [ 88, 81, 75, 68, 62 ], 57 => [ 87, 79, 72, 64 ], 62 => [ 88, 81, 75, 68 ], 64 => [ 87, 79, 72 ], 66 => [ 80 ], 68 => [ 88, 81, 75 ], 72 => [ 87, 79 ], 75 => [ 88, 81 ], 79 => [ 87 ], 81 => [ 88 ], 91 => [ 93, 92 ], 92 => [ 93 ], 96 => [ 95 ], 97 => [ 95, 96 ] },
	{ 11 => [ 81, 67, 53, 39, 25 ], 25 => [ 81, 67, 53, 39 ], 28 => [ 88, 80, 73, 65, 58, 50, 43, 35 ], 35 => [ 88, 80, 73, 65, 58, 50, 43 ], 39 => [ 81, 67, 53 ], 43 => [ 88, 80, 73, 65, 58, 50 ], 50 => [ 88, 80, 73, 65, 58 ], 53 => [ 81, 67 ], 58 => [ 88, 80, 73, 65 ], 65 => [ 88, 80, 73 ], 67 => [ 81 ], 69 => [ 89, 82, 76 ], 73 => [ 88, 80 ], 76 => [ 89, 82 ], 80 => [ 88 ], 82 => [ 89 ], 91 => [ 94, 93, 92 ], 92 => [ 94, 93 ], 93 => [ 94 ], 97 => [ 96 ] },
	{ 12 => [ 82, 68, 54, 40, 26 ], 14 => [ 89, 81, 74, 66, 59, 51, 44, 36, 29, 21 ], 21 => [ 89, 81, 74, 66, 59, 51, 44, 36, 29 ], 26 => [ 82, 68, 54, 40 ], 29 => [ 89, 81, 74, 66, 59, 51, 44, 36 ], 36 => [ 89, 81, 74, 66, 59, 51, 44 ], 40 => [ 82, 68, 54 ], 44 => [ 89, 81, 74, 66, 59, 51 ], 51 => [ 89, 81, 74, 66, 59 ], 54 => [ 82, 68 ], 59 => [ 89, 81, 74, 66 ], 66 => [ 89, 81, 74 ], 68 => [ 82 ], 74 => [ 89, 81 ], 81 => [ 89 ], 83 => [ 90 ], 91 => [ 95, 94, 93, 92 ], 92 => [ 95, 94, 93 ], 93 => [ 95, 94 ], 94 => [ 95 ] },
	{  0 => [ 90, 82, 75, 67, 60, 52, 45, 37, 30, 22, 15,  7 ],  7 => [ 90, 82, 75, 67, 60, 52, 45, 37, 30, 22, 15 ], 13 => [ 83, 69, 55, 41, 27 ], 15 => [ 90, 82, 75, 67, 60, 52, 45, 37, 30, 22 ], 22 => [ 90, 82, 75, 67, 60, 52, 45, 37, 30 ], 27 => [ 83, 69, 55, 41 ], 30 => [ 90, 82, 75, 67, 60, 52, 45, 37 ], 37 => [ 90, 82, 75, 67, 60, 52, 45 ], 41 => [ 83, 69, 55 ], 45 => [ 90, 82, 75, 67, 60, 52 ], 52 => [ 90, 82, 75, 67, 60 ], 55 => [ 83, 69 ], 60 => [ 90, 82, 75, 67 ], 67 => [ 90, 82, 75 ], 69 => [ 83 ], 75 => [ 90, 82 ], 82 => [ 90 ], 91 => [ 96, 95, 94, 93, 92 ], 92 => [ 96, 95, 94, 93 ], 93 => [ 96, 95, 94 ], 94 => [ 96, 95 ], 95 => [ 96 ] },
];

1;
