// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        scenewin.h
//
// Purpose:     interface to 3D scene, managed with InterViews
//
// Created:     26 Jan 94   Michael Pichler
//
// Changed:      9 Jan 96   Michael Pichler
//
// $Id: scenewin.h,v 1.10 1996/02/01 10:06:02 mpichler Exp $
//
//</file>


#ifndef hg_viewer_hg3d_scenewin_h
#define hg_viewer_hg3d_scenewin_h


#include "scene3d.h"

#include <hyperg/utils/str.h>

#include <InterViews/enter-scope.h>
class Allocation;
class ApplicationWindow;
class Event;
class Session;
class Window;

#include <Dispatch/enter-scope.h>
class IOHandler;

class GEContext;
class HG3dInputHandler;
class ProgressIndicator;
class SceneMenus;
class TextBrowser;


class NavMode
{
  public:
    enum { flip_obj, walk_around, fly_1, fly_2, heads_up, num_navmodes };
}; // navigation mode


class FlipMode
{
  public:
    enum { flip_all, flip_translate, flip_rotate, flip_zoom };
}; // submode of flip object (currently unused, may be reactivated in future)


class SceneWindow: public Scene3D
{
  public:
    SceneWindow (Session*,              // create application window
      const char* wintitle);
    virtual ~SceneWindow ();

    ApplicationWindow* appwin ()        // application window
    { return appwin_; }

    SceneMenus* menus ()                // menu class
    { return themenus_; }

    void redraw ();                     // redraw GL window

    void reset ();                      // reset scene and redraw

    void setCamera (                    // set a camera (no redraw)
      const point3D& position,
      const point3D& lookat,
      const vector3D* up = 0            // optional up vector
    );

    void drawAll (const Allocation&);   // draw scene and UI atop it

    void updateLanguage ();             // update language dependent components

    // Scene3D
    virtual void clear ();              // clear scene

    int readSceneFILE (FILE* file);     // read scene from file (uncompresses data)
    void progress (float p, int id);    // progress of reading scene
    void showNumFaces ();               // feedback: number of polygons

    // error messages
    void errorMessage (const char*) const;  // error message (redirected into dialog)

    void loadTextureFile (              // load texture file
      Material* mat, const char* file
    );

    void selectionChanged ();           // for enabling/disabling menu items

    // viewpoint menu
    void registerCamera (               // add camera to viewpoint list
      const char* name,
      QvPerspectiveCamera*,
      QvOrthographicCamera*
    );

    // navigation modes
    void setNavigationMode (int mode);  // set navigation mode
    int navigationMode () const         // get current navigation mode
    { return navmode_; }
    static int modeDrawsUI (int mode)   // are drawings done atop scene
    { return (mode != NavMode::flip_obj); }

    void navigationHint (int);          // not to mix up with NavMode

    // flip object submode (currently unused)
    int flipObjectMode () const
    { return FlipMode::flip_all; }

    int anchorMotion () const           // motion when anchors highlighted
    { return anchormotion_; }           // (replaces AnchorMotion::active)
    void anchorMotion (int flag)
    { anchormotion_ = flag; }

    int velocityControl () const        // drag mouse to control velocity
    { return velocitycontrol_; }        // instead of movements in modes
    void velocityControl (int flag)     // walk and heads-up
    { velocitycontrol_ = flag; }

    int showFramerate () const          // time and framerate feedback
    { return measuretime_; }
    void showFramerate (int flag);
    void toggleShowFramerate ()
    { showFramerate (!measuretime_); }

    // selection modes
    enum { SelectObject, SelectGroup };
    int selectionMode () const          // replaces Optselection::state
    { return selectionmode_; }
    void selectionMode (int flag)
    { selectionmode_ = flag; }

    // anchor activation
    void activateAnchor ();             // activate currently selected anchor

    virtual void beginFeedback ();      // feedback
    virtual void endFeedback ();        // (on activateAnchor)
    virtual void endFeedback (long, long)  { }  // IO-Callback
    void doEndFeedback (long a, long b)
    { endFeedback (a, b); }             // g++ patch

    // status line
    void statusMessage (const char*);   // give hint in status line (Scene3D)

    void setTitle (const char* title)   // set title/name of scene
    { title_ = title;  showTitle (); }
    void showTitle ();                  // show title in status line

    void giveNavigationHint ();         // navigation usage hint in status line

    // key handling
    void handleKeystroke (const Event&);  // handle key strokes

    GEContext* gecontext ()         { return gecontext_; }
    HG3dInputHandler* ihandler ()   { return hg3dinput_; }
    ProgressIndicator* progrind ()  { return progrind_; }
    double feedbacktime ()          { return feedbacktime_; }
    IOHandler* feedbackhandler ()   { return feedbackhandler_; }

    // spaceball initialisation
    static int init_spaceball (Window* win);  // returns non-zero if spaceball found

    // remote calls
    virtual void acceptRemoteRequests (Window*, int /*on*/)  { }
    virtual void propertyRemoteRequest (Window*, const Event&)  { }

  private:
    int navmode_;
    SceneMenus* themenus_;
    ProgressIndicator* progrind_;
    RString title_;

    int anchormotion_;
    int velocitycontrol_;
    int selectionmode_;
    int measuretime_;

    GEContext* gecontext_;
    HG3dInputHandler* hg3dinput_;
    ApplicationWindow* appwin_;
    double feedbacktime_;  // ms
    IOHandler* feedbackhandler_;

    void makeappwin (Session*,          // create application window and gecontext
      const char* wintitle);
    void setdefaults ();                // load Xdefaults

    int readSceneU (FILE*);             // read scene for uncompressed data

}; // SceneWindow



#endif
