//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
// 
//</copyright>


//<file>
//
// Name:        labels.C
//
// Purpose:     interface to UnderlinedLabel
//
// Created:      9 Sep 94   Michael Pichler
//
// Changed:     11 Oct 94   Michael Pichler
//
// Changed:     08 Jun 95   Bernhard Marschall (moved WLabel functionality to IV)
//
//
//</file>


#include "labels.h"

#include <InterViews/brush.h>
#include <InterViews/canvas.h>
#include <InterViews/color.h>
#include <InterViews/font.h>
#include <InterViews/hit.h>

#include <IV-look/kit.h>
#include <OS/string.h>


UnderlinedLabel::UnderlinedLabel (
  const char* str, const Font* font, const Color* color,
  int from, int to
)
: Label (str, font, color)
{
  if (from < 0)
    from = 0;
  from_ = from;
  to_ = to;

  brush_ = new Brush (0.0);  // thin brush
  Resource::ref (brush_);
}


UnderlinedLabel::~UnderlinedLabel ()
{
  Resource::unref (brush_);
}


void UnderlinedLabel::draw (Canvas* c, const Allocation& a) const
{
  int len = string ()->length ();

  Label::draw (c, a);

  int to = to_;
  if (to < 0 || to > len)
    to = len;  // underline whole label

  if (from_ < to)
  {
    Coord asc = ascent ();
    Coord des = descent ();
    Coord base = a.y () - des/2;
    Coord left = a.x () - 0.2;
    const Coord* cw = charWidths ();

    int i = from_;  // assert: from >= 0
    while (i--)
      left += *cw++;
    Coord right = left;
    i = to - from_;
    while (i--)
      right += *cw++;

    c->line (left, base, right, base, color (), brush_);
  }
} // draw


/*** kit for underlined labels ***/

UnderlinedLabel* UnderlinedLabel::udlLabel (
  WidgetKit& kit, const char* str,
  const char* style, const char* alias)
{
  if (style)
    kit.begin_style (style);
  if (alias)
    kit.alias (alias);

  UnderlinedLabel* ulabel = new UnderlinedLabel (str, kit.font (), kit.foreground (), 0, -1);

  if (style)
    kit.end_style ();

  return ulabel;
}


UnderlinedLabel* UnderlinedLabel::hotLabel (
  WidgetKit& kit, const char* str,
  const char* style, const char* alias,
  int no, int num)
{
  if (style)
    kit.begin_style (style);
  if (alias)
    kit.alias (alias);

  UnderlinedLabel* ulabel = new UnderlinedLabel (str, kit.font (), kit.foreground (), no, no+num);

  if (style)
    kit.end_style ();

  return ulabel;
}
