// -*- C++ -*-

//<copyright>
//
// Copyright (c) 1993
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
//
//</copyright>

//<file>
//
// Name: sscrbox.h
//
// Purpose: interface to class SmoothTBScrollBox
//
// Created: 1.9.94   Gaisbauer Mansuet Juergen
//
// Modified:
//
// Description:
//
//</file>


#ifndef harmony_widgets_sscrbox_h_
#define harmony_widgets_sscrbox_h_

#include <InterViews/adjust.h>
#include <InterViews/polyglyph.h>
#include <InterViews/scrbox.h>
#include <InterViews/transformer.h>
#include <OS/list.h>

class Canvas;
class SmoothTBScrollBox;

class GlyphInfo
{
  private:
    Allocation allocation_;
    Glyph* glyph_;
  friend class SmoothTBScrollBox;
};

class ComponentInfo
{
  private:
    Requirement y_req_;
    Coord offs_;
  friend class SmoothTBScrollBox;
};

declareList(ComponentInfoList, ComponentInfo)
declareList(GlyphInfoList, GlyphInfo)


class SmoothTBScrollBox: public ScrollBox
{
  public:
     SmoothTBScrollBox(GlyphIndex size = 10);
     virtual ~SmoothTBScrollBox();
     
     virtual void request(Requisition&) const;
     virtual void allocate(Canvas*, const Allocation&, Extension&);
     virtual void draw(Canvas*, const Allocation&) const;
     virtual void pick(Canvas*, const Allocation&, int depth, Hit&);
     virtual void undraw();
     
     virtual void modified(GlyphIndex);
     virtual boolean shown(GlyphIndex) const;
     virtual GlyphIndex first_shown() const;
     virtual GlyphIndex last_shown() const;
     virtual void allotment(GlyphIndex, DimensionName, Allotment&) const;
     
     virtual Coord lower(DimensionName) const;
     virtual Coord upper(DimensionName) const;
     virtual Coord length(DimensionName) const;
     virtual Coord cur_lower(DimensionName) const;
     virtual Coord cur_upper(DimensionName) const;
     virtual Coord cur_length(DimensionName) const;
     
     virtual void scroll_forward(DimensionName);
     virtual void scroll_backward(DimensionName);
     virtual void page_forward(DimensionName);
     virtual void page_backward(DimensionName);

     virtual void scroll_to(DimensionName, Coord lower);
     virtual void scrollOnTop(GlyphIndex i);
     // scroll such that line i becomes the top line
     virtual void scrollOnBottom(GlyphIndex i);
     // scroll such that line i becomes the bottom line

  private:
     GlyphIndex first_shown_;  // index of the first visual component
     GlyphIndex last_shown_;   // index of the last visual component
     GlyphInfoList shown_list_;

     Coord cur_lower_;
     Coord cur_upper_;

     Coord length_;

     boolean changed_;

     Requisition requisition_;
     boolean requested_;
     Canvas* canvas_;
     Transformer transformer_;
     Allocation allocation_;
     Extension extension_;

     ComponentInfoList component_infos_;

     void check(Canvas*, const Allocation&) const;
     void refresh() const;
     void reallocate();
     void redraw();
     void undraw_range(GlyphIndex begin, GlyphIndex end);

     void scroll_by(DimensionName, Coord);
     void do_scroll(DimensionName, Coord new_start, Coord new_end);
     GlyphIndex getComponentRel(Coord, GlyphIndex);

};  // SmoothTBScrollBox


#endif
