#if 0
// This allows usage of this file with plain C

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        harcolors.h
//
// Purpose:     interface to Harmony colormap
//
// Created:     05 Apr 95   Michael Pichler
//
// Changed:     05 Apr 95   Bernhard Marschall
//
//
//</file>
#endif

#ifndef harcolors_h
#define harcolors_h

typedef struct
{
  unsigned short r, g, b;
} HarColor;



extern const HarColor harmony_color[];
extern const int num_harmony_colors;
extern const unsigned char map_RGB_harmony[];

#define HarGetColorIndex_f(r, g, b) \
( map_RGB_harmony[(int) ((r) * 15.5) << 8 | (int) ((g) * 15.5) << 4 | (int) ((b) * 15.5)] )
/* 0 <= r, g, b <= 1 */

#define HarGetColorIndex_16(r, g, b) \
( map_RGB_harmony[(int)(r) << 8 | (int)(g) << 4 | (int)(b)] )
/* 0 <= r, g, b <= 15 */

#define HarGetColorIndex_256(r, g, b) \
( map_RGB_harmony[(int) ((r)&0xf0) << 4 | (int) ((g)&0xf0) | (int) (b) >> 4] )
/* 0 <= r, g, b <= 255 */

#endif
