        SUBROUTINE  SSF
     *     (N, P,IP, IA,JA, IJU,JU,IU,JUMAX, Q, MARK, JL, FLAG)           SD 315
C                                                                         SD 316
C  ADDITIONAL PARAMETERS                                                  SD 317
C                                                                         SD 318
C    Q     - INTEGER ONE-DIMENSIONAL WORK ARRAY;  DIMENSION = N           SD 319
C                                                                         SD 320
C    MARK  - INTEGER ONE-DIMENSIONAL WORK ARRAY;  DIMENSION = N           SD 321
C                                                                         SD 322
C    JL    - INTEGER ONE-DIMENSIONAL WORK ARRAY;  DIMENSION = N           SD 323
C                                                                         SD 324
C                                                                         SD 325
C  DEFINITIONS OF INTERNAL PARAMETERS (DURING K-TH STAGE OF ELIMINATION)  SD 326
C                                                                         SD 327
C    Q CONTAINS AN ORDERED LINKED LIST REPRESENTATION OF THE NONZERO      SD 328
C      STRUCTURE OF THE K-TH ROW OF U --                                  SD 329
C        Q(K) IS THE FIRST COLUMN WITH A NONZERO ENTRY                    SD 330
C        Q(I) IS THE NEXT COLUMN WITH A NONZERO ENTRY AFTER COLUMN I      SD 331
C      IN EITHER CASE, Q(I) = N+1 INDICATES THE END OF THE LIST           SD 332
C                                                                         SD 333
C    JL CONTAINS LISTS OF ROWS TO BE MERGED INTO UNELIMINATED ROWS --     SD 334
C        I GE K => JL(I) IS THE FIRST ROW TO BE MERGED INTO ROW I         SD 335
C        I LT K => JL(I) IS THE ROW FOLLOWING ROW I IN SOME LIST OF ROWS  SD 336
C      IN EITHER CASE, JL(I) = 0 INDICATES THE END OF A LIST              SD 337
C                                                                         SD 338
C    MARK(I) IS THE LAST ROW STORED IN JU FOR WHICH U(MARK(I),I) NE 0     SD 339
C                                                                         SD 340
C    JUMIN AND JUPTR ARE THE INDICES IN JU OF THE FIRST AND LAST          SD 341
C      ELEMENTS IN THE LAST ROW SAVED IN JU                               SD 342
C                                                                         SD 343
C    LUK IS THE NUMBER OF NONZERO ENTRIES IN THE K-TH ROW                 SD 344
C                                                                         SD 345
C-----------------------------------------------------------------------  SD 346
C                                                                         SD 347
        INTEGER  P(1), IP(1),  IA(1), JA(1),  IJU(1), JU(1), IU(1),       SD 348
     *     Q(1),  MARK(1),  JL(1),  FLAG,  TAG, VJ, QM                    SD 349
        LOGICAL  CLIQUE                                                   SD 350
C                                                                         SD 351
C----INITIALIZATION                                                       SD 352
        JUMIN = 1                                                         SD 353
        JUPTR = 0                                                         SD 354
        IU(1) = 1                                                         SD 355
        DO 1 K=1,N                                                        SD 356
          MARK(K) = 0                                                     SD 357
   1      JL(K) = 0                                                       SD 358
C                                                                         SD 359
C----FOR EACH ROW K                                                       SD 360
        DO 18 K=1,N                                                       SD 361
          LUK = 0                                                         SD 362
          Q(K) = N+1                                                      SD 363
C                                                                         SD 364
          TAG = MARK(K)                                                   SD 365
          CLIQUE = .FALSE.                                                SD 366
          IF (JL(K).NE.0)  CLIQUE = JL(JL(K)).EQ.0                        SD 367
C                                                                         SD 368
C------INITIALIZE NONZERO STRUCTURE OF K-TH ROW TO ROW P(K) OF M          SD 369
          JMIN = IA(P(K))                                                 SD 370
          JMAX = IA(P(K)+1) - 1                                           SD 371
          IF (JMIN.GT.JMAX)  GO TO 4                                      SD 372
          DO 3 J=JMIN,JMAX                                                SD 373
            VJ = IP(JA(J))                                                SD 374
            IF (VJ.LE.K)  GO TO 3                                         SD 375
C                                                                         SD 376
              QM = K                                                      SD 377
   2          M = QM                                                      SD 378
              QM = Q(M)                                                   SD 379
              IF (QM.LT.VJ)  GO TO 2                                      SD 380
              IF (QM.EQ.VJ)  GO TO 102                                    SD 381
                LUK = LUK+1                                               SD 382
                Q(M) = VJ                                                 SD 383
                Q(VJ) = QM                                                SD 384
                IF (MARK(VJ).NE.TAG)  CLIQUE = .FALSE.                    SD 385
C                                                                         SD 386
   3        CONTINUE                                                      SD 387
C                                                                         SD 388
C------IF EXACTLY ONE ROW IS TO BE MERGED INTO THE K-TH ROW AND THERE IS  SD 389
C------A NONZERO ENTRY IN EVERY COLUMN IN THAT ROW IN WHICH THERE IS A    SD 390
C------NONZERO ENTRY IN ROW P(K) OF M, THEN DO NOT COMPUTE FILL-IN, JUST  SD 391
C------USE THE COLUMN INDICES FOR THE ROW WHICH WAS TO HAVE BEEN MERGED   SD 392
   4      IF (.NOT.CLIQUE)  GO TO 5                                       SD 393
            IJU(K) = IJU(JL(K)) + 1                                       SD 394
            LUK = IU(JL(K)+1) - (IU(JL(K))+1)                             SD 395
            GO TO 17                                                      SD 396
C                                                                         SD 397
C------MODIFY NONZERO STRUCTURE OF K-TH ROW BY COMPUTING FILL-IN          SD 398
C------FOR EACH ROW I TO BE MERGED IN                                     SD 399
   5      LMAX = 0                                                        SD 400
          IJU(K) = JUPTR                                                  SD 401
C                                                                         SD 402
          I = K                                                           SD 403
   6      I = JL(I)                                                       SD 404
          IF (I.EQ.0)  GO TO 10                                           SD 405
C                                                                         SD 406
C--------MERGE ROW I INTO K-TH ROW                                        SD 407
            LUI = IU(I+1) - (IU(I)+1)                                     SD 408
            JMIN = IJU(I) +  1                                            SD 409
            JMAX = IJU(I) + LUI                                           SD 410
            QM = K                                                        SD 411
C                                                                         SD 412
            DO 8 J=JMIN,JMAX                                              SD 413
              VJ = JU(J)                                                  SD 414
   7          M = QM                                                      SD 415
              QM = Q(M)                                                   SD 416
              IF (QM.LT.VJ)  GO TO 7                                      SD 417
              IF (QM.EQ.VJ)  GO TO 8                                      SD 418
                LUK = LUK+1                                               SD 419
                Q(M) = VJ                                                 SD 420
                Q(VJ) = QM                                                SD 421
                QM = VJ                                                   SD 422
   8          CONTINUE                                                    SD 423
C                                                                         SD 424
C--------REMEMBER LENGTH AND POSITION IN JU OF LONGEST ROW MERGED         SD 425
            IF (LUI.LE.LMAX)  GO TO 9                                     SD 426
              LMAX = LUI                                                  SD 427
              IJU(K) = JMIN                                               SD 428
C                                                                         SD 429
   9        GO TO 6                                                       SD 430
C                                                                         SD 431
C------IF THE K-TH ROW IS THE SAME LENGTH AS THE LONGEST ROW MERGED,      SD 432
C------THEN USE THE COLUMN INDICES FOR THAT ROW                           SD 433
  10      IF (LUK.EQ.LMAX)  GO TO 17                                      SD 434
C                                                                         SD 435
C------IF THE TAIL OF THE LAST ROW SAVED IN JU IS THE SAME AS THE HEAD    SD 436
C------OF THE K-TH ROW, THEN OVERLAP THE TWO SETS OF COLUMN INDICES --    SD 437
C--------SEARCH LAST ROW SAVED FOR FIRST NONZERO ENTRY IN K-TH ROW ...    SD 438
            I = Q(K)                                                      SD 439
            IF (JUMIN.GT.JUPTR)  GO TO 12                                 SD 440
            DO 11 JMIN=JUMIN,JUPTR                                        SD 441
              IF (JU(JMIN)-I)  11, 13, 12                                 SD 442
  11          CONTINUE                                                    SD 443
  12        GO TO 15                                                      SD 444
C                                                                         SD 445
C--------... AND THEN TEST WHETHER TAIL MATCHES HEAD OF K-TH ROW          SD 446
  13        IJU(K) = JMIN                                                 SD 447
            DO 14 J=JMIN,JUPTR                                            SD 448
              IF (JU(J).NE.I)  GO TO 15                                   SD 449
              I = Q(I)                                                    SD 450
              IF (I.GT.N)  GO TO 17                                       SD 451
  14          CONTINUE                                                    SD 452
            JUPTR = JMIN - 1                                              SD 453
C                                                                         SD 454
C------SAVE NONZERO STRUCTURE OF K-TH ROW IN JU                           SD 455
  15      I = K                                                           SD 456
          JUMIN = JUPTR +  1                                              SD 457
          JUPTR = JUPTR + LUK                                             SD 458
          IF (JUPTR.GT.JUMAX)  GO TO 106                                  SD 459
          DO 16 J=JUMIN,JUPTR                                             SD 460
            I = Q(I)                                                      SD 461
            JU(J) = I                                                     SD 462
  16        MARK(I) = K                                                   SD 463
          IJU(K) = JUMIN                                                  SD 464
C                                                                         SD 465
C------ADD K TO ROW LIST FOR FIRST NONZERO ELEMENT IN K-TH ROW            SD 466
  17      IF (LUK.LE.1)  GO TO 18                                         SD 467
            I = JU(IJU(K))                                                SD 468
            JL(K) = JL(I)                                                 SD 469
            JL(I) = K                                                     SD 470
C                                                                         SD 471
  18      IU(K+1) = IU(K) + LUK                                           SD 472
C                                                                         SD 473
        FLAG = 0                                                          SD 474
        RETURN                                                            SD 475
C                                                                         SD 476
C ** ERROR -- DUPLICATE ENTRY IN A                                        SD 477
 102    FLAG = 2*N + P(K)                                                 SD 478
        RETURN                                                            SD 479
C ** ERROR -- INSUFFICIENT STORAGE FOR JU                                 SD 480
 106    FLAG = 6*N + K                                                    SD 481
        RETURN                                                            SD 482
        END                                                               SD 483
