        SUBROUTINE  NSF
     *     (N, R,IC, IA,JA, IL,JL,JLMAX, IU,JU,JUMAX, Q, IM, FLAG)        ND 398
C                                                                         ND 399
C       INPUT VARIABLES:   N, R,IC, IA,JA, JLMAX, JUMAX.                  ND 400
C       OUTPUT VARIABLES:  IL,JL, IU,JU, FLAG.                            ND 401
C                                                                         ND 402
C       PARAMETERS USED INTERNALLY:                                       ND 403
C NIA   \ Q     - SUPPOSE M' IS THE RESULT OF REORDERING M;  IF           ND 404
C       \           PROCESSING OF THE KTH ROW OF M' (HENCE THE KTH ROWS   ND 405
C       \           OF L AND U) IS BEING DONE, THEN Q(J) IS INITIALLY     ND 406
C       \           NONZERO IF M'(K,J) IS NONZERO;  SINCE VALUES NEED     ND 407
C       \           NOT BE STORED, EACH ENTRY POINTS TO THE NEXT          ND 408
C       \           NONZERO;  FOR EXAMPLE, IF  N=9  AND THE 5TH ROW OF    ND 409
C       \           M' IS                                                 ND 410
C       \                   0 X X 0 X 0 0 X 0,                            ND 411
C       \           THEN Q WILL INITIALLY BE                              ND 412
C       \                   A 3 5 A 8 A A 10 A 2        (A - ARBITRARY);  ND 413
C       \           Q(N+1) POINTS TO THE FIRST NONZERO IN THE ROW AND     ND 414
C       \           THE LAST NONZERO POINTS TO  N+1;  AS THE ALGORITHM    ND 415
C       \           PROCEEDS, OTHER ELEMENTS OF Q ARE INSERTED IN THE     ND 416
C       \           LIST BECAUSE OF FILLIN.                               ND 417
C       \           SIZE = N+1.                                           ND 418
C NIA   \ IM    - AT EACH STEP IN THE FACTORIZATION, IM(I) IS THE LAST    ND 419
C       \           ELEMENT IN THE ITH ROW OF U WHICH NEEDS TO BE         ND 420
C       \           CONSIDERED IN COMPUTING FILLIN.                       ND 421
C       \           SIZE = N.                                             ND 422
C                                                                         ND 423
C  INTERNAL VARIABLES--                                                   ND 424
C    JLPTR - POINTS TO THE LAST POSITION USED IN  JL.                     ND 425
C    JUPTR - POINTS TO THE LAST POSITION USED IN  JU.                     ND 426
C                                                                         ND 427
        INTEGER  R(1), IC(1),  IA(1), JA(1),  IL(1), JL(1),               ND 428
     *     IU(1), JU(1),  Q(1),  IM(1),  FLAG,  QM, VJ                    ND 429
C                                                                         ND 430
C  ******  INITIALIZE POINTERS  ****************************************  ND 431
        JLPTR = 0                                                         ND 432
        IL(1) = 1                                                         ND 433
        JUPTR = 0                                                         ND 434
        IU(1) = 1                                                         ND 435
C                                                                         ND 436
C  ******  FOR EACH ROW OF L AND U  ************************************  ND 437
        DO 10 K=1,N                                                       ND 438
C  ******  SET Q TO THE REORDERED ROW OF A  ****************************  ND 439
          Q(N+1) = N+1                                                    ND 440
          JMIN = IA(R(K))                                                 ND 441
          JMAX = IA(R(K)+1) - 1                                           ND 442
          IF (JMIN.GT.JMAX)  GO TO 101                                    ND 443
          DO 2 J=JMIN,JMAX                                                ND 444
            VJ = IC(JA(J))                                                ND 445
            QM = N+1                                                      ND 446
   1        M = QM                                                        ND 447
            QM = Q(M)                                                     ND 448
            IF (QM.LT.VJ)  GO TO 1                                        ND 449
            IF (QM.EQ.VJ)  GO TO 102                                      ND 450
              Q(M) = VJ                                                   ND 451
              Q(VJ) = QM                                                  ND 452
   2        CONTINUE                                                      ND 453
C                                                                         ND 454
C  ******  FOR EACH ENTRY IN THE LOWER TRIANGLE  ***********************  ND 455
          I = N+1                                                         ND 456
   3      I = Q(I)                                                        ND 457
          IF (I.GE.K)  GO TO 7                                            ND 458
C  ******  L(K,I) WILL BE NONZERO, SO ADD IT TO JL  ********************  ND 459
            JLPTR = JLPTR+1                                               ND 460
            IF (JLPTR.GT.JLMAX)  GO TO 103                                ND 461
            JL(JLPTR) = I                                                 ND 462
            QM = I                                                        ND 463
C  ******  INSPECT ITH ROW FOR FILLIN, ADJUST IM IF POSSIBLE  **********  ND 464
            JMIN = IU(I)                                                  ND 465
            JMAX = IM(I)                                                  ND 466
            IF (JMIN.GT.JMAX)  GO TO 6                                    ND 467
            DO 5 J=JMIN,JMAX                                              ND 468
              VJ = JU(J)                                                  ND 469
              IF (VJ.EQ.K)  IM(I) = J                                     ND 470
   4          M = QM                                                      ND 471
              QM = Q(M)                                                   ND 472
              IF (QM.LT.VJ)  GO TO 4                                      ND 473
              IF (QM.EQ.VJ)  GO TO 5                                      ND 474
                Q(M) = VJ                                                 ND 475
                Q(VJ) = QM                                                ND 476
                QM = VJ                                                   ND 477
   5          CONTINUE                                                    ND 478
   6        GO TO 3                                                       ND 479
C                                                                         ND 480
C  ******  CHECK FOR NULL PIVOT  ***************************************  ND 481
   7      IF (I.NE.K)  GO TO 105                                          ND 482
C  ******  REMAINING ELEMENTS OF Q DEFINE STRUCTURE OF U(K, )  *********  ND 483
   8      I = Q(I)                                                        ND 484
          IF (I.GT.N)  GO TO 9                                            ND 485
            JUPTR = JUPTR+1                                               ND 486
            IF (JUPTR.GT.JUMAX)  GO TO 106                                ND 487
            JU(JUPTR) = I                                                 ND 488
            GO TO 8                                                       ND 489
C  ******  GET READY FOR NEXT ROW  *************************************  ND 490
   9      IM(K) = JUPTR                                                   ND 491
          IL(K+1) = JLPTR+1                                               ND 492
  10      IU(K+1) = JUPTR+1                                               ND 493
C                                                                         ND 494
        FLAG = 0                                                          ND 495
        RETURN                                                            ND 496
C                                                                         ND 497
C ** ERROR:  NULL ROW IN A                                                ND 498
 101    FLAG = N + R(K)                                                   ND 499
        RETURN                                                            ND 500
C ** ERROR:  DUPLICATE ENTRY IN A                                         ND 501
 102    FLAG = 2*N + R(K)                                                 ND 502
        RETURN                                                            ND 503
C ** ERROR:  INSUFFICIENT STORAGE FOR JL                                  ND 504
 103    FLAG = 3*N + K                                                    ND 505
        RETURN                                                            ND 506
C ** ERROR:  NULL PIVOT                                                   ND 507
 105    FLAG = 5*N + K                                                    ND 508
        RETURN                                                            ND 509
C ** ERROR:  INSUFFICIENT STORAGE FOR JU                                  ND 510
 106    FLAG = 6*N + K                                                    ND 511
        RETURN                                                            ND 512
        END                                                               ND 513
