        SUBROUTINE  NNS
     *     (N, R,C, IL,JL,L, D, IU,JU,U, Z, B, TMP)                       ND 633
C                                                                         ND 634
C       INPUT VARIABLES:   N, R,C, IL,JL,L, D, IU,JU,U, B                 ND 635
C       OUTPUT VARIABLES:  Z                                              ND 636
C                                                                         ND 637
C       PARAMETERS USED INTERNALLY:                                       ND 638
C FIA   \ TMP   - HOLDS NEW RIGHT-HAND SIDE B' FOR SOLUTION OF THE        ND 639
C       \           EQUATION UX = B'.                                     ND 640
C       \           SIZE = N.                                             ND 641
C                                                                         ND 642
        INTEGER  R(1), C(1),  IL(1), JL(1),  IU(1), JU(1)                 ND 643
C       REAL  L(1), D(1), U(1),  Z(1), B(1),  TMP(1), SUM                 ND 644
        DOUBLE PRECISION  L(1), D(1), U(1),  Z(1), B(1),  TMP(1), SUM     ND 645
C                                                                         ND 646
C  ******  SOLVE LDY = B  BY FORWARD SUBSTITUTION  *********************  ND 647
        DO 2 K=1,N                                                        ND 648
          SUM = B(R(K))                                                   ND 649
          JMIN = IL(K)                                                    ND 650
          JMAX = IL(K+1) - 1                                              ND 651
          IF (JMIN.GT.JMAX)  GO TO 2                                      ND 652
          DO 1 J=JMIN,JMAX                                                ND 653
   1        SUM = SUM - L(J) * TMP(JL(J))                                 ND 654
   2      TMP(K) = SUM * D(K)                                             ND 655
C                                                                         ND 656
C  ******  SOLVE  UX = Y  BY BACK SUBSTITUTION  ************************  ND 657
        K = N                                                             ND 658
        DO 5 I=1,N                                                        ND 659
          SUM = TMP(K)                                                    ND 660
          JMIN = IU(K)                                                    ND 661
          JMAX = IU(K+1) - 1                                              ND 662
          IF (JMIN.GT.JMAX)  GO TO 4                                      ND 663
          DO 3 J=JMIN,JMAX                                                ND 664
   3        SUM = SUM - U(J) * TMP(JU(J))                                 ND 665
   4      TMP(K) = SUM                                                    ND 666
          Z(C(K)) = SUM                                                   ND 667
   5      K = K-1                                                         ND 668
        RETURN                                                            ND 669
        END                                                               ND 670
