/*
### handle event from parameter space window ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>

void param_handle_event(param_canvas, event, arg)
Canvas          param_canvas;
Event          *event;
caddr_t         arg;
{
	static int r_x, r_y, r_xnew, r_ynew, r_tmp;
	static int e_x_tmp,e_y_tmp;
	int i,e_id, e_down,e_ctrl_down,e_shift_down, e_x, e_y;
	double win_xsize, win_ysize,x_scaled, y_scaled,**temp_x;
	extern Menu param_menu;
	extern Pixfont *boldfont24,*boldfont;
	extern Pixwin *param_pw;
	extern int slide_mode,record_on,cur_color,region_index,clipping,text_input_mode,more_digits_on;
	extern int mdim0,mdim0_init,n_displayed_data0,mdim1,segment_count0;
	extern int p_l_margin,p_b_margin,p_xwidth,p_ywidth,p_ycanvas;
	extern int n_stored_data1,n_stored_data1_save,n_stored_data0,n_stored_data0_save;
	extern int stop,rescale,param_cur_index[];
	extern int var_dim,func_dim,param_dim,full_dim,my_colormap_size;
	extern double *win_var_i,*win_var_f,*all_min,*all_max,*param;
        extern double **data0_x,**data1_x,**data2_x;
	extern char string[];

	e_down = event_is_down(event);
	e_id = event_id(event);
	if(e_down && e_id != LOC_MOVE ){
		e_ctrl_down = event_ctrl_is_down(event);
		e_shift_down = event_shift_is_down(event);
		if(e_ctrl_down != 0)
			e_ctrl_down = 1;
		if(e_shift_down != 0)
			e_shift_down = 1;
		e_x = event_x(event);
		e_y = event_y(event);
		if(!event_is_ascii(event)){
			e_x_tmp = e_x;
			e_y_tmp = e_y;
		}
		else if(text_input_mode) {
			sprintf(string,"%c",e_id);
			if(slide_mode)
				pw_text(param_pw,e_x_tmp,e_y_tmp,PIX_SRC | PIX_COLOR(cur_color),(Pixfont *)boldfont24,string);
			else
				pw_text(param_pw,e_x_tmp,e_y_tmp,PIX_SRC | PIX_COLOR(cur_color),(Pixfont *)boldfont24,string);
				/* temporarily use 24 point */
				/*
				pw_text(param_pw,e_x_tmp,e_y_tmp,PIX_SRC | PIX_COLOR(cur_color),(Pixfont *)boldfont,string);
				*/
			e_x_tmp += 10;
		}
		region_index = 0;
	}
	else {
		return;
	}

	/* menu */
	if(!e_ctrl_down && !e_shift_down && e_id == MS_RIGHT){
		menu_show(param_menu,param_canvas,event,0);
		return;
	}

	if (!rescale && e_ctrl_down && e_id == MS_MIDDLE ) {
		all_reset();
		clear_region(0);
		n_stored_data0_save = n_stored_data0;
		n_displayed_data0 = 0;
		n_stored_data0= 0;
		segment_count0 = 0;
		draw_all_objects(0);
		if(mdim0 > mdim0_init){
			mdim0 = mdim0_init;
			data0_x = (double **) realloc_main_data(mdim0,param_dim);
			if(!stop){
				sprintf(string,"data0: Memory reallocation done! new_dim = %d\n",mdim0);
				system_mess_proc(0,string);
			}
		}
		all_refresh();
		return;
	}

	/* Reset a parameter value from a mouse input */
	if (!rescale && !e_ctrl_down  && e_id == MS_LEFT){
		all_reset();
		if (region_index==0){
			sun_to_space_coord(&x_scaled,&y_scaled,e_x,e_y,0);
			param[param_cur_index[0]] = all_min[full_dim+param_cur_index[0]] + x_scaled * (all_max[full_dim+param_cur_index[0]] - all_min[full_dim+param_cur_index[0]]);
			param[param_cur_index[1]] = all_min[full_dim+param_cur_index[1]] + y_scaled * (all_max[full_dim+param_cur_index[1]] - all_min[full_dim+param_cur_index[1]]);
		}
		all_refresh();
		return;
	}

	if (!rescale && !e_ctrl_down && e_shift_down && e_id == MS_MIDDLE ) {
		all_reset();
		redisplay_data(0);
	}
	if (!rescale && e_ctrl_down && !e_shift_down && e_id == MS_RIGHT) {
		all_reset();
		system_mess_proc(0,"Parameter space selected!");
	}

	/* enter a rescaling mode */
	if ((rescale || e_ctrl_down) && e_id == MS_LEFT  ) {
		all_reset();
		if(e_ctrl_down)
			rescale = 1- rescale;
		if(rescale)
			frame_header_proc(0,"Rescaling On");
		else
			frame_header_proc(0,"Rescaling Off");
		box(param_pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1,1);
		r_x = e_x;
		r_y = e_y;
		r_xnew = r_x;
		r_ynew = r_y;
		box(param_pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1,1);
		return;
	}
	/* show the rubberband box for the rescaled region */
	if (rescale && e_id == LOC_DRAG ) {
		box(param_pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1,1);
		r_xnew = e_x;
		r_ynew = e_y;
		box(param_pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size - 1,1);
		return;
	}
	/* rescaling action and exit rescaling mode */
	if (rescale && e_id == MS_MIDDLE ) {
		box(param_pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1,1);
		all_reset();
		if (r_x > r_xnew) {
			r_tmp = r_xnew;
			r_xnew = r_x;
			r_x = r_tmp;
		}
		if (r_y < r_ynew) {
			r_tmp = r_ynew;
			r_ynew = r_y;
			r_y = r_tmp;
		}

		win_xsize = all_max[full_dim+param_cur_index[0]] - all_min[full_dim+param_cur_index[0]];
		win_ysize = all_max[full_dim+param_cur_index[1]] - all_min[full_dim+param_cur_index[1]];
		if(!e_shift_down) {
			all_max[full_dim+param_cur_index[0]] = all_min[full_dim+param_cur_index[0]] + win_xsize * (r_xnew - p_l_margin) / (double) p_xwidth;
			all_min[full_dim+param_cur_index[0]] += win_xsize * (r_x - p_l_margin) / (double) p_xwidth;
			all_max[full_dim+param_cur_index[1]] = all_min[full_dim+param_cur_index[1]] + win_ysize * ((p_ycanvas - r_ynew) - p_b_margin) / (double) p_ywidth;
			all_min[full_dim+param_cur_index[1]] += win_ysize * ((p_ycanvas - r_y) - p_b_margin) / (double) p_ywidth;
		}
		else {
			all_min[full_dim+param_cur_index[0]] -= win_xsize * (r_x - p_l_margin) / (r_xnew - r_x);
			all_max[full_dim+param_cur_index[0]] = all_min[full_dim+param_cur_index[0]] + win_xsize * p_xwidth / (r_xnew - r_x);
			all_min[full_dim+param_cur_index[1]] -= win_ysize * ((p_ycanvas - r_y) - p_b_margin) / (r_y - r_ynew);
			all_max[full_dim+param_cur_index[1]] = all_min[full_dim+param_cur_index[1]] + win_ysize * p_ywidth / (r_y - r_ynew);
		}
		redisplay_data(0);
		r_xnew = r_x;
		r_ynew = r_y;
		rescale = 0;
		if(rescale)
			frame_header_proc(0,"Rescaling On");
		else
			frame_header_proc(0,"Rescaling Off");
		all_refresh();
		return;
	}
	
	(void) handle_function_keys(0,e_id);
}
