/*
### draw and record orbits ###

Input: record_on: 0 no recording, 1: recording data

Note: draws only on phase and combined space window if they are
open and, for combined space window, in the right mode.
Data are recorded onto array "data1_*"
*/

void draw_record_orbit(vf,iter,record_on)
double vf[];
int iter,record_on;
{
	int color;
	extern int draw_mode,batch_on,colormap_option,dot_size,symbol_type,symbol_size,pix_type;

	if((color=pen_mode(vf,iter)) >= 0 ){
		/* dot mode */
		if(draw_mode==0)
			all_pen_down(1,vf,color,-1,dot_size,pix_type);
		/* symbol mode */
		else if(draw_mode==1)
			all_pen_down(1,vf,color,symbol_type,symbol_size,pix_type);
		/* record if record_on is on or in batch mode */
		if(batch_on || record_on)
			record_data(vf,color);
	}
}
