/*
### create panel for computing Poincare sections ###
*/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include "../modellib/class_kaos_def.h"

void create_section_panel()
{
	int i,ipanel_row = 0,px,py;
	void section_panel_quit_proc(),draw_all_proc();
	void polar_section_proc(), section_index_proc(), linear_interpolation_proc();
	extern Frame frame,section_frame;
	extern Panel section_panel;
	extern Pixfont *boldfont;	
	extern Panel_item section_panel_quit_item,draw_all_item;
	extern Panel_item polar_section_item,linear_interpolation_item,section_index_item,section_constant_item,n_poincare_item;
	extern short section_panel_show;
	extern int panel_colormap_on;
	extern int draw_all,more_digits_on,polar_section,enable_polar,var_dim;

	extern int p_l_margin,polar_section,linear_interpolation,section_index,model,n_poincare;
	extern double section_constant;
	extern char string[],string2[],**all_label,**win_var_label,**var_label,**var_polar_label;

	if(section_panel_show){
		window_set(section_frame,WIN_SHOW,TRUE,0);
		return;
	}
	else
		section_panel_show = 1;
	px =  (int) window_get(frame,WIN_X);
	py =  (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT);
	if(py > 950 - 200)
		py = 950 - 200;
	section_frame = window_create(frame, FRAME,
		FRAME_NO_CONFIRM, TRUE,
		FRAME_LABEL, "section",
		FRAME_SHOW_LABEL, TRUE,
		WIN_SHOW, TRUE,
		WIN_X, px,
		WIN_Y, py,
		WIN_FONT, boldfont,
		0);
	if(section_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		section_panel_show = 0;
		return;
	}
	section_panel = window_create(section_frame, PANEL,
		WIN_FONT, boldfont,
		0);
	if(section_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_section_panel();
		return;
	}
	section_panel_quit_item = panel_create_item(section_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(section_panel, "Quit", 5, boldfont),
		PANEL_NOTIFY_PROC, section_panel_quit_proc,
		0);
	/* Create PANEL_CYCLE_items */
	draw_all_item = panel_create_item(section_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Draw:",
		PANEL_CHOICE_STRINGS, "Poincare Section", "Project Orbit", 0,
		PANEL_VALUE, draw_all,
		PANEL_NOTIFY_PROC, draw_all_proc,
		0);
	polar_section_item = panel_create_item(section_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Polar Section:",
		PANEL_CHOICE_STRINGS, "Off", "On", 0,
		PANEL_VALUE, polar_section,
		PANEL_NOTIFY_PROC, polar_section_proc,
		0);
	linear_interpolation_item = panel_create_item(section_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Interpolation:",
		PANEL_CHOICE_STRINGS, "Unimplemented", "Linear", "Super Linear",0,
		PANEL_VALUE, linear_interpolation,
		PANEL_NOTIFY_PROC, linear_interpolation_proc,
		0);
	if(enable_polar && polar_section)
		for(i=0;i<var_dim;i++) win_var_label[i] = var_polar_label[i];
	else
		for(i=0;i<var_dim;i++) win_var_label[i] = var_label[i];
	section_index_item = panel_create_item(section_panel, PANEL_CYCLE,
			PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
			PANEL_LABEL_X, ATTR_COL(0),
			PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
			PANEL_LABEL_STRING, "Surface Index:",
			PANEL_VALUE, section_index,
			PANEL_NOTIFY_PROC, section_index_proc,
			PANEL_CHOICE_STRINGS, WIN_VAR_LABELS,0,
			0);

	if(more_digits_on){
		sprintf(string, "%.14lg", section_constant);
	}
	else {
		sprintf(string, "%lg", section_constant);
	}
	section_constant_item = panel_create_item(section_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 18,
		PANEL_LABEL_STRING, "Surface Constant:",
		0);
	sprintf(string, "%d", n_poincare);
	n_poincare_item = panel_create_item(section_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 9,
		PANEL_LABEL_STRING, "# Maximum:",
		0);
	window_fit(section_panel);
	window_fit(section_frame);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(section_panel,WIN_PIXWIN),"section_panel_cms");
}
