/*
### create menu for opening the panels and windows ###
*/

#include <suntool/sunview.h>

void create_open_menu()
{
	void param_window_proc(),main_panel_proc(),options_panel_proc(),save_load_panel_proc();
	void section_panel_proc(),window_size_panel_proc(),system_info_panel_proc();
	void aux_window_proc(),int_panel_proc(),fp_panel_proc(),exec_panel_proc(),auto_panel_proc();
	void tser_panel_proc(),fft_panel_proc(),lyap_panel_proc(),dims_panel_proc();
	void scan_panel_proc();
	extern Menu open_menu;
	extern Pixfont *boldfont;
	
	open_menu = menu_create(
			MENU_ITEM,
				MENU_STRING, "Main",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, main_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Parameter space",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, param_window_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Option",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, options_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Projection",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, window_size_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Save/load",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, save_load_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Section",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, section_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "System info",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, system_info_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Auxiliary space",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, aux_window_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Integration",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, int_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Periodic orbit",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, fp_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Execution",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, exec_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Auto",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, auto_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Time series",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, tser_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Fourier",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, fft_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Lyapunov",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, lyap_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Dimension",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, dims_panel_proc, 0,
			MENU_ITEM,
				MENU_STRING, "Scan",
				MENU_FONT, boldfont,
				MENU_NOTIFY_PROC, scan_panel_proc, 0,
		0);
}
