/* Lorenz system */

int lorenz_init()
{
	title_label = "Lorenz system";

	mapping_on = 0; 
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 3;
	param_dim = 3;
	func_dim = 3;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "z";
	param_label[0] = "sigma";
	param_label[1] = "rho";
	param_label[2] = "beta";
	func_label[0] = "t";
	func_label[1] = "x+y";
	func_label[2] = "x-y";

	param[0] = 10;
	param[1] = 28;
	param[2] = 2.6666666666666;
	var_i[0] = 0.1;
	var_i[1] = 0.1;
	var_i[2] = 0.1;

	param_min[0]= -20; param_max[0]= 20;
	param_min[1]= 0; param_max[1]= 40;
	param_min[2]= -5; param_max[2]= 5;
	var_min[0]= -30; var_max[0]= 30;
	var_min[1]= -30; var_max[1]= 30;
	var_min[2]= -5; var_max[2]= 50;
	func_min[0]= 0; func_max[0]= 100;
	func_min[1]= -60; func_max[1]= 60;
	func_min[2]= -60; func_max[2]= 60;

	f_p = lorenz_f;
	func_p = lorenz_func;
}

int lorenz_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	f[0] = p[0] * ( x[1] - x[0] );
	f[1] = p[1] * x[0] - x[1] - x[0] * x[2];
	f[2] = - p[2] * x[2] + x[0] * x[1];
	
}
int lorenz_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = t;
	f[1] = x[0] + x[1];
	f[2] = x[0] - x[1];
}
