
int d4genfn_init()
{
	title_label = "D4 Generating Function";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 1;
	enable_period = 0;
	
	var_dim = 4;
	param_dim = 5;
	func_dim = 2;
	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "z";
	var_label[3] = "w";
	var_polar_label[0] = "r";
	var_polar_label[1] = "rp";
	var_polar_label[2] = "theta";
	var_polar_label[3] = "thetap";
	param_label[0] = "Ls";
	param_label[1] = "La";
	param_label[2] = "A";
	param_label[3] = "B";
	param_label[4] = "C";
	func_label[0] = "Energy";
	func_label[1] = "AngMom";

	param[0] = 2;
	param[1] = 0;
	param[2] = 0;
	param[3] = 0;
	param[4] = 0;

	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;
	var_i[3] = 0;
	var_polar_i[0] = 0;
	var_polar_i[1] = 0;
	var_polar_i[2] = 0;
	var_polar_i[3] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;
	param_min[4]= -5; param_max[3]= 5;
	param_min[5]= -5; param_max[4]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;
	var_min[3]= -5; var_max[3]= 5;

	var_polar_min[0]= -5; var_polar_max[0]= 5;
	var_polar_min[1]= -5; var_polar_max[1]= 5;
	var_polar_min[2]= -pi; var_polar_max[2]= pi;
	var_polar_min[3]= -5; var_polar_max[3]= 5;

	f_p = d4genfn_f;
	func_p = d4genfn_func;
}

int d4genfn_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double v0sq,v1sq,v2sq,v3sq;
	v0sq = x[0] * x[0];
	v1sq = x[1] * x[1];
	v2sq = x[2] * x[2];
	v3sq = x[3] * x[3];
	if(index!=2){
		f[0] = p[0] * x[1] - p[1] * x[1]
		+ p[2] * x[1] * (v0sq+v1sq+v2sq+v3sq) 
		+ p[3] * x[1] * (v2sq+v3sq)
		+ p[4] * ( -x[1] * (v2sq-v3sq) +  2 * x[0] * x[2] * x[3]);
		f[2] = p[0] * x[3] - p[1] * x[3]
		+ p[2] * x[3] * (v0sq+v1sq+v2sq+v3sq) 
		+ p[3] * x[3] * (v0sq+v1sq)
		+ p[4] * ( -x[3] * (v0sq-v1sq) +  2 * x[0] * x[1] * x[2]);
	}
	if(index !=1){
		f[1] = p[0] * x[0] + p[1] * x[0]
		+ p[2] * x[0] * (v0sq+v1sq+v2sq+v3sq) 
		+ p[3] * x[0] * (v2sq+v3sq)
		+ p[4] * ( x[0] * (v2sq-v3sq) +  2 * x[1] * x[2] * x[3]);
		f[1] = -f[1];
		f[3] = p[0] * x[2] + p[1] * x[2]
		+ p[2] * x[2] * (v0sq+v1sq+v2sq+v3sq) 
		+ p[3] * x[2] * (v0sq+v1sq)
		+ p[4] * ( x[2] * (v0sq-v1sq) +  2 * x[0] * x[1] * x[3]);
		f[3] = -f[3];
	}
}
int d4genfn_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
        double v0sq,v1sq,v2sq,v3sq;

	/* energy and angular momentum are defined in euclidean
	coordinates */
	v0sq = x[0] * x[0];
	v2sq = x[2] * x[2];
	f[0] = 0.5 * (( x[1] * x[1] + x[3] * x[3]) - p[0]*(v0sq+v2sq) + 0.5 *
	(v0sq+v2sq)*(v0sq+v2sq) - p[1] * v0sq* v2sq);
	f[1] =  x[1] * x[2] - x[0] * x[3];
	
}
