/*
***************************************************************************
			Kaos main global variables

		Swan Kim and John Guckenheimer, POSTECH & Cornell U. 11/1/89

***************************************************************************
	Initialized variables are almost always customizable to
	change defaults.
	All path names and the printer name need to be changed to reflect
	the local environments.
	(This is automaically taken care of the shell script "kaos_install")
****************************************************************************
*/

/*--------------------------------------------------------------------------
	Initialization of sytsem labels (do not touch)
---------------------------------------------------------------------------*/
char tmp[20]="";	/* temporary label */
char base_frame_label[80] = "kaos - Swan Kim & John Guckenheimer - phase space";	/* Base frame label */
char startup_message[200] = "kaos written by Swan Kim & John Guckenheimer, POSTECH and Cornell U, pre alpha release 1.0 1/1990. All Copyrights Reserved.";	/* startup message */

/*-------------------------------------------------------------------------
	pathname initializations (local environment dependent)
---------------------------------------------------------------------------*/
char source_dir[MAX_LENGTH] = "/marcy/kim/kaos"; /* source directory (used to locate the source code */
char help_dir[MAX_LENGTH] = "/marcy/kim/kaos/helplib"; /* help file directory (used to locate the source code */
char graph_label[MAX_LENGTH] = "/marcy/kim/kaos/bin/kgraph";	/* a local graphic filter (modification of UNIX graph) */
char raster_label[MAX_LENGTH] = "/marcy/kim/kaos/bin/psraster -i"; /* a raster to postscript fileter */
char lpr_label[MAX_LENGTH] = "lpr -h -Plaser"; /* a line printer filter (lpr -Pprinter_name) */
char dir_name[MAX_LENGTH] = "/marcy/kim/kaos/examples"; /* directory where files for saving and loading  resides */
char colormap_dir_name[MAX_LENGTH] = "/marcy/kim/kaos/cmaplib"; /* directory where colormap files are stored */
char preproc_label[MAX_LENGTH] = "/marcy/kim/kaos/bin/kpic X 2 3"; /* a preprocessor which ouputs two column data from multicolumn input */
char batch_name[] = "/marcy/kim/kaos/kaos_batch"; /* a batch executable to be executed when a job is batched */
char file_name[MAX_LENGTH] = "tmp.dat"; /* file for saving and loading */
char tmp_name[MAX_LENGTH] = "tmp.dat"; /* temporary file */

/*------------------------------------------------------------------------
	font file names of various sizes (local environment dependent)
 *-------------------------------------------------------------------------*/
char font_file24[] = "/usr/lib/fonts/fixedwidthfonts/screen.b.16";
char font_file12[] = "/usr/lib/fonts/fixedwidthfonts/screen.b.12";
char font_file10[] = "/usr/lib/fonts/fixedwidthfonts/cour.b.10";

/*-------------------------------------------------------------------------
	Window configuration (customizable)
 -------------------------------------------------------------------------
	Full screen size: xwindow = 1152, ywindow = 900
	All drawing operations are done in my coordinates (bottom-left
	origin) and converted to Sun coordinates. (Top-left origin)
 *-------------------------------------------------------------------------*/
int xwindow = 650; int ywindow = 800;	/* base window width and height */
int xcanvas; int ycanvas;	/* phase space (base) canvas width and height */
int xwidth; int ywidth;	/* phase space box width and height */ 
int l_margin = 10; int b_margin = 20;	/* phase space box left and bottom margin */
int margin = 30; int margin_small = 10;	/* general purpose large and small
margins */
int colormap_height = 13; int colormap_width = 9; /* height and width of the colormap squares in a colormap strip displayed in the canvas */
int colormap_spacing= 8;/* spacing between the colormap strips */
int colormap_max_bands = 64; /* maximal number of colormap squares in a single strip */
int y_message=0;	/* top-left y coord for system messages */
int y_line_height = 14; /* height of each system message line */
int y_title_label=70;	/* top-left y coord for a title label */
int p_xwindow = 420; int p_ywindow = 420; /* width and height of the parameter space window */
int p_xwidth; int p_ywidth; /* width and height of the parameter space box */
int p_xcanvas; int p_ycanvas; /* width and height of the parameter space canvas */
int p_l_margin=10; int p_b_margin=20; /* left and bottom margins of the parameter space box */

/*-------------------------------------------------------------------------
	colormap file names (customizable)
	(they resides in the colormap directory specified by colormap_dir[].
	Colormaps are read by load_colormap())
-------------------------------------------------------------------------*/
/* White background */
char colormap_fname0[] = "cmap.x11r2.128";
char colormap_fname1[] = "cmap.depth.128";
char colormap_fname2[] = "cmap.nldepth.128";
char colormap_fname3[] = "cmap.alternating.128";
char colormap_fnameu[] = "cmap.user.128";
/* Black background */
char colormap_fname0i[] = "cmap.x11r2.128.i";
char colormap_fname1i[] = "cmap.depth.128.i";
char colormap_fname2i[] = "cmap.nldepth.128.i";
char colormap_fname3i[] = "cmap.alternating.128.i";
char colormap_fnameui[] = "cmap.user.128.i";

/*-------------------------------------------------------------------------
	global variables for colormap (customizable)
 *-------------------------------------------------------------------------*/
int my_colormap_size = MY_COLORMAP_SIZE;	/* total size of my colormap */
int var_colormap_size = VAR_COLORMAP_SIZE;	/* size of variable colormap */
unsigned char red[MY_COLORMAP_SIZE];	/* red intensity */
unsigned char green[MY_COLORMAP_SIZE];	/* green intensity */
unsigned char blue[MY_COLORMAP_SIZE];	/* blue intensity */
int bt_color = Orange;	/* color for backward transient orbits */	
int b_color = Red;	/* color for backward aymptotic orbits */
int ft_color = Green;	/* color for forward transient orbits */
int f_color = Blue;	/* color for forward asymptotic orbits */
int default_color = Black;	/* color chosen by default when it is not clear to which case orbits belong*/ 
int panel_colormap_on = 1;	/* turn on and off colormaps of panels */

/*-------------------------------------------------------------------------
	main data variables
---------------------------------------------------------------------------
	data0_* = parameter space data
	data1_* = phase space data
	data2_* = combined space data
	fp_* = periodic orbit data
-------------------------------------------------------------------------*/
int *data0_color,*data1_color,*data2_color;	/* color indices */
double **data0_x,**data1_x,**data2_x;		/* coordinates */

int *fp_period;	/* period of a periodic orbit */
double **fp_x;	/* coordinate of a single member of a periodic orbit */
double ***fp_eval;	/* eigenvalues of a periodic orbit */
double ***fp_evec;	/* eigenvectors of a periodic orbit */
double *fp_xerr;	/* error estimate of a periodic orbit */

/*-------------------------------------------------------------------------
	memory allocation dimensions for main data (customizable)
-------------------------------------------------------------------------*/
int mdim0_init = 500;	/* initial memory allocation dimension for data0 */
int mdim0_crit = 5000;	/* critical memory allocation dimension for data0 */
int mdim0_step = 2000;	/* incremental memory allocation dimension for data0 */
int mdim1_init = 20000;	/* initial memory allocation dimension for data1 */
int mdim1_crit = 50000;	/* critical memory allocation dimension for data1 */
int mdim1_step = 20000;	/* incremental memory allocation dimension for data1 */
int mdim2_init = 1000;	/* initial memory allocation dimension for data2 */
int mdim2_crit = 2000;	/* critical memory allocation dimension for data2 */
int mdim2_step = 1000;	/* incremental memory allocation dimension for data2 */
int mdim_fp_init = 100;	/* initial memory allocation dimension for data_fp */
int mdim_fp_crit = 500;	/* critical memory allocation dimension for data_fp */
int mdim_fp_step = 100;	/* incremental memory allocation dimension for data_fp*/
int mdim0;	/* current memory allocation dimension for data0 */
int mdim1;	/* current memory allocation dimension for data1 */
int mdim2;	/* current memory allocation dimension for data2 */
int mdim_fp;	/* current memory allocation dimension for data_fp */

/*-------------------------------------------------------------------------
	major variables defining individual dynamical systems
---------------------------------------------------------------------------*/
int var_dim;	/* dimension of phase space */
int func_dim;	/* dimension of function space */
int param_dim;	/* dimension of parameter space */
int full_dim;	/* dimension of full space (phase space + (function space)) */
char *title_label;	/* title label of a dynamical system */
char *model_label;	/* id label of the model */
int mapping_on;		/* 1: mapping, 0: vector field */
int inverse_on;		/* 1: explicit inverse exist, 0: otherwise */  
int fderiv_on;		/* 1: explicit jacobian exist, 0: otherwise */
int enable_polar;	/* 1: use secondary coords, 0: otherwise */
int enable_period;	/* 1: enable periodicity, 0: otherwise */
char **var_label;	/* label for primary phase space variables */
char **var_polar_label;	/* label for secondary phase space variables */
char **param_label;	/* label for parameters */
char **func_label;	/* label for functions */
char **all_label;	/* label for combined space data */

double *param;	/* parameters of the dynamical system */
double *param_min,*param_max;	/* lower and upper bounds of the parameter space box */
double *var_i,*var_polar_i;	/* initial starting values of primary and secondary phase space variables */
double var_min,*var_max;	/* lower and upper bounds of primary phase space variables */
double *var_polar_min,*var_polar_max; /* lower and upper bounds of secondary
phase space variables */
double *func;	/* function values */
double *func_min,*func_max;	/* lower and upper bounds of function space */
double *period_len;	/* length of a period of each variable */
double *func_min_top;	/* lower bound of function values */
double *func_max_top;	/* upper bound of funtion values */
double *param_min_top;	/* lower bound of parameter values */
double *param_max_top;	/* upper bound of parameter values */
double time;			/* current time or independent variable for integration */

/*-------------------------------------------------------------------------
	miscellaneous flags (customizable)
 *-------------------------------------------------------------------------*/
/* customizable system flags */
int clipping = 0;	/* 1: clip (not record) data outside the box */
int func_on = 1;		/* function mode toggle */
int show_error_mess= 1;	/* 1: show error message, 0: otherwise */
int more_digits_on = 0;	/* display more digits (achieve more accuracy) in text items */
int text_input_mode = 0;	/* 1: can enter texts inside the canvas */
int draw_mode = 0;	/* 0: dot mode, 1: symbol mode (during plotting) */
int symp_int_on = 0;	/* 1: if symplectic algorithm is invoked, 0: othewise (This is automatically set by int_driver_proc() and int_algorithm_proc()) */
int batch_on = 0; 	/* 0: always for main program,  1: for a batch program*/
int record_on = 1;	/* enable and disable recording of data */
int batch_count = 0;	/* counting the number of batch jobs submitted (used to index batch jobs) */
int new_data_format = 0;	/* 1: data in a new format, 0: old format */
int lock_interval = 100;	/* an interval between successive locking */
int nice_number = 18;	/* nice number for a batch job and other processes */
int auto_option = 0;	/* auto86 mode choice */
double cutoff = 1.e20;	/* maximal value of the coordinate considered to be not diverging. Kaos will stop if the coordinate value exceeds this. */

/* customizable graphic flags */
int pixel_depth = 8;		/* depth of a pixel (1: monochrome, 8: 8bit, 24: 24bit) */
int slide_mode = 0;	/* 1: mode for making slides of pictures from kaos */
int bell_on = 1;	/* activate the bell sound for error messages */
int boxes_on = 1;	/* 1: show boxes */
int grids_on = 1;	/* 1: show grids, if grids_on>=1, it is a # of grids*/
int axis_label_on = 1;	/* 1: show axis labels */
int title_label_on = 1;	/* 1: show title */
int colormap_strip_on = 1;	/* 1: show colormap strip */

/* non-customizable flags */
int continue_toggle = 0;	/* 1: continue orbits, 0: otherwise */
int forward_toggle = 1; 	/* 1: forward in time, 0: backward in time */
int nok=0;		/* # of good steps (defition of "good" may vary from
algorithm to algorithm) */
int nbad=0;		/* # of bad steps */
int rescale = 0;		/* rescale mode toggle */
int stop = 0;		/* stop toggle, 1: stop immediately and exit the loop*/
int region_index=1; 	/* data type, 0: parameter space data, 1: phase space data, 2: combined space data */
int pixel_depth_entered=0;
int section_count = 0;		/* counter for poincare sections */ 
int n_stored_data0=0;		/* # of stored data for data0 */
int n_stored_data1=0;		/* # of stored data for data1 */
int n_stored_data2=0;		/* # of stored data for data2 */
int n_stored_data0_save=0;	/* # of formerly stored data for data0 */
int n_stored_data1_save=0;	/* # of formerly stored data for data1 */
int n_stored_data2_save=0;	/* # of formerly stored data for data2 */
int i_stop;	/* # of iteration when the computational loop is stopped */
int lock_count;	/* counter of plotting operations (to be used for locking) */
int error_result; /* result of error testing */
int segment_count0 = 0;		/* data segment counter for data0 */
int segment_count1 = 0;		/* data segment counter for data1 */
int segment_count2 = 0;		/* data segment counter for data2 */
int n_stored_data_segment0[500];	/* # of data in each data segment for data0 */
int n_stored_data_segment1[500];	/* # of data in each data segment for data1 */
int n_stored_data_segment2[500];	/* # of data in each data segment for data2 */

/*-------------------------------------------------------------------------
	window (or panel) to be created??? (customizable)
	(Intially: determine if window is created as a default
	 Later: determine if window is already created or not)
 *-------------------------------------------------------------------------*/
short main_panel_show = 1;
short options_panel_show = 0;
short section_panel_show = 0;
short window_size_panel_show = 1;
short system_info_panel_show = 0;
short save_load_panel_show = 1;
short param_window_show = 1;

/*-------------------------------------------------------------------------
	Main panel (customizable)
 *-------------------------------------------------------------------------*/
int i_start = 500;	/* orbit is regarded as transient up to i_start */
int i_max = 1000;	/* maximal number of iteration or integration */
int i_step = 1;		/* plot every other i_step'th orbits computed */
double time_step = 0.01;	/* time step for integration. Not used for maps */
int symbol_type=0;	/* type of a current symbol to be displayed */
int symbol_size=4;	/* size of a current symbol */
int cur_color=1;	/* currently selected color */
int pix_type=0;		/* pixrect operation type: 0 for regular plot, 1 for exclusive or combination */

/*-------------------------------------------------------------------------
	Options window  (customizable)
 *-------------------------------------------------------------------------*/
int model = 6; 	/* index for a currently selected model  */
/* 0: use primary coordinates (used for defining vector fields),
   1: use secondary coordinates (typically polar coordinates) */
int polar_coord = 0;
int draw_all = 1; 	/* 1: projecting all orbits, 0: poincare sections */
int show_transient = 1;	/* 1: show transients, 0: otherwise */
int dot_size = 2;	/* size of dots plotted */
int invert_background = 1;	/* 1: invert background to black, 0: otherwise */
int colormap_option = 3; 	/* index for a currently selected colormap */
int colorcode_depth_index = 2;	/* an index for a coordinate to be used for depth cueing */
double colorcode_min = -5;	/* lower bound of a depth-cued coordinate */
double colorcode_max = 5;	/* upper bound of a depth-cued coordinate */

/*-------------------------------------------------------------------------
	System info window (customizable)
 *-------------------------------------------------------------------------*/
int n_displayed_data0 = 0;	/* number of data0 displayed in a box */
int n_displayed_data1 = 0;	/* number of data1 displayed in a box */
int n_displayed_data2 = 0;	/* number of data2 displayed in a box */
double average_return_time = 0;	/* average return time between poincare sections */
double *func_i,*func_f;	/* initial and final values of functions */

/*-------------------------------------------------------------------------
	section window (customizable)
 *-------------------------------------------------------------------------*/
int polar_section = 0;	/* 1: section in terms of secondary coordinates, 0: otherwise */
int linear_interpolation = 1;	/* 1: linear interpolation to get a section, 0: picard iteration */
int section_index = 2;	/* an index of a coordinate used to define a secton surface */
double section_constant = 0; /* a value of a section coordinate: section
surface is defined by x[section_index] = section_constant */
int n_poincare = 100000;	/* number of maximum poincare section to be computed */

/*-------------------------------------------------------------------------
	Save-Load window (customizable)
 *-------------------------------------------------------------------------*/
int save_option = 0;	/* index for choosing variety of saving and loading options */

/*-------------------------------------------------------------------------
	projection window (customizable)
 *-------------------------------------------------------------------------*/
int param_cur_index[2] = {0,1};	/* x and y indices for a currently selected
projection of parameter space data (data0) */
int var_cur_index[2] = {0,1};	/* x and y indices for a currently selected
projection of phase space data (data1) */
double *all_min;	/* lower bound of a current box for combined data */
double *all_max;	/* upper bound of a current box for combined data */
double *all_min_top;	/* lower bound of a top box for combined data */
double *all_max_top;	/* upper bound of a top box for combined data */

/*-------------------------------------------------------------------------
	auxiliary (or combined space) window initializations (customizable)
-------------------------------------------------------------------------*/
/* window configuration */
int aux_win_i = 0;		/* index for an auxiliary window */
int aux_panel_height = 70;	/* y coord of an auxiliary panel */
int aux_xwindow = 350;	/* width of an auxiliary window */
int aux_ywindow = 350;	/* height of an auxiliary window */
int aux_xcanvas;	/* width an auxiliary canvase */
int aux_ycanvas;	/* height of an auxiliary canvas */
int aux_xwidth;	/* width of an auxiliary space box */
int aux_ywidth;	/* height of an auxiliary space box */
int aux_l_margin = 0;	/* left margin of an auxiliary space box */
int aux_b_margin = 0;	/* bottom margin of an auxiliary space box */
int *aux_win_mode;	/* auxiliary window display mode, 0: simultaneous display of data1, 1: display of data2 */
int *aux_on;		/* 1: if auxiliary window is created, 0: otherwise */
int *aux_rescale;	/* 1: if rescale mode is on, 0: otherwise */
int **aux_cur_index;	/* x and y indices for a projection plane */
double **aux_x_min,**aux_x_max; /* lower and upper bounds of auxiliary space
box */


/*-------------------------------------------------------------------------
	integration window initializations (customizable)
-------------------------------------------------------------------------*/
char int_frame_label[MAX_LENGTH] = "integration";	/* window label */
short int_panel_show = 0;	/* 1: if integration window is created */
int int_driver = 0;		/* index for an integration driver */
int int_algorithm = 1;		/* index for an integration algorithm */
int int_option=0;		/* index for an iteration method */
int int_nstep = 1000;		/* number of integration steps */
int int_max_nstep = 1000000;	/* maximal number of integration steps to avoid a disaster*/
double int_start=0,int_end=1;	/* starting and endting time */
double int_period=1;		/* period of an integration */
double int_eps=1.e-10;		/* tolerated error */
double int_guessed_step=0.01;	/* guessed step size */
double int_min_step=0;		/* minimum step size */
double *int_yscal;		/* scaling factor for errors */

/*-------------------------------------------------------------------------
	periodic orbit (fixed point) window initializations (customizable)
-------------------------------------------------------------------------*/
char fp_frame_label[MAX_LENGTH] = "Fixed Point Panel";	/* window label */
short fp_panel_show = 0;	/* 1: if periodic orbit window is created */
int fp_show_toggle=1;		/* 1: show periodic orbits, 0: otherwise */	
int fp_display_option=1;	/* index for periodic orbit display options */ 
int fp_go_option=1;		/* index for periodic orbit computation options */
int fp_algorithm=1;		/* iteration algorithm index */
int ir=0;			/* period of a periodic orbit */
int n_stored_fp=0;		/* number of stored periodic orbits */
int n_mc=10;			/* # of Monte Carlo computations */
int ms=200,mu=200; 		/* maximal steps for stable and unstable manifolds */
int msf=1,muf=1;		/* # of filling bwtween two points of stable and unstable manifolds */
int iskip=1;			/* # of skips between plotting */
int sqzex_maxsq=30;		/* # of iteration for finding periodic
orbits */
int fi_maxsq=30;		/* # of iteration for finding an inverse */
double gp_delm=1.e-6;		/* distance from a periodic orbit to a
starting point on a manifold */
double mc_eps=1.e-8;		/* tolerated error for non-duplicacy check */
double sqzex_eps=1.e-14;	/* tolerated error in x of periodic orbit computation */
double sqzex_epsf=1.e-16;	/* tolerated error in f of periodic orbit computation */
double sqzex_epsm=10;		/* tolerated jump in intermediate values of iteration */
double fi_eps=1.e-10;	/* tolerated error in x of inverse computation */
double fi_epsf=1.e-10;	/* tolerated error in f of inverse computation */
double fi_epsm=10;		/* tolerated jump in intermediate values of iteration */
double *xoffset;	/* offset values of x in periodic orbit equation,
i.e., f(x) = x + xoffset is solved */

/*-------------------------------------------------------------------------
	print window initializations (customizable)
-------------------------------------------------------------------------*/
char print_frame_label[MAX_LENGTH] = "print";	/* window label */
short print_panel_show = 0;	/* 1: if print window is created */
int print_option=1;	/* option index for printing */
int print_region=1;	/* index for region and data type to be printed */

/*-------------------------------------------------------------------------
	AUTO86 initializations (see AUTO manual for details) 
-------------------------------------------------------------------------*/
short auto_panel_show = 0; 	/* 1: if auto panel is created */
char auto_dir_name[MAX_LENGTH] = "/marcy/kim/src/lib/autos/AUTO86/examples"; /* directory name where auto executable resides */
char auto_file_name[MAX_LENGTH] = "@autod^pp2";	/* auto executable file name with arguments (arguments are seperated by ^ not white spaces) */
char auto_input_name[MAX_LENGTH] = "autpp2_init.f";	/* file which is read onto auto text window and edited */

/* auto variables (see AUTO manual for details) */
int auto_ibr,auto_ntot,auto_itp,auto_lab;
int auto_ndim,auto_ips,auto_irs,auto_ilp;
int auto_ntst,auto_ncol,auto_iad,auto_isp,auto_isw,auto_iplt;
int auto_nbc,auto_nint,auto_nmx,auto_npr,auto_mxbf,auto_iid;
int auto_itmx,auto_itnw,auto_nwtn,auto_jac,auto_nuzr;
int auto_n1,auto_n2,auto_nfpar,auto_icp[AUTO_NFPAR_MAX];
double auto_rl0,auto_rl1,auto_a0,auto_a1,auto_par[AUTO_ALL_PARAM_DIM];
double auto_epsu,auto_epss,auto_epsl[2],auto_ds,auto_dsmin,auto_dsmax;
double auto_thetau,auto_thetal[2];

/*-------------------------------------------------------------------------
	execution window (customizable)
-------------------------------------------------------------------------*/

short exec_panel_show = 0; /* 1 if execution window is created, 0: otherwise */
char exec_dir_name[MAX_LENGTH] = "/marcy/kim/kaos/companionlib"; /* directory where an external executable resides */ 
char exec_file_name[MAX_LENGTH] = "bifseta"; /* filename of an external executable */
char exec_input_name[MAX_LENGTH] = "bifseta.inp"; /* input filename from which an external executable reads parameters */

/*-------------------------------------------------------------------------
	time series window (customizable)
-------------------------------------------------------------------------*/

short tser_panel_show = 0; /* 1 if timeseries window is created, 0: otherwise */
int tser_data_option = 0;
int tser_algorithm_option = 0;
int tser_len=0;
int tser_mdim=0;
double *tser;

/*-------------------------------------------------------------------------
	fft window (customizable)
-------------------------------------------------------------------------*/

short fft_panel_show = 0; /* 1 if fft window is created, 0: otherwise */
int fft_algorithm_option=0;
int fft_mdim=0;
double *fft;

/*-------------------------------------------------------------------------
	lyapunov window (customizable)
-------------------------------------------------------------------------*/

short lyap_panel_show = 0; /* 1 if lyapunov window is created, 0: otherwise */
int lyap_algorithm_option=0;

/*-------------------------------------------------------------------------
	dimensions window (customizable)
-------------------------------------------------------------------------*/

short dims_panel_show = 0; /* 1 if dimensions window is created, 0: otherwise */
int dims_type_option=0;
int dims_algorithm_option=0;
int dims_scale_max = 20;
int dims_lsf_start = 0;
int dims_lsf_end = 20;
double dims_scale_factor=2.0;

/*-------------------------------------------------------------------------
	scan window (customizable)
-------------------------------------------------------------------------*/

short scan_panel_show = 0; /* 1 if dimensions window is created, 0: otherwise */
int scan_list_type=0;
int scan_grid_dim=0;
int scan_algorithm_option=0;
int scan_n_max=0;
int scan_xgrid[3]={1,1,1};
int scan_cur_index[3]={0,1,2};
int scan_mdim=0;
int scan_mdim_init=100;

int scan_col_dim=0;
int scan_region_index=0;
int scan_n_stored=0;
int *scan_type;
double scan_xmin[3],scan_xmax[3];
double **scan_x;

/*-------------------------------------------------------------------------
	help window 
-------------------------------------------------------------------------*/
short help_panel_show = 0; /* 1 if help window is created, 0: otherwise */
int help_option=0;

/*-------------------------------------------------------------------------
	window variables
	(take either values of primary or secondary coordinates
	depending on the polar coordinate flag)
 *-------------------------------------------------------------------------*/
double *win_var_f;	/* final values of window variables */
double *win_var_i;	/* starting values of window variables */
double *win_var_i_old;	/* temporary window varibles */
char **win_var_label;	/* label for window variables (either primary or

/*-------------------------------------------------------------------------
	Miscelleneous constants, file pointers, temporary strings
 *-------------------------------------------------------------------------*/
double pi = 3.1415926535897932;		/* Pi */
double twopi =6.2831853071795864 ;	/* 2 * Pi */
FILE *fp, *fopen(),*ffp;		/* file pointers */
char string[MAX_LENGTH];		/* temporay strings */
char string2[MAX_LENGTH];		/* temporay strings */
char lstring[BIG_LENGTH];		/* temporay strings */
char lstring2[BIG_LENGTH];		/* temporay strings */
char full_path[MAX_LENGTH] = "";	/* path name string for a file to be saved and loaded */
char *error_mess[MAX_LENGTH] = {"Error:"};	/* error message string */
char error_yes[MAX_LENGTH] = {"Confirm"};	/* error message confirm string */
char error_no[MAX_LENGTH] = {"Cancel"};		/* error message disapproval string */
double **dmatrix();	/* matrix memory allocation routine */
void free_dmatrix();	/* matrix memory free routine */

/*-------------------------------------------------------------------------
 * Temporary variables. (USE ONLY LOCALLY WITHIN A SUBROUTINE)
 * (Introduced not to dynamically allocate memory within
 * frequently called programs)
 *-------------------------------------------------------------------------*/
double *v;	/* dim=var_dim */
double *t_v;	/* dim=var_dim */
double *t_vf;	/* dim=full_dim */
double *t_va;	/* dim=all_dim */

/*-------------------------------------------------------------------------
 * flags saved temporarily for resetting panels 
 *-------------------------------------------------------------------------*/
int func_on_old,save_option_old,model_old,polar_section_old,colormap_option_old,invert_background_old,polar_coord_old,enable_polar_old,ds_class_old,draw_all_old;


/*-------------------------------------------------------------------------
 * initializing global variables from global constants (global constants
 * will be removed eventually)
 *-------------------------------------------------------------------------*/
int aux_max = AUX_MAX;
int var_dim_max = VAR_DIM_MAX;
int param_dim_max = PARAM_DIM_MAX;
int func_dim_max = FUNC_DIM_MAX;
int full_dim_max = FULL_DIM_MAX;
int all_dim_max = ALL_DIM_MAX;
int max_length = MAX_LENGTH;
int big_length = BIG_LENGTH;

/*-------------------------------------------------------------------------
 * frame parameters (currently not used and commented out)
 *-------------------------------------------------------------------------*/
/*
int frame_argc = 11;
char *frame_argv[11] = { "dummy","-Wb","255","255","0","-Wf","0","0","255","-Wl","kaos - Swan Kim & J. Guckenheimer, POSTECH and Cornell U., pre alpha 1.8 9/1989"};
*/

/*-------------------------------------------------------------------------
	temporary variable which will be removed from the package in future
-------------------------------------------------------------------------*/
int algorithm_dim = 4; /* The number of installed integration algorithms */

/*-------------------------------------------------------------------------
	partially implemented options to be fully installed in future
-------------------------------------------------------------------------*/
int nofrill = 1;	/* nofrill algorithm toggle */
int resize=0;		/* temporay variable used by resize_proc() */
int large_system_on=0;
