/*
### Picard iteration to solve nonlinear implicit equation ###

Input:	(double *) pxv (dim=var_dim): current coords
	(int) dim: the dimension of the phase space
Output:	(double *) pvy (dim=var_dim): returns the coordinates of the next
		orbit.
*/
symp_picard(pvy,pvx,time,time_step,dim)
double *pvy,*pvx,time,time_step;
int dim;
{
	int i,it,max_iter,iswit;
	double eps,epsf,err,fabs(),*vnew,*vnewt,*dvec,*vnewp,*dvector();
	extern int stop,nok,nbad;
	extern double cutoff,*param;
	extern int (*f_p)();

	vnew = dvector(0,dim-1);
	vnewp= dvector(0,dim-1);
	vnewt= dvector(0,dim-1);
	dvec = dvector(0,dim-1);
	eps = 1.e-14;
	epsf = 1.e-16;
	max_iter = 10;
	for(i=0;i<dim;i++) vnew[i]= *(pvx+i);
	for(i=0;i<dim;i++) vnewp[i]= *(pvx+i);

	for(it = 0;it <max_iter;it++){
		for(i=0;i<dim;i++){
			if(vnew[i] > cutoff || vnew[i] < - cutoff) {
				system_mess_proc(1,"Orbits appear to diverge off to an infinity! Stop!");
				stop=1;
				goto done;
			}
		}
		for(i=0;i<dim;i++) vnewt[i] = (vnew[i] + *(pvx+i))/2;
		(int) f_p(vnew,0,vnewt,param,time,dim);
		for(i=0;i<dim;i++) vnew[i] = *(pvx+i) + time_step * vnew[i];

		if(stop) {
			system_mess_proc(1,"symp_sqze: sigular matrix");
			goto done;
		}
	
		/* testing for adequacy of roots */
		iswit =1;
		for(i=0;i<dim;i++){
			dvec[i] = vnew[i]-vnewp[i];
			if(fabs(dvec[i]) >eps)
				iswit = 0;
			vnewp[i]=vnew[i];
		}
		if(iswit)
			goto done;
	}

done:
	for(i=0;i<dim;i++) *(pvy+i) = vnew[i];
	err = 1.e-16;
	for(i=0;i<dim;i++){
		if(err > dvec[i])
	      		err = dvec[i];
	}
	if(it>=10)
		nbad++;
	else
		nok++;
	(void) free_dvector(vnew,0,dim-1);
	(void) free_dvector(vnewt,0,dim-1);
	(void) free_dvector(vnewp,0,dim-1);
	(void) free_dvector(dvec,0,dim-1);
}
