/*
### rational extrapolation ###
*/

extern double **ddd, *xxx;

void rzextr(iest,xest,yest,yz,dy,nv,nuse)
int iest,nv,nuse;
double xest,yest[],yz[],dy[];
{
	int  m1,k,j;
	double yy,v,ddy,c,b1,b,*fx,*dvector();

	fx = dvector(0,nuse-1);
	xxx[iest] = xest;
	if(iest == 0)
		for(j=0;j<nv;j++) {
			yz[j] = yest[j];
			ddd[j][0] = yest[j];
			dy[j] = yest[j];
		}
	else {
		m1 = (iest < nuse-1 ? iest : nuse-1 );
		for(k=0;k<m1;k++)
			fx[k+1] = xxx[iest-k-1] / xest;
		for(j=0;j<nv;j++){
			yy = yest[j];
			v = ddd[j][0];
			c = yy;
			ddd[j][0] = yy;
			for(k=1;k<m1+1;k++){
				b1 = fx[k] * v;
				b = b1 - c;
				if (b) {
					b = (c - v) / b;
					ddy = c * b;
					c = b1 * b;
				}
				else 
					ddy = v;
				if(k != m1) v = ddd[j][k];
				ddd[j][k] = ddy;
				yy += ddy;
			}
			dy[j] = ddy;
			yz[j] = yy;
		}
	}
	(void) free_dvector(fx,0,nuse-1);
}
