/*
option:	0:	x11r2colormap
	1:	depth colormap
	2:	nonlinear depth colormap
	3:	alternating colormap
*/
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <stdio.h>
#include "../include/x11r2_kaos_def.h"
#define TOT_CMAP_SIZE 128
#define VAR_CMAP_SIZE 50
#define ABS_CMAP_SIZE 78
#define INTENSITY_MIN 107
#define INTENSITY_MAX 255
#define CMAP_WIDTH 10
#define CMAP_HEIGHT 20

Frame base_frame;
Canvas canvas;
Pixwin *pw;
main(argc,argv)
int argc;
char **argv;
{
	FILE *fp,*fopen();
	int i,xp,yp,invert_color,pixel_depth,intensity_min,intensity_max,option;
	double log();
	unsigned char r[TOT_CMAP_SIZE];
	unsigned char g[TOT_CMAP_SIZE];
	unsigned char b[TOT_CMAP_SIZE];
	char filename[80];
 
 	invert_color = 0;
	intensity_min = INTENSITY_MIN;
	intensity_max = INTENSITY_MAX;
	sprintf(filename,"cmap.dat");
	for (i=1; i<argc; i++){
		if (strcmp(argv[i],"-c") == 0) {
			i++;
			intensity_min = atoi(argv[i]);
			i++;
			intensity_max = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-o") == 0) {
			i++;
			option = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-i") == 0) {
			i++;
			invert_color = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-f") == 0) {
			i++;
			sprintf(filename,"%s",argv[i]);
		}
	}

	base_frame = window_create(NULL,FRAME,
		FRAME_LABEL,"Colormap - Swan Kim",
		FRAME_INHERIT_COLORS,TRUE,
		WIN_WIDTH,64*(CMAP_WIDTH+2)+30,
		WIN_HEIGHT,4*(CMAP_HEIGHT+10)+50,
		0);

	canvas = window_create(base_frame,CANVAS,
		CANVAS_RETAINED,TRUE,
		CANVAS_WIDTH,64*(CMAP_WIDTH+2)+20,
		CANVAS_HEIGHT,4*(CMAP_HEIGHT+10)+30,
		0);

	fp = fopen(filename,"w");

	i=0;
	b[0]=0;
	r[0]=0;
	g[0]=0;
	fprintf(fp,"%d %d %d %d\n",i,r[i],g[i],b[i]);
	cms_x11r2colormap_setup(r,g,b);
	switch(option){
		case 0:
			for(i=1;i<VAR_CMAP_SIZE-1;i++){
				r[i] = r[X11R2_ABS_CMAP_START+i];
				g[i] = g[X11R2_ABS_CMAP_START+i];
				b[i] = b[X11R2_ABS_CMAP_START+i];
				fprintf(fp,"%d %d %d %d\n",i,r[i],g[i],b[i]);
			}
			break;
		case 1:
			for(i=1; i<VAR_CMAP_SIZE-1; i++){
				if(i<VAR_CMAP_SIZE/2){
					g[i] = intensity_min + (int) ((intensity_max-intensity_min) * (double) i / (VAR_CMAP_SIZE/2));
				}
				else {
					g[i] = intensity_min + (int) ((intensity_max-intensity_min) * (double) (VAR_CMAP_SIZE-i) / (VAR_CMAP_SIZE/2));
				}
				if(i > VAR_CMAP_SIZE/2){
					r[i] = intensity_min + (int) ((intensity_max - intensity_min) * (double) (i-VAR_CMAP_SIZE/2) / (VAR_CMAP_SIZE/2));
				}
				else {
					r[i] = intensity_min;
				}
				if(i < VAR_CMAP_SIZE/2){
					b[i] = intensity_min + (int) ((intensity_max - intensity_min) * (double)(VAR_CMAP_SIZE/2-i) / (double)(VAR_CMAP_SIZE/2));
				}	
				else {
					b[i] = intensity_min;
				}
				fprintf(fp,"%d %d %d %d\n",i,r[i],g[i],b[i]);
			}
			break;
		case 2:
			for(i=1; i<VAR_CMAP_SIZE-1; i++){
				if(i<VAR_CMAP_SIZE/2){
					g[i] = intensity_min + (int) ((intensity_max-intensity_min) * log((double)(i)) / log((double)VAR_CMAP_SIZE/2));
				}
				else {
					g[i] = intensity_min + (int) ((intensity_max-intensity_min) * log((double)(VAR_CMAP_SIZE-i)) / log((double)VAR_CMAP_SIZE/2));
				}
				if(i > VAR_CMAP_SIZE/2){
					r[i] = intensity_min + (int) ((intensity_max - intensity_min) * log((double)i-(double)VAR_CMAP_SIZE/2) / log((double)VAR_CMAP_SIZE/2) );
				}
				else {
					r[i] = intensity_min;
				}
				if(i < VAR_CMAP_SIZE/2){
					b[i] = intensity_min + (int) ((intensity_max - intensity_min) * log((double)VAR_CMAP_SIZE/2-i) / log((double)VAR_CMAP_SIZE/2) );
				}	
				else {
					b[i] = intensity_min;
				}
				fprintf(fp,"%d %d %d %d\n",i,r[i],g[i],b[i]);
			}
			break;
		case 3:
			/* colormap with high constrast need to be installed */
			r[0] = 0; g[0] = 0; b[0] = 0;
			r[1] = 255; g[1] = 255; b[1] = 255;
			r[2] = 255; g[2] = 0; b[2] = 0;
			r[3] = 0; g[3] = 255; b[3] = 0;
			r[4] = 0; g[4] = 0; b[4] = 255;
			r[5] = 255; g[5] = 255; b[5] = 0;
			r[6] = 0; g[6] = 255; b[6] = 255;
			r[7] = 255; g[7] = 0; b[7] = 255;
			r[8] = 191; g[8] = 115; b[8] = 0;
			r[9] = 0; g[9] = 200; b[9] = 255;
			r[10] = 170; g[10] = 170; b[10] = 170;
			for(i=1;i<=10;i++)
				fprintf(fp,"%d %d %d %d\n",i,r[i],g[i],b[i]);
			for(i=11;i<VAR_CMAP_SIZE;i++){
				r[i] = r[(i-2) % 9 + 2];
				g[i] = g[(i-2) % 9 + 2];
				b[i] = b[(i-2) % 9 + 2];
				fprintf(fp,"%d %d %d %d\n",i,r[i],g[i],b[i]);
			}
			break;

	}
	b[VAR_CMAP_SIZE-1]=255;
	r[VAR_CMAP_SIZE-1]=255;
	g[VAR_CMAP_SIZE-1]=255;
	i=VAR_CMAP_SIZE-1;
	fprintf(fp,"%d %d %d %d\n",i,r[i],g[i],b[i]);

	r[X11R2_ABS_CMAP_START]=0;
	g[X11R2_ABS_CMAP_START]=0;
	b[X11R2_ABS_CMAP_START]=0;
	b[TOT_CMAP_SIZE-1]=255;
	r[TOT_CMAP_SIZE-1]=255;
	g[TOT_CMAP_SIZE-1]=255;
	for(i=X11R2_ABS_CMAP_START;i<TOT_CMAP_SIZE;i++){
		fprintf(fp,"%d %d %d %d\n",i,r[i],g[i],b[i]);
	}

	fclose(fp);

	/* set the CANVAS_PIXWIN colormap */
	pw = (Pixwin *) canvas_pixwin(canvas);
	pixel_depth = (int) get_pixel_depth();
	pw_setcmsname(pw,"my_colormap");
	pw_putcolormap(pw,0,TOT_CMAP_SIZE,r,g,b);
	if(invert_color)
		(void) pw_blackonwhite(pw,0,TOT_CMAP_SIZE-1);

	/* draw ramp of colors */
	if(pixel_depth >1){
		xp=0;
		yp=10;
		for(i=0; i< TOT_CMAP_SIZE; i++){
			pw_rop(pw,xp,yp,CMAP_WIDTH,CMAP_HEIGHT,PIX_SRC | PIX_COLOR(i),(Pixrect *)0,0,0);
			if(i!=0 && (i % 64 == 63)){
				xp = 0;
				yp += CMAP_HEIGHT+10;
			}
			else {
				xp += CMAP_WIDTH+2;
			}
		}	
	}

	window_main_loop(base_frame);

	exit(0);
}

#include <suntool/sunview.h>
int get_pixel_depth()
{
	char maxgroup[PIXPG_24BIT_COLOR+1];
	extern Pixwin *pw; 
	Pixrect *pr,*pr_open();
	
	pr = pr_open("/dev/fb");
	pr_available_plane_groups(pr,PIXPG_24BIT_COLOR+1,maxgroup);
	(void) pr_close(pr);
	if(maxgroup[PIXPG_24BIT_COLOR] != 0){
		return(24);
	}
	else {
		return(pw->pw_pixrect->pr_depth);
	}
}
