
 /*
 *  NCSA Telnet source code
 *  National Center for Supercomputing Applications
 *  November 1, 1987
 *  (C) Copyright 1987 The Board of Trustees of the University of Illinois
 *
 *  Permission is granted to any individual or institution to use, copy,
 *  modify, or redistribute this software and its documentation provided
 *  this notice and the copyright notices are retained.  This software
 *  may not be distributed for profit, either in original form or in
 *  derivative works.  The University of Illinois makes no representations
 *  about the suitability of this software for any purpose.  
 *  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
 *  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
 *  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
 *  OF FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static char *SCCSid = "@(#)vsem.c	1.12	(NCSA)	11/2/87";
#endif

/*
 *
 *      Virtual Screen Kernel Emulation Routines
 *                      (vsem.c)
 *  
 *      c1986,1987, National Center for Supercomputing Applications
 *      by Gaige B. Paulsen
 *
 *    This file contains the private emulation calls for the NCSA
 *  Virtual Screen Kernel.
 *
 *      Version Date    Notes
 *      ------- ------  ---------------------------------------------------
 *      0.01    861102  Initial coding -GBP
 *      0.10    861111  Added/Modified VT emulator -GBP
 *      0.50    861113  First compiled edition -GBP
 */

#include "vsdata.h"
#include "vskeys.h"

VSem(c,ctr)
register int ctr;
register unsigned char *c;
{
    register int i,sx;
    register int escflg;
    int insert,ocount,attrib,wrapit,extra,offend;
    char *acurrent,*current,*start;

    escflg= VSIw->escflg;

    while (ctr>0) {
    while ( (escflg==0) && (ctr>0) && (*c<32) ) {
        switch(*c) {
        case 0x1b:
            escflg++;
            break;
        case 0x0e:
			if (VSIw->G1)
            	VSIw->attrib=VSgraph(VSIw->attrib);
			else
            	VSIw->attrib=VSnotgraph(VSIw->attrib);
			VSIw->charset=1;
            break;
        case 0x0f:
			if (VSIw->G0)
            	VSIw->attrib=VSgraph(VSIw->attrib);
			else
            	VSIw->attrib=VSnotgraph(VSIw->attrib);
			VSIw->charset=0;
            break;
        case 0x07:
            RSbell(VSIwn);
            break;
        case 0x08:
            VSIw->x--;
			if (VSIw->x<0) VSIw->x=0;
            break;
        case 0x0c:
            VSIindex();
            break;
        case 0x09:              /* Later change for versatile tabbing */
            VSItab();
            break;
        case 0x0a:
            VSIindex();
            break;
        case 0x0d:
            VSIw->x=0;
            break;
        case 0x0b:
            VSIindex();
            break;
#ifdef CISB
        case 0x10:
			bp_DLE( c, ctr);
			ctr = 0;
			break;
		case 0x05:
			bp_ENQ();
			break;
#endif CISB
        }
        c++;ctr--;
        }
    while( (ctr>0) && (escflg==0) && (*c>=32) ) {
            /* the following line is important, both are * chars */
        current = start = &VSIw->linest[VSIw->y]->text[VSIw->x];
        acurrent = &VSIw->attrst[VSIw->y]->text[VSIw->x];
        attrib = VSIw->attrib;
        insert = VSIw->IRM;           /* boolean */
        ocount = VSIw->x;
        wrapit=0;offend=0;extra=0;
        sx=VSIw->x;
        if ( VSIw->x > VSIw->maxwidth ) {
	        if ( VSIw->DECAWM ) {
	            VSIw->x=0;
	            VSIindex();
	            }
			else
				VSIw->x=VSIw->maxwidth;
	        current = start = &VSIw->linest[VSIw->y]->text[VSIw->x];
	        acurrent = &VSIw->attrst[VSIw->y]->text[VSIw->x];
	        ocount = VSIw->x;
	        sx=VSIw->x;
			}
        while( (ctr>0) && (*c>=32) && (offend==0)) {
            if (insert) VSIinschar(1);
            *current = *c;
            *acurrent=attrib;
            c++;
            ctr--;
            if (VSIw->x < VSIw->maxwidth)
				{acurrent++; current++; VSIw->x++; }
            else {
				if (VSIw->DECAWM) {
					VSIw->x++;
            		offend=1;
					}
            	else {
            		VSIw->x=VSIw->maxwidth;
					extra=1;
					}
            	}
            }
        if (insert) {
            VSIinsstring(VSIw->x-ocount+offend+extra,start);
                                /* actually just decides which RS to use */
            }
            else VSIdraw(VSIwn,sx,VSIw->y,VSIw->attrib,VSIw->x-ocount+offend+extra,start);
        }

while( (ctr>0) && (escflg==1) ) {
        switch(*c) {
        case 0x08:
            VSIw->x--;
			if (VSIw->x<0) VSIw->x=0;
            break;
        case '[': 
            VSIapclear();
            escflg++;
            break;
        case '7':
            VSIsave();
            escflg = 0;
            break;
        case '8':
            VSIrestore();
            escflg = 0;
            break;
        case 'c':
            VSIreset();
            break;
        case 'D':
            VSIindex();
            escflg = 0;
            break;
        case 'E':
            VSIw->x=0;
            VSIindex();
            escflg = 0;
            break;
        case 'M':
            VSIrindex();
            escflg = 0;
            break;
        case '>':
            VSIw->DECPAM=0;
            escflg = 0;
            break;
        case '=':
            VSIw->DECPAM=1;
            escflg = 0;
            break;
        case 'Z':
            VTsendident();
            escflg = 0;
            break;
        case '#':
            escflg=3;
            break;
        case '(':
            escflg=4;
            break;
        case ')':
            escflg=5;
            break;
		case 'H':
			VSIw->tabs[VSIw->x]='x';
			escflg=0;
			break;
#ifdef CISB
		case 'I':
			bp_ESC_I();
			break;
#endif CISB
        default:
            escflg = 0;
            break;
        }
    c++;ctr--;
    }
while ( (escflg==2) && (ctr>0) ) {
        switch(*c) {
        case 0x08:
            VSIw->x--;
			if (VSIw->x<0) VSIw->x=0;
            break;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
            if (VSIw->parms[VSIw->parmptr]<0) VSIw->parms[VSIw->parmptr]=0;
            VSIw->parms[VSIw->parmptr] *= 10;
            VSIw->parms[VSIw->parmptr] += *c-'0';
            break;
        case '?':
            VSIw->parms[VSIw->parmptr++] = -2;
            break;
        case ';':
            VSIw->parmptr++;
            break;
        case 'A':
            if (VSIw->parms[0]<1) VSIw->y--;
                else VSIw->y-=VSIw->parms[0];
			if ( VSIw->y < VSIw->top ) VSIw->y=VSIw->top;
            VSIrange();
            escflg = 0;
            break;
        case 'B':
            if (VSIw->parms[0]<1) VSIw->y++;
                else VSIw->y+=VSIw->parms[0];
			if ( VSIw->y > VSIw->bottom ) VSIw->y=VSIw->bottom;
            VSIrange();
            escflg = 0;
            break;
        case 'C':
            if (VSIw->parms[0]<1) VSIw->x++;
                else VSIw->x+=VSIw->parms[0];
            VSIrange();
			if (VSIw->x > VSIw->maxwidth)
				VSIw->x = VSIw->maxwidth;
            escflg = 0;
            break;
        case 'D':
            if (VSIw->parms[0]<1) VSIw->x--;
                else VSIw->x-=VSIw->parms[0];
            VSIrange();
            escflg = 0;
            break;
        case 'f':
        case 'H':
            VSIw->x=VSIw->parms[1]-1;
            VSIw->y=VSIw->parms[0]-1;
            VSIrange();
            escflg = 0;
            break;
        case 'K':
            switch(VSIw->parms[0]) {
            case -1:
            case  0:
                VSIeeol();
                break;
            case  1:
                VSIebol();
                break;
            case  2:
                VSIel(-1);
                break;
            default:
                escflg=0;
                break;
            }
            escflg = 0;
            break;
        case 'J':
            switch(VSIw->parms[0]) {
            case -1:
            case  0:
                VSIeeos();
                break;
            case  1:
                VSIebos();
                break;
            case  2:
                VSIes();
                break;
            default:
                escflg=0;
                break;
            }
            escflg = 0;
            break;
        case 'm':
            { int temp=0;
              while (temp<=VSIw->parmptr) {
              if (VSIw->parms[temp]<1) VSIw->attrib&=128;
              else VSIw->attrib|=1<<(VSIw->parms[temp]-1);
              temp++;
              }
            }
            escflg = 0;
            break;
        case 'q':
            escflg = 0;
            break;
        case 'c':
            VTsendident();
            escflg = 0;
            break;
        case 'n':
            switch(VSIw->parms[0]) {
            case 5:
                VTsendstat();
                break;
            case 6:
                VTsendpos();
                break;
                }
            escflg = 0;
            break;
        case 'L':
            if(VSIw->parms[0]<1) VSIw->parms[0]=1;
            VSIinslines(VSIw->parms[0],-1);
            escflg = 0;
            break;
        case 'M':
            if(VSIw->parms[0]<1) VSIw->parms[0]=1;
            VSIdellines(VSIw->parms[0],-1);
            escflg = 0;
            break;
        case 'P':
            if(VSIw->parms[0]<1) VSIw->parms[0]=1;
            VSIdelchars(VSIw->parms[0]);
            escflg = 0;
            break;
        case 'r':
            if (VSIw->parms[0]<0) VSIw->top=0;
                else VSIw->top=VSIw->parms[0]-1;
            if (VSIw->parms[1]<0) VSIw->bottom=23;
                else VSIw->bottom=VSIw->parms[1]-1;
            if (VSIw->top<0) VSIw->top=0;
            if (VSIw->top>22) VSIw->top=22;
            if (VSIw->bottom<1) VSIw->bottom=23;
            if (VSIw->bottom>23) VSIw->bottom=23;
            VSIw->x=0; VSIw->y=0;
            escflg = 0;
            break;
        case 'h':
            VSIsetoption(1);
            escflg = 0;
            break;
        case 'l':
            VSIsetoption(0);
            escflg = 0;
            break;
		case 'g':
			if (VSIw->parms[0]==3) VSItabclear();
			else if (VSIw->parms[0]==0 || VSIw->parms[0]<0)
					VSIw->tabs[VSIw->x]=' ';
			escflg =0;
			break;
		default:			/* Dag blasted strays... */
			escflg=0;
			break;
        }
        c++; ctr--;
    }

while ( (escflg==3) && (ctr>0) ) {	/* #  Handling */
	switch(*c) {
        case 0x08:
            VSIw->x--;
			if (VSIw->x<0) VSIw->x=0;
            break;
		case '8':
			VTalign();
			escflg=0;
			break;
		default:
			escflg=0;
			break;
		}
		c++; ctr--;
	}

while ( (escflg==4) && (ctr>0) ) {	/* (  Handling */
    switch(*c) {
        case 0x08:
            VSIw->x--;
			if (VSIw->x<0) VSIw->x=0;
            break;
		case 'A':
		case 'B':
		case '1':
			VSIw->G0=0;
			if ( !VSIw->charset )
            	VSIw->attrib=VSnotgraph(VSIw->attrib);
			escflg=0;
			break;
		case '0':
		case '2':
			VSIw->G0=1;
			if ( !VSIw->charset )
            	VSIw->attrib=VSgraph(VSIw->attrib);
			escflg=0;
			break;
		default:
			escflg=0;
			break;
		}
		c++; ctr--;
	}

while ( (escflg==5) && (ctr>0) ) {	/* )  Handling */
    switch(*c) {
        case 0x08:
            VSIw->x--;
			if (VSIw->x<0) VSIw->x=0;
            break;
		case 'A':
		case 'B':
		case '1':
			VSIw->G1=0;
			if ( VSIw->charset )
            	VSIw->attrib=VSnotgraph(VSIw->attrib);
			escflg=0;
			break;
		case '0':
		case '2':
			VSIw->G1=1;
			if ( VSIw->charset )
            	VSIw->attrib=VSgraph(VSIw->attrib);
			escflg=0;
			break;
		default:
			escflg=0;
			break;
		}
		c++; ctr--;
	}

    if ((escflg>2) && (ctr>0)) {escflg=0; c++; ctr--;}
    }
    VSIw->escflg=escflg;
}

