
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)confirmer.c	1.3	NCSA	6/22/87";
#endif lint

/*
** the following code is heavily borrowed from the Sunview Programmer's Guide
** "Simple confirmer package",	pp.31 - 33
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>

extern Pixwin *pw;
extern Frame base_frame;

static Frame init_confirmer();
static void yes_no_ok();

confirm(message,ok_only)
char *message;
int ok_only;
{
	Frame confirmer;
	int	 answer;

	confirmer=init_confirmer(message,ok_only);
	answer=(int)window_loop(confirmer);
	window_set(confirmer,FRAME_NO_CONFIRM,TRUE,0);
	window_destroy(confirmer);
 
	return(answer);

}

static Frame
init_confirmer(message,ok_only)
char *message;
int ok_only;
{
	Frame confirmer;
	Panel panel;
	Panel_item message_item;
	int left,top,width,height,pixnum;
	Rect *r;
	Rect rr;
	struct pixrect *pr;
	Pixwin *conpw;

	confirmer=window_create(0,FRAME,FRAME_SHOW_LABEL,FALSE,0);
	panel=window_create(confirmer,PANEL,PANEL_LABEL_BOLD,TRUE,0);

	conpw=(Pixwin *)window_get(panel,WIN_PIXWIN);	 /* get panel's pixwin */
	message_item=panel_create_item(panel,PANEL_MESSAGE,
			                           PANEL_LABEL_STRING,message,
			                           0);
	if (ok_only) {
		pr=panel_button_image(panel,"OK",3,0);
		width=pr->pr_width;
	}
	else {
		pr=panel_button_image(panel,"NO",3,0);
		width=2*pr->pr_width+12;
	}
	r=(Rect *)panel_get(message_item,PANEL_ITEM_RECT);
	/*
	** center the yes/no or ok buttons under the message
	*/

	top=rect_bottom(r)+5;
	if (ok_only) {
		pixnum = ATTR_COL(18);
		if (r->r_width < pixnum) 
			left=(pixnum - width)/2;
		else
			left=(r->r_width - width)/2;
		panel_create_item(panel,PANEL_BUTTON,
			                PANEL_ITEM_X,left,PANEL_ITEM_Y,top,
			                PANEL_LABEL_IMAGE,pr,
			                PANEL_CLIENT_DATA,TRUE,
			                PANEL_NOTIFY_PROC,yes_no_ok,
			                0);
	}
	else {
		left=(r->r_width - width)/2;
		if (left<0) left=0;
		panel_create_item(panel,PANEL_BUTTON,
			                PANEL_ITEM_X,left,PANEL_ITEM_Y,top,
			                PANEL_LABEL_IMAGE,pr,
			                PANEL_CLIENT_DATA,FALSE,
			                PANEL_NOTIFY_PROC,yes_no_ok,
			                0);
			
		panel_create_item(panel,PANEL_BUTTON,
			                PANEL_LABEL_IMAGE,
							panel_button_image(panel,"YES",3,0),
			                PANEL_CLIENT_DATA,TRUE,
			                PANEL_NOTIFY_PROC,yes_no_ok,
			                0);
	}

	window_fit(panel);
	window_fit(confirmer);

	/*
	**center confirmer on screen
	*/

	win_getsize(window_get(base_frame, WIN_FD), &rr);
	width=(int)window_get(confirmer,WIN_WIDTH);
	height=(int)window_get(confirmer,WIN_HEIGHT);
	left=(rr.r_width -width)/2;
	top=(rr.r_height-height)/2;
	if (left<0) left=0;
	if (top<0) top=0;

	left += (int) window_get(base_frame, WIN_X);
	top += (int) window_get(base_frame, WIN_Y);

	window_set(confirmer,WIN_X,left,WIN_Y,top,0);
	return(confirmer);

}

static void
yes_no_ok(item,event)
Panel_item item;
Event *event;
{
	window_return(panel_get(item,PANEL_CLIENT_DATA));
}
