/* SCCS @(#)structure.h	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          structure.h                                 */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   structure.h                                         */
/*                                                                      */
/* DESCRIPTION  :   Structures of LaboImage                             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


/****** R.O.Is  et gen.c *******/

typedef	struct coords	*ptr_point;           

struct	    coords  
{
  short	      x,y;
  ptr_point   next;
};

typedef	struct str_zone	*ptr_zone;             

struct	    str_zone	
{
  int		nbr_pts ;
  ptr_point	pts ;		    
};

/********************/


struct image_ecran {
    char    type[15];
    char    filename[30];
    char    comment[384];
    ptr_zone  	pt_zone;           /* struct des points correspondant */
                                   /* a la region d'interet selectionnee */
    int     npixels;   /* region of interest */
    short   nbr_plan, nligne, ncolonne, n_plan;
    float   mini[3], maxi[3], mu[3], ecart[3];
};

struct description {
    short   type, nligne, ncolonne;
    char    date[26];
    float   maxi[6];
    float   mini[6];
    float   mu[6];
    float   ecart[6];
    char    comment[384];
}; 

extern struct  description desc;      /* descripteur d'un fichier-image */

struct commande {
    char    nom[9];
    int	    code;
    int	    from[4];
    int	    to[4];
    char    *param;
    struct  commande	*next;
};
struct	description_macro{
    struct  commande	*debut;
};
extern	struct	description_macro   dir_desc_macro[];
extern	struct	commande	    *macro_cour;


struct description_memoire {
    short   	type, nligne, ncolonne;
    char    	date[26];
    float   	mmin, mmax, mu, ecart;
    ptr_zone  	pt_zone;           /* struct des points correspondant */
                                   /* a la region d'interet selectionnee */
    char    	filename[60];
    char    	comment[384];
};
extern struct description_memoire dir_desc[],
				  buffer_desc[];
                               /* tableau de descripteurs de plans-image */
                               /* en memoire                             */
struct directoire_image {
    int    flag_reserve;
    unsigned char * image;
};
extern struct directoire_image  dir_image[], 
				buffer_image[];
                               /* tableau de pointeurs sur plans-image + */
                               /* indicateur de disponibilite            */

extern struct directoire_image dir_vecteur[];

struct description_vecteur{
    short   type, genre;
    int	    ncase, b_min, b_max;
    float   vmin, vmax, total;
    char    *prive;
};

extern struct description_vecteur dir_desc_vect[];

