/* SCCS @(#)threshold4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      threshold4.c                                    */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   threshold4.c                                        */
/*                                                                      */
/* DESCRIPTION  :   Threshold operation                                 */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdio.h>
#include <math.h>


int diff_hist_thresh(image, dimy, dimx, diffhist, graylevels,
					minval, maxval, mode)
 int *image, dimx, dimy, graylevels, minval, maxval, mode;
 int **diffhist;
{
    int dx, dy, filxmin, filxmax, filymin, filymax, pixval;
    int  fx, fy, indexy, indexy2, threshdet, i, j;
    int gradient, maxdiff;


    dx = dimx - 1;
    dy = dimy - 1 ;
    *diffhist = (int *) calloc(graylevels , sizeof(int *));
/* -ve difference histogram */
    if (mode < 0){
	for (i=1; (i<dy); ++i){
	    filxmin = i-1;
	    filxmax = i+2;
	    indexy = dimy*i;
	    for(j=1; (j<dx); ++j){
		filymin = j-1;
		filymax = j+1;
		pixval = *(image + indexy + j);
		for(fy=filymin; (fy<filymax); ++fy) {
		    indexy2 = dimy*fy;
		    for(fx=filxmin; (fx<filxmax); ++fx){
			gradient = (float)(pixval - *(image + indexy2 +fx));
			if (gradient < 0) *(*diffhist + pixval) -=  gradient;
		   }    
		}
	    }
	}
    }
    else{  /* +ve difference histogram */
	for (i=1; (i<dy); ++i){
	    filxmin = i-1;
	    filxmax = i+2;
	    indexy = dimy*i;
	    for(j=1; (j<dx); ++j){
		filymin = j-1;
		filymax = j+1;
		pixval = *(image + indexy + j);
		for(fy=filymin; (fy<filymax); ++fy) {
		    indexy2 = dimy*fy;
		    for(fx=filxmin; (fx<filxmax); ++fx){
			gradient = (float)(pixval - *(image + indexy2 +fx));
			if (gradient > 0) *(*diffhist + pixval) = 
		                     *(*diffhist + pixval) + gradient;
		    }
		}
	    }
	}
    }
/* max of histograme between min and max values of threshold range */
 if ((minval < 0) || (minval > maxval) || (maxval > graylevels-1 )){
     minval = 0;
     maxval = graylevels - 1;
 }
 maxval = maxval + 1;
 maxdiff = 0.0;
 for (i=minval; (i < maxval); ++i){
     if (*(*diffhist + i)>= maxdiff){
	 threshdet = i;
	 maxdiff = *(*diffhist + i);
     }
 }
 return(threshdet);
}



void refplane_binary_thresh(image, refplane, imageres, dimy, dimx, mode)
int *image, *refplane, **imageres, dimy, dimx, mode ;
{
    int i,j, thresh, buf;

    *imageres = (int *)calloc(dimy * dimx, sizeof(int));

    switch (mode) {
	case 1: for(i=0; (i<dimy); ++i){
		    buf = i*dimy;
		    for(j=0; (j<dimx); ++j){
			if (*(image + buf + j) > *(refplane + buf +j))
			    *(*imageres + buf + j) = 1;
			else *(*imageres + buf + j) = 0;
		    }
		}
		break;
	case 2: for(i=0; (i<dimy); ++i){
		    buf = i*dimy;
		    for(j=0; (j<dimx); ++j){
			if (*(image + buf + j) < *(refplane + buf +j))
			    *(*imageres + buf + j) = 0;
			else *(*imageres + buf + j) = 1;
		    }
		}
		break;
	case 3: for(i=0; (i<dimy); ++i){
		    buf = i*dimy;
		    for(j=0; (j<dimx); ++j){
			if (*(image + buf + j) < *(refplane + buf +j))
			    *(*imageres + buf + j) = 1;
			else *(*imageres + buf + j) = 0;
		    }
		}
		break;
	case 4: for(i=0; (i<dimy); ++i){
		    buf = i*dimy;
		    for(j=0; (j<dimx); ++j){
			if (*(image + buf + j) > *(refplane + buf +j))
			    *(*imageres + buf + j) = 0;
			else *(*imageres + buf + j) = 1;
		    }
		}
		break;
    }
}


