/* SCCS @(#)i_osto_pos.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          i_osto_pos.layout.c                         */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   i_osto_pos.layout.c                                 */
/*                                                                      */
/* DESCRIPTION  :   IO operations of LaboImage (store and postscript)   */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "i_osto_pos.layout.h"
#include "global.h"

#define MAX_ARGS 100

extern Widget gLabowidget;
extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for IO_store_post_file_widget 
/*******************************************************/

Widget
build_IO_store_post_file_widget(IO_store_postscript, type, message)
	Widget IO_store_postscript;
	int    type;
	char *message;
{
	Widget IO_store_post_file_widget;
	Widget IO_store_post_file_selection;
	Widget IO_load_image_separator;
	Widget selectplaneinput;
	char filemessage[100];
	Arg args[MAX_ARGS];
	int n;

	/* Creating IO_store_post_file_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,307); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,660); n++;
	XtSetArg(args[n],XmNx,2); n++;
	XtSetArg(args[n],XmNy,2); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(message, XmSTRING_DEFAULT_CHARSET)); n++;

	IO_store_post_file_widget = 
	  XmCreateFormDialog(gLabowidget,"IO_store_post_file_widget",args,n);

	/* Creating IO_store_post_file_selection Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	if (strcmp (repertoire_save, "") == 0)
		strcpy(repertoire_save, getenv("HOME"));

	XtSetArg(args[n],XmNdirMask,
		XmStringLtoRCreate(repertoire_save,
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNfilterLabelString,
		XmStringLtoRCreate(paneltabs[268],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNlistLabelString,
		XmStringLtoRCreate(paneltabs[270],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNbuttonFontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelFontList, gFontlist); n++;
	XtSetArg(args[n],XmNtextFontList, gSmall_fontlist); n++;

	IO_store_post_file_selection = 
          XtCreateWidget("IO_store_post_file_selection", 
			 xmFileSelectionBoxWidgetClass, 
			 IO_store_post_file_widget, args,n);

	/* default value for the namefile */
	switch (type)
	{
	  case IO_STORE_SINGLE:
	  case IO_STORE_CARTESIAN:
	  case IO_STORE_POLAR:
	  case IO_STORE_RGB:
	  case IO_STORE_SUN:
	    sprintf (filemessage, "%s/image_save", repertoire_save);
	    break;
	  case IO_STORE_MELANIE:
	    sprintf (filemessage, "%s/gel_save", repertoire_save);
	    break;
	  case IO_POST_NORMAL:
	  case IO_POST_MAXIMUM:
	    sprintf (filemessage, "%s/image_postcript", repertoire_save);
	    break;
	  default: break;
	}

        XmTextSetString (XmFileSelectionBoxGetChild 
	     (IO_store_post_file_selection, XmDIALOG_TEXT), filemessage);

	/* help button unsensitive! */
	XtSetSensitive(XmFileSelectionBoxGetChild 
	   (IO_store_post_file_selection, XmDIALOG_HELP_BUTTON), False);
    

	/* Adding Callbacks for IO_store_post_file_selection */ 

	XtAddCallback(IO_store_post_file_selection,XmNcancelCallback,
	   IO_store_post_file_CANCEL_callb, IO_store_post_file_widget);

	switch (type)
	{
	  case IO_STORE_SINGLE:
	    XtAddCallback(IO_store_post_file_selection,XmNokCallback,
			  IO_store_single_OK_callb,IO_store_post_file_widget); 
	    break;
	  case IO_STORE_CARTESIAN:
	    XtAddCallback(IO_store_post_file_selection,XmNokCallback,
			IO_store_cartesian_OK_callb,IO_store_post_file_widget); 
	    break;
	  case IO_STORE_POLAR:
	    XtAddCallback(IO_store_post_file_selection,XmNokCallback,
			  IO_store_polar_OK_callb,IO_store_post_file_widget); 
	    break;
	  case IO_STORE_RGB:
	    XtAddCallback(IO_store_post_file_selection,XmNokCallback,
			  IO_store_rgb_OK_callb,IO_store_post_file_widget); 
	    break;
	  case IO_STORE_MELANIE:
	    XtAddCallback(IO_store_post_file_selection,XmNokCallback,
			  IO_store_melanie_OK_callb,IO_store_post_file_widget); 
	    break;
	  case IO_STORE_SUN:
	    XtAddCallback(IO_store_post_file_selection,XmNokCallback,
			  IO_store_sun_OK_callb,IO_store_post_file_widget); 
	    break;
	  case IO_POST_NORMAL:
	    XtAddCallback(IO_store_post_file_selection,XmNokCallback,
			  IO_post_normal_OK_callb,IO_store_post_file_widget); 
	    break;
	  case IO_POST_MAXIMUM:
	    XtAddCallback(IO_store_post_file_selection,XmNokCallback,
			  IO_post_max_OK_callb,IO_store_post_file_widget); 
	    break;
	  default: break;
	}


	/* Creating selectplaneinput Widget */

	switch (type)
	{
	  case IO_STORE_SINGLE:  /* one plane */
	  case IO_STORE_SUN:
	  case IO_POST_NORMAL:
	  case IO_POST_MAXIMUM:
	  case IO_STORE_MELANIE:
	  selectplaneinput = 
	    build_SelectionPlane(IO_store_post_file_widget, 
			       XmFileSelectionBoxGetChild
			   (IO_store_post_file_selection, XmDIALOG_OK_BUTTON),
			     paneltabs[105], 0);
	    break;
	  case IO_STORE_CARTESIAN:  /* two planes */
	  selectplaneinput = 
	    build_Selection2Planes(IO_store_post_file_widget, 
			XmFileSelectionBoxGetChild
			   (IO_store_post_file_selection, XmDIALOG_OK_BUTTON),
			       paneltabs[77], paneltabs[78], 0);
	    break;
	  case IO_STORE_POLAR:   /* two planes */
	  selectplaneinput = 
	    build_Selection2Planes(IO_store_post_file_widget, 
			XmFileSelectionBoxGetChild
			   (IO_store_post_file_selection, XmDIALOG_OK_BUTTON),
			       paneltabs[79], paneltabs[80], 0);
	    break;
	  case IO_STORE_RGB:   /* three planes */
	  selectplaneinput = 
	    build_Selection3Planes(IO_store_post_file_widget, 
			XmFileSelectionBoxGetChild
			   (IO_store_post_file_selection, XmDIALOG_OK_BUTTON),
			       paneltabs[74], paneltabs[75], paneltabs[76]);
	    break;
	  default: break;
	}

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetValues(selectplaneinput, args, n);
	XtManageChild(selectplaneinput);

	/* Creating IO_load_image_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,selectplaneinput); n++;
	XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;

	IO_load_image_separator = 
		XmCreateSeparator(IO_store_post_file_widget,
			"IO_load_image_separator",args,n);
	XtManageChild(IO_load_image_separator);


	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,IO_load_image_separator); n++;
	XtSetValues(IO_store_post_file_selection, args, n);
	XtManageChild(IO_store_post_file_selection);

	return(IO_store_post_file_widget);
}
