#! /bin/zsh -f

# Written by SL Baur <steve@xemacs.org>
# December, 1998
# This file is part of XEmacs and is used by the maintainers
#  for creating distributions

# UpdatePackages:  Rebytecompile and install a minimal set of packages
# Usage:  UpdatePackages XEMACS

setopt extendedglob
set -e # Exit at the first sign of trouble

if [ $# != 1 ]; then
	echo "Usage: $0: XEMACS"
	exit 1
fi

export XEMACS=$1

function dopackage
{
	export DESTDIR=$1
	shift

	for package; do	(
		cd xemacs-packages/${package}
		make XEMACS=${XEMACS} STAGING=${DESTDIR} install
	)
	done
}

dopackage $(pwd)/bootstrap-mule-packages mule/mule-base
dopackage $(pwd)/bootstrap-xemacs-packages libs/xemacs-base wp/texinfo

exit 0
