/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class GetArray
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.args.remove(0), "object ID");
        ObjectReference oRef = this.proc.getStore().get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such object exists");
        }
        if (!(oRef instanceof ArrayReference)) {
            throw new JDEException("Object is not an array");
        }
        if (this.args.size() == 0) {
            this.jde.signalCommandResult(this.procID, this.cmdID, Rep.getArrayRep((ArrayReference)oRef, this.proc.getStore(), -1, -1));
        } else if (this.args.size() == 2) {
            int index = Etc.safeGetint(this.args.remove(0), "index");
            int length = Etc.safeGetint(this.args.remove(0), "length");
            this.jde.signalCommandResult(this.procID, this.cmdID, Rep.getArrayRep((ArrayReference)oRef, this.proc.getStore(), index, length));
        } else {
            throw new JDEException("Syntax error: Wrong number of arguments");
        }
    }

    public Object clone() {
        return new GetArray();
    }
}

