/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.LispForm;
import jde.debugger.Protocol;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class DebugThread
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.args.remove(0), "thread ID");
        ThreadReference tRef = (ThreadReference)this.proc.getStore().get(uniqueID);
        if (tRef == null) {
            throw new JDEException("Invalid thread ID or the thread is dead");
        }
        this.proc.getVM().suspend();
        try {
            LispForm locationRep = Rep.getLocationRep(tRef.frame(0).location());
            LispForm lispForm = new LispForm("(list 'jde-dbo-step-event " + locationRep + ")");
            this.jde.signal(this.procID, "event-set", new LispForm("\"thread\" " + Rep.getThreadRep(tRef, this.proc.getStore()) + Protocol.BR + lispForm));
            this.jde.signalCommandResult(this.procID, this.cmdID);
        }
        catch (IncompatibleThreadStateException exc) {
            throw new JDEException(exc.toString());
        }
    }

    public Object clone() {
        return new DebugThread();
    }
}

