/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import jde.debugger.JDE;
import jde.debugger.Jdebug;

public class CommandStream
extends StreamTokenizer {
    public CommandStream(BufferedReader in) {
        super(in);
        this.setSyntax();
    }

    public List nextCommand() {
        List<String> commandLine = new ArrayList<String>();
        try {
            int token = this.nextToken();
            while (token != 10) {
                switch (token) {
                    case -1: {
                        throw new IOException("EOF occurred reading command stream.");
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        commandLine.add(this.sval);
                        break;
                    }
                    default: {
                        commandLine.add(String.valueOf((char)token));
                    }
                }
                token = this.nextToken();
            }
            if (commandLine.size() < 3) {
                if (commandLine.size() > 0) {
                    JDE.getJDE().signalCommandError(Jdebug.debuggerID, new Integer(-1), "Malformed command");
                }
                commandLine = this.nextCommand();
            }
        }
        catch (IOException ex) {
            commandLine = null;
        }
        return commandLine;
    }

    private void setSyntax() {
        this.resetSyntax();
        this.eolIsSignificant(true);
        this.whitespaceChars(0, 32);
        this.wordChars(33, 255);
        this.quoteChar(34);
    }

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        CommandStream commandStream = new CommandStream(in);
        out.print("> ");
        out.flush();
        List command = commandStream.nextCommand();
        while (command != null && !((String)command.get(2)).startsWith("qu")) {
            int n = command.size();
            int i = 0;
            while (i < n) {
                out.println(command.get(i));
                ++i;
            }
            out.print("> ");
            out.flush();
            command = commandStream.nextCommand();
        }
    }
}

