/*
  File autogenerated by gengetopt version 2.22.1
  generated with the following command:
  /home/bettini/usr/local/bin/gengetopt --input cmdline.ggo --unamed-opts --no-handle-help --no-handle-version 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X)
#endif // FIX_UNUSED

#include "getopt.h"

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "Highlight the syntax of a source file (e.g. Java) into a specific format (e.g. \nHTML)";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTIONS]... [FILES]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -i, --input=filename          input file. default std input",
  "  -o, --output=filename         output file. default std output. If STDOUT is \n                                  specified, the output is directed to standard \n                                  output",
  "  -s, --src-lang=STRING         source language (use --lang-list to get the \n                                  complete list).  If not specified, the source \n                                  language will be guessed from the file \n                                  extension.",
  "      --lang-list               list all the supported language and associated \n                                  language definition file",
  "      --outlang-list            list all the supported output language and \n                                  associated language definition file",
  "  -f, --out-format=STRING       output format (use --outlang-list to get the \n                                  complete list)  (default=`html')",
  "  -d, --doc                     create an output file that can be used as a \n                                  stand alone document (e.g., not to be \n                                  included in another one)",
  "      --no-doc                  cancel the --doc option even if it is implied \n                                  (e.g., when css is given)",
  "  -c, --css=filename            the external style sheet filename.  Implies \n                                  --doc",
  "  -T, --title=STRING            give a title to the output document.  Implies \n                                  --doc",
  "  -t, --tab=INT                 specify tab length.  (default=`8')",
  "  -H, --header=filename         file to insert as header",
  "  -F, --footer=filename         file to insert as footer",
  "      --style-file=filename     specify the file containing format options  \n                                  (default=`default.style')",
  "      --style-css-file=filename specify the file containing format options (in \n                                  css syntax)",
  "      --style-defaults=filename specify the file containing defaults for format \n                                  options  (default=`style.defaults')",
  "      --outlang-def=filename    output language definition file",
  "      --outlang-map=filename    output language map file  \n                                  (default=`outlang.map')",
  "      --data-dir=path           directory where language definition files and \n                                  language maps are searched for.  If not \n                                  specified these files are searched for in the \n                                  current directory and in the data dir \n                                  installation directory",
  "      --output-dir=path         output directory",
  "      --lang-def=filename       language definition file",
  "      --lang-map=filename       language map file  (default=`lang.map')",
  "      --show-lang-elements=filename\n                                prints the language elements that are defined \n                                  in the language definition file",
  "      --infer-lang              force to infer source script language \n                                  (overriding given language specification)",
  "\nreference generation:",
  "  -n, --line-number[=padding]   number all output lines, using the specified \n                                  padding character  (default=`0')",
  "      --line-number-ref[=prefix]\n                                number all output lines and generate an anchor, \n                                  made of the specified prefix + the line \n                                  number  (default=`line')",
  "      --gen-references=STRING   generate references  (possible \n                                  values=\"inline\", \"postline\", \"postdoc\" \n                                  default=`inline')",
  "      --ctags-file=filename     specify the file generated by ctags that will \n                                  be used to generate references  \n                                  (default=`tags')",
  "      --ctags=cmd               how to run the ctags command.  If this option \n                                  is not specified, ctags will be executed with \n                                  the default value.  If it is specified with \n                                  an empty string, ctags will not be executed \n                                  at all  (default=`ctags --excmd=n \n                                  --tag-relative=yes')",
  "\ntesting:",
  "  -v, --verbose                 verbose mode on",
  "  -q, --quiet                   print no progress information",
  "      --statistics              print some statistics (i.e., elapsed time)",
  "      --gen-version             put source-highlight version in the generated \n                                  file  (default=on)",
  "      --check-lang=filename     only check the correctness of a language \n                                  definition file",
  "      --check-outlang=filename  only check the correctness of an output \n                                  language definition file",
  "      --failsafe                if no language definition is found for the \n                                  input, it is simply copied to the output",
  "  -g, --debug-langdef[=type]    debug a language definition.  In dump mode just \n                                  dumps all the steps; in interactive, at each \n                                  step, waits for some input (press ENTER to \n                                  step)  (possible values=\"interactive\", \n                                  \"dump\" default=`dump')",
  "      --show-regex=filename     show the regular expression automaton \n                                  corresponding to a language definition file",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


const char *cmdline_parser_gen_references_values[] = {"inline", "postline", "postdoc", 0}; /*< Possible values for gen-references. */
const char *cmdline_parser_debug_langdef_values[] = {"interactive", "dump", 0}; /*< Possible values for debug-langdef. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->output_given = 0 ;
  args_info->src_lang_given = 0 ;
  args_info->lang_list_given = 0 ;
  args_info->outlang_list_given = 0 ;
  args_info->out_format_given = 0 ;
  args_info->doc_given = 0 ;
  args_info->no_doc_given = 0 ;
  args_info->css_given = 0 ;
  args_info->title_given = 0 ;
  args_info->tab_given = 0 ;
  args_info->header_given = 0 ;
  args_info->footer_given = 0 ;
  args_info->style_file_given = 0 ;
  args_info->style_css_file_given = 0 ;
  args_info->style_defaults_given = 0 ;
  args_info->outlang_def_given = 0 ;
  args_info->outlang_map_given = 0 ;
  args_info->data_dir_given = 0 ;
  args_info->output_dir_given = 0 ;
  args_info->lang_def_given = 0 ;
  args_info->lang_map_given = 0 ;
  args_info->show_lang_elements_given = 0 ;
  args_info->infer_lang_given = 0 ;
  args_info->line_number_given = 0 ;
  args_info->line_number_ref_given = 0 ;
  args_info->gen_references_given = 0 ;
  args_info->ctags_file_given = 0 ;
  args_info->ctags_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->quiet_given = 0 ;
  args_info->statistics_given = 0 ;
  args_info->gen_version_given = 0 ;
  args_info->check_lang_given = 0 ;
  args_info->check_outlang_given = 0 ;
  args_info->failsafe_given = 0 ;
  args_info->debug_langdef_given = 0 ;
  args_info->show_regex_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->input_arg = NULL;
  args_info->input_orig = NULL;
  args_info->output_arg = NULL;
  args_info->output_orig = NULL;
  args_info->src_lang_arg = NULL;
  args_info->src_lang_orig = NULL;
  args_info->out_format_arg = gengetopt_strdup ("html");
  args_info->out_format_orig = NULL;
  args_info->css_arg = NULL;
  args_info->css_orig = NULL;
  args_info->title_arg = NULL;
  args_info->title_orig = NULL;
  args_info->tab_arg = 8;
  args_info->tab_orig = NULL;
  args_info->header_arg = NULL;
  args_info->header_orig = NULL;
  args_info->footer_arg = NULL;
  args_info->footer_orig = NULL;
  args_info->style_file_arg = gengetopt_strdup ("default.style");
  args_info->style_file_orig = NULL;
  args_info->style_css_file_arg = NULL;
  args_info->style_css_file_orig = NULL;
  args_info->style_defaults_arg = gengetopt_strdup ("style.defaults");
  args_info->style_defaults_orig = NULL;
  args_info->outlang_def_arg = NULL;
  args_info->outlang_def_orig = NULL;
  args_info->outlang_map_arg = gengetopt_strdup ("outlang.map");
  args_info->outlang_map_orig = NULL;
  args_info->data_dir_arg = NULL;
  args_info->data_dir_orig = NULL;
  args_info->output_dir_arg = NULL;
  args_info->output_dir_orig = NULL;
  args_info->lang_def_arg = NULL;
  args_info->lang_def_orig = NULL;
  args_info->lang_map_arg = gengetopt_strdup ("lang.map");
  args_info->lang_map_orig = NULL;
  args_info->show_lang_elements_arg = NULL;
  args_info->show_lang_elements_orig = NULL;
  args_info->line_number_arg = gengetopt_strdup ("0");
  args_info->line_number_orig = NULL;
  args_info->line_number_ref_arg = gengetopt_strdup ("line");
  args_info->line_number_ref_orig = NULL;
  args_info->gen_references_arg = gengetopt_strdup ("inline");
  args_info->gen_references_orig = NULL;
  args_info->ctags_file_arg = gengetopt_strdup ("tags");
  args_info->ctags_file_orig = NULL;
  args_info->ctags_arg = gengetopt_strdup ("ctags --excmd=n --tag-relative=yes");
  args_info->ctags_orig = NULL;
  args_info->gen_version_flag = 1;
  args_info->check_lang_arg = NULL;
  args_info->check_lang_orig = NULL;
  args_info->check_outlang_arg = NULL;
  args_info->check_outlang_orig = NULL;
  args_info->debug_langdef_arg = gengetopt_strdup ("dump");
  args_info->debug_langdef_orig = NULL;
  args_info->show_regex_arg = NULL;
  args_info->show_regex_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->input_help = gengetopt_args_info_help[2] ;
  args_info->output_help = gengetopt_args_info_help[3] ;
  args_info->src_lang_help = gengetopt_args_info_help[4] ;
  args_info->lang_list_help = gengetopt_args_info_help[5] ;
  args_info->outlang_list_help = gengetopt_args_info_help[6] ;
  args_info->out_format_help = gengetopt_args_info_help[7] ;
  args_info->doc_help = gengetopt_args_info_help[8] ;
  args_info->no_doc_help = gengetopt_args_info_help[9] ;
  args_info->css_help = gengetopt_args_info_help[10] ;
  args_info->title_help = gengetopt_args_info_help[11] ;
  args_info->tab_help = gengetopt_args_info_help[12] ;
  args_info->header_help = gengetopt_args_info_help[13] ;
  args_info->footer_help = gengetopt_args_info_help[14] ;
  args_info->style_file_help = gengetopt_args_info_help[15] ;
  args_info->style_css_file_help = gengetopt_args_info_help[16] ;
  args_info->style_defaults_help = gengetopt_args_info_help[17] ;
  args_info->outlang_def_help = gengetopt_args_info_help[18] ;
  args_info->outlang_map_help = gengetopt_args_info_help[19] ;
  args_info->data_dir_help = gengetopt_args_info_help[20] ;
  args_info->output_dir_help = gengetopt_args_info_help[21] ;
  args_info->lang_def_help = gengetopt_args_info_help[22] ;
  args_info->lang_map_help = gengetopt_args_info_help[23] ;
  args_info->show_lang_elements_help = gengetopt_args_info_help[24] ;
  args_info->infer_lang_help = gengetopt_args_info_help[25] ;
  args_info->line_number_help = gengetopt_args_info_help[27] ;
  args_info->line_number_ref_help = gengetopt_args_info_help[28] ;
  args_info->gen_references_help = gengetopt_args_info_help[29] ;
  args_info->ctags_file_help = gengetopt_args_info_help[30] ;
  args_info->ctags_help = gengetopt_args_info_help[31] ;
  args_info->verbose_help = gengetopt_args_info_help[33] ;
  args_info->quiet_help = gengetopt_args_info_help[34] ;
  args_info->statistics_help = gengetopt_args_info_help[35] ;
  args_info->gen_version_help = gengetopt_args_info_help[36] ;
  args_info->check_lang_help = gengetopt_args_info_help[37] ;
  args_info->check_outlang_help = gengetopt_args_info_help[38] ;
  args_info->failsafe_help = gengetopt_args_info_help[39] ;
  args_info->debug_langdef_help = gengetopt_args_info_help[40] ;
  args_info->show_regex_help = gengetopt_args_info_help[41] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->input_arg));
  free_string_field (&(args_info->input_orig));
  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  free_string_field (&(args_info->src_lang_arg));
  free_string_field (&(args_info->src_lang_orig));
  free_string_field (&(args_info->out_format_arg));
  free_string_field (&(args_info->out_format_orig));
  free_string_field (&(args_info->css_arg));
  free_string_field (&(args_info->css_orig));
  free_string_field (&(args_info->title_arg));
  free_string_field (&(args_info->title_orig));
  free_string_field (&(args_info->tab_orig));
  free_string_field (&(args_info->header_arg));
  free_string_field (&(args_info->header_orig));
  free_string_field (&(args_info->footer_arg));
  free_string_field (&(args_info->footer_orig));
  free_string_field (&(args_info->style_file_arg));
  free_string_field (&(args_info->style_file_orig));
  free_string_field (&(args_info->style_css_file_arg));
  free_string_field (&(args_info->style_css_file_orig));
  free_string_field (&(args_info->style_defaults_arg));
  free_string_field (&(args_info->style_defaults_orig));
  free_string_field (&(args_info->outlang_def_arg));
  free_string_field (&(args_info->outlang_def_orig));
  free_string_field (&(args_info->outlang_map_arg));
  free_string_field (&(args_info->outlang_map_orig));
  free_string_field (&(args_info->data_dir_arg));
  free_string_field (&(args_info->data_dir_orig));
  free_string_field (&(args_info->output_dir_arg));
  free_string_field (&(args_info->output_dir_orig));
  free_string_field (&(args_info->lang_def_arg));
  free_string_field (&(args_info->lang_def_orig));
  free_string_field (&(args_info->lang_map_arg));
  free_string_field (&(args_info->lang_map_orig));
  free_string_field (&(args_info->show_lang_elements_arg));
  free_string_field (&(args_info->show_lang_elements_orig));
  free_string_field (&(args_info->line_number_arg));
  free_string_field (&(args_info->line_number_orig));
  free_string_field (&(args_info->line_number_ref_arg));
  free_string_field (&(args_info->line_number_ref_orig));
  free_string_field (&(args_info->gen_references_arg));
  free_string_field (&(args_info->gen_references_orig));
  free_string_field (&(args_info->ctags_file_arg));
  free_string_field (&(args_info->ctags_file_orig));
  free_string_field (&(args_info->ctags_arg));
  free_string_field (&(args_info->ctags_orig));
  free_string_field (&(args_info->check_lang_arg));
  free_string_field (&(args_info->check_lang_orig));
  free_string_field (&(args_info->check_outlang_arg));
  free_string_field (&(args_info->check_outlang_orig));
  free_string_field (&(args_info->debug_langdef_arg));
  free_string_field (&(args_info->debug_langdef_orig));
  free_string_field (&(args_info->show_regex_arg));
  free_string_field (&(args_info->show_regex_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->input_given)
    write_into_file(outfile, "input", args_info->input_orig, 0);
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  if (args_info->src_lang_given)
    write_into_file(outfile, "src-lang", args_info->src_lang_orig, 0);
  if (args_info->lang_list_given)
    write_into_file(outfile, "lang-list", 0, 0 );
  if (args_info->outlang_list_given)
    write_into_file(outfile, "outlang-list", 0, 0 );
  if (args_info->out_format_given)
    write_into_file(outfile, "out-format", args_info->out_format_orig, 0);
  if (args_info->doc_given)
    write_into_file(outfile, "doc", 0, 0 );
  if (args_info->no_doc_given)
    write_into_file(outfile, "no-doc", 0, 0 );
  if (args_info->css_given)
    write_into_file(outfile, "css", args_info->css_orig, 0);
  if (args_info->title_given)
    write_into_file(outfile, "title", args_info->title_orig, 0);
  if (args_info->tab_given)
    write_into_file(outfile, "tab", args_info->tab_orig, 0);
  if (args_info->header_given)
    write_into_file(outfile, "header", args_info->header_orig, 0);
  if (args_info->footer_given)
    write_into_file(outfile, "footer", args_info->footer_orig, 0);
  if (args_info->style_file_given)
    write_into_file(outfile, "style-file", args_info->style_file_orig, 0);
  if (args_info->style_css_file_given)
    write_into_file(outfile, "style-css-file", args_info->style_css_file_orig, 0);
  if (args_info->style_defaults_given)
    write_into_file(outfile, "style-defaults", args_info->style_defaults_orig, 0);
  if (args_info->outlang_def_given)
    write_into_file(outfile, "outlang-def", args_info->outlang_def_orig, 0);
  if (args_info->outlang_map_given)
    write_into_file(outfile, "outlang-map", args_info->outlang_map_orig, 0);
  if (args_info->data_dir_given)
    write_into_file(outfile, "data-dir", args_info->data_dir_orig, 0);
  if (args_info->output_dir_given)
    write_into_file(outfile, "output-dir", args_info->output_dir_orig, 0);
  if (args_info->lang_def_given)
    write_into_file(outfile, "lang-def", args_info->lang_def_orig, 0);
  if (args_info->lang_map_given)
    write_into_file(outfile, "lang-map", args_info->lang_map_orig, 0);
  if (args_info->show_lang_elements_given)
    write_into_file(outfile, "show-lang-elements", args_info->show_lang_elements_orig, 0);
  if (args_info->infer_lang_given)
    write_into_file(outfile, "infer-lang", 0, 0 );
  if (args_info->line_number_given)
    write_into_file(outfile, "line-number", args_info->line_number_orig, 0);
  if (args_info->line_number_ref_given)
    write_into_file(outfile, "line-number-ref", args_info->line_number_ref_orig, 0);
  if (args_info->gen_references_given)
    write_into_file(outfile, "gen-references", args_info->gen_references_orig, cmdline_parser_gen_references_values);
  if (args_info->ctags_file_given)
    write_into_file(outfile, "ctags-file", args_info->ctags_file_orig, 0);
  if (args_info->ctags_given)
    write_into_file(outfile, "ctags", args_info->ctags_orig, 0);
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->quiet_given)
    write_into_file(outfile, "quiet", 0, 0 );
  if (args_info->statistics_given)
    write_into_file(outfile, "statistics", 0, 0 );
  if (args_info->gen_version_given)
    write_into_file(outfile, "gen-version", 0, 0 );
  if (args_info->check_lang_given)
    write_into_file(outfile, "check-lang", args_info->check_lang_orig, 0);
  if (args_info->check_outlang_given)
    write_into_file(outfile, "check-outlang", args_info->check_outlang_orig, 0);
  if (args_info->failsafe_given)
    write_into_file(outfile, "failsafe", 0, 0 );
  if (args_info->debug_langdef_given)
    write_into_file(outfile, "debug-langdef", args_info->debug_langdef_orig, cmdline_parser_debug_langdef_values);
  if (args_info->show_regex_given)
    write_into_file(outfile, "show-regex", args_info->show_regex_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  FIX_UNUSED (field);
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'i' },
        { "output",	1, NULL, 'o' },
        { "src-lang",	1, NULL, 's' },
        { "lang-list",	0, NULL, 0 },
        { "outlang-list",	0, NULL, 0 },
        { "out-format",	1, NULL, 'f' },
        { "doc",	0, NULL, 'd' },
        { "no-doc",	0, NULL, 0 },
        { "css",	1, NULL, 'c' },
        { "title",	1, NULL, 'T' },
        { "tab",	1, NULL, 't' },
        { "header",	1, NULL, 'H' },
        { "footer",	1, NULL, 'F' },
        { "style-file",	1, NULL, 0 },
        { "style-css-file",	1, NULL, 0 },
        { "style-defaults",	1, NULL, 0 },
        { "outlang-def",	1, NULL, 0 },
        { "outlang-map",	1, NULL, 0 },
        { "data-dir",	1, NULL, 0 },
        { "output-dir",	1, NULL, 0 },
        { "lang-def",	1, NULL, 0 },
        { "lang-map",	1, NULL, 0 },
        { "show-lang-elements",	1, NULL, 0 },
        { "infer-lang",	0, NULL, 0 },
        { "line-number",	2, NULL, 'n' },
        { "line-number-ref",	2, NULL, 0 },
        { "gen-references",	1, NULL, 0 },
        { "ctags-file",	1, NULL, 0 },
        { "ctags",	1, NULL, 0 },
        { "verbose",	0, NULL, 'v' },
        { "quiet",	0, NULL, 'q' },
        { "statistics",	0, NULL, 0 },
        { "gen-version",	0, NULL, 0 },
        { "check-lang",	1, NULL, 0 },
        { "check-outlang",	1, NULL, 0 },
        { "failsafe",	0, NULL, 0 },
        { "debug-langdef",	2, NULL, 'g' },
        { "show-regex",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVi:o:s:f:dc:T:t:H:F:n::vqg::", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->help_given),
              &(local_args_info.help_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "help", 'h',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'V':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'V',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'i':	/* input file. default std input.  */
        
        
          if (update_arg( (void *)&(args_info->input_arg), 
               &(args_info->input_orig), &(args_info->input_given),
              &(local_args_info.input_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "input", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* output file. default std output. If STDOUT is specified, the output is directed to standard output.  */
        
        
          if (update_arg( (void *)&(args_info->output_arg), 
               &(args_info->output_orig), &(args_info->output_given),
              &(local_args_info.output_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output", 'o',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* source language (use --lang-list to get the complete list).  If not specified, the source language will be guessed from the file extension..  */
        
        
          if (update_arg( (void *)&(args_info->src_lang_arg), 
               &(args_info->src_lang_orig), &(args_info->src_lang_given),
              &(local_args_info.src_lang_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "src-lang", 's',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* output format (use --outlang-list to get the complete list).  */
        
        
          if (update_arg( (void *)&(args_info->out_format_arg), 
               &(args_info->out_format_orig), &(args_info->out_format_given),
              &(local_args_info.out_format_given), optarg, 0, "html", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "out-format", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* create an output file that can be used as a stand alone document (e.g., not to be included in another one).  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->doc_given),
              &(local_args_info.doc_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "doc", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* the external style sheet filename.  Implies --doc.  */
        
        
          if (update_arg( (void *)&(args_info->css_arg), 
               &(args_info->css_orig), &(args_info->css_given),
              &(local_args_info.css_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "css", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* give a title to the output document.  Implies --doc.  */
        
        
          if (update_arg( (void *)&(args_info->title_arg), 
               &(args_info->title_orig), &(args_info->title_given),
              &(local_args_info.title_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "title", 'T',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* specify tab length..  */
        
        
          if (update_arg( (void *)&(args_info->tab_arg), 
               &(args_info->tab_orig), &(args_info->tab_given),
              &(local_args_info.tab_given), optarg, 0, "8", ARG_INT,
              check_ambiguity, override, 0, 0,
              "tab", 't',
              additional_error))
            goto failure;
        
          break;
        case 'H':	/* file to insert as header.  */
        
        
          if (update_arg( (void *)&(args_info->header_arg), 
               &(args_info->header_orig), &(args_info->header_given),
              &(local_args_info.header_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "header", 'H',
              additional_error))
            goto failure;
        
          break;
        case 'F':	/* file to insert as footer.  */
        
        
          if (update_arg( (void *)&(args_info->footer_arg), 
               &(args_info->footer_orig), &(args_info->footer_given),
              &(local_args_info.footer_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "footer", 'F',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* number all output lines, using the specified padding character.  */
        
        
          if (update_arg( (void *)&(args_info->line_number_arg), 
               &(args_info->line_number_orig), &(args_info->line_number_given),
              &(local_args_info.line_number_given), optarg, 0, "0", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "line-number", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* verbose mode on.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* print no progress information.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->quiet_given),
              &(local_args_info.quiet_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "quiet", 'q',
              additional_error))
            goto failure;
        
          break;
        case 'g':	/* debug a language definition.  In dump mode just dumps all the steps; in interactive, at each step, waits for some input (press ENTER to step).  */
        
        
          if (update_arg( (void *)&(args_info->debug_langdef_arg), 
               &(args_info->debug_langdef_orig), &(args_info->debug_langdef_given),
              &(local_args_info.debug_langdef_given), optarg, cmdline_parser_debug_langdef_values, "dump", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "debug-langdef", 'g',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* list all the supported language and associated language definition file.  */
          if (strcmp (long_options[option_index].name, "lang-list") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->lang_list_given),
                &(local_args_info.lang_list_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "lang-list", '-',
                additional_error))
              goto failure;
          
          }
          /* list all the supported output language and associated language definition file.  */
          else if (strcmp (long_options[option_index].name, "outlang-list") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->outlang_list_given),
                &(local_args_info.outlang_list_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "outlang-list", '-',
                additional_error))
              goto failure;
          
          }
          /* cancel the --doc option even if it is implied (e.g., when css is given).  */
          else if (strcmp (long_options[option_index].name, "no-doc") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->no_doc_given),
                &(local_args_info.no_doc_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "no-doc", '-',
                additional_error))
              goto failure;
          
          }
          /* specify the file containing format options.  */
          else if (strcmp (long_options[option_index].name, "style-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->style_file_arg), 
                 &(args_info->style_file_orig), &(args_info->style_file_given),
                &(local_args_info.style_file_given), optarg, 0, "default.style", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "style-file", '-',
                additional_error))
              goto failure;
          
          }
          /* specify the file containing format options (in css syntax).  */
          else if (strcmp (long_options[option_index].name, "style-css-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->style_css_file_arg), 
                 &(args_info->style_css_file_orig), &(args_info->style_css_file_given),
                &(local_args_info.style_css_file_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "style-css-file", '-',
                additional_error))
              goto failure;
          
          }
          /* specify the file containing defaults for format options.  */
          else if (strcmp (long_options[option_index].name, "style-defaults") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->style_defaults_arg), 
                 &(args_info->style_defaults_orig), &(args_info->style_defaults_given),
                &(local_args_info.style_defaults_given), optarg, 0, "style.defaults", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "style-defaults", '-',
                additional_error))
              goto failure;
          
          }
          /* output language definition file.  */
          else if (strcmp (long_options[option_index].name, "outlang-def") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->outlang_def_arg), 
                 &(args_info->outlang_def_orig), &(args_info->outlang_def_given),
                &(local_args_info.outlang_def_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "outlang-def", '-',
                additional_error))
              goto failure;
          
          }
          /* output language map file.  */
          else if (strcmp (long_options[option_index].name, "outlang-map") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->outlang_map_arg), 
                 &(args_info->outlang_map_orig), &(args_info->outlang_map_given),
                &(local_args_info.outlang_map_given), optarg, 0, "outlang.map", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "outlang-map", '-',
                additional_error))
              goto failure;
          
          }
          /* directory where language definition files and language maps are searched for.  If not specified these files are searched for in the current directory and in the data dir installation directory.  */
          else if (strcmp (long_options[option_index].name, "data-dir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->data_dir_arg), 
                 &(args_info->data_dir_orig), &(args_info->data_dir_given),
                &(local_args_info.data_dir_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "data-dir", '-',
                additional_error))
              goto failure;
          
          }
          /* output directory.  */
          else if (strcmp (long_options[option_index].name, "output-dir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_dir_arg), 
                 &(args_info->output_dir_orig), &(args_info->output_dir_given),
                &(local_args_info.output_dir_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-dir", '-',
                additional_error))
              goto failure;
          
          }
          /* language definition file.  */
          else if (strcmp (long_options[option_index].name, "lang-def") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->lang_def_arg), 
                 &(args_info->lang_def_orig), &(args_info->lang_def_given),
                &(local_args_info.lang_def_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "lang-def", '-',
                additional_error))
              goto failure;
          
          }
          /* language map file.  */
          else if (strcmp (long_options[option_index].name, "lang-map") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->lang_map_arg), 
                 &(args_info->lang_map_orig), &(args_info->lang_map_given),
                &(local_args_info.lang_map_given), optarg, 0, "lang.map", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "lang-map", '-',
                additional_error))
              goto failure;
          
          }
          /* prints the language elements that are defined in the language definition file.  */
          else if (strcmp (long_options[option_index].name, "show-lang-elements") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->show_lang_elements_arg), 
                 &(args_info->show_lang_elements_orig), &(args_info->show_lang_elements_given),
                &(local_args_info.show_lang_elements_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "show-lang-elements", '-',
                additional_error))
              goto failure;
          
          }
          /* force to infer source script language (overriding given language specification).  */
          else if (strcmp (long_options[option_index].name, "infer-lang") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->infer_lang_given),
                &(local_args_info.infer_lang_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "infer-lang", '-',
                additional_error))
              goto failure;
          
          }
          /* number all output lines and generate an anchor, made of the specified prefix + the line number.  */
          else if (strcmp (long_options[option_index].name, "line-number-ref") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->line_number_ref_arg), 
                 &(args_info->line_number_ref_orig), &(args_info->line_number_ref_given),
                &(local_args_info.line_number_ref_given), optarg, 0, "line", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "line-number-ref", '-',
                additional_error))
              goto failure;
          
          }
          /* generate references.  */
          else if (strcmp (long_options[option_index].name, "gen-references") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->gen_references_arg), 
                 &(args_info->gen_references_orig), &(args_info->gen_references_given),
                &(local_args_info.gen_references_given), optarg, cmdline_parser_gen_references_values, "inline", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "gen-references", '-',
                additional_error))
              goto failure;
          
          }
          /* specify the file generated by ctags that will be used to generate references.  */
          else if (strcmp (long_options[option_index].name, "ctags-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ctags_file_arg), 
                 &(args_info->ctags_file_orig), &(args_info->ctags_file_given),
                &(local_args_info.ctags_file_given), optarg, 0, "tags", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "ctags-file", '-',
                additional_error))
              goto failure;
          
          }
          /* how to run the ctags command.  If this option is not specified, ctags will be executed with the default value.  If it is specified with an empty string, ctags will not be executed at all.  */
          else if (strcmp (long_options[option_index].name, "ctags") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ctags_arg), 
                 &(args_info->ctags_orig), &(args_info->ctags_given),
                &(local_args_info.ctags_given), optarg, 0, "ctags --excmd=n --tag-relative=yes", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "ctags", '-',
                additional_error))
              goto failure;
          
          }
          /* print some statistics (i.e., elapsed time).  */
          else if (strcmp (long_options[option_index].name, "statistics") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->statistics_given),
                &(local_args_info.statistics_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "statistics", '-',
                additional_error))
              goto failure;
          
          }
          /* put source-highlight version in the generated file.  */
          else if (strcmp (long_options[option_index].name, "gen-version") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->gen_version_flag), 0, &(args_info->gen_version_given),
                &(local_args_info.gen_version_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "gen-version", '-',
                additional_error))
              goto failure;
          
          }
          /* only check the correctness of a language definition file.  */
          else if (strcmp (long_options[option_index].name, "check-lang") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->check_lang_arg), 
                 &(args_info->check_lang_orig), &(args_info->check_lang_given),
                &(local_args_info.check_lang_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "check-lang", '-',
                additional_error))
              goto failure;
          
          }
          /* only check the correctness of an output language definition file.  */
          else if (strcmp (long_options[option_index].name, "check-outlang") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->check_outlang_arg), 
                 &(args_info->check_outlang_orig), &(args_info->check_outlang_given),
                &(local_args_info.check_outlang_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "check-outlang", '-',
                additional_error))
              goto failure;
          
          }
          /* if no language definition is found for the input, it is simply copied to the output.  */
          else if (strcmp (long_options[option_index].name, "failsafe") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->failsafe_given),
                &(local_args_info.failsafe_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "failsafe", '-',
                additional_error))
              goto failure;
          
          }
          /* show the regular expression automaton corresponding to a language definition file.  */
          else if (strcmp (long_options[option_index].name, "show-regex") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->show_regex_arg), 
                 &(args_info->show_regex_orig), &(args_info->show_regex_given),
                &(local_args_info.show_regex_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "show-regex", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
