//
// C++ Interface: generatormap
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GENERATORMAP_H
#define GENERATORMAP_H

#include <map>
#include <string>

class TextGenerator;

/**
map of generators; associate a generator for each program element, e.g., keyword, string, etc.

@author Lorenzo Bettini
*/
class GeneratorMap
{
 protected:
  typedef std::map<std::string, TextGenerator *> MapType;
  MapType generatormap;
  TextGenerator *default_generator;

  virtual TextGenerator *missingGenerator(const std::string &elem);

 public:
  GeneratorMap();
  virtual ~GeneratorMap();

  TextGenerator *getGenerator(const std::string &elem);
  void addGenerator(const std::string &elem, TextGenerator *gen);

  void setDefaultGenerator(TextGenerator *g);

  void generate( const std::string &elem, const std::string &s );
  void generateln( const std::string &elem, const std::string &s );
  void generateEntire( const std::string &elem, const std::string &s );
};

#endif
