/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// generatorfactory.cc

#include "generatorfactory.h"

#include "tags.h"
#include "keys.h"
#include "docgenerator.h"
#include "chartranslator.h"
#include "textgen.h"
#include "colormap.h"

// global
#include "maingeneratormap.h"

GeneratorFactory::GeneratorFactory(const string &t) :
  char_translator (0), title (t)
{
}

GeneratorFactory::~ GeneratorFactory()
{
  if (generatormap)
    delete generatormap;

  if (MapOfColors)
    delete MapOfColors;
}

CharTranslator *
GeneratorFactory::getCharTranslator()
{
  if (! char_translator)
    char_translator = createCharTranslator();

  return char_translator;
}

GeneratorMap *
GeneratorFactory::createGeneratorMap()
{
  return new GeneratorMap;
}

void
GeneratorFactory::createGenerators()
{
  MapOfColors = createColorMap ();
  generatormap = createGeneratorMap();

  const Tags *tags = getTags();

  TextGenerator *text_gen;
  for (Tags::const_iterator it = tags->begin(); it != tags->end(); ++it)
    {
      text_gen = createGenerator(*it);
      generatormap->addGenerator((*it)->GetName(), text_gen);
    }

  // set the normal generator as the default generator
  TextGenerator *normal = createDefaultGenerator ();
  generatormap->setDefaultGenerator(normal);
}

#define GET_DECORATED( d ) ( d ? d : final_dec )

TextGenerator *
GeneratorFactory::createDefaultGenerator()
{
  return createGenerator (NORMAL);
}

TextGenerator *
GeneratorFactory::createGenerator( const string &key )
{
  const Tag *tag = getTag( key ) ;

  if ( ! tag ) // no options
    return new TextGenerator ;

  return createGenerator(tag);
}

TextGenerator *
GeneratorFactory::createGenerator( const Tag *tag )
{
  resetTagBuffers();

  const string &color = tag->GetColor() ;
  if ( color.size () )
    {
     string c;
     if ( color[0] == '#' && color.size () == 7 )
       c = color; // FIXME: handle direct colors not only for HTML
     else
       c = MapOfColors->getColor (color);

     addColor( c ) ;
    }

  if ( tag->IsBold() )
    addBold();
  if ( tag->IsItalic() )
    addItalic();
  if ( tag->IsUnderline() )
    addUnderline();

  return new TextGenerator(getPreTag(), getPostTag());
}

DocGenerator *
GeneratorFactory::createDocGenerator()
{
  return new DocGenerator (title);
}
