/*
** Copyright (C) 1999, 2000, 2002 Lorenzo Bettini <bettini@gnu.org>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

// factory for HTML generators

#ifndef HTMLGENERATORFACTORY_H
#define HTMLGENERATORFACTORY_H

#include "generatorfactory.h"

class HtmlGeneratorFactory : public GeneratorFactory
{
 protected:
  string input_file_name;
  string doc_header;
  string doc_footer;
  string css_url;

  virtual TextGenerator *createBoldDecorator(TextGenerator *);
  virtual TextGenerator *createItalicDecorator(TextGenerator *);
  virtual TextGenerator *createUnderlineDecorator(TextGenerator *);
  virtual TextGenerator *createColorDecorator(TextGenerator *, const string &color);

  virtual DocGenerator *createDocGenerator();
  virtual ColorMap *createColorMap();
  virtual CharTranslator *createCharTranslator();

 public:
  HtmlGeneratorFactory(bool line_number, const string &t, 
                       bool line_ref,
                       const string &input,
                       const string &header, const string &foot, const string &css);
  virtual ~HtmlGeneratorFactory() {}
};

#endif // HTMLGENERATORFACTORY_H
