/* $NoKeywords:$ */
/**
 * @file
 *
 * Collectively assign unique filecodes for assert and debug to each source file.
 *
 * Publish values for decorated filenames, which can be used for
 * ASSERT and debug support using a preprocessor define like:
 * @n <tt> \#define FILECODE MY_C_FILENAME_FILECODE </tt> @n
 * This file serves as a reference for debugging to associate the code and filename.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  Include
 * @e \$Revision: 309899 $   @e \$Date: 2014-12-23 02:21:13 -0600 (Tue, 23 Dec 2014) $
 */
 /*****************************************************************************
 *
 * Copyright (c) 2008 - 2015, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#ifndef _FILECODE_H_
#define _FILECODE_H_

#define UNASSIGNED_FILE_FILECODE                                         (0xFFFF)

/// For debug use in any Platform's options C file.
/// Can be reused for platforms and image builds, since only one options file can be built.
#define PLATFORM_SPECIFIC_OPTIONS_FILECODE                               (0xBBBB)


#define PROC_GNB_COMMON_GNBLIBFEATURES_FILECODE                          (0xA001)
#define PROC_GNB_GNBINITATEARLY_FILECODE                                 (0xA017)
#define PROC_GNB_GNBINITATENV_FILECODE                                   (0xA020)
#define PROC_GNB_GNBINITATLATE_FILECODE                                  (0xA021)
#define PROC_GNB_GNBINITATMID_FILECODE                                   (0xA022)
#define PROC_GNB_GNBINITATPOST_FILECODE                                  (0xA023)
#define PROC_GNB_GNBINITATRESET_FILECODE                                 (0xA024)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIB_FILECODE                    (0xA025)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBCPUACC_FILECODE              (0xA026)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBHEAP_FILECODE                (0xA027)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBIOACC_FILECODE               (0xA028)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBMEMACC_FILECODE              (0xA029)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBPCI_FILECODE                 (0xA02A)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBPCIACC_FILECODE              (0xA030)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXCARDINFO_FILECODE            (0xA031)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXENUMCONNECTORS_FILECODE      (0xA032)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GNBGFXINITLIBV1_FILECODE        (0xA033)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIECONFIGDATA_FILECODE           (0xA036)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIECONFIGLIB_FILECODE            (0xA037)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIEINPUTPARSER_FILECODE          (0xA038)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIEMAPTOPOLOGY_FILECODE          (0xA039)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEASPMBLACKLIST_FILECODE     (0xA03B)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEASPMEXITLATENCY_FILECODE   (0xA03C)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPHYSERVICES_FILECODE       (0xA03D)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPIFSERVICES_FILECODE       (0xA03E)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPORTREGACC_FILECODE        (0xA03F)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPORTSERVICES_FILECODE      (0xA041)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPOWERMGMT_FILECODE         (0xA043)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIESILICONSERVICES_FILECODE   (0xA045)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIETIMER_FILECODE             (0xA046)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIETOPOLOGYSERVICES_FILECODE  (0xA047)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEUTILITYLIB_FILECODE        (0xA048)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEWRAPPERREGACC_FILECODE     (0xA049)
#define PROC_GNB_MODULES_GNBPCIECOMMCLKCFG_PCIECOMMCLKCFG_FILECODE       (0xA04C)

#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGENV_FILECODE              (0xA08E)
#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGPOST_FILECODE             (0xA08F)
#define PROC_GNB_MODULES_GNBTABLE_GNBTABLE_FILECODE                      (0xA090)
#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGLIB_FILECODE              (0xA093)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEWRAPPERSERVICESV4_FILECODE (0xA0A6)
#define PROC_GNB_MODULES_GNBIOMMUIVRS_GNBIOMMUIVRS_FILECODE              (0xA0A7)
#define PROC_GNB_MODULES_GNBIVRSLIB_GNBIVRSLIB_FILECODE                  (0xA0A8)
#define PROC_GNB_MODULES_GNBNBINITLIBV4_GNBNBINITLIBV4_FILECODE          (0xA0A9)
#define PROC_GNB_MODULES_GNBFAMTRANSLATION_GNBPCIETRANSLATION_FILECODE   (0xA0AA)

#define PROC_GNB_MODULES_GNBSBLIB_GNBSBPCIE_FILECODE                     (0xA0BA)
#define PROC_GNB_MODULES_GNBSBLIB_GNBSBLIB_FILECODE                      (0xA0BB)
#define PROC_GNB_MODULES_GNBSBIOMMULIB_GNBSBIOMMULIB_FILECODE            (0xA0BC)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBTIMERLIB_FILECODE               (0xA0BD)
#define PROC_GNB_MODULES_GNBSSOCKETLIB_GNBSSOCKETLIB_FILECODE            (0xA0BF)
#define PROC_GNB_MODULES_GNBPCIECONFIG_GNBHANDLELIB_FILECODE             (0xA0C0)
#define PROC_GNB_MODULES_GNBPCIEASPM_PCIEASPM_FILECODE                   (0xA0C2)

#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEASPMEXITLATENCYV5_FILECODE (0xA0C5)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPIFSERVICESV5_FILECODE     (0xA0C6)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPORTSERVICESV5_FILECODE    (0xA0C7)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPOWERMGMTV5_FILECODE       (0xA0C8)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIESILICONSERVICESV5_FILECODE (0xA0C9)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEWRAPPERSERVICESV5_FILECODE (0xA0CA)
#define PROC_GNB_MODULES_GNBNBINITLIBV5_GNBNBINITLIBV5_FILECODE          (0xA0CB)

#define PROC_GNB_MODULES_GNBFAMTRANSLATION_GNBTRANSLATION_FILECODE       (0xA0DB)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEPOWERMGMTV4_FILECODE       (0xA0DC)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEPORTSERVICESV4_FILECODE    (0xA0DD)

#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGMID_FILECODE              (0xA0E0)

#define PROC_GNB_MODULES_GNBIOAPIC_GNBIOAPIC_FILECODE                    (0xA0EE)

#define PROC_GNB_MODULES_GNBPCIEMAXPAYLOAD_PCIEMAXPAYLOAD_FILECODE       (0xA0F4)
#define PROC_GNB_MODULES_GNBPCIECLKPM_PCIECLKPM_FILECODE                 (0xA0F5)

#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIETOPOLOGYSERVICESV5_FILECODE (0xA100)
#define PROC_GNB_MODULES_GNBPCIETRAININGV2_PCIETRAININGV2_FILECODE        (0xA101)
#define PROC_GNB_MODULES_GNBPCIETRAININGV2_PCIEWORKAROUNDSV2_FILECODE     (0xA102)

#define PROC_GNB_MODULES_GNBINITCZ_ALIBCZ_FILECODE                       (0xA202)
#define PROC_GNB_MODULES_GNBINITCZ_GFXENVINITCZ_FILECODE                 (0xA203)
#define PROC_GNB_MODULES_GNBINITCZ_GFXGMCINITCZ_FILECODE                 (0xA204)
#define PROC_GNB_MODULES_GNBINITCZ_GFXINTEGRATEDINFOTABLECZ_FILECODE     (0xA205)
#define PROC_GNB_MODULES_GNBINITCZ_GFXLIBCZ_FILECODE                     (0xA206)
#define PROC_GNB_MODULES_GNBINITCZ_GFXMIDINITCZ_FILECODE                 (0xA207)
#define PROC_GNB_MODULES_GNBINITCZ_GFXPOSTINITCZ_FILECODE                (0xA208)
#define PROC_GNB_MODULES_GNBINITCZ_GNBEARLYINITCZ_FILECODE               (0xA209)
#define PROC_GNB_MODULES_GNBINITCZ_GNBENVINITCZ_FILECODE                 (0xA20A)
#define PROC_GNB_MODULES_GNBINITCZ_GNBFUSETABLECZ_FILECODE               (0xA20B)
#define PROC_GNB_MODULES_GNBINITCZ_GNBIOMMUIVRSCZ_FILECODE               (0xA20C)
#define PROC_GNB_MODULES_GNBINITCZ_GNBMIDINITCZ_FILECODE                 (0xA20D)
#define PROC_GNB_MODULES_GNBINITCZ_GNBPOSTINITCZ_FILECODE                (0xA20E)
#define PROC_GNB_MODULES_GNBINITCZ_GNBREGISTERACCCZ_FILECODE             (0xA20F)
#define PROC_GNB_MODULES_GNBINITCZ_GNBURATOKENMAPCZ_FILECODE             (0xA211)
#define PROC_GNB_MODULES_GNBINITCZ_PCIECOMPLEXDATACZ_FILECODE            (0xA212)
#define PROC_GNB_MODULES_GNBINITCZ_PCIECONFIGCZ_FILECODE                 (0xA213)
#define PROC_GNB_MODULES_GNBINITCZ_PCIEEARLYINITCZ_FILECODE              (0xA214)
#define PROC_GNB_MODULES_GNBINITCZ_PCIEENVINITCZ_FILECODE                (0xA215)
#define PROC_GNB_MODULES_GNBINITCZ_PCIELIBCZ_FILECODE                    (0xA216)
#define PROC_GNB_MODULES_GNBINITCZ_PCIEMIDINITCZ_FILECODE                (0xA217)
#define PROC_GNB_MODULES_GNBINITCZ_PCIEPOSTINITCZ_FILECODE               (0xA218)
#define PROC_GNB_MODULES_GNBINITCZ_PCIEPOWERGATECZ_FILECODE              (0xA219)
#define PROC_GNB_MODULES_GNBINITCZ_GNBURACZ_FILECODE                     (0xA21A)
#define PROC_GNB_MODULES_GNBSMULIBV8_GNBSMUINITLIBV8_FILECODE            (0xA21B)
#define PROC_GNB_MODULES_GNBINITCZ_PCIEARIINITCZ_FILECODE                (0xA21C)
#define PROC_GNB_MODULES_GNBINITCZ_GNBBOOTTIMECALCZ_FILECODE             (0xA21D)
#define PROC_GNB_MODULES_GNBINITCZ_GNBPSPCZ_FILECODE                     (0xA21E)
#define PROC_GNB_MODULES_GNBINITCZ_GNBSMUINITCZ_FILECODE                 (0xA21F)

#define PROC_RECOVERY_GNB_GNBRECOVERY_FILECODE                           (0xAE01)
#define PROC_RECOVERY_GNB_NBINITRECOVERY_FILECODE                        (0xAE02)
#define PROC_GNB_GNBINITATRTB_FILECODE                                   (0xAE03)
#define PROC_GNB_MODULES_GNBSVIEW_GNBSVIEW_FILECODE                      (0xAE04)

#define PROC_GNB_MODULES_GNBIOMMUSCRATCH_GNBIOMMUSCRATCH_FILECODE        (0xAE18)

#define PROC_GNB_MODULES_GNBPCIEALIBV2_PCIEALIBV2_FILECODE               (0xAE33)
#define PROC_GNB_MODULES_GNBURALIBV1_GNBURALIBV1_FILECODE                (0xAE3A)
#define PROC_GNB_MODULES_GNBGFXINTTABLEV5_GFXLIBV5_FILECODE              (0xAE41)
#define PROC_GNB_MODULES_GNBGFXINTTABLEV5_GFXINTEGRATEDINFOTABLEV5_FILECODE (0xAE42)
#define PROC_GNB_MODULES_GNBGFXINTTABLEV5_GFXPWRPLAYTABLEV5_FILECODE     (0xAE43)
#define PROC_GNB_MODULES_GNBAZALIALIB_GNBAZALIALIB_FILECODE              (0xAE44)

// FCH
#define PROC_FCH_COMMON_ACPILIB_FILECODE                                 (0xB010)
#define PROC_FCH_COMMON_FCHLIB_FILECODE                                  (0xB011)
#define PROC_FCH_COMMON_FCHCOMMON_FILECODE                               (0xB012)
#define PROC_FCH_COMMON_FCHCOMMONSMM_FILECODE                            (0xB013)
#define PROC_FCH_COMMON_MEMLIB_FILECODE                                  (0xB014)
#define PROC_FCH_COMMON_PCILIB_FILECODE                                  (0xB015)
#define PROC_FCH_COMMON_FCHPELIB_FILECODE                                (0xB016)

#define UEFI_SMM_MEMSMMLIB_MEMSMMLIB_FILECODE                             (0xB2C1)
#define UEFI_SMM_MEMSMMLIB_CZ_DRAMMAPCZ_FILECODE                          (0xB2C3)
#define PROC_FCH_KERN_KERNAZALIA_KERNAZALIARESET_FILECODE                           (0xB400)
#define PROC_FCH_KERN_KERNAZALIA_KERNAZALIAENV_FILECODE                             (0xB401)
#define PROC_FCH_KERN_KERNAZALIA_KERNAZALIAMID_FILECODE                             (0xB402)
#define PROC_FCH_KERN_KERNAZALIA_KERNAZALIALATE_FILECODE                            (0xB403)
#define PROC_FCH_KERN_KERNHWACPI_KERNHWACPIRESET_FILECODE                           (0xB410)
#define PROC_FCH_KERN_KERNHWACPI_KERNHWACPIENV_FILECODE                             (0xB411)
#define PROC_FCH_KERN_KERNHWACPI_KERNHWACPIMID_FILECODE                             (0xB412)
#define PROC_FCH_KERN_KERNHWACPI_KERNHWACPILATE_FILECODE                            (0xB413)
#define PROC_FCH_KERN_KERNHWACPI_KERNSSSERVICE_FILECODE                             (0xB414)
#define PROC_FCH_KERN_KERNHWACPI_KERNHWACPIENVSERVICE_FILECODE                      (0xB415)
#define PROC_FCH_KERN_KERNHWACPI_KERNHWACPIMIDSERVICE_FILECODE                      (0xB416)
#define PROC_FCH_KERN_KERNHWACPI_KERNHWACPILATESERVICE_FILECODE                     (0xB417)
#define PROC_FCH_KERN_KERNHWM_KERNHWMRESET_FILECODE                                 (0xB420)
#define PROC_FCH_KERN_KERNHWM_KERNHWMENV_FILECODE                                   (0xB421)
#define PROC_FCH_KERN_KERNHWM_KERNHWMMID_FILECODE                                   (0xB422)
#define PROC_FCH_KERN_KERNHWM_KERNHWMLATE_FILECODE                                  (0xB423)
#define PROC_FCH_KERN_KERNHWM_KERNHWMENVSERVICE_FILECODE                            (0xB424)
#define PROC_FCH_KERN_KERNHWM_KERNHWMMIDSERVICE_FILECODE                            (0xB425)
#define PROC_FCH_KERN_KERNHWM_KERNHWMLATESERVICE_FILECODE                           (0xB426)
#define PROC_FCH_KERN_KERNINTERFACE_KERNFCHINITRESET_FILECODE                       (0xB427)
#define PROC_FCH_KERN_KERNINTERFACE_KERNFCHINITENV_FILECODE                         (0xB428)
#define PROC_FCH_KERN_KERNINTERFACE_KERNFCHINITMID_FILECODE                         (0xB429)
#define PROC_FCH_KERN_KERNINTERFACE_KERNFCHINITLATE_FILECODE                        (0xB42A)
#define PROC_FCH_KERN_KERNINTERFACE_KERNFCHINITS3_FILECODE                          (0xB42B)
#define PROC_FCH_KERN_KERNINTERFACE_KERNINITRESETDEF_FILECODE                       (0xB42C)
#define PROC_FCH_KERN_KERNINTERFACE_KERNINITENVDEF_FILECODE                         (0xB42D)
#define PROC_FCH_KERN_KERNINTERFACE_KERNFCHTASKLAUNCHER_FILECODE                    (0xB42E)
#define PROC_FCH_KERN_KERNIMC_KERNIMCRESET_FILECODE                                 (0xB430)
#define PROC_FCH_KERN_KERNIMC_KERNIMCENV_FILECODE                                   (0xB431)
#define PROC_FCH_KERN_KERNIMC_KERNIMCMID_FILECODE                                   (0xB432)
#define PROC_FCH_KERN_KERNIMC_KERNIMCLATE_FILECODE                                  (0xB433)
#define PROC_FCH_KERN_KERNIMC_KERNFCHECRESET_FILECODE                               (0xB434)
#define PROC_FCH_KERN_KERNIMC_KERNFCHECENV_FILECODE                                 (0xB435)
#define PROC_FCH_KERN_KERNIMC_KERNFCHECMID_FILECODE                                 (0xB436)
#define PROC_FCH_KERN_KERNIMC_KERNFCHECLATE_FILECODE                                (0xB437)
#define PROC_FCH_KERN_KERNIMC_KERNIMCLIB_FILECODE                                   (0xB438)
#define PROC_FCH_KERN_KERNIMC_KERNIMCSERVICE_FILECODE                               (0xB439)
#define PROC_FCH_KERN_KERNIR_KERNIRENV_FILECODE                                     (0xB43A)
#define PROC_FCH_KERN_KERNIR_KERNIRMID_FILECODE                                     (0xB43B)
#define PROC_FCH_KERN_KERNIR_KERNIRLATE_FILECODE                                    (0xB43C)
#define PROC_FCH_KERN_KERNPCIE_KERNABRESET_FILECODE                                 (0xB440)
#define PROC_FCH_KERN_KERNPCIE_KERNABENV_FILECODE                                   (0xB441)
#define PROC_FCH_KERN_KERNPCIE_KERNABMID_FILECODE                                   (0xB442)
#define PROC_FCH_KERN_KERNPCIE_KERNABLATE_FILECODE                                  (0xB443)
#define PROC_FCH_KERN_KERNPCIE_KERNABENVSERVICE_FILECODE                            (0xB44C)
#define PROC_FCH_KERN_KERNPCIE_KERNABRESETSERVICE_FILECODE                          (0xB44D)
#define PROC_FCH_KERN_KERNPCIE_KERNABSERVICE_FILECODE                               (0xB44E)
#define PROC_FCH_KERN_KERNSATA_KERNSATARESET_FILECODE                               (0xB460)
#define PROC_FCH_KERN_KERNSATA_KERNSATAENV_FILECODE                                 (0xB461)
#define PROC_FCH_KERN_KERNSATA_KERNSATAMID_FILECODE                                 (0xB462)
#define PROC_FCH_KERN_KERNSATA_KERNSATALATE_FILECODE                                (0xB463)
#define PROC_FCH_KERN_KERNSATA_KERNSATARESETSERVICE_FILECODE                        (0xB464)
#define PROC_FCH_KERN_KERNSATA_KERNSATAENVSERVICE_FILECODE                          (0xB465)
#define PROC_FCH_KERN_KERNSATA_KERNSATASERVICE_FILECODE                             (0xB466)
#define PROC_FCH_KERN_KERNSATA_KERNSATALIB_FILECODE                                 (0xB467)
#define PROC_FCH_KERN_KERNSATA_KERNSATAENVLIB_FILECODE                              (0xB468)
#define PROC_FCH_KERN_KERNSATA_KERNAHCILIB_FILECODE                                 (0xB469)
#define PROC_FCH_KERN_KERNSATA_KERNAHCIENV_FILECODE                                 (0xB46A)
#define PROC_FCH_KERN_KERNSATA_KERNAHCIMID_FILECODE                                 (0xB46B)
#define PROC_FCH_KERN_KERNSATA_KERNAHCILATE_FILECODE                                (0xB46C)
#define PROC_FCH_KERN_KERNSATA_KERNRAIDLIB_FILECODE                                 (0xB46D)
#define PROC_FCH_KERN_KERNSATA_KERNRAIDENV_FILECODE                                 (0xB46E)
#define PROC_FCH_KERN_KERNSATA_KERNRAIDMID_FILECODE                                 (0xB46F)
#define PROC_FCH_KERN_KERNSATA_KERNRAIDLATE_FILECODE                                (0xB470)
#define PROC_FCH_KERN_KERNSATA_KERNIDE2AHCILIB_FILECODE                             (0xB471)
#define PROC_FCH_KERN_KERNSATA_KERNIDE2AHCIENV_FILECODE                             (0xB472)
#define PROC_FCH_KERN_KERNSATA_KERNIDE2AHCIMID_FILECODE                             (0xB473)
#define PROC_FCH_KERN_KERNSATA_KERNIDE2AHCILATE_FILECODE                            (0xB474)
#define PROC_FCH_KERN_KERNSATA_KERNSATAIDELIB_FILECODE                              (0xB475)
#define PROC_FCH_KERN_KERNSATA_KERNSATAIDEENV_FILECODE                              (0xB476)
#define PROC_FCH_KERN_KERNSATA_KERNSATAIDEMID_FILECODE                              (0xB477)
#define PROC_FCH_KERN_KERNSATA_KERNSATAIDELATE_FILECODE                             (0xB478)
#define PROC_FCH_KERN_KERNSD_KERNSDENV_FILECODE                                     (0xB481)
#define PROC_FCH_KERN_KERNSD_KERNSDMID_FILECODE                                     (0xB482)
#define PROC_FCH_KERN_KERNSD_KERNSDLATE_FILECODE                                    (0xB483)
#define PROC_FCH_KERN_KERNSD_KERNSDRESETSERVICE_FILECODE                            (0xB484)
#define PROC_FCH_KERN_KERNSD_KERNSDENVSERVICE_FILECODE                              (0xB485)
#define PROC_FCH_KERN_KERNSD_KERNSDSERVICE_FILECODE                                 (0xB486)
#define PROC_FCH_KERN_KERNSPI_KERNSPIRESET_FILECODE                                 (0xB490)
#define PROC_FCH_KERN_KERNSPI_KERNSPIENV_FILECODE                                   (0xB491)
#define PROC_FCH_KERN_KERNSPI_KERNSPIMID_FILECODE                                   (0xB492)
#define PROC_FCH_KERN_KERNSPI_KERNSPILATE_FILECODE                                  (0xB493)
#define PROC_FCH_KERN_KERNSPI_KERNLPCRESET_FILECODE                                 (0xB494)
#define PROC_FCH_KERN_KERNSPI_KERNLPCENV_FILECODE                                   (0xB495)
#define PROC_FCH_KERN_KERNSPI_KERNLPCMID_FILECODE                                   (0xB496)
#define PROC_FCH_KERN_KERNSPI_KERNLPCLATE_FILECODE                                  (0xB497)
#define PROC_FCH_KERN_KERNSPI_KERNLPCRESETSERVICE_FILECODE                          (0xB498)
#define PROC_FCH_KERN_KERNSPI_KERNLPCENVSERVICE_FILECODE                            (0xB499)
#define PROC_FCH_KERN_KERNUSB_KERNUSBRESET_FILECODE                                 (0xB4A0)
#define PROC_FCH_KERN_KERNUSB_KERNUSBENV_FILECODE                                   (0xB4A1)
#define PROC_FCH_KERN_KERNUSB_KERNUSBMID_FILECODE                                   (0xB4A2)
#define PROC_FCH_KERN_KERNUSB_KERNUSBLATE_FILECODE                                  (0xB4A3)
#define PROC_FCH_KERN_KERNUSB_KERNEHCIRESET_FILECODE                                (0xB4A4)
#define PROC_FCH_KERN_KERNUSB_KERNEHCIENV_FILECODE                                  (0xB4A5)
#define PROC_FCH_KERN_KERNUSB_KERNEHCIMID_FILECODE                                  (0xB4A6)
#define PROC_FCH_KERN_KERNUSB_KERNEHCILATE_FILECODE                                 (0xB4A7)
#define PROC_FCH_KERN_KERNUSB_KERNEHCIMIDSERVICE_FILECODE                           (0xB4A8)
#define PROC_FCH_KERN_KERNUSB_KERNEHCIENVSERVICE_FILECODE                           (0xB4A9)
#define PROC_FCH_KERN_KERNUSB_KERNEHCILATESERVICE_FILECODE                          (0xB4AA)
#define PROC_FCH_KERN_KERNUSB_KERNXHCIRESET_FILECODE                                (0xB4B2)
#define PROC_FCH_KERN_KERNUSB_KERNXHCIENV_FILECODE                                  (0xB4B3)
#define PROC_FCH_KERN_KERNUSB_KERNXHCIMID_FILECODE                                  (0xB4B4)
#define PROC_FCH_KERN_KERNUSB_KERNXHCILATE_FILECODE                                 (0xB4B5)
#define PROC_FCH_KERN_KERNUSB_KERNXHCIRESETSERVICE_FILECODE                         (0xB4B6)
#define PROC_FCH_KERN_KERNUSB_KERNXHCIENVSERVICE_FILECODE                           (0xB4B7)
#define PROC_FCH_KERN_KERNUSB_KERNXHCIMIDSERVICE_FILECODE                           (0xB4B8)
#define PROC_FCH_KERN_KERNUSB_KERNXHCILATESERVICE_FILECODE                          (0xB4B9)
#define PROC_FCH_KERN_KERNUSB_KERNXHCIRECOVERY_FILECODE                             (0xB4BA)
#define UEFI_FCH_KERN_DXE_FCHACPICS_FCHACPICS_FILECODE                                  (0xB408)
#define UEFI_FCH_KERN_DXE_FCHACPICS_FCHACPICSAML_FILECODE                               (0xB409)
#define UEFI_FCH_KERN_DXE_FCHACPICS_FCHACPICSCONTROL_FILECODE                           (0xB40A)
#define UEFI_FCH_KERN_DXE_FCHACPICS_FUNCTIONS_FCHD3COLD_FCHD3COLD_FILECODE              (0xB40B)
#define UEFI_FCH_KERN_DXE_AMDFCHHWM_AMDFCHHWM_FILECODE                                  (0xB4C1)
#define UEFI_FCH_KERN_DXE_AMDFCHWHEA_AMDFCHWHEA_FILECODE                                (0xB4C2)
#define UEFI_FCH_KERN_DXE_AMDFCHWHEA_AMDFCHWHEAEINJ_FILECODE                            (0xB4C3)
#define UEFI_FCH_KERN_DXE_AMDFCHWHEA_AMDFCHWHEAHEST_FILECODE                            (0xB4C4)
#define UEFI_FCH_KERN_DXE_CF9RESET_CF9RESET_FILECODE                                    (0xB4C5)
#define UEFI_FCH_KERN_DXE_CF9RESET_IA32_IA32CF9RESET_FILECODE                           (0xB4C6)
#define UEFI_FCH_KERN_DXE_CF9RESET_X64_X64CF9RESET_FILECODE                             (0xB4C7)
#define UEFI_FCH_KERN_DXE_FCHDXE_FCHDXE_FILECODE                                        (0xB4C8)
#define UEFI_FCH_KERN_DXE_FCHDXE_USBOC_FILECODE                                         (0xB4C9)
#define UEFI_FCH_KERN_DXE_FCHDXEAUX_DXEBOOTTIMER_FILECODE                               (0xB4CA)
#define UEFI_FCH_KERN_DXE_FCHDXEAUX_DXEDISUSBPORT_FILECODE                              (0xB4CB)
#define UEFI_FCH_KERN_DXE_FCHDXEAUX_DXEESATAPORT_FILECODE                               (0xB4CC)
#define UEFI_FCH_KERN_DXE_FCHDXEAUX_DXEGPIO_FILECODE                                    (0xB4CD)
#define UEFI_FCH_KERN_DXE_FCHDXEAUX_DXEGPIOREAD_FILECODE                                (0xB4CE)
#define UEFI_FCH_KERN_DXE_FCHDXEAUX_FCHDXEAUX_FILECODE                                  (0xB4CF)
#define UEFI_FCH_KERN_DXE_FCHDXELIB_FCHDXELIB_FILECODE                                  (0xB4D0)
#define UEFI_FCH_KERN_DXE_FCHDXELPCCLKRUN_FCHDXELPCCLKRUN_FILECODE                      (0xB4D1)
#define UEFI_FCH_KERN_DXE_FCHDXEMMIO_FCHDXEMMIO_FILECODE                                (0xB4D2)
#define UEFI_FCH_KERN_DXE_LEGACYINTERRUPT_LEGACYINTERRUPT_FILECODE                      (0xB4D3)
#define UEFI_FCH_KERN_DXE_SMBUS_SMBUSLIGHT_FILECODE                                     (0xB4D4)
#define UEFI_FCH_KERN_DXE_SMMCONTROL_SMMCONTROL_FILECODE                                (0xB4D5)
#define UEFI_FCH_KERN_PEI_FCHPEI_FCHEHCIRECOVERY_FILECODE                               (0xB4D6)
#define UEFI_FCH_KERN_PEI_FCHPEI_FCHPEI_FILECODE                                        (0xB4D8)
#define UEFI_FCH_KERN_PEI_FCHPEI_FCHRESET_FILECODE                                      (0xB4D9)
#define UEFI_FCH_KERN_PEI_FCHPEI_FCHSATARECOVERY_FILECODE                               (0xB4DA)
#define UEFI_FCH_KERN_PEI_FCHPEI_FCHSTALL_FILECODE                                      (0xB4DB)
#define UEFI_FCH_KERN_PEI_FCHPEI_FCHXHCIRECOVERY_FILECODE                               (0xB4DC)
#define UEFI_FCH_KERN_PEI_FCHPEIAUX_FCHPEIAUX_FILECODE                                  (0xB4DD)
#define UEFI_FCH_KERN_PEI_FCHPEIAUX_PEIBOOTTIMER_FILECODE                               (0xB4DE)
#define UEFI_FCH_KERN_PEI_FCHPEIAUX_PEIDISUSBPORT_FILECODE                              (0xB4DF)
#define UEFI_FCH_KERN_PEI_FCHPEIAUX_PEIGPIO_FILECODE                                    (0xB4E0)
#define UEFI_FCH_KERN_PEI_FCHPEIAUX_PEIGPIOREAD_FILECODE                                (0xB4E1)
#define UEFI_FCH_KERN_PEI_FCHPEIAUX_PEIOSCOUTCLOCK_FILECODE                             (0xB4E2)
#define UEFI_FCH_KERN_PEI_FCHPEILIB_FCHPEILIB_FILECODE                                  (0xB4E3)
#define UEFI_FCH_KERN_PEI_FCHPEILIB_LIBAMDPEI_FILECODE                                  (0xB4E4)
#define UEFI_FCH_KERN_PEI_SMBUS_SMBUS_FILECODE                                          (0xB4E5)
#define UEFI_FCH_KERN_SMM_FCHSMM_FCHSMM_FILECODE                                        (0xB4E6)
#define UEFI_FCH_KERN_SMM_FCHSMM_GPESMI_FILECODE                                        (0xB4E7)
#define UEFI_FCH_KERN_SMM_FCHSMM_IOTRAPSMI_FILECODE                                     (0xB4E8)
#define UEFI_FCH_KERN_SMM_FCHSMM_MISCSMI_FILECODE                                       (0xB4E9)
#define UEFI_FCH_KERN_SMM_FCHSMM_PERIODICTIMERSMI_FILECODE                              (0xB4EA)
#define UEFI_FCH_KERN_SMM_FCHSMM_POWERBUTTONSMI_FILECODE                                (0xB4EB)
#define UEFI_FCH_KERN_SMM_FCHSMM_SWSMI_FILECODE                                         (0xB4EC)
#define UEFI_FCH_KERN_SMM_FCHSMM_SXSMI_FILECODE                                         (0xB4ED)
#define UEFI_FCH_KERN_SMM_FCHSMMCOMPLEMENT_IMCCONTROL_IMCCONTROL_FILECODE                                  (0xB4F0)
#define UEFI_FCH_KERN_SMM_FCHSMMCOMPLEMENT_IMCCONTROL_IMCCONTROLLIB_FILECODE                               (0xB4F1)
#define UEFI_FCH_KERN_SMM_FCHSMMLIB_FCHDXECOMMON_FILECODE                                                  (0xB4F5)
#define UEFI_FCH_KERN_SMM_FCHSMMLIB_FCHSMMLIB_FILECODE                                                     (0xB4F6)
#define UEFI_FCH_KERN_SMM_FCHSMMDISPATCHER_FCHSMMDISPATCHER_FILECODE                                       (0xB4F7)
#define UEFI_FCH_KERN_SMM_FCHSMMDISPATCHER_FCHSMMGPEDISPATCHER_FCHSMMGPEDISPATCHER_FILECODE                (0xB4F8)
#define UEFI_FCH_KERN_SMM_FCHSMMDISPATCHER_FCHSMMIOTRAPDISPATCHER_FCHSMMIOTRAPDISPATCHER_FILECODE          (0xB4F9)
#define UEFI_FCH_KERN_SMM_FCHSMMDISPATCHER_FCHSMMMISCDISPATCHER_FCHSMMMISCDISPATCHER_FILECODE              (0xB4FA)
#define UEFI_FCH_KERN_SMM_FCHSMMDISPATCHER_FCHSMMPERIODICALDISPATCHER_FCHSMMPERIODICALDISPATCHER_FILECODE  (0xB4FB)
#define UEFI_FCH_KERN_SMM_FCHSMMDISPATCHER_FCHSMMPWRBTNDISPATCHER_FCHSMMPWRBTNDISPATCHER_FILECODE          (0xB4FC)
#define UEFI_FCH_KERN_SMM_FCHSMMDISPATCHER_FCHSMMSWDISPATCHER_FCHSMMSWDISPATCHER_FILECODE                  (0xB4FE)
#define UEFI_FCH_KERN_SMM_FCHSMMDISPATCHER_FCHSMMSXDISPATCHER_FCHSMMSXDISPATCHER_FILECODE                  (0xB4FF)
#define UEFI_FCH_KERN_SMM_FCHSMMDISPATCHER_FCHSMMUSBDISPATCHER_FCHSMMUSBDISPATCHER_FILECODE                (0xB4F2)


#define LIB_AMDLIB_FILECODE                                              (0xC001)
#define LEGACY_PROC_AGESACALLOUTS_FILECODE                               (0xC010)
#define LEGACY_PROC_HOBTRANSFER_FILECODE                                 (0xC011)
#define LEGACY_PROC_DISPATCHER_FILECODE                                  (0xC012)

#define UEFI_DXE_AMDAGESADXEDRIVER_AMDAGESADXEDRIVER_FILECODE            (0xC120)

#define UEFI_PEI_AMDINITPOSTPEIM_AMDINITPOSTPEIM_FILECODE                (0xC140)
#define UEFI_PEI_AMDPROCESSORINITPEIM_AMDPROCESSORINITPEIM_FILECODE      (0xC141)
#define UEFI_PEI_AMDRESETMANAGER_AMDRESETMANAGER_FILECODE                (0xC142)
#define UEFI_PROC_COMMON_HOBTRANSFERUEFI_FILECODE                        (0xC160)
#define UEFI_PROC_DXE_HOBTRANSFERUEFIDXE_FILECODE                        (0xC161)
#define UEFI_PROC_PEI_HOBTRANSFERUEFIPEI_FILECODE                        (0xC162)

#define PROC_COMMON_AMDINITEARLY_FILECODE                                (0xC020)
#define PROC_COMMON_AMDINITENV_FILECODE                                  (0xC021)
#define PROC_COMMON_AMDINITLATE_FILECODE                                 (0xC022)
#define PROC_COMMON_AMDINITMID_FILECODE                                  (0xC023)
#define PROC_COMMON_AMDINITPOST_FILECODE                                 (0xC024)
#define PROC_COMMON_AMDINITRECOVERY_FILECODE                             (0xC025)
#define PROC_COMMON_AMDINITRESET_FILECODE                                (0xC026)
#define PROC_COMMON_AMDINITRESUME_FILECODE                               (0xC027)
#define PROC_COMMON_AMDS3LATERESTORE_FILECODE                            (0xC028)
#define PROC_COMMON_AMDINITRTB_FILECODE                                  (0xC029)
#define PROC_COMMON_AMDLATERUNAPTASK_FILECODE                            (0xC02A)
#define PROC_COMMON_AMDS3FINALRESTORE_FILECODE                           (0xC02B)

#define PROC_COMMON_COMMONRETURNS_FILECODE                               (0xC0C0)
#define PROC_COMMON_CREATESTRUCT_FILECODE                                (0xC0D0)
#define PROC_COMMON_COMMONINITS_FILECODE                                 (0xC0F0)
#define PROC_COMMON_S3RESTORESTATE_FILECODE                              (0xC0F8)
#define PROC_COMMON_S3SAVESTATE_FILECODE                                 (0xC0F9)
#define PROC_COMMON_S3INIT_FILECODE                                      (0xC0FA)

#define PROC_CPU_CPUAPCOMM_FILECODE                                      (0xC401)
#define PROC_CPU_CPUAPCOMMAPIC_FILECODE                                  (0xC402)
#define PROC_CPU_CPUAPCOMMPCI_FILECODE                                   (0xC403)
#define PROC_CPU_TABLE_FILECODE                                          (0xC404)
#define PROC_CPU_CPUEARLYINIT_FILECODE                                   (0xC405)
#define PROC_CPU_CPUEVENTLOG_FILECODE                                    (0xC406)
#define PROC_CPU_CPUFAMILYTRANSLATION_FILECODE                           (0xC407)
#define PROC_CPU_CPUGENERALSERVICES_FILECODE                             (0xC408)
#define PROC_CPU_CPULATEINIT_FILECODE                                    (0xC40A)
#define PROC_CPU_CPUMICROCODEPATCH_FILECODE                              (0xC40B)
#define PROC_CPU_CPUWARMRESET_FILECODE                                   (0xC40C)
#define PROC_CPU_HEAPMANAGER_FILECODE                                    (0xC40D)
#define PROC_CPU_CPUBIST_FILECODE                                        (0xC40E)
#define PROC_CPU_MMIOMAPMANAGER_FILECODE                                 (0xC40F)
#define PROC_CPU_CPUINITEARLYTABLE_FILECODE                              (0xC410)
#define PROC_CPU_CPURESETINIT_FILECODE                                   (0xC411)
#define PROC_CPU_CPUPOSTINIT_FILECODE                                    (0xC420)
#define PROC_CPU_CPUMIDINIT_FILECODE                                     (0xC421)
#define PROC_CPU_CPUPOWERMGMT_FILECODE                                   (0xC430)
#define PROC_CPU_S3_FILECODE                                             (0xC460)

// Family 15h
#define PROC_CPU_FAMILY_0X15_CPUCOMMONF15UTILITIES_FILECODE              (0xCB01)
#define PROC_CPU_FAMILY_0X15_CPUF15BRANDID_FILECODE                      (0xCB02)
#define PROC_CPU_FAMILY_0X15_CPUF15CACHEDEFAULTS_FILECODE                (0xCB03)
#define PROC_CPU_FAMILY_0X15_CPUF15DMI_FILECODE                          (0xCB04)
#define PROC_CPU_FAMILY_0X15_CPUF15UTILITIES_FILECODE                    (0xCB08)
#define PROC_CPU_FAMILY_0X15_CPUF15WHEAINITDATATABLES_FILECODE           (0xCB09)
#define PROC_CPU_FAMILY_0X15_CPUF15APM_FILECODE                          (0xCB0A)
#define PROC_CPU_FAMILY_0X15_CPUF15CRAT_FILECODE                         (0xCB0B)
#define PROC_CPU_FAMILY_0X15_CPUF15MMIOMAP_FILECODE                      (0xCB0C)
#define PROC_CPU_FAMILY_0X15_CPUF15PREFETCHMODE_FILECODE                 (0xCB0D)

#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZCOREAFTERRESET_FILECODE          (0xCB70)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZDMI_FILECODE                     (0xCB71)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZNBAFTERRESET_FILECODE            (0xCB72)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZPSTATE_FILECODE                  (0xCB73)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZLOGICALIDTABLES_FILECODE         (0xCB74)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZMICROCODEPATCHTABLES_FILECODE    (0xCB75)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZALLCORETABLES_FILECODE           (0xCB76)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZCOMPUTEUNITTABLES_FILECODE       (0xCB77)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZEQUIVALENCETABLE_FILECODE        (0xCB78)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZPRIMARYCORETABLES_FILECODE       (0xCB79)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZPOWERMGMTSYSTEMTABLES_FILECODE   (0xCB7A)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZUTILITIES_FILECODE               (0xCB7C)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZC6STATE_FILECODE                 (0xCB7D)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZCPB_FILECODE                     (0xCB7E)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZIOCSTATE_FILECODE                (0xCB7F)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZCACHEFLUSHONHALT_FILECODE        (0xCB80)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZHTC_FILECODE                     (0xCB81)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZINITEARLYTABLE_FILECODE          (0xCB82)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZEARLYSAMPLES_FILECODE            (0xCB83)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZPSI_FILECODE                     (0xCB85)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZWORKAROUNDTABLE_FILECODE         (0xCB87)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZCC6EXITCONTROL_FILECODE          (0xCB88)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZCONNECTEDSTANDBY_FILECODE        (0xCB89)
#define PROC_CPU_FAMILY_0X15_CZ_CPUF15CZBTC_FILECODE                     (0xCB8A)

#define PROC_CPU_FEATURE_CPUCACHEFLUSHONHALT_FILECODE                    (0xDC01)
#define PROC_CPU_FEATURE_CPUCACHEINIT_FILECODE                           (0xDC02)
#define PROC_CPU_FEATURE_CPUDMI_FILECODE                                 (0xDC10)
#define PROC_CPU_FEATURE_CPUPSTATETABLES_FILECODE                        (0xDC43)
#define PROC_CPU_FEATURE_CPUWHEA_FILECODE                                (0xDC70)
#define PROC_CPU_FEATURE_CPUC6STATE_FILECODE                             (0xDC82)
#define PROC_CPU_FEATURE_CPUCPB_FILECODE                                 (0xDC83)
#define PROC_CPU_FEATURE_CPUIOCSTATE_FILECODE                            (0xDC85)
#define PROC_CPU_FEATURE_CPUAPM_FILECODE                                 (0xDC86)
#define PROC_CPU_FEATURE_CPUFEATURES_FILECODE                            (0xDC90)
#define PROC_CPU_FEATURE_CPUCORELEVELING_FILECODE                        (0xDCB0)
#define PROC_CPU_FEATURE_CPUPSI_FILECODE                                 (0xDCC0)
#define PROC_CPU_FEATURE_CPUHTC_FILECODE                                 (0xDCC1)
#define PROC_CPU_FEATURE_CPUCRAT_FILECODE                                (0xDCD0)
#define PROC_CPU_FEATURE_CPUCDIT_FILECODE                                (0xDCD1)
#define PROC_CPU_FEATURE_CPUPREFETCHMODE_FILECODE                        (0xDCD3)
#define PROC_CPU_FEATURE_CPUCONNECTEDSTANDBY_FILECODE                    (0xDCD5)
#define PROC_CPU_FEATURE_CPUCC6EXITCONTROL_FILECODE                      (0xDCD6)

#define PROC_RECOVERY_CPU_CPURECOVERY_FILECODE                           (0xDE01)

#define PROC_TOPOLOGY_TOPOMAIN_FILECODE                                  (0xE001)
#define PROC_TOPOLOGY_TOPONB_FILECODE                                    (0xE002)
#define PROC_TOPOLOGY_FAM15_TOPONBFAM15_FILECODE                         (0xE087)
#define PROC_TOPOLOGY_FAM15_TOPONBUTILITIESFAM15_FILECODE                (0xE088)

#define PROC_RECOVERY_TOPOLOGY_TOPOINITRECOVERY_FILECODE                 (0xE0FF)

#define PROC_IDS_CONTROL_IDSCTRL_FILECODE                                (0xE801)
#define PROC_IDS_LIBRARY_IDSLIB_FILECODE                                 (0xE802)
#define PROC_IDS_DEBUG_IDSDEBUG_FILECODE                                 (0xE803)
#define PROC_IDS_PERF_IDSPERF_FILECODE                                   (0xE804)
#define PROC_IDS_FAMILY_0X15_IDSF15ALLSERVICE_FILECODE                   (0xE80C)

#define PROC_IDS_LIBRARY_IDSREGACC_FILECODE                              (0xE810)
#define PROC_IDS_DEBUG_IDSDPHDTOUT_FILECODE                              (0xE811)
#define PROC_IDS_DEBUG_IDSDEBUGPRINT_FILECODE                            (0xE812)
#define PROC_IDS_DEBUG_IDSDPSERIAL_FILECODE                              (0xE813)
#define PROC_IDS_DEBUG_IDSDPREDIRECTIO_FILECODE                          (0xE814)
#define PROC_IDS_DEBUG_IDSDPRAM_FILECODE                                 (0xE815)

#define PROC_IDS_DEBUG_IDSIDTTABLE_FILECODE                              (0xE81E)
#define PROC_IDS_CONTROL_IDSNVTOCMOS_FILECODE                            (0xE81F)
#define PROC_IDS_FAMILY_0X15_CZ_IDSF15CZALLSERVICE_FILECODE              (0xE821)


///0xE820 ~ 0xE840 is reserved for ids extend module

#define PROC_MEM_ARDK_MA_FILECODE                                    (0xF001)

#define PROC_MEM_FEAT_CHINTLV_MFCHI_FILECODE                         (0xF081)
#define PROC_MEM_FEAT_CSINTLV_MFCSI_FILECODE                         (0xF082)
#define PROC_MEM_FEAT_ECC_MFECC_FILECODE                             (0xF083)
#define PROC_MEM_FEAT_ECC_MFEMP_FILECODE                             (0xF085)
#define PROC_MEM_FEAT_EXCLUDIMM_MFDIMMEXCLUD_FILECODE                (0xF086)
#define PROC_MEM_FEAT_IDENDIMM_MFIDENDIMM_FILECODE                   (0xF088)
#define PROC_MEM_FEAT_INTLVRN_MFINTLVRN_FILECODE                     (0xF089)
#define PROC_MEM_FEAT_LVDDR3_MFLVDDR3_FILECODE                       (0xF08A)
#define PROC_MEM_FEAT_MEMCLR_MFMEMCLR_FILECODE                       (0xF08B)
#define PROC_MEM_FEAT_NDINTLV_MFNDI_FILECODE                         (0xF08C)
#define PROC_MEM_FEAT_ODTHERMAL_MFODTHERMAL_FILECODE                 (0xF08D)
#define PROC_MEM_FEAT_OLSPARE_MFSPR_FILECODE                         (0xF08E)
#define PROC_MEM_FEAT_PARTRN_MFSTANDARDTRAINING_FILECODE             (0xF091)
#define PROC_MEM_FEAT_S3_MFS3_FILECODE                               (0xF092)
#define PROC_MEM_FEAT_TABLE_MFTDS_FILECODE                           (0xF093)
#define PROC_MEM_FEAT_CHINTLV_MFMCHI_FILECODE                        (0xF094)
#define PROC_MEM_FEAT_CRAT_MFCRAT_FILECODE                           (0xF095)
#define PROC_MEM_FEAT_AMP_MFAMP_FILECODE                             (0xF096)
#define PROC_MEM_FEAT_DATAEYE_MF2DDATAEYE_FILECODE                   (0xF097)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFWRDAT2DTRAINING_FILECODE         (0xF098)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDWR2DEYERIMSEARCH_FILECODE      (0xF099)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDDQS2DTRAINING_FILECODE         (0xF09A)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDWR2DTRAINING_FILECODE          (0xF09B)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDWR2DPATTERNGENERATION_FILECODE (0xF09C)
#define PROC_MEM_FEAT_AGGRESSOR_MFAGGRESSOR_FILECODE                    (0xF09F)
#define PROC_MEM_FEAT_DLLPDBYPASS_MFDLLPDBYPASS_FILECODE                (0xF0A0)

#define PROC_MEM_MAIN_MDEF_FILECODE                                  (0xF101)
#define PROC_MEM_MAIN_MINIT_FILECODE                                 (0xF102)
#define PROC_MEM_MAIN_MM_FILECODE                                    (0xF103)
#define PROC_MEM_FEAT_DMI_MFDMI_FILECODE                             (0xF104)
#define PROC_MEM_MAIN_MMECC_FILECODE                                 (0xF105)
#define PROC_MEM_MAIN_MMEXCLUDEDIMM_FILECODE                         (0xF106)
#define PROC_MEM_MAIN_MMNODEINTERLEAVE_FILECODE                      (0xF10B)
#define PROC_MEM_MAIN_MMONLINESPARE_FILECODE                         (0xF10C)
#define PROC_MEM_MAIN_MMPARALLELTRAINING_FILECODE                    (0xF10D)
#define PROC_MEM_MAIN_MMSTANDARDTRAINING_FILECODE                    (0xF10E)
#define PROC_MEM_MAIN_MUC_FILECODE                                   (0xF10F)
#define PROC_MEM_MAIN_MMMEMCLR_FILECODE                              (0xF110)
#define PROC_MEM_MAIN_MMFLOW_FILECODE                                (0xF112)
#define PROC_MEM_MAIN_MERRHDL_FILECODE                               (0xF113)
#define PROC_MEM_MAIN_MMLVDDR3_FILECODE                              (0xF115)
#define PROC_MEM_MAIN_MMUMAALLOC_FILECODE                            (0xF116)
#define PROC_MEM_MAIN_MMMEMRESTORE_FILECODE                          (0xF117)
#define PROC_MEM_MAIN_MMCONDITIONALPSO_FILECODE                      (0xF118)
#define PROC_MEM_MAIN_MMAGGRESSOR_FILECODE                           (0xF119)
#define PROC_MEM_MAIN_CZ_MMFLOWD3CZ_FILECODE                         (0xF127)

#define PROC_MEM_NB_MN_FILECODE                                      (0XF27C)
#define PROC_MEM_NB_MNDCT_FILECODE                                   (0XF27D)
#define PROC_MEM_NB_MNPHY_FILECODE                                   (0XF27E)
#define PROC_MEM_NB_MNMCT_FILECODE                                   (0XF27F)
#define PROC_MEM_NB_MNS3_FILECODE                                    (0XF280)
#define PROC_MEM_NB_MNFLOW_FILECODE                                  (0XF281)
#define PROC_MEM_NB_MNFEAT_FILECODE                                  (0XF282)
#define PROC_MEM_NB_MNTRAIN3_FILECODE                                (0XF284)
#define PROC_MEM_NB_MNREG_FILECODE                                   (0XF285)
#define PROC_MEM_NB_MNPMU_FILECODE                                   (0xF2B7)
#define PROC_MEM_NB_CZ_MNCZ_FILECODE                                 (0xF2D8)
#define PROC_MEM_NB_CZ_MNDCTCZ_FILECODE                              (0xF2D9)
#define PROC_MEM_NB_CZ_MNIDENDIMMCZ_FILECODE                         (0xF2DA)
#define PROC_MEM_NB_CZ_MNMCTCZ_FILECODE                              (0xF2DB)
#define PROC_MEM_NB_CZ_MNPHYCZ_FILECODE                              (0xF2DC)
#define PROC_MEM_NB_CZ_MNPMUCZ_FILECODE                              (0xF2DD)
#define PROC_MEM_NB_CZ_MNPMUSRAMMSGBLOCKCZ_FILECODE                  (0xF2DE)
#define PROC_MEM_NB_CZ_MNPROTOCZ_FILECODE                            (0xF2DF)
#define PROC_MEM_NB_CZ_MNREGCZ_FILECODE                              (0xF2E0)
#define PROC_MEM_NB_CZ_MNS3CZ_FILECODE                               (0xF2E1)
#define PROC_MEM_NB_CZ_MNPSPCZ_FILECODE                              (0XF2E3)


#define PROC_MEM_PS_MP_FILECODE                                      (0XF401)
#define PROC_MEM_PS_MPRTT_FILECODE                                   (0XF422)
#define PROC_MEM_PS_MPMAXFREQ_FILECODE                               (0XF423)
#define PROC_MEM_PS_MPODTPAT_FILECODE                                (0XF424)
#define PROC_MEM_PS_MPSAO_FILECODE                                   (0XF425)
#define PROC_MEM_PS_MPMR0_FILECODE                                   (0XF426)
#define PROC_MEM_PS_MPRC2IBT_FILECODE                                (0XF427)
#define PROC_MEM_PS_MPRC10OPSPD_FILECODE                             (0XF428)
#define PROC_MEM_PS_MPLRIBT_FILECODE                                 (0XF429)
#define PROC_MEM_PS_MPLRNPR_FILECODE                                 (0XF42A)
#define PROC_MEM_PS_MPLRNLR_FILECODE                                 (0XF42B)
#define PROC_MEM_PS_MPS2D_FILECODE                                   (0XF436)
#define PROC_MEM_PS_MPSEEDS_FILECODE                                 (0XF437)
#define PROC_MEM_PS_MPCADCFG_FILECODE                                (0XF43C)
#define PROC_MEM_PS_MPDATACFG_FILECODE                               (0XF43D)
#define PROC_MEM_PS_CZ_MPCZ3_FILECODE                                (0XF445)
#define PROC_MEM_PS_CZ_MPSCZ3_FILECODE                               (0XF446)
#define PROC_MEM_PS_CZ_MPUCZ3_FILECODE                               (0XF447)
#define PROC_MEM_PS_CZ_FP4_MPSCZFP4_FILECODE                         (0XF44A)
#define PROC_MEM_PS_CZ_FP4_MPUCZFP4_FILECODE                         (0XF44B)


#define PROC_MEM_TECH_MT_FILECODE                                    (0XF501)
#define PROC_MEM_TECH_MTHDI_FILECODE                                 (0XF502)
#define PROC_MEM_TECH_MTTDIMBT_FILECODE                              (0XF504)
#define PROC_MEM_TECH_MTTECC_FILECODE                                (0XF505)
#define PROC_MEM_TECH_MTTHRC_FILECODE                                (0XF506)
#define PROC_MEM_TECH_MTTML_FILECODE                                 (0XF507)
#define PROC_MEM_TECH_MTTOPTSRC_FILECODE                             (0XF509)
#define PROC_MEM_TECH_MTTSRC_FILECODE                                (0XF50B)
#define PROC_MEM_TECH_MTTEDGEDETECT_FILECODE                         (0XF50C)
#define PROC_MEM_TECH_DDR3_MT3_FILECODE                              (0XF581)
#define PROC_MEM_TECH_DDR3_MTOT3_FILECODE                            (0XF583)
#define PROC_MEM_TECH_DDR3_MTRCI3_FILECODE                           (0XF584)
#define PROC_MEM_TECH_DDR3_MTSDI3_FILECODE                           (0XF585)
#define PROC_MEM_TECH_DDR3_MTSPD3_FILECODE                           (0XF586)
#define PROC_MEM_TECH_DDR3_MTTWL3_FILECODE                           (0XF587)
#define PROC_MEM_TECH_DDR3_MTTECC3_FILECODE                          (0XF588)
#define PROC_MEM_TECH_DDR3_MTLRDIMM3_FILECODE                        (0XF589)
#define PROC_MEM_TECH_MTTHRCSEEDTRAIN_FILECODE                       (0XF58A)
#define PROC_MEM_TECH_MTTRDDQS2DTRAINING_FILECODE                    (0XF58B)
#define PROC_MEM_TECH_MTTRDDQS2DEYERIMSEARCH_FILECODE                (0XF58C)

#define PROC_MEM_X86_MEMINITLIBX86_FILECODE                             (0xF590)
#define PROC_MEM_A57_MEMINITLIBA57_FILECODE                             (0xF591)

#define PROC_RECOVERY_MEM_MRDEF_FILECODE                             (0XF801)
#define PROC_RECOVERY_MEM_MRINIT_FILECODE                            (0XF802)
#define PROC_RECOVERY_MEM_MRM_FILECODE                               (0XF803)
#define PROC_RECOVERY_MEM_MRUC_FILECODE                              (0XF804)
#define PROC_RECOVERY_MEM_TECH_MRTTPOS_FILECODE                      (0XF8C1)
#define PROC_RECOVERY_MEM_TECH_MRTTSRC_FILECODE                      (0XF8C2)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRT3_FILECODE                    (0XF8C3)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTRCI3_FILECODE                 (0XF8C4)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTSDI3_FILECODE                 (0XF8C5)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTSPD3_FILECODE                 (0XF8C6)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTTWL3_FILECODE                 (0XF8C7)
#define PROC_RECOVERY_MEM_NB_MRN_FILECODE                            (0XF8C8)
#define PROC_RECOVERY_MEM_NB_MRNDCT_FILECODE                         (0XF8C9)
#define PROC_RECOVERY_MEM_NB_MRNMCT_FILECODE                         (0XF8CA)
#define PROC_RECOVERY_MEM_NB_MRNTRAIN3_FILECODE                      (0XF8CB)
#define PROC_RECOVERY_MEM_TECH_MRTTHRC_FILECODE                      (0XF8CC)
#define PROC_RECOVERY_MEM_PS_MRP_FILECODE                            (0XF8E0)
#define PROC_RECOVERY_MEM_PS_MRPRTT_FILECODE                         (0XF8E1)
#define PROC_RECOVERY_MEM_PS_MRPODTPAT_FILECODE                      (0XF8E2)
#define PROC_RECOVERY_MEM_PS_MRPSAO_FILECODE                         (0XF8E3)
#define PROC_RECOVERY_MEM_PS_MRPMR0_FILECODE                         (0XF8E4)
#define PROC_RECOVERY_MEM_PS_MRPRC2IBT_FILECODE                      (0XF8E5)
#define PROC_RECOVERY_MEM_PS_MRPRC10OPSPD_FILECODE                   (0XF8E6)
#define PROC_RECOVERY_MEM_PS_MRPLRIBT_FILECODE                       (0XF8E7)
#define PROC_RECOVERY_MEM_PS_MRPLRNPR_FILECODE                       (0XF8E8)
#define PROC_RECOVERY_MEM_PS_MRPLRNLR_FILECODE                       (0XF8E9)
#define PROC_RECOVERY_MEM_TECH_MRTTHRCSEEDTRAIN_FILECODE             (0XF8FA)

//Psp
#define PROC_PSP_PSPBASELIB_PSPBASELIB_FILECODE                      (0xFA20)

#endif // _FILECODE_H_
