#| -*-Scheme-*-

Copyright (C) 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994,
    1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
    2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016,
    2017, 2018, 2019, 2020 Massachusetts Institute of Technology

This file is part of MIT/GNU Scheme.

MIT/GNU Scheme is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

MIT/GNU Scheme is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with MIT/GNU Scheme; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,
USA.

|#

;;;; UCD property: gc (general-category)

;;; Generated from Unicode 9.0.0

(declare (usual-integrations))

(define (ucd-gc-value char)
  (let ((sv (char->integer char)))
    (vector-ref ucd-gc-table-5 (bytevector-u8-ref ucd-gc-table-4 (fix:or (fix:lsh (bytevector-u16be-ref ucd-gc-table-3 (fix:lsh (fix:or (fix:lsh (bytevector-u8-ref ucd-gc-table-2 (fix:or (fix:lsh (bytevector-u8-ref ucd-gc-table-1 (fix:or (fix:lsh (bytevector-u8-ref ucd-gc-table-0 (fix:lsh sv -16)) 4) (fix:and 15 (fix:lsh sv -12)))) 4) (fix:and 15 (fix:lsh sv -8)))) 4) (fix:and 15 (fix:lsh sv -4))) 1)) 4) (fix:and 15 sv))))))

(define ucd-gc-table-0
  '#u8(0 1 2 3 3 3 3 3 3 3 3 3 3 3 4 5 5))

(define ucd-gc-table-1
  '#u8(0 1 2 3 4 5 5 5 5 6 7 5 5 8 9 10 11 12 13 14 15 16 17 5 18 16 16 19 16 20 21 22 5 5 5 5 5 5 5 5 5 5 23 24 25 16 16 26 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 27 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 28))

(define ucd-gc-table-2
  '#u8(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 17 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 33 41 42 43 44 45 46 47 48 39 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 49 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 50 51 17 17 17 52 17 53 54 55 56 57 58 17 17 17 17 17 17 17 17 17 17 17 59 60 60 60 60 60 60 60 60 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 17 62 63 17 64 65 66 67 68 69 70 71 72 17 73 74 75 76 77 78 79 80 79 81 82 83 84 85 86 87 88 89 79 90 79 91 79 79 79 17 17 17 92 93 94 79 79 79 79 79 79 79 79 79 79 17 17 17 17 95 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 17 17 96 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 17 17 97 98 79 79 79 99 17 17 17 17 17 17 17 100 17 17 101 79 79 79 79 79 102 79 79 79 79 79 79 79 79 79 79 79 103 79 79 79 104 105 106 107 108 109 110 111 39 39 112 79 79 79 79 79 113 79 79 79 79 79 79 79 114 115 79 79 79 79 116 79 117 118 119 120 39 39 121 122 123 124 79 79 79 79 79 79 17 17 17 17 17 17 125 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 126 127 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 128 79 79 79 79 79 79 79 79 79 17 17 129 79 79 79 79 79 130 131 79 79 79 79 79 79 79 79 79 79 79 79 79 79 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 132))

(define ucd-gc-table-3
  '#u8(0 0 0 0 0 1 0 2 0 3 0 4 0 5 0 6 0 0 0 0 0 7 0 8 0 9 0 10 0 11 0 12 0 13 0 13 0 13 0 14 0 15 0 13 0 13 0 16 0 17 0 18 0 19 0 20 0 21 0 22 0 13 0 23 0 13 0 13 0 13 0 24 0 25 0 11 0 11 0 11 0 11 0 26 0 11 0 27 0 28 0 29 0 30 0 31 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 33 0 34 0 35 0 36 0 11 0 37 0 38 0 13 0 39 0 9 0 9 0 9 0 11 0 11 0 11 0 13 0 13 0 40 0 13 0 13 0 13 0 41 0 13 0 13 0 13 0 13 0 13 0 13 0 42 0 9 0 43 0 44 0 11 0 45 0 46 0 32 0 47 0 48 0 49 0 50 0 51 0 52 0 53 0 49 0 49 0 54 0 32 0 55 0 56 0 49 0 49 0 49 0 49 0 49 0 57 0 58 0 59 0 60 0 61 0 49 0 32 0 62 0 49 0 49 0 49 0 49 0 49 0 63 0 64 0 65 0 49 0 66 0 67 0 49 0 68 0 69 0 70 0 49 0 71 0 72 0 72 0 72 0 72 0 49 0 73 0 72 0 74 0 75 0 32 0 76 0 49 0 49 0 77 0 78 0 79 0 80 0 81 0 82 0 83 0 84 0 85 0 86 0 87 0 88 0 89 0 90 0 83 0 84 0 91 0 92 0 93 0 94 0 95 0 96 0 97 0 84 0 98 0 99 0 100 0 88 0 101 0 102 0 83 0 84 0 103 0 104 0 105 0 88 0 106 0 107 0 108 0 109 0 110 0 111 0 112 0 94 0 113 0 114 0 115 0 84 0 116 0 117 0 118 0 88 0 119 0 120 0 115 0 84 0 121 0 122 0 123 0 88 0 124 0 125 0 115 0 49 0 126 0 127 0 128 0 88 0 129 0 130 0 131 0 49 0 132 0 133 0 134 0 94 0 135 0 136 0 49 0 49 0 137 0 138 0 139 0 72 0 72 0 140 0 141 0 142 0 143 0 144 0 145 0 72 0 72 0 146 0 147 0 148 0 149 0 150 0 49 0 151 0 152 0 153 0 154 0 32 0 155 0 156 0 157 0 72 0 72 0 49 0 49 0 158 0 159 0 160 0 161 0 162 0 163 0 164 0 165 0 9 0 9 0 166 0 49 0 49 0 167 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 168 0 169 0 49 0 49 0 168 0 49 0 49 0 170 0 171 0 172 0 49 0 49 0 49 0 171 0 49 0 49 0 49 0 173 0 174 0 175 0 49 0 176 0 9 0 9 0 9 0 9 0 9 0 177 0 178 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 179 0 49 0 180 0 181 0 49 0 49 0 49 0 49 0 182 0 183 0 184 0 185 0 49 0 186 0 49 0 187 0 184 0 188 0 49 0 49 0 49 0 189 0 190 0 191 0 192 0 193 0 194 0 192 0 49 0 49 0 195 0 49 0 49 0 196 0 197 0 49 0 198 0 49 0 49 0 49 0 49 0 199 0 49 0 200 0 201 0 202 0 203 0 49 0 204 0 205 0 49 0 49 0 206 0 49 0 207 0 208 0 209 0 209 0 49 0 210 0 49 0 49 0 49 0 211 0 212 0 213 0 192 0 192 0 214 0 215 0 72 0 72 0 72 0 72 0 216 0 49 0 49 0 217 0 218 0 160 0 219 0 220 0 221 0 49 0 222 0 65 0 49 0 49 0 223 0 224 0 49 0 49 0 225 0 226 0 227 0 65 0 49 0 228 0 229 0 72 0 72 0 72 0 230 0 231 0 232 0 233 0 11 0 11 0 234 0 27 0 27 0 27 0 235 0 236 0 11 0 237 0 27 0 27 0 32 0 32 0 32 0 238 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 13 0 239 0 13 0 13 0 13 0 13 0 13 0 13 0 240 0 241 0 240 0 240 0 241 0 242 0 240 0 243 0 244 0 244 0 244 0 245 0 246 0 247 0 248 0 249 0 250 0 251 0 252 0 253 0 254 0 255 1 0 1 1 1 2 1 3 1 4 1 5 0 72 1 6 1 7 1 8 1 9 1 10 1 11 1 12 1 13 1 14 1 15 1 15 1 16 1 17 1 18 0 209 1 19 1 20 0 209 1 21 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 23 0 209 1 24 0 209 0 209 0 209 0 209 1 25 0 209 1 26 1 22 1 27 0 209 1 28 1 29 1 30 0 209 0 209 1 31 0 72 1 32 0 72 1 14 1 14 1 14 1 33 0 209 0 209 0 209 0 209 1 34 1 14 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 1 35 1 36 0 209 0 209 1 37 0 209 0 209 0 209 0 209 0 209 0 209 1 38 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 1 39 1 40 1 14 1 41 0 209 0 209 1 42 1 22 1 43 1 22 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 22 1 44 1 45 1 22 1 22 1 22 1 46 1 22 1 47 0 209 0 209 0 209 1 22 1 48 0 209 0 209 1 49 0 209 1 50 0 209 1 51 1 52 1 53 1 54 0 72 0 9 0 9 1 55 0 11 0 11 1 56 1 57 1 58 0 13 0 13 0 13 0 13 0 13 0 13 1 59 1 60 0 11 0 11 1 61 0 49 0 49 0 49 1 62 1 63 0 49 1 64 1 65 1 65 1 65 1 65 0 32 0 32 1 66 1 67 1 68 1 69 1 70 0 72 0 72 0 72 0 209 1 71 0 209 0 209 0 209 0 209 0 209 1 72 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 1 73 0 72 1 74 1 75 1 76 1 77 1 78 0 136 0 49 0 49 0 49 0 49 1 79 0 178 0 49 0 49 0 49 0 49 1 80 1 81 0 49 0 204 0 136 0 49 0 49 0 49 0 49 0 200 1 82 0 49 0 50 0 209 0 209 1 72 0 49 0 209 1 30 1 83 0 209 1 84 1 85 0 209 0 209 1 83 0 209 0 209 1 85 0 209 0 209 0 209 1 30 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 199 0 209 0 209 0 209 0 209 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 199 0 72 0 72 0 49 1 86 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 151 0 209 0 209 0 209 1 31 0 49 0 49 0 228 1 87 0 49 1 88 0 72 0 13 0 13 1 89 1 90 0 13 1 91 0 49 0 49 0 49 0 49 1 92 1 93 0 31 1 94 1 95 1 96 0 13 0 13 0 13 1 97 1 98 1 99 1 100 1 101 0 72 0 72 0 72 1 102 1 103 0 49 1 104 1 105 0 49 0 49 0 49 1 106 1 107 0 49 0 49 1 108 1 109 0 192 0 32 1 110 0 65 0 49 1 111 0 49 1 112 1 113 0 49 0 151 0 76 0 49 0 49 1 114 1 115 1 116 1 117 1 118 0 49 0 49 1 119 1 120 1 121 1 122 0 49 1 123 0 49 0 49 0 49 1 124 1 125 1 126 1 127 1 128 1 129 1 130 1 65 0 11 0 11 1 131 1 132 0 11 0 11 0 11 0 11 0 11 0 49 0 49 1 133 0 192 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 1 134 0 49 1 135 0 49 0 49 0 206 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 136 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 0 49 0 49 0 49 0 49 0 49 0 49 0 204 0 49 0 49 0 49 0 49 0 49 0 49 0 207 0 72 0 72 1 138 1 139 1 140 1 141 1 142 0 49 0 49 0 49 0 49 0 49 0 49 1 143 1 144 1 145 0 49 0 49 0 49 0 49 0 49 1 146 0 72 0 49 0 49 0 49 0 49 1 147 0 49 0 49 0 196 0 72 0 72 1 148 0 32 1 149 0 32 1 150 1 151 1 152 1 153 1 154 0 49 0 49 0 49 0 49 0 49 0 49 0 49 1 155 1 156 0 2 0 3 0 4 0 5 1 157 1 158 1 159 0 49 1 160 0 49 0 200 1 161 1 162 1 163 1 164 1 165 0 49 0 172 1 166 0 204 0 204 0 72 0 72 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 50 1 167 1 14 1 14 1 168 1 15 1 15 1 15 1 169 1 170 1 74 1 171 0 72 0 72 0 209 0 209 1 172 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 151 0 49 0 49 0 49 0 100 1 173 1 174 0 49 0 49 1 175 0 49 1 176 0 49 0 49 1 177 0 49 1 178 0 49 0 49 1 179 1 180 0 72 0 72 0 9 0 9 1 181 0 11 0 11 0 49 0 49 0 49 0 49 0 204 0 192 0 9 0 9 1 182 0 11 1 183 0 49 0 49 0 196 0 49 0 49 0 49 1 184 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 49 1 64 0 49 0 199 0 196 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 1 185 0 49 0 49 1 186 0 49 1 187 0 49 1 188 0 49 0 200 1 189 0 72 0 72 0 72 0 49 1 190 0 49 1 191 0 49 1 192 0 72 0 72 0 72 0 72 0 49 0 49 0 49 1 193 1 14 1 194 1 14 1 14 1 195 1 196 0 49 1 197 1 198 1 199 0 49 1 200 0 49 1 201 0 72 0 72 1 202 0 49 1 203 1 204 0 49 0 49 0 49 1 205 0 49 1 206 0 49 1 207 0 49 1 208 1 209 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 49 0 49 1 210 0 72 0 72 0 72 0 9 0 9 0 9 1 211 0 11 0 11 0 11 1 212 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 1 14 1 213 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 1 214 0 49 0 49 1 215 1 216 1 194 1 217 1 218 0 221 0 49 0 49 1 219 1 220 0 49 1 210 0 192 1 221 0 49 1 222 1 223 1 224 0 49 0 49 1 225 0 221 0 49 0 49 1 226 1 227 1 228 1 229 1 230 0 49 0 97 1 231 1 232 0 72 0 72 0 72 0 72 1 233 1 234 1 235 0 49 0 49 1 236 1 237 0 192 1 238 0 83 0 84 0 98 1 239 1 240 1 241 1 242 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 49 1 243 1 244 1 245 0 72 0 72 0 49 0 49 0 49 1 246 1 247 0 192 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 1 248 1 249 1 250 1 251 0 72 0 72 0 49 0 49 0 49 1 252 1 253 0 192 1 254 0 72 0 49 0 49 1 255 2 0 0 192 0 72 0 72 0 72 0 49 2 1 2 2 2 3 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 9 0 9 0 11 0 11 0 148 2 4 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 49 1 210 0 84 0 49 1 248 2 5 2 6 0 148 0 175 2 7 0 49 2 8 2 9 2 10 0 72 0 72 0 72 0 72 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 207 0 72 0 72 0 72 0 72 0 72 0 72 1 15 1 15 1 15 1 15 1 15 1 15 2 11 2 12 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 1 134 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 200 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 49 0 49 1 64 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 49 1 210 0 49 0 200 1 116 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 204 2 13 0 49 0 49 0 49 2 14 2 15 2 16 2 17 2 18 0 49 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 49 0 49 0 205 2 19 2 20 2 21 1 218 2 22 0 72 0 72 0 72 0 72 2 23 0 72 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 151 0 72 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 2 24 2 25 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 49 0 49 0 49 0 49 0 50 0 151 1 210 2 26 2 27 0 72 0 72 0 72 0 72 0 72 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 1 73 0 209 0 209 2 28 0 209 0 209 0 209 2 29 2 30 2 31 0 209 2 32 0 209 0 209 0 209 2 33 0 72 0 209 0 209 0 209 0 209 2 34 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 209 0 209 0 209 0 209 0 209 1 31 1 14 2 35 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 9 2 36 0 11 2 37 2 38 2 39 0 240 0 9 2 40 2 41 2 42 2 43 2 44 0 9 2 36 0 11 2 45 2 46 0 11 2 47 2 48 2 49 2 50 0 9 2 51 0 11 0 9 2 36 0 11 2 37 2 38 0 11 0 240 0 9 2 40 2 50 0 9 2 51 0 11 0 9 2 36 0 11 2 52 0 9 2 53 2 54 2 55 2 56 0 11 2 57 0 9 2 58 2 59 2 60 2 61 0 11 2 62 0 9 2 63 0 11 2 64 2 65 2 65 2 65 0 32 0 32 0 32 2 66 0 32 0 32 2 67 2 68 2 69 2 70 0 46 0 72 0 72 0 72 0 72 0 72 2 71 2 72 2 73 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 2 74 2 75 0 72 0 72 0 9 0 9 2 40 0 11 2 76 1 116 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 2 77 0 49 2 78 2 79 2 80 2 81 2 82 2 83 2 84 0 206 2 85 0 206 0 72 0 72 0 72 2 86 0 209 0 209 1 74 0 209 0 209 0 209 0 209 0 209 0 209 1 72 1 30 2 87 2 87 2 87 0 209 1 73 0 175 0 209 1 30 0 209 0 209 0 209 1 74 0 209 0 209 0 209 2 88 0 72 0 72 0 72 2 89 0 209 2 90 0 209 0 209 1 74 2 33 1 53 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 2 91 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 0 209 2 90 2 88 1 31 0 209 0 209 0 209 0 209 0 209 0 209 0 209 1 72 0 209 0 209 0 209 0 209 0 209 2 92 0 72 0 72 1 74 0 209 0 209 0 209 2 93 0 176 0 209 0 209 2 93 0 209 2 94 0 72 0 72 0 72 0 72 0 72 0 72 1 30 2 93 2 95 1 74 1 30 0 72 0 72 0 209 1 53 0 72 0 72 1 171 0 72 0 72 0 72 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 1 64 0 72 0 72 0 49 0 49 0 49 0 205 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 204 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 0 49 2 25 0 72 0 72 0 72 0 72 0 72 0 49 0 204 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 2 96 0 72 2 97 2 97 2 97 2 97 2 97 2 97 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 72 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 32 0 72 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 1 137 2 98))

(define ucd-gc-table-4
  '#u8(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 2 2 3 2 2 2 4 5 2 6 2 7 2 2 8 8 8 8 8 8 8 8 8 8 2 2 6 6 6 2 2 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 4 2 5 10 11 10 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 4 6 5 6 0 1 2 3 3 3 3 13 2 10 13 14 15 6 16 13 10 13 6 17 17 10 12 2 2 10 17 14 18 17 17 17 2 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 6 9 9 9 9 9 9 9 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 6 12 12 12 12 12 12 12 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 9 12 9 12 9 12 12 12 9 9 12 9 12 9 9 12 9 9 9 12 12 9 9 9 9 12 9 9 12 9 9 9 12 12 12 9 9 12 9 9 12 9 12 9 12 9 9 12 9 12 12 9 12 9 9 12 9 9 9 12 9 12 9 9 12 12 14 9 12 12 12 14 14 14 14 9 19 12 9 19 12 9 19 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 12 9 12 12 9 19 12 9 12 9 9 9 12 9 12 9 12 9 12 9 12 9 12 12 12 12 12 12 12 9 9 12 9 9 12 12 9 12 9 9 9 9 12 9 12 9 12 9 12 9 12 12 12 12 12 14 12 12 12 12 12 12 12 12 12 12 12 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 10 10 10 10 20 20 20 20 20 20 20 20 20 20 20 20 10 10 10 10 10 10 10 10 10 10 10 10 10 10 20 20 20 20 20 10 10 10 10 10 10 10 20 10 20 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 9 12 9 12 20 10 9 12 22 22 20 12 12 12 2 9 22 22 22 22 10 10 9 2 9 9 9 22 9 22 9 9 12 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 22 9 9 9 9 9 9 9 9 9 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 9 12 12 9 9 9 12 12 12 9 12 9 12 9 12 9 12 12 12 12 12 9 12 6 9 12 9 9 12 12 9 9 9 9 12 13 21 21 21 21 21 23 23 9 12 9 12 9 12 9 9 12 9 12 9 12 9 12 9 12 9 12 9 12 12 22 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 22 22 20 2 2 2 2 2 2 22 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 2 7 22 22 13 13 3 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 7 21 2 21 21 2 21 21 2 21 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 14 14 14 2 2 22 22 22 22 22 22 22 22 22 22 22 16 16 16 16 16 16 6 6 6 2 2 3 2 2 13 13 21 21 21 21 21 21 21 21 21 21 21 2 16 22 2 2 20 14 14 14 14 14 14 14 14 14 14 21 21 21 21 21 8 8 8 8 8 8 8 8 8 8 2 2 2 2 14 14 21 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 2 14 21 21 21 21 21 21 21 16 13 21 21 21 21 21 21 20 20 21 21 13 21 21 21 21 14 14 8 8 8 8 8 8 8 8 8 8 14 14 14 13 13 14 2 2 2 2 2 2 2 2 2 2 2 2 2 2 22 16 14 21 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 21 21 21 21 21 21 21 21 21 21 22 22 14 14 14 14 14 14 14 14 14 21 21 21 21 21 21 21 21 21 21 21 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 8 8 8 8 8 8 8 8 8 8 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 21 21 21 21 21 21 21 21 20 20 13 2 2 2 20 22 22 22 22 22 14 14 14 14 14 14 21 21 21 21 20 21 21 21 21 21 21 21 21 21 20 21 21 21 20 21 21 21 21 21 22 22 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 22 14 14 14 14 14 14 14 14 14 21 21 21 22 22 2 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 22 14 14 14 14 14 14 14 14 22 22 22 22 22 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 16 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 21 14 24 24 24 21 21 21 21 21 21 21 21 24 24 24 24 21 24 24 14 21 21 21 21 21 21 21 14 14 14 14 14 14 14 14 14 14 21 21 2 2 8 8 8 8 8 8 8 8 8 8 2 20 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 24 22 14 14 14 14 14 14 14 14 22 22 14 14 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 22 14 22 22 22 14 14 14 14 22 22 21 14 24 24 24 21 21 21 21 22 22 24 24 22 22 24 24 21 14 22 22 22 22 22 22 22 22 24 22 22 22 22 14 14 22 14 14 14 21 21 22 22 8 8 8 8 8 8 8 8 8 8 14 14 3 3 17 17 17 17 17 17 13 3 22 22 22 22 22 21 21 24 22 14 14 14 14 14 14 22 22 22 22 14 14 22 14 14 22 14 14 22 14 14 22 22 21 22 24 24 24 21 21 22 22 22 22 21 21 22 22 21 21 21 22 22 22 21 22 22 22 22 22 22 22 14 14 14 14 22 14 22 22 22 22 22 22 22 8 8 8 8 8 8 8 8 8 8 21 21 14 14 14 21 22 22 22 22 22 22 22 22 22 22 22 21 21 24 22 14 14 14 14 14 14 14 14 14 22 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 22 14 14 14 14 14 22 22 21 14 24 24 24 21 21 21 21 21 22 21 21 24 22 24 24 21 22 22 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 2 3 22 22 22 22 22 22 22 14 22 22 22 22 22 22 22 21 24 24 22 14 14 14 14 14 14 14 14 22 22 14 14 22 14 14 22 14 14 14 14 14 22 22 21 14 24 21 24 21 21 21 21 22 22 24 24 22 22 24 24 21 22 22 22 22 22 22 22 22 21 24 22 22 22 22 14 14 22 14 13 14 17 17 17 17 17 17 22 22 22 22 22 22 22 22 22 22 21 14 22 14 14 14 14 14 14 22 22 22 14 14 14 22 14 14 14 14 22 22 22 14 14 22 14 22 14 14 22 22 22 14 14 22 22 22 14 14 14 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 24 24 21 24 24 22 22 22 24 24 24 22 24 24 24 21 22 22 14 22 22 22 22 22 22 24 22 22 22 22 22 22 22 22 17 17 17 13 13 13 13 13 13 3 13 22 22 22 22 22 21 24 24 24 22 14 14 14 14 14 14 14 14 22 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 14 21 21 21 24 24 24 24 22 21 21 21 22 21 21 21 21 22 22 22 22 22 22 22 21 21 22 14 14 14 22 22 22 22 22 22 22 22 22 22 22 22 22 17 17 17 17 17 17 17 13 14 21 24 24 22 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 22 14 14 14 14 14 22 22 21 14 24 21 24 24 24 24 24 22 21 24 24 22 24 24 21 21 22 22 22 22 22 22 22 24 24 22 22 22 22 22 22 22 14 22 22 14 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 21 24 24 22 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 14 24 24 24 21 21 21 21 22 24 24 24 22 24 24 24 21 14 13 22 22 22 22 14 14 14 24 17 17 17 17 17 17 17 14 17 17 17 17 17 17 17 17 17 13 14 14 14 14 14 14 22 22 24 24 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 22 14 22 22 14 14 14 14 14 14 14 22 22 22 21 22 22 22 22 24 24 24 21 21 21 22 21 22 24 24 24 24 24 24 24 24 22 22 24 24 2 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 14 14 21 21 21 21 21 21 21 22 22 22 22 3 14 14 14 14 14 14 20 21 21 21 21 21 21 21 21 2 8 8 8 8 8 8 8 8 8 8 2 2 22 22 22 22 22 14 14 22 14 22 22 14 14 22 14 22 22 14 22 22 22 22 22 22 14 14 14 14 22 14 14 14 14 14 14 14 22 14 14 14 22 14 22 14 22 22 14 14 22 14 14 14 14 21 14 14 21 21 21 21 21 21 22 21 21 14 22 22 14 14 14 14 14 22 20 22 21 21 21 21 21 21 22 22 8 8 8 8 8 8 8 8 8 8 22 22 14 14 14 14 14 13 13 13 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 13 2 13 13 13 21 21 13 13 13 13 13 13 8 8 8 8 8 8 8 8 8 8 17 17 17 17 17 17 17 17 17 17 13 21 13 21 13 21 4 5 4 5 24 24 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 24 21 21 21 21 21 2 21 21 14 14 14 14 14 21 21 21 21 21 21 21 21 21 21 21 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 22 13 13 13 13 13 13 13 13 21 13 13 13 13 13 13 22 13 13 2 2 2 2 2 13 13 13 13 2 2 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 24 24 21 21 21 21 24 21 21 21 21 21 21 24 21 21 24 24 21 21 14 8 8 8 8 8 8 8 8 8 8 2 2 2 2 2 2 14 14 14 14 14 14 24 24 21 21 14 14 14 14 21 21 21 14 24 24 24 14 14 24 24 24 24 24 24 24 14 14 14 21 21 21 21 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 24 21 21 24 24 24 24 24 24 21 14 24 8 8 8 8 8 8 8 8 8 8 24 24 24 21 13 13 9 9 9 9 9 9 22 9 22 22 22 22 22 9 22 22 14 14 14 14 14 14 14 14 14 14 14 2 20 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 22 22 14 14 14 14 14 14 14 22 14 22 14 14 14 14 22 22 14 22 14 14 14 14 22 22 14 14 14 14 14 14 14 22 14 22 14 14 14 14 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 21 21 21 2 2 2 2 2 2 2 2 2 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 22 22 22 13 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 9 9 9 9 9 9 22 22 12 12 12 12 12 12 22 22 7 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 2 2 14 1 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 4 5 22 22 22 14 14 14 14 14 14 14 14 14 14 14 2 2 2 25 25 25 14 14 14 14 14 14 14 14 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 21 21 21 22 22 22 22 22 22 22 22 22 22 22 14 14 21 21 21 2 2 22 22 22 22 22 22 22 22 22 14 14 21 21 22 22 22 22 22 22 22 22 22 22 22 22 14 22 21 21 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 21 21 24 21 21 21 21 21 21 21 24 24 24 24 24 24 24 24 21 24 24 21 21 21 21 21 21 21 21 21 21 21 2 2 2 20 2 2 2 3 14 21 22 22 8 8 8 8 8 8 8 8 8 8 22 22 22 22 22 22 17 17 17 17 17 17 17 17 17 17 22 22 22 22 22 22 2 2 2 2 2 2 7 2 2 2 2 21 21 21 16 22 14 14 14 20 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 22 22 22 14 14 14 14 14 21 21 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 14 22 22 22 22 22 14 14 14 14 14 14 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 21 21 21 24 24 24 24 21 21 24 24 24 22 22 22 22 24 24 21 24 24 24 24 24 24 21 21 21 22 22 22 22 13 22 22 22 2 2 8 8 8 8 8 8 8 8 8 8 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 14 14 14 14 14 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 22 8 8 8 8 8 8 8 8 8 8 17 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 14 14 14 14 14 14 14 21 21 24 24 21 22 22 2 2 14 14 14 14 14 24 21 24 21 21 21 21 21 21 21 22 21 24 21 24 24 21 21 21 21 21 21 21 21 24 24 24 24 24 24 21 21 21 21 21 21 21 21 21 21 22 22 21 2 2 2 2 2 2 2 20 2 2 2 2 2 2 22 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 23 22 21 21 21 21 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 21 21 21 21 21 24 21 24 24 24 24 24 21 24 24 14 14 14 14 14 14 14 22 22 22 22 2 13 13 13 13 13 13 13 13 13 13 21 21 21 21 21 21 21 21 21 13 13 13 13 13 13 13 13 13 22 22 22 21 21 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 24 21 21 21 21 24 24 21 21 24 21 21 21 14 14 14 14 14 14 14 14 21 24 21 21 24 24 24 21 24 21 21 21 24 24 22 22 22 22 22 22 22 22 2 2 2 2 14 14 14 14 24 24 24 24 24 24 24 24 21 21 21 21 21 21 21 21 24 24 21 21 22 22 22 2 2 2 2 2 8 8 8 8 8 8 8 8 8 8 22 22 22 14 14 14 14 14 14 14 14 14 14 14 20 20 20 20 20 20 2 2 12 12 12 12 12 12 12 12 12 22 22 22 22 22 22 22 2 2 2 2 2 2 2 2 22 22 22 22 22 22 22 22 21 21 21 2 21 21 21 21 21 21 21 21 21 21 21 21 21 24 21 21 21 21 21 21 21 14 14 14 14 21 14 14 14 14 24 24 21 14 14 22 21 21 22 22 22 22 22 22 12 12 12 12 12 12 12 12 12 12 12 12 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 12 12 12 12 12 12 12 12 12 12 12 12 12 20 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 20 20 20 20 20 21 21 21 21 21 21 22 22 22 22 22 21 21 21 21 21 9 12 9 12 9 12 12 12 12 12 12 12 12 12 9 12 12 12 12 12 12 12 12 12 9 9 9 9 9 9 9 9 12 12 12 12 12 12 22 22 9 9 9 9 9 9 22 22 12 12 12 12 12 12 12 12 22 9 22 9 22 9 22 9 12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 22 12 12 12 12 12 12 12 12 19 19 19 19 19 19 19 19 12 12 12 12 12 22 12 12 9 9 9 9 19 10 12 10 10 10 12 12 12 22 12 12 9 9 9 9 19 10 10 10 12 12 12 12 22 22 12 12 9 9 9 9 22 10 10 10 12 12 12 12 12 12 12 12 9 9 9 9 9 10 10 10 22 22 12 12 12 22 12 12 9 9 9 9 19 10 10 22 1 1 1 1 1 1 1 1 1 1 1 16 16 16 16 16 7 7 7 7 7 7 2 2 15 18 4 15 15 18 4 15 2 2 2 2 2 2 2 2 26 27 16 16 16 16 16 1 2 2 2 2 2 2 2 2 2 15 18 2 2 2 2 11 11 2 2 2 6 4 5 2 2 2 2 2 2 2 2 2 2 2 6 2 11 2 2 2 2 2 2 2 2 2 2 1 16 16 16 16 16 22 16 16 16 16 16 16 16 16 16 16 17 20 22 22 17 17 17 17 17 17 6 6 6 4 5 20 17 17 17 17 17 17 17 17 17 17 6 6 6 4 5 22 20 20 20 20 20 20 20 20 20 20 20 20 20 22 22 22 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 22 21 21 21 21 21 21 21 21 21 21 21 21 21 23 23 23 23 21 23 23 23 21 21 21 21 21 21 21 21 21 21 21 21 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 9 13 13 13 13 9 13 13 12 9 9 9 12 12 9 9 9 12 13 9 13 13 6 9 9 9 9 9 13 13 13 13 13 13 9 13 9 13 9 13 9 9 9 9 13 12 9 9 9 9 12 14 14 14 14 12 13 13 12 12 9 9 6 6 6 6 6 9 12 12 12 12 13 6 13 13 12 13 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 9 12 25 25 25 25 17 13 13 22 22 22 22 6 6 6 6 6 13 13 13 13 13 6 6 13 13 13 13 6 13 13 6 13 13 6 13 13 13 13 13 13 13 6 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6 6 13 13 6 13 6 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 13 13 13 13 13 13 13 13 4 5 4 5 13 13 13 13 6 6 13 13 13 13 13 13 13 4 5 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6 6 6 6 6 6 6 6 6 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6 6 6 6 6 6 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 22 22 22 22 22 17 17 17 17 17 17 17 17 17 17 17 17 13 13 13 13 13 13 13 13 13 13 13 13 13 13 17 17 17 17 17 17 13 13 13 13 13 13 13 6 13 13 13 13 13 13 13 13 13 6 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6 6 6 6 6 6 6 6 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6 13 13 13 13 13 13 13 13 4 5 4 5 4 5 4 5 4 5 4 5 4 5 17 17 17 17 17 17 17 17 17 17 17 17 17 17 13 13 13 13 13 13 13 13 13 13 13 13 6 6 6 6 6 4 5 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 4 5 4 5 4 5 4 5 4 5 6 6 6 4 5 4 5 4 5 4 5 4 5 4 5 4 5 4 5 4 5 4 5 4 5 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 4 5 4 5 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 4 5 6 6 6 6 6 6 6 13 13 6 6 6 6 6 6 13 13 13 13 13 13 13 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 22 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 22 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 9 12 9 9 9 12 12 9 12 9 12 9 12 9 9 9 9 12 9 12 12 9 12 12 12 12 12 12 20 20 9 9 9 12 9 12 12 13 13 13 13 13 13 9 12 9 12 21 21 21 9 12 22 22 22 22 22 2 2 2 2 17 2 2 12 12 12 12 12 12 22 12 22 22 22 22 22 12 22 22 14 14 14 14 14 14 14 14 22 22 22 22 22 22 22 20 2 22 22 22 22 22 22 22 22 22 22 22 22 22 22 21 14 14 14 14 14 14 14 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 22 2 2 15 18 15 18 2 2 2 15 18 2 15 18 2 2 2 2 2 2 2 2 2 7 2 2 7 2 15 18 2 2 15 18 4 5 4 5 4 5 4 5 2 2 2 2 2 20 2 2 2 2 2 2 2 2 2 2 7 7 2 2 2 2 7 2 4 2 2 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 22 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 22 22 22 22 1 2 2 2 13 20 14 25 4 5 4 5 4 5 4 5 4 5 13 13 4 5 4 5 4 5 4 5 7 4 5 5 13 25 25 25 25 25 25 25 25 25 21 21 21 21 24 24 7 20 20 20 20 20 13 13 25 25 25 20 14 2 13 13 14 14 14 14 14 14 14 22 22 21 21 10 10 20 20 14 14 14 14 14 14 14 14 14 14 14 14 2 20 20 20 14 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 13 13 17 17 17 17 13 13 13 13 13 13 13 13 13 13 17 17 17 17 17 17 17 17 17 17 13 13 13 13 13 13 13 13 13 13 13 13 13 13 17 17 17 17 17 17 17 17 13 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 14 14 14 14 14 20 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 20 2 2 2 8 8 8 8 8 8 8 8 8 8 14 14 22 22 22 22 9 12 9 12 9 12 9 12 9 12 9 12 9 12 14 21 23 23 23 2 21 21 21 21 21 21 21 21 21 21 2 20 9 12 9 12 9 12 9 12 9 12 9 12 20 20 21 21 14 14 14 14 14 14 25 25 25 25 25 25 25 25 25 25 21 21 2 2 2 2 2 2 22 22 22 22 22 22 22 22 10 10 10 10 10 10 10 20 20 20 20 20 20 20 20 20 10 10 9 12 9 12 9 12 9 12 9 12 9 12 9 12 12 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 20 12 12 12 12 12 12 12 12 9 12 9 12 9 9 12 9 12 9 12 9 12 9 12 20 10 10 9 12 9 12 14 9 12 9 12 12 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 12 9 9 9 9 9 22 9 9 9 9 9 12 9 12 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 20 20 12 14 14 14 14 14 14 14 21 14 14 14 21 14 14 14 14 21 14 14 14 14 14 14 14 24 24 21 21 24 13 13 13 13 22 22 22 22 17 17 17 17 17 17 13 13 3 13 22 22 22 22 22 22 14 14 14 14 2 2 2 2 22 22 22 22 22 22 22 22 24 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 21 21 22 22 22 22 22 22 22 22 2 2 21 21 14 14 14 14 14 14 2 2 2 14 2 14 22 22 14 14 14 14 14 14 21 21 21 21 21 21 21 21 2 2 14 14 14 14 14 14 14 21 21 21 21 21 21 21 21 21 21 21 24 24 22 22 22 22 22 22 22 22 22 22 22 2 14 14 14 21 24 24 21 21 21 21 24 24 21 24 24 24 24 2 2 2 2 2 2 2 2 2 2 2 2 2 22 20 8 8 8 8 8 8 8 8 8 8 22 22 22 22 2 2 14 14 14 14 14 21 20 14 14 14 14 14 14 14 14 14 8 8 8 8 8 8 8 8 8 8 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 21 21 21 21 21 21 24 24 21 21 24 24 21 21 22 22 22 22 22 22 22 22 22 14 14 14 21 14 14 14 14 14 14 14 14 21 24 22 22 8 8 8 8 8 8 8 8 8 8 22 22 2 2 2 2 20 14 14 14 14 14 14 13 13 13 14 24 21 24 14 14 21 14 21 21 21 14 14 21 21 14 14 14 14 14 21 21 14 21 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 20 2 2 14 14 14 14 14 14 14 14 14 14 14 24 21 21 24 24 2 2 14 20 20 24 21 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 22 22 14 14 14 14 14 14 22 22 14 14 14 14 14 14 22 22 22 22 22 22 22 22 22 12 12 12 12 12 12 12 12 12 12 12 10 20 20 20 20 12 12 12 12 12 12 22 22 22 22 22 22 22 22 22 22 14 14 14 24 24 21 24 24 21 24 24 2 24 21 22 22 14 14 14 14 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 22 22 22 22 14 14 14 14 14 28 28 28 28 28 28 28 28 28 28 28 28 28 28 28 28 29 29 29 29 29 29 29 29 29 29 29 29 29 29 29 29 12 12 12 12 12 12 12 22 22 22 22 22 22 22 22 22 22 22 22 12 12 12 12 12 22 22 22 22 22 14 21 14 14 14 14 14 14 14 14 14 14 6 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 22 14 22 14 14 22 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 5 4 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 3 13 22 22 2 2 2 2 2 2 2 4 5 2 22 22 22 22 22 22 2 7 7 11 11 4 5 4 5 4 5 4 5 4 5 4 5 4 5 4 5 2 2 4 5 2 2 2 2 11 11 11 2 2 2 22 2 2 2 2 7 4 5 4 5 4 5 2 2 2 6 7 6 6 6 22 2 3 2 2 22 22 22 22 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 16 22 2 2 2 3 2 2 2 4 5 2 6 2 7 2 2 12 12 12 12 12 12 12 12 12 12 12 4 6 5 6 4 5 2 4 5 2 2 14 14 14 14 14 14 14 14 14 14 20 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 20 20 22 22 14 14 14 14 14 14 22 22 14 14 14 14 14 14 22 22 14 14 14 14 14 14 22 22 14 14 14 22 22 22 3 3 6 10 13 3 3 22 13 6 6 6 6 13 13 22 22 22 22 22 22 22 22 22 22 16 16 16 13 13 22 22 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 22 14 2 2 2 22 22 22 22 17 17 17 17 17 17 17 17 17 17 17 17 17 22 22 22 13 13 13 13 13 13 13 13 13 25 25 25 25 25 17 17 17 17 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 17 17 13 13 13 22 13 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 21 22 22 21 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 22 22 22 22 17 17 17 17 22 22 22 22 22 22 22 22 22 22 22 22 14 25 14 14 14 14 14 14 14 14 25 22 22 22 22 22 14 14 14 14 14 14 21 21 21 21 21 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 2 14 14 14 14 22 22 22 22 14 14 14 14 14 14 14 14 2 25 25 25 25 25 22 22 22 22 22 22 22 22 22 22 9 9 9 9 9 9 9 9 12 12 12 12 12 12 12 12 9 9 9 9 22 22 22 22 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 22 22 22 14 14 14 14 22 22 22 22 22 22 22 22 22 22 22 2 14 14 14 14 14 14 22 22 14 22 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 22 22 22 14 22 22 14 14 14 14 14 14 14 22 2 17 17 17 17 17 17 17 17 14 14 14 14 14 14 14 13 13 17 17 17 17 17 17 17 22 22 22 22 22 22 22 17 17 17 17 17 17 17 17 17 14 14 14 22 14 14 22 22 22 22 22 17 17 17 17 17 14 14 14 14 14 14 17 17 17 17 17 17 22 22 22 2 14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 2 14 14 14 14 14 14 14 14 22 22 22 22 17 17 14 14 22 22 17 17 17 17 17 17 17 17 17 17 17 17 17 17 14 21 21 21 22 21 21 22 22 22 22 22 21 21 21 21 14 14 14 14 22 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 21 21 21 22 22 22 22 21 17 17 17 17 17 17 17 17 22 22 22 22 22 22 22 22 2 2 2 2 2 2 2 2 2 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 17 17 2 14 14 14 14 14 14 14 14 14 14 14 14 14 17 17 17 14 14 14 14 14 14 14 14 13 14 14 14 14 14 14 14 14 14 14 14 14 21 21 22 22 22 22 17 17 17 17 17 2 2 2 2 2 2 2 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 22 22 22 2 2 2 2 2 2 2 14 14 14 14 14 14 22 22 17 17 17 17 17 17 17 17 14 14 14 22 22 22 22 22 17 17 17 17 17 17 17 17 14 14 22 22 22 22 22 22 22 2 2 2 2 22 22 22 22 22 22 22 22 22 22 22 22 17 17 17 17 17 17 17 14 14 14 14 14 14 14 14 14 22 22 22 22 22 22 22 9 9 9 22 22 22 22 22 22 22 22 22 22 22 22 22 12 12 12 22 22 22 22 22 22 22 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 22 24 21 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 2 2 2 2 2 2 2 22 22 17 17 17 17 17 17 8 8 8 8 8 8 8 8 8 8 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 21 24 24 24 21 21 21 21 24 24 21 21 2 2 16 2 2 2 2 22 22 22 22 22 22 22 22 22 22 22 22 22 22 21 21 21 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 21 21 21 21 24 21 21 21 21 21 21 21 21 22 8 8 8 8 8 8 8 8 8 8 2 2 2 2 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 21 2 2 14 22 22 22 22 22 22 22 22 22 14 14 14 24 24 24 21 21 21 21 21 21 21 21 21 24 24 14 14 14 14 2 2 2 2 2 21 21 21 2 22 22 8 8 8 8 8 8 8 8 8 8 14 2 14 2 2 2 22 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 24 24 24 21 21 21 24 24 21 24 21 21 2 2 2 2 2 2 21 22 14 14 14 14 14 14 14 22 14 22 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 2 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 24 24 21 21 21 21 21 21 21 21 22 22 22 22 22 21 21 24 24 22 14 14 14 14 14 14 14 14 22 22 14 21 24 24 24 24 22 22 24 24 22 22 24 24 24 22 22 14 22 22 22 22 22 22 24 22 22 22 22 22 14 14 14 14 14 24 24 22 22 21 21 21 21 21 21 21 22 22 22 21 21 21 21 21 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 24 24 24 21 21 21 21 21 21 21 21 24 24 21 21 21 24 21 14 14 14 14 2 2 2 2 2 8 8 8 8 8 8 8 8 8 8 22 2 22 2 22 22 24 24 24 21 21 21 21 21 21 24 21 24 24 24 24 21 21 24 21 21 14 14 2 14 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 24 24 24 21 21 21 21 22 22 24 24 24 24 21 21 24 21 21 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 14 14 14 14 21 21 22 22 24 24 24 21 21 21 21 21 21 21 21 24 24 21 24 21 21 2 2 2 14 22 22 22 22 22 22 22 22 22 22 22 2 2 2 2 2 2 2 2 2 2 2 2 2 22 22 22 14 14 14 14 14 14 14 14 14 14 14 21 24 21 24 24 21 21 21 21 21 21 24 21 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 22 22 22 21 21 21 24 24 21 21 21 21 24 21 21 21 21 21 22 22 22 22 8 8 8 8 8 8 8 8 8 8 17 17 2 2 2 13 17 17 17 22 22 22 22 22 22 22 22 22 22 22 22 14 21 21 21 21 21 21 21 22 21 21 21 21 21 21 24 21 14 2 2 2 2 2 22 22 22 22 22 22 22 22 22 22 2 2 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 22 24 21 21 21 21 21 21 21 24 21 21 24 21 21 22 22 22 22 22 22 22 22 22 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 22 2 2 2 2 2 22 22 22 22 22 22 22 22 22 22 22 21 21 21 21 21 2 22 22 22 22 22 22 22 22 22 22 21 21 21 21 21 21 21 2 2 2 2 2 13 13 13 13 20 20 20 20 2 13 22 22 22 22 22 22 22 22 22 22 8 8 8 8 8 8 8 8 8 8 22 17 17 17 17 17 17 17 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 14 14 14 14 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 22 21 21 21 20 20 20 20 20 20 20 20 20 20 20 20 20 20 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 22 22 13 21 21 2 16 16 16 16 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 22 22 13 13 13 13 13 13 13 13 13 13 13 13 24 24 21 21 21 13 13 13 24 24 24 24 24 24 16 16 16 16 16 16 16 16 21 21 21 21 21 21 21 21 13 13 21 21 21 21 21 21 21 13 13 13 13 13 13 13 13 13 13 13 13 13 13 21 21 21 21 13 13 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 13 13 21 21 21 13 22 22 22 22 22 22 22 22 22 22 17 17 22 22 22 22 22 22 22 22 22 22 22 22 22 22 9 9 9 9 9 9 9 9 9 9 12 12 12 12 12 12 12 12 12 12 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 12 12 12 12 12 12 12 22 12 12 12 12 12 12 12 12 12 12 9 9 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 9 22 9 9 22 22 9 22 22 9 9 22 22 9 9 9 9 22 9 9 9 9 9 9 9 9 12 12 12 12 22 12 22 12 12 12 12 12 12 12 22 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 9 9 22 9 9 9 9 22 22 9 9 9 9 9 9 9 9 22 9 9 9 9 9 9 9 22 12 12 12 12 12 12 12 12 12 12 9 9 22 9 9 9 9 22 9 9 9 9 9 22 9 22 22 22 9 9 9 9 9 9 9 22 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 9 9 9 9 9 9 9 9 9 9 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 22 9 9 9 9 9 9 9 9 9 6 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 6 12 12 12 12 12 12 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 6 12 12 12 12 12 12 12 12 12 6 12 12 12 12 12 12 9 9 9 9 9 9 9 9 9 6 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 6 12 12 12 12 12 12 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 6 12 12 12 12 12 12 12 12 12 6 12 12 12 12 12 12 9 9 9 9 9 9 9 9 9 6 12 12 12 12 12 12 12 12 12 6 12 12 12 12 12 12 9 12 22 22 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 21 21 21 21 21 21 21 13 13 13 13 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 13 13 13 13 13 13 13 13 21 13 13 13 13 13 13 13 13 13 13 13 13 13 13 21 13 13 2 2 2 2 2 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 21 21 21 21 21 21 21 21 21 21 21 21 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 22 22 21 21 21 21 21 21 21 22 21 21 22 21 21 21 21 21 22 22 22 22 22 14 14 14 14 14 22 22 17 17 17 17 17 17 17 17 17 21 21 21 21 21 21 21 22 22 22 22 22 22 22 22 22 12 12 12 12 21 21 21 21 21 21 21 22 22 22 22 22 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 22 14 14 22 14 22 22 14 22 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 22 14 22 14 22 22 22 22 22 22 14 22 22 22 22 14 22 14 22 14 22 14 14 14 22 14 14 22 14 22 22 14 22 14 22 14 22 14 22 14 22 14 14 22 14 22 22 14 14 14 14 22 14 14 14 14 14 14 14 22 14 14 14 14 22 14 14 14 14 22 14 22 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 22 14 14 14 22 14 14 14 14 14 22 14 14 14 14 14 6 6 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 10 10 10 10 10 13 13 13 13 13 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 13 22 22 13 13 13 13 13 13 13 13 13 13 13 13 22 22 16 22 22 22 22 22 22 22 22 22 22 22 22 22 22 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 29 29 29 29 29 29 29 29 29 29 29 29 29 29 22 22))

(define ucd-gc-table-5
  '#(other:control separator:space punctuation:other symbol:currency punctuation:open punctuation:close symbol:math punctuation:dash number:decimal-digit letter:uppercase symbol:modifier punctuation:connector letter:lowercase symbol:other letter:other punctuation:initial-quote other:format number:other punctuation:final-quote letter:titlecase letter:modifier mark:nonspacing other:not-assigned mark:enclosing mark:spacing-combining number:letter separator:line separator:paragraph other:surrogate other:private-use))
