/* @(#) various.h 2.3 87/12/27 14:44:34 */

/*
The contents of this file are hereby released to the public domain.

                           -- Rahul Dhesi 1986/11/14
*/

/*
This files gives definitions for most external functions used by Zoo.
If LINT_ARGS is defined, ANSI-style function prototypes are used, else
normal K&R function declarations are used.

Note:  Always precede this file with an include of stdio.h because it uses
the predefined type FILE.

Microsoft C and Turbo C use different conventions for specifying an
incomplete argument list in a function prototype.  Microsoft C uses a
trailing comma, while Turbo C uses three dots (...).  To take care
of these peculiarities, the symbol MORE stands for incomplete arguments.
For Turbo C we define it to be three dots and for Microsoft C we
define it to be nothing.  This is done in options.h, so options.h must
always be included before various.h is included.
*/

#ifndef PARMS
#ifdef LINT_ARGS
#define	PARMS(x)		x
#else
#define	PARMS(x)		()
#endif
#endif

FILE *fdopen PARMS ((int, char *));
FILE *fopen PARMS ((char *, char *));
char *fgets PARMS ((char *, int, FILE *));
char *gets PARMS ((char *));
char *malloc PARMS ((unsigned int));
char *realloc PARMS ((char *, unsigned int));
char *strcat PARMS ((char *, char *));
char *strchr PARMS ((char *, int));
char *strcpy PARMS ((char *, char *));
char *strdup PARMS ((char *));
char *strlwr PARMS ((char *));
char *strncat PARMS ((char *, char *, unsigned int));
char *strncpy PARMS ((char *, char *, unsigned int));
char *strrchr PARMS ((char *, int));
int fclose PARMS ((FILE *));
int fflush PARMS ((FILE *));
int fgetc PARMS ((FILE *));
int fgetchar PARMS (());
int fprintf PARMS ((FILE *, char *, MORE));
int fputchar PARMS ((int));
int fputs PARMS ((char *, FILE *));

#ifdef ALWAYS_INT
int fputc PARMS ((int, FILE *));
int fread PARMS ((VOIDPTR, int, int, FILE *));
int fwrite PARMS ((VOIDPTR, int, int, FILE *));
#else
int fputc PARMS ((char, FILE *));
int fread PARMS ((VOIDPTR, unsigned, unsigned, FILE *));
int fwrite PARMS ((VOIDPTR, unsigned, unsigned, FILE *));
#endif /* ALWAYS_INT */

int fseek PARMS ((FILE *, long, int));
int printf PARMS ((char *, MORE));
int rename PARMS ((char *, char *));
int setmode PARMS ((int, int));
int strcmp PARMS ((char *, char *));
int strncmp PARMS ((char *, char *, unsigned int));
int unlink PARMS ((char *));
long ftell PARMS ((FILE *));
unsigned int strlen PARMS ((char *));
