
/*  A Bison parser, made from filter.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define yyparse filterparse
#define yylex filterlex
#define yyerror filtererror
#define yylval filterlval
#define yychar filterchar
#define yydebug filterdebug
#define yynerrs filternerrs
#define	OP_OR	257
#define	OP_AND	258
#define	OP_NOT	259
#define	OP_MS	260
#define	OP_EQUAL	261
#define	OP_APPEND	262
#define	OP_COMPARE	263
#define	KEYW_ANY	264
#define	KEYW_PEERAS	265
#define	KEYW_IGP_COST	266
#define	KEYW_PREPEND	267
#define	KEYW_APPEND	268
#define	KEYW_DELETE	269
#define	KEYW_CONTAINS	270
#define	KEYW_INTERNET	271
#define	KEYW_NO_EXPORT	272
#define	KEYW_NO_ADVERTISE	273
#define	KEYW_SELF	274
#define	ASPATH_POSTFIX	275
#define	TKN_FLTRNAME	276
#define	TKN_ASNO	277
#define	TKN_RSNAME	278
#define	TKN_ASNAME	279
#define	TKN_PRFXV4	280
#define	TKN_PRFXV4RNG	281
#define	TKN_PREF	282
#define	TKN_MED	283
#define	TKN_DPA	284
#define	TKN_ASPATH	285
#define	TKN_COMMUNITY	286
#define	TKN_COMM_NO	287
#define	TKN_NEXT_HOP	288
#define	TKN_IPV4	289
#define	TKN_COST	290
#define	TKN_INT	291

#line 1 "filter.y"

/*
  filename: filter.y

  description:
    Defines the grammar for an RPSL filter attribute.  It was mostly
    stolen from the IRRToolSet, simplified by removing ability to parse
    things defined by a dictionary (we use XML for extensibility rather
    than a dictionary).

  notes:
    Defines tokens for the associated lexer, filter.l.
*/

#line 16 "filter.y"
typedef union {
    char *sval;
} YYSTYPE;
#line 30 "filter.y"

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

int yyerror(const char *s);

/* defines for unit testing */
#ifdef UNIT_TEST
int main();
#endif /* UNIT_TEST */
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		137
#define	YYFLAG		-32768
#define	YYNTBASE	56

#define YYTRANSLATE(x) ((unsigned)(x) <= 291 ? yytranslate[x] : 83)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,    50,     2,     2,     2,    38,
    39,    46,    48,    44,    54,    51,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,    55,    40,
     2,    41,    47,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    52,     2,    53,    49,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    42,    45,    43,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     4,     7,     9,    13,    15,    18,    22,    24,    26,
    30,    32,    34,    36,    39,    41,    43,    45,    47,    49,
    53,    54,    56,    58,    62,    64,    66,    70,    72,    75,
    77,    80,    83,    86,    89,    91,    93,    95,    99,   101,
   103,   105,   107,   109,   113,   118,   119,   122,   125,   128,
   133,   136,   139,   143,   145,   147,   149,   151,   153,   155,
   157,   161,   165,   169,   173,   180,   182,   186,   190,   194,
   201,   208,   215,   220,   224,   228,   230,   234,   236,   238,
   240,   242,   244,   248,   252
};

static const short yyrhs[] = {    56,
     3,    57,     0,    56,    57,     0,    57,     0,    57,     4,
    58,     0,    58,     0,     5,    58,     0,    38,    56,    39,
     0,    59,     0,    10,     0,    40,    65,    41,     0,    71,
     0,    22,     0,    60,     0,    61,     6,     0,    61,     0,
    23,     0,    11,     0,    25,     0,    24,     0,    42,    62,
    43,     0,     0,    63,     0,    64,     0,    63,    44,    64,
     0,    26,     0,    27,     0,    65,    45,    66,     0,    66,
     0,    66,    67,     0,    67,     0,    67,    46,     0,    67,
    47,     0,    67,    48,     0,    67,    21,     0,    68,     0,
    49,     0,    50,     0,    38,    65,    39,     0,    69,     0,
    23,     0,    11,     0,    25,     0,    51,     0,    52,    70,
    53,     0,    52,    49,    70,    53,     0,     0,    70,    23,
     0,    70,    11,     0,    70,    51,     0,    70,    23,    54,
    23,     0,    70,    25,     0,    71,    55,     0,     0,    71,
    55,     0,    72,     0,    73,     0,    74,     0,    75,     0,
    77,     0,    81,     0,    82,     0,    28,     7,    37,     0,
    29,     7,    37,     0,    29,     7,    12,     0,    30,     7,
    37,     0,    31,    51,    13,    38,    76,    39,     0,    23,
     0,    76,    44,    23,     0,    32,     7,    78,     0,    32,
     8,    78,     0,    32,    51,    14,    38,    79,    39,     0,
    32,    51,    15,    38,    79,    39,     0,    32,    51,    16,
    38,    79,    39,     0,    32,    38,    79,    39,     0,    32,
     9,    78,     0,    42,    79,    43,     0,    80,     0,    79,
    44,    80,     0,    17,     0,    18,     0,    19,     0,    37,
     0,    33,     0,    34,     7,    35,     0,    34,     7,    20,
     0,    36,     7,    37,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    45,    46,    47,    50,    51,    54,    55,    56,    59,    60,
    61,    62,    63,    66,    67,    70,    71,    72,    73,    74,
    77,    78,    81,    82,    85,    86,    89,    90,    93,    94,
    97,    98,    99,   100,   101,   104,   105,   106,   107,   110,
   111,   112,   113,   114,   115,   118,   119,   120,   121,   122,
   123,   126,   127,   130,   131,   132,   133,   134,   135,   136,
   139,   150,   159,   162,   173,   176,   177,   180,   181,   182,
   183,   184,   185,   186,   189,   192,   193,   196,   197,   198,
   199,   209,   212,   213,   216
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","OP_OR",
"OP_AND","OP_NOT","OP_MS","OP_EQUAL","OP_APPEND","OP_COMPARE","KEYW_ANY","KEYW_PEERAS",
"KEYW_IGP_COST","KEYW_PREPEND","KEYW_APPEND","KEYW_DELETE","KEYW_CONTAINS","KEYW_INTERNET",
"KEYW_NO_EXPORT","KEYW_NO_ADVERTISE","KEYW_SELF","ASPATH_POSTFIX","TKN_FLTRNAME",
"TKN_ASNO","TKN_RSNAME","TKN_ASNAME","TKN_PRFXV4","TKN_PRFXV4RNG","TKN_PREF",
"TKN_MED","TKN_DPA","TKN_ASPATH","TKN_COMMUNITY","TKN_COMM_NO","TKN_NEXT_HOP",
"TKN_IPV4","TKN_COST","TKN_INT","'('","')'","'<'","'>'","'{'","'}'","','","'|'",
"'*'","'?'","'+'","'^'","'$'","'.'","'['","']'","'-'","';'","filter","filter_term",
"filter_factor","filter_operand","filter_prefix","filter_prefix_operand","opt_filter_prefix_list",
"filter_prefix_list","filter_prefix_list_prefix","filter_aspath","filter_aspath_term",
"filter_aspath_closure","filter_aspath_factor","filter_aspath_no","filter_aspath_range",
"rp_attribute","pref","med","dpa","aspath","asno_list","community","community_list",
"community_elm_list","community_elm","next_hop","cost", NULL
};
#endif

static const short yyr1[] = {     0,
    56,    56,    56,    57,    57,    58,    58,    58,    59,    59,
    59,    59,    59,    60,    60,    61,    61,    61,    61,    61,
    62,    62,    63,    63,    64,    64,    65,    65,    66,    66,
    67,    67,    67,    67,    67,    68,    68,    68,    68,    69,
    69,    69,    69,    69,    69,    70,    70,    70,    70,    70,
    70,    -1,    -1,    71,    71,    71,    71,    71,    71,    71,
    72,    73,    73,    74,    75,    76,    76,    77,    77,    77,
    77,    77,    77,    77,    78,    79,    79,    80,    80,    80,
    80,    80,    81,    81,    82
};

static const short yyr2[] = {     0,
     3,     2,     1,     3,     1,     2,     3,     1,     1,     3,
     1,     1,     1,     2,     1,     1,     1,     1,     1,     3,
     0,     1,     1,     3,     1,     1,     3,     1,     2,     1,
     2,     2,     2,     2,     1,     1,     1,     3,     1,     1,
     1,     1,     1,     3,     4,     0,     2,     2,     2,     4,
     2,     2,     3,     1,     1,     1,     1,     1,     1,     1,
     3,     3,     3,     3,     6,     1,     3,     3,     3,     6,
     6,     6,     4,     3,     3,     1,     3,     1,     1,     1,
     1,     1,     3,     3,     3
};

static const short yydefact[] = {     0,
     0,     9,    17,    12,    16,    19,    18,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    21,     0,     3,     5,
     8,    13,    15,    11,    54,    55,    56,    57,    58,    59,
    60,     6,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    41,    40,    42,     0,    36,    37,
    43,    46,     0,    28,    30,    35,    39,    25,    26,     0,
    22,    23,     0,     2,     0,    14,    61,    63,    62,    64,
     0,     0,    68,    69,    74,    78,    79,    80,    82,    81,
     0,    76,     0,     0,     0,    84,    83,    85,     7,     0,
    46,     0,    10,     0,    29,    34,    31,    32,    33,    20,
     0,     1,     4,     0,     0,    73,     0,     0,     0,     0,
    38,     0,    48,    47,    51,    49,    44,    27,    24,    66,
     0,    75,    77,     0,     0,     0,    45,     0,    65,     0,
    70,    71,    72,    50,    67,     0,     0
};

static const short yydefgoto[] = {    18,
    19,    20,    21,    22,    23,    60,    61,    62,    53,    54,
    55,    56,    57,    92,    24,    25,    26,    27,    28,   121,
    29,    73,    81,    82,    30,    31
};

static const short yypact[] = {   114,
   114,-32768,-32768,-32768,-32768,-32768,-32768,     9,    29,    33,
   -13,    -3,    53,    55,   114,    47,    60,    21,    64,-32768,
-32768,-32768,    74,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,    57,    -4,    76,    98,    73,    73,    73,    -8,
    63,   -17,    84,    78,-32768,-32768,-32768,    47,-32768,-32768,
-32768,    77,   -11,    47,    45,-32768,-32768,-32768,-32768,    79,
    83,-32768,   114,    64,   114,-32768,-32768,-32768,-32768,-32768,
    85,    -8,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
   -27,-32768,    90,    91,    92,-32768,-32768,-32768,-32768,   -32,
-32768,    16,-32768,    47,    45,-32768,-32768,-32768,-32768,-32768,
    60,    64,-32768,   108,   -21,-32768,    -8,    -8,    -8,    -8,
-32768,    31,-32768,    80,-32768,-32768,-32768,    47,-32768,-32768,
   -25,-32768,-32768,   -24,    32,    51,-32768,   109,-32768,   110,
-32768,-32768,-32768,-32768,-32768,   135,-32768
};

static const short yypgoto[] = {   125,
   -16,    -1,-32768,-32768,-32768,-32768,-32768,    40,    99,    59,
   -53,-32768,-32768,    58,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,    66,   -35,    44,-32768,-32768
};


#define	YYLAST		156


static const short yytable[] = {    32,
    95,    64,    86,    37,    38,    39,   111,    68,    76,    77,
    78,   106,    94,   129,   131,    33,   107,    87,   130,   107,
   136,   122,   107,    63,    79,     1,   113,    64,    80,    93,
     2,     3,    69,    94,    40,    34,   105,    36,   114,    35,
   115,   113,     4,     5,     6,     7,   102,    41,     8,     9,
    10,    11,    12,   114,    13,   115,    14,    45,    15,    42,
    16,    43,    17,   103,    95,    96,   116,    65,   117,    46,
   132,    47,   124,   125,   126,   107,    83,    84,    85,    66,
    63,   116,     1,   127,    48,    58,    59,     2,     3,   133,
    97,    98,    99,    67,   107,    49,    50,    51,    52,     4,
     5,     6,     7,    74,    75,     8,     9,    10,    11,    12,
    71,    13,    70,    14,    72,    15,    89,    16,     1,    17,
    88,   100,   104,     2,     3,    91,   101,   108,   109,   110,
   120,   134,   135,   128,   137,     4,     5,     6,     7,    44,
   119,     8,     9,    10,    11,    12,    90,    13,   112,    14,
   123,    15,   118,    16,     0,    17
};

static const short yycheck[] = {     1,
    54,    18,    20,     7,     8,     9,    39,    12,    17,    18,
    19,    39,    45,    39,    39,     7,    44,    35,    44,    44,
     0,    43,    44,     3,    33,     5,    11,    44,    37,    41,
    10,    11,    37,    45,    38,     7,    72,    51,    23,     7,
    25,    11,    22,    23,    24,    25,    63,    51,    28,    29,
    30,    31,    32,    23,    34,    25,    36,    11,    38,     7,
    40,     7,    42,    65,   118,    21,    51,     4,    53,    23,
    39,    25,   108,   109,   110,    44,    14,    15,    16,     6,
     3,    51,     5,    53,    38,    26,    27,    10,    11,    39,
    46,    47,    48,    37,    44,    49,    50,    51,    52,    22,
    23,    24,    25,    38,    39,    28,    29,    30,    31,    32,
    13,    34,    37,    36,    42,    38,    39,    40,     5,    42,
    37,    43,    38,    10,    11,    49,    44,    38,    38,    38,
    23,    23,    23,    54,     0,    22,    23,    24,    25,    15,
   101,    28,    29,    30,    31,    32,    48,    34,    91,    36,
   107,    38,    94,    40,    -1,    42
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/local/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 61:
#line 139 "filter.y"
{
      long int val;
      char *s, *p;
      p = yyvsp[0].sval;
      val = strtol(p, &s, 10);
      if ((val < 0) || (val > 65535)) {
          syntax_error("pref value \"%s\" is not between 0 and 65535", p);
      }
;
    break;}
case 62:
#line 150 "filter.y"
{
      long int val;
      char *s, *p;
      p = yyvsp[0].sval;
      val = strtol(p, &s, 10);
      if ((val < 0) || (val > 65535)) {
          syntax_error("med value \"%s\" is not between 0 and 65535", p);
      }
;
    break;}
case 64:
#line 162 "filter.y"
{
      long int val;
      char *s, *p;
      p = yyvsp[0].sval;
      val = strtol(p, &s, 10);
      if ((val < 0) || (val > 65535)) {
          syntax_error("dpa value \"%s\" is not between 0 and 65535", p);
      }
;
    break;}
case 81:
#line 199 "filter.y"
{
      unsigned long int val;
      char *s, *p;
      p = yyvsp[0].sval;
      val = strtoul(p, &s, 10);
      if ((val < 1) || (val > 4294967295UL) || (*s != '\0')) {
          syntax_error("community element \"%s\" is not between 1 and 4294967295",
                       p);
      }
;
    break;}
case 85:
#line 216 "filter.y"
{
      long int val;
      char *s, *p;
      p = yyvsp[0].sval;
      val = strtol(p, &s, 10);
      if ((val < 0) || (val > 65535)) {
          syntax_error("cost value \"%s\" is not between 0 and 65535", p);
      }
;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/local/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 228 "filter.y"


/* define a unit test that simply returns "yes" or "no" for filter input */
#ifndef UNIT_TEST

#undef filtererror
#undef yyerror

int
filtererror (const char *s)
{
    yyerror(s);
    return 0;
}
#else /* UNIT_TEST */

int parse_error_count;

/* parse error */
void 
yyerror(const char *s)
{
    fputs(s, stderr);
    putc('\n', stderr);
    parse_error_count++;
}

/* syntax error */
void 
syntax_error(const char *fmt, ...)
{
    va_list args;
    char buf[1024];

    va_start(args, fmt);
    vsnprintf(buf, sizeof(buf), fmt, args);
    va_end(args);
    yyerror(buf);
}

int
yywrap()
{
    return 1;
}

/* taken from _lex & yacc_ p.157, by Levine, Mason, & Brown (corrected) */
char *myinputptr;
char *myinputlim;

#undef min
#define min(a, b)  (((a) < (b)) ? (a) : (b))

void
yy_input(char *buf, int *result, int max_size)
{
    int n = min(max_size, myinputlim - myinputptr);

    if (n > 0) {
        memcpy(buf, myinputptr, n);
        myinputptr += n;
    }
    *result = n;
}

/* program entry point */
int 
main()
{
    char buf[4096];

    setbuf(stdout, NULL);
    for (;;) {
        printf("filter> ");
        if (gets(buf) == NULL) {
            printf("\n");
            return(0);
        }
        parse_error_count = 0;
        myinputptr = buf;
        myinputlim = buf + strlen(buf);
        filterparse();
        printf("%d parse errors\n", parse_error_count);
    }
}
#endif /* UNIT_TEST */
