/***************************************
  $Revision: 1.3 $

  Subject line parsing 

  Status: NOT REVIEWED, TESTED

  Author(s):      Engin Gunduz 

  ******************/ /******************
  Modification History:
        engin (19/03/2001) Created.
  ******************/ /******************
  Copyright (c) 2001,2002                         RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/

#ifndef UP_SUBJECT_H
#define UP_SUBJECT_H 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <glib.h>

enum UP_KEYW_CLASSIFICATION{
  UP_KEYWORD_HELP = 0,   /* HELP or HOWTO     */
  UP_KEYWORD_NEW,        /* NEW keyword       */
  UP_KEYWORD_UNRECOG     /* All other strings */
};

enum UP_SUBJ_RESULT{
  UP_SUBJ_INIT = 0,      /* only to initialize in UP_subject_process function */
  UP_SUBJ_HELP_REQ,      /* Tells that help is requested in subject line */
  UP_SUBJ_NEW_ENFORCED,  /* Tells that NEW keyword is specified in subject line */
  UP_SUBJ_UNRECOG,       /* Tells that some unrecognised words found in subj line, 
                            (as well as recognised one[s]) */
  UP_SUBJ_ALL_UNRECOG,   /* Tells that all words were unrecognised ones (or subject
                            line was empty or non-existent */
  UP_SUBJ_INVALID_COMB   /* Tells that an invalid combination of keywords is
                            found */
};

#ifdef __cplusplus
extern "C" {
#endif


typedef struct _up_subject_struct{ 
   int result;       /* result of the subject processing */                        
   char * word_list; /* this is the list of keywords that aren't recognised */
} up_subject_struct;




up_subject_struct UP_subject_process(const char *subject_line);
up_subject_struct UP_subject_flags();

#ifdef __cplusplus
 }
#endif

#endif
