
#	$RCSfile: whois.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $

# This is a very simple whois client, but it knows the new server arguments

PERL5OPTIONS

require "getopts.pl";

GETLIB SRCDIR/whoisqry.pl;

&Getopts('aFg:h:i:LmMp:rs:St:T:');

if ((!@ARGV) && (!$opt_t) && (!$opt_g) && (!(($opt_g) && ($opt_t)))) {
    
    print <<"EOF";

Usage: whois [-aFLmMrSv] [-h hostname] [-s sources] [-T types] [-i attr] keys
       whois -t type

Where:

-a                         search all databases
-F                         fast raw output
-h hostname                search alternate server
-i attr[[,attr] ... ]      do an inverse lookup for specified attributes
-L                         find all Less specific matches
-m                         find first level more specific matches
-M                         find all More specific matches
-p port                    port to connect to
-r                         turn off recursive lookups
-s source[[,source] ... ]  search databases with source 'source'
-S                         tell server to leave out 'syntactic sugar'
-t type                    requests template for object of type 'type'
-T type[[,type] ... ]      only look for objects of type 'type'

Please note that most of these flags are NOT understood by
non RIPE whois servers
EOF
	exit(0);
}

if (!$opt_h) {
   $opt_h="WHOISHOST";
}

if ($opt_L) {
    print STDERR "whois: warning -L overrides -m\n" if $opt_m;
    print STDERR "whois: warning -L overrides -M\n" if $opt_M;
    $opt_m = 0;
    $opt_M = 0;
}

if ($opt_m) {
    print STDERR "whois: warning -m overrides -M\n" if $opt_M;
    $opt_M = 0;
}

local($query)="";

$query.="-a "            if ($opt_a);
#
#  undocumented option, get specified updates:
#
# -g Source:First-Last       get updates with 'Source' from 
#                            serial 'First' till 'Last' (you may use LAST)        
$query.="-g ".$opt_g." " if ($opt_g);
$query.="-F "            if ($opt_F);
$query.="-i ".$opt_i." " if ($opt_i);
$query.="-L "            if ($opt_L);
$query.="-m "            if ($opt_m);
$query.="-M "            if ($opt_M);
$query.="-r "            if ($opt_r);
$query.="-S "            if ($opt_S);
$query.="-s ".$opt_s." " if ($opt_s);
$query.="-t ".$opt_t." " if ($opt_t);
$query.="-T ".$opt_T." " if ($opt_T);

#
# tell the server what version of RIPE whois we are running,
# but only if we are sure that we are talking to an
# RIPE whois server

if (($opt_h=~ /(ripe\.net|ra\.net|apnic\.net|mci\.net|isi\.edu|garr\.it|ans\.net)$/i) ||
    $opt_a || $opt_g || $opt_F || $opt_i || $opt_m || $opt_M || $opt_L ||
    $opt_r || $opt_s || $opt_S || $opt_t || $opt_T) {
    
   $query.="-Vwp2.0 ";

}

$query.=join(" ",@ARGV);


#
# returning sockets doesn't work with perl4 so we use the global one ;-(

local($msg);

if ($msg=&initwhoisqry($opt_h,$opt_p?$opt_p:"",
                       $query,AF_INETVALUE,SOCKADDRVALUE,SOCK_STREAMVALUE)) {
   
   print STDERR $msg;
   exit 1;

}

#
# exit cleanly when asked to ...

sub quitconnection {
   
    close(WHOIS_S);
    print "\nConnection closed.\n";
    
    exit;

}

$SIG{'HUP'}='quitconnection';
$SIG{'INT'}='quitconnection';
$SIG{'KILL'}='quitconnection';
$SIG{'TERM'}='quitconnection';

while (<WHOIS_S>) {
    print;
}

close(WHOIS_S);

# end of program