#	$RCSfile: defines.pl,v $
#	$Revision: 2.1 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 17:52:39 $

$OK		=	1;
$NOK		=	0;
$EOF		=	99;

$LOCK_SH = 1;
$LOCK_EX = 2;
$LOCK_NB = 4;
$LOCK_UN = 8;

# Return codes for when trying to modify the database
# with explanatory messages. These are used deep down in the code
# just before or during updates, like dbadd.pl and updatecheck.pl.

$E_EXIST	 =	2;
$E_NOT_FOUND	 =	3;
$E_MULT_MATCH	 =	4;
$E_MISMATCH	 =	5;
$E_NOOP		 =	6;
$E_OLDER	 =	7;
$E_GUARDED	 =	8;
$E_AUTHFAIL      =      9;
$E_HIER_AUTHFAIL =     10;
$E_GENERAL       =     11;
$E_NOAUTOUPDATE  =     12;
$E_NOTNEW        =     13;
$E_STILLREFERENCED =   14;

$MESSAGE[$E_EXIST]	= "entry already exists";
$MESSAGE[$E_NOT_FOUND]	= "entry not found";
$MESSAGE[$E_MULT_MATCH]	= "more than one match";
$MESSAGE[$E_MISMATCH]	= "mismatch between update and original";
$MESSAGE[$E_NOOP]	= "update results in NOOP";
$MESSAGE[$E_OLDER]	= "update is older than original";
$MESSAGE[$E_AUTHFAIL]   = "authorisation failed, request forwarded to maintainer";
$MESSAGE[$E_HIER_AUTHFAIL] = "hierarchical authorisation failed, request forwarded to maintainer\nof object direct above the to be updated object in the hierarchy";
$MESSAGE[$E_NOAUTOUPDATE] = "object cannot be updated\/deleted automatically\nthe to be updated\/deleted object doesn\'t contain\na ".$ATTL{"mb"}." line.\nplease contact \<$HUMAILBOX\> for updating this object";
$MESSAGE[$E_GENERAL]    = "";
$MESSAGE[$E_NOTNEW]     = "object already exists";
$MESSAGE[$E_STILLREFERENCED] = "cannot delete object that is still referenced\nby other objects in one of the databases";

#
# Return codes for syntax checking the objects
#
# we could better have used one unified model for return codes
# but for the mean time we at least keep some aliases to
# avoid even more trouble

$O_OK		=	$OK;
$O_ERROR	=	$NOK;
$O_WARNING	=	22;

$O_INVALIDIP     =24;
$O_INVALIDPREFIX =25;
$O_INVALIDRANGE  =26;
$O_SYNTAXERROR   =27;

$O_NOTFOUND=28;
$O_COULDNOTOPEN=29; 


$MESSAGE[$O_OK]		=	"object OK";
$MESSAGE[$O_ERROR]	=	"object has errors";
$MESSAGE[$O_WARNING]	=	"object has warnings";

# Return codes for authorisation

$A_OK		=	1;	# Authorisation worked
$A_BAD		= 	0;      # Authorisation failed
$A_ERR  	=      -1;      # Authorisation Error condition

# protocol codes - not implemented
#
# $_AU_OK	= 100;		# Authorization OK
# $_AU_BAD	= 110;		# Authorization BAD
# $_AU_ERR	= 120;		# Authoization ERROR (cannot open file etc)
#
# $_I_GENERAL	= 200;		# General information
# $_I_DUNNO	= 210;		# "I don't know what you mean" message
# $_I_WAIT	= 220;		# Waiting for input ...
# $_I_RECVD	= 230;		# Have received something, will start
#				# processing now
#
# $_A_OK	= 300;		# Addition OK
# $_A_UNKNOWN	= 310;		# Addition general failures
# $_A_PERM	= 320;		# Addition permission denied
#
# $_D_OK	= 400;		# Deletion OK
# $_D_UNKNOWN	= 410;		# Deletion general failures
# $_D_PERM	= 420;		# Deletion permission denied
# $_D_NFOUND	= 430;		# Object not found for deletion
#
# $_M_OK	= 500;		# Modify OK
# $_M_UNKNNOWN	= 510;		# Modify general failures
# $_M_PERM	= 520;		# Modify permission denied
# $_M_NFOUND	= 530;		# Object not found for modification
#
# $_AM_OK	= 600;		# Add_or_modify OK
# $_AM_UNKNOWN	= 610;		# Add_or_modify general failures
# $_AM_PERM	= 620;		# Add_or_modify permission denied

#
# possible actions for an entry

$ADDACTION="ADD";
$DELETEACTION="DEL";
$CHANGEACTION="CHANGE";

#
# updatecheck, printstat, dbadd & dbdel binary options

$NEWOPTION=1;
$DELETEOPTION=2;
$MODIFYOPTION=4;
$OVERRIDEOPTION=8;
$NOCHECKSOPTION=16;
$OKOPTION=32;
$NOOPOPTION=64;
$FAILEDOPTION=128;
$BACKWARDCOMPATIBILITYOPTION=256;
$ASSIGNEDNICOPTION=512;

#
# donetdbm (binary) options

$CLASSLESSOPTION=1;
$CLEANOPTION=2;

#
# dbmatch & lookupandprint (binary) options

$INTERSECTIONOPTION=1;
$ALLLESSSPECIFICOPTION=2;
$MORESPECIFICOPTION=4;
$ALLMORESPECIFICOPTION=8;
$NONRECURSIVEOPTION=16;
$FASTOPTION=32;
$NOSYNTACTICSUGAR=64;
$EXACTMATCHOPTION=128;

#
# The version of the inputformat we default to

$UPDATEVERSION=1;

#
# Supported update versions

@UPDATEVERSIONS=($UPDATEVERSION);

#
# The file extension for the current serial number files 

$CURRENTEXTENSION=".CURRENTSERIAL";

#
# The file extension for the oldest available serial number files 

$OLDESTEXTENSION=".OLDESTSERIAL";

#
# used for fast computations in range2prefix

$ONEDIVLOG2=1/log(2);

#
# very tiny value for rounding of real values in range2prefix

$TINYLOGVALUE=(32-(log(2**32-1)*$ONEDIVLOG2))/100;


#
# the maximal number of country attributes on a line

$MAXCOUNTRIES=12;

#
# The maximal length of a key measured in characters that is *not* indexed

$SMALLESTKEY=1;

#
# maximal number of initials for NIC handles

$MAXLENGTHINITIALS=4;

#
# which characters are valid for an attribute 
# Note: the * is for the error attribute!

$VALIDATTRCHAR='\w\-\*';

#
# valid domain name regular expression

$DOMAINNAME='[a-zA-Z\d]+([\.\-][a-zA-Z\d]+)*'; 

#
# valid source attribute regular expression

$SOURCENAME='[A-Z][A-Z\d\-]+';

#
# the prefix that is used for auto nichandle assignments

$AUTONICPREFIX="AUTO-";
$AUTONICPREFIXREGULAR='AUTO\-';

#
# some common titles - only use lower case

$TITLES='(m[rs]s?|drs?|ir|ing|sign|herr|hr|frau|prof\S*)\.? +';

#
#

$SPLITFILENAME='^\s*(\S+\/)?([^\/\s]+)\s*$';

#
# ip regular expressions

#
# generic

$VALIDPREFIX='[\d\:a-f]+\/\d+';

$VALIDPREFIXKEY=$VALIDPREFIX;


# this one has interesting (but no fatal) problems with perl5 & grep, see whoisd

$VALIDIP4='0*(1?[1-9]?\d|[12][0-4]\d|25[0-5])(\.0*1?[1-9]?\d|\.0*[12][0-4]\d|\.0*25[0-5]){0,3}';

$VALIDIP4PREFIX=$VALIDIP4.'\/\d+';

$VALIDIP4PREFIXKEY='\d+\/\d+';

#
# for ipv6

$VALIDIP6='[\da-f]{1,4}(\:[\da-f]{1,4}){7}';

$VALIDIP6PREFIX='[\d\:a-f]+\:[\d\:a-f]+\/\d+';

$VALIDIP6PREFIXKEY=$VALIDIP6.'\/\d+';


#
# the attribute value to be used for deleted objects

$DELETEDOBJECT="XX";

#
# what is the extension for classless databases ?

$CLASSLESSEXT=".cl";


#
# what is the extension for the overflow files ?

$OVERFLOWEXTENSION=".overflow.";

#
# what is the key for finding a new overflow number

$OVERFLOWKEY="\t";

#
# what is the prefix before the offset when we find an overflow instead
# of offset values

$OVERFLOWPREFIX="\t";
$OVERFLOWPREFIXREGULAR='\t';

#
# NOTEXISTINGPREFIXESKEY 
#
# key to find the list of existing prefixes

$NOTEXISTINGPREFIXESKEY=$OVERFLOWKEY.$OVERFLOWKEY;

#
# which string do we use as 'binding' for uniquekeys

$UNIQUEKEYBINDING="\t";

#
# maximal number of entries/objects that we read & process at a time
#
# entries/objects are stored in a list of this length

$MAXLISTLENGTH=7500;

#
# this value determines the maximal length of a string 
# during processing
#
# usually we are talking about prefix keys:
#
# example: 536870912/8
#
# that is components are about 10 bytes long
# and the maximal string length is thus 10*$MAXSTRINGCOMPONENTS
#
# the more components we allow, the longer in memory copies take
# the less components we allow, the more disk accesses we need

$MAXSTRINGCOMPONENTS=200;

#
# Masks for IP addresses

@masks = (0x0,
          0x80000000, 0xc0000000, 0xe0000000, 0xf0000000,
	  0xf8000000, 0xfc000000, 0xfe000000, 0xff000000,
	  0xff800000, 0xffc00000, 0xffe00000, 0xfff00000,
	  0xfff80000, 0xfffc0000, 0xfffe0000, 0xffff0000,
	  0xffff8000, 0xffffc000, 0xffffe000, 0xfffff000,
	  0xfffff800, 0xfffffc00, 0xfffffe00, 0xffffff00,
	  0xffffff80, 0xffffffc0, 0xffffffe0, 0xfffffff0,
	  0xfffffff8, 0xfffffffc, 0xfffffffe, 0xffffffff );

%ipv6zeroes= ( "0", 4, 
               "1", 0,
               "2", 1,
               "3", 0,
               "4", 2,
               "5", 0,
               "6", 1,
               "7", 0,
               "8", 3,
               "9", 0,
               "a", 1,
               "b", 0,
               "c", 2,
               "d", 0,
               "e", 1,
               "f", 0
              );
             
#
# three arrays contain: 
#
# hexadecimal masks with ^0x1
# hexadecimal masks with ^0x3
# hexadecimal masks with ^0x7             
              
%ipv6masks1= ("0", "0",
              "1", "0",
              "2", "2",
              "3", "2",
              "4", "4",
              "5", "4",
              "6", "6",
              "7", "6",
              "8", "8",
              "9", "9",
              "a", "a",
              "b", "a",
              "c", "c",
              "d", "c",
              "e", "e",
              "f", "e");

%ipv6masks2= ("0", "0",
              "1", "0",
              "2", "0",
              "3", "0",
              "4", "4",
              "5", "4",
              "6", "4",
              "7", "4",
              "8", "8",
              "9", "8",
              "a", "8",
              "b", "8",
              "c", "c",
              "d", "c",
              "e", "c",
              "f", "c");

%ipv6masks3= ("0", "0",
              "1", "0",
              "2", "0",
              "3", "0",
              "4", "0",
              "5", "0",
              "6", "0",
              "7", "0",
              "8", "8",
              "9", "8",
              "a", "8",
              "b", "8",
              "c", "8",
              "d", "8",
              "e", "8",
              "f", "8");

1;