
/* 
 * @(#)main.c	1.24 6/11/96
 */

#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>

#include "def.h"
#include "buffers.h"
#include "message.h"

FILE	*mail_fp;

extern	MESSAGE_LIST	messages;
extern	PROC	procs[];
extern	BUFFER	stdout_messages;
extern	char	our_domain[];

char	*our_userid;
char	home_dir[] = HOME;
char	www_home[] = WWWHOME;
char	user_name[] = USERNAME;

#ifdef OTHER_DOMAIN
char	other_domain[] = OTHER_DOMAIN;
#endif
char	default_mail_file [] = MAIL_FILE;

#ifndef PGPTOOLS
static	char	pgp_exec [] = PGPEXEC;
#endif

static	char	*mail_args[] =

{
	"/usr/lib/sendmail",
	"-t",
	NULL
};

static	char	*uu_args [] = 

{
	"/usr/bin/uuencode",
	NULL,
	NULL,
	NULL,
};

static	char	indent[] = "\n> ";

static	char	footer[] = "\n--\nProcessed by Mark's Mailbot (http://www.c2.org/~mark/mailbot/)\n";

static	int	read_line (fp, l)

FILE	*fp;
char	*l;

{
	int	c;

	while ((c = getc(fp)) != EOF && c != '\n')
		*l++ = c;
	*l = 0;

	return (c == EOF);
}

static	void	reply_to (b, m, s, u, r)

BUFFER	*b;
MESSAGE	*m;
char	*s, *u, *r;

{
	char	line[1024];
	char	*to;

	to = m->email;
	if (m->reply_to)
		to = m->reply_to;

	sprintf (line, "From: %s@%s\n", u, our_domain);
	string_to_buffer (b, line);
	sprintf (line, "To: %s\n", to);
	string_to_buffer (b, line);
	sprintf (line, "Subject: %s\n", s);
	string_to_buffer (b, line);
	sprintf (line, "Reply-To: %s@%s\n\n", r, our_domain);
	string_to_buffer (b, line);
}

int	bounce_message (m, u, r, sub)

MESSAGE	*m;
char	*r, *u, *sub;

{
	BUFFER	*b, *mc;
	char	line[1024];
	char	*to, *s;
	int	i, l;
	int	status;

	if (!sub)
		sub = r;

	to = m->email;
	if (m->reply_to)
		to = m->reply_to;
	if (m->errors_to)
		to = m->errors_to;

	b = new_buffer ();
	sprintf (line, "From: postmaster@%s\n", our_domain);
	string_to_buffer (b, line);
	sprintf (line, "To: %s\n", to);
	string_to_buffer (b, line);
	sprintf (line, "Subject: %s\n", sub);
	string_to_buffer (b, line);
	sprintf (line, "Reply-To: /dev/null@%s\n", our_domain);
	string_to_buffer (b, line);

	string_to_buffer (b, "\n\nMessage processing failed because:\n\n");
	string_to_buffer (b, r);
	sprintf (line, "\n\nSend mail to help@%s for helpfile.", our_domain);
	string_to_buffer (b, line);
	string_to_buffer (b, "\n\nOriginal message follows :\n\n");

	s = (char *)m->header->message;
	l = m->header->length;

	while (l) {
		i = 0;
		while (l && *s != '\n') {
			l--;
			line [i++] = *s++;
		}
		if (l) {
			l--;
			s++;
		}
		line[i] = 0;

		if (strncmp (line, "Received:", 9)) {
			string_to_buffer (b, indent);
			string_to_buffer (b, line);
		}
	}

	string_to_buffer (b, indent);

	mc = message_contents (m);
	l = mc->length;
	s = (char *)mc->message;

	while (l) {
		string_to_buffer (b, indent);
		while (*s != '\n' && l) {
			add_to_buffer (b, s++, 1);
			l--;
		}
		if (l) {
			s++;
			l--;
		}
	}

	string_to_buffer (b, footer);
	status = run_program(mail_args[0],b->message,
			b->length,mail_args,NULL);
	free_buffer (b);

	return !status;
}

/* Look for bad path */

static	int	check_path (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	char	fail[1024];

	if (strstr (s, "..")) {
		sprintf(fail, "Dodgy path %s", s);
		bounce_message (m, u, fail, NULL);

		return TRUE;
	}

	if (access (s, R_OK)) {
		sprintf (fail, "No such file %s", s);
		bounce_message (m, u, fail, NULL);

		return TRUE;
	}

	return FALSE;
}

int	send_html (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	BUFFER	*b;
	int	fd, status;
	char	subj[1024];
	char	local[1024];
	char	line[1024];
	char	filename[1024];
	char	uufile[1024];
	int	encoded = FALSE;
	int	l;

	if (!m->subject) {
		return bounce_message (m, u, "Must include file path in subject", NULL);
	}

	s = m->subject;

	/* Strip the prefix if they included it */

	if (!strncmp (s, www_home, strlen(www_home)))
		s += strlen(www_home);

	sprintf(local, "%s/public_html/%s", home_dir, s);

	if (check_path (m, u, local))
		return TRUE;

	/* Check for a .htaccess file */

	strcpy (line, local);
	l = strlen (line) - 1;
	while (l && line[l] != '/')
		l--;

	strcpy (filename, line + l + 1);

	sprintf(line + l, "/.htaccess");
	if (!access (line, F_OK)) {
		char	fail [1024];
		
		sprintf(fail, "Access denied to %s/%s", www_home,
			s);
		return bounce_message (m, u, fail, NULL);
	}

	/* Check suffix */

	l = strlen (filename) - 1;
	while (l && filename[l] != '.')
		l--;

	if (!strcmp (filename + l, ".gif") ||
		!strcmp (filename + l, ".jpg") ||
		!strcmp (filename + l, ".jpeg") ||
		!strcmp (filename + l, ".mpeg") ||
		!strcmp (filename + l, ".mpg")) {

		/* We need to uuencode this ! */

		uu_args[1] = local;
		uu_args[2] = filename;

		status = run_program(uu_args[0],local,
			0,uu_args,NULL);

		if (status)
			return FALSE;

		sprintf(uufile, "/tmp/uu.%d.%d", time(0), getpid());
		fd = open (uufile, O_WRONLY|O_CREAT, 0600);

		if (!fd)
			return FALSE;

		if (write (fd, stdout_messages.message, 
			stdout_messages.length) != stdout_messages.length) {
			close (fd);
			unlink (uufile);
			return FALSE;
		}
		close (fd);

		strcpy (local, uufile);
		encoded = TRUE;
	}

	/* Now copy the file */

	fd = open (local, O_RDONLY);
	if (fd < 0) {
		char	fail[1024];

		sprintf (fail, "No such file %s/%s", www_home, s);
		return bounce_message (m, u, fail, NULL);
	}

	b = new_buffer();
	sprintf(subj, "File %s/%s", www_home, s);
	reply_to (b, m, subj, u, u);

	do {
		l = read (fd, line, 1024);
		add_to_buffer (b, line, l);
	} while (l > 0);

	close (fd);

#ifndef SAFE
	if (encoded)
		unlink (uufile);
#endif

	/* Call Sendmail */

	string_to_buffer (b, footer);
	status = run_program(mail_args[0],b->message,
			b->length,mail_args,NULL);
	free_buffer (b);

	return !status;
}

/* Process an update on what I'm doing */

int	process_update (m, u, f)

MESSAGE	*m;
char	*f, *u;

{
	BUFFER	*decrypted, *sign;
	int	status;
	char	filename[1024];
	char	line[1024];
	char	l[1024];
	char	url[1024];
	char	*s;
	char	*sub, *dat;
	int	fd, i;
	FILE	*fp;
	static	char	latest[] = "\tLatest Info\n\t===========\n\n";
	static	char	date[] = "\nDate: ";
	static	char	subject[] = "\nSubject: ";
	static	int	count = 0;
	BUFFER	*b, *acc;
	char	datafile[1024];
	char	lockfile[1024];
	char	fail[4096];
	int	cnt = 250;

	if (!(m->flags & (MESS_SIGNED|MESS_ENCRYPTED))) {
		char	fail[1024];

		sprintf(fail, "No such user : %s", m->to);
		return bounce_message (m, u, fail, NULL);
	}

	decrypted = new_buffer ();
	sign = new_buffer ();

	status = decrypt_message (message_contents(m), decrypted,
		sign, NULL, FL_ASCII, NULL);

	if (status != SIG_GOOD) {
		free_buffer (decrypted);
		sprintf(fail, "Bad PGP Signature!\nStatus: %d, errors: %s", 
			status,
			sign->message);
		free_buffer (sign);
		return bounce_message (m, u, fail, "Bad PGP Signature");
	}

	free_buffer (sign);
	sprintf(filename, "%s/data/latest.txt", home_dir);
	fd = open (filename, O_WRONLY|O_CREAT, 0600);

	if (fd < 0)  {
		free_buffer (decrypted);
		return FALSE;
	}

	write (fd, latest, strlen (latest));

	sub = m->subject;
	if (!sub)
		sub = "No Subject";
	dat = m->date;
	if (!dat)
		dat = "No Date";

	write (fd, subject, sizeof(subject));
	write (fd, sub, strlen (sub));

	write (fd, date, sizeof(date));
	write (fd, dat, strlen (dat));

	write (fd, "\n\n", 2);

	if (write (fd, decrypted->message, decrypted->length) !=
		decrypted->length) {
		free_buffer (decrypted);
		close (fd);
		unlink (filename);
		return FALSE;
	}

	close (fd);

	i = 0;
	do {
		sprintf (url, "%s/%d.%d.%d.html", u,
			time (0), getpid(), 
			count++);
		sprintf (filename, "%s/public_html/%s", home_dir, url);
		fp = fopen (filename, "wt");
	} while (!fp && i++ < 100);

	if (!fp) {
		free_buffer (decrypted);
		return FALSE;
	}

	if (strncasecmp(decrypted->message, "<HTML>", 6)) {
		int	italics = FALSE;
		int	new_para = TRUE;
		int	indented = FALSE;
	
		/* Ok, now we have an html file */

		fprintf(fp, "<HTML>\n<BODY BACKGROUND=../world.gif>");
		fprintf(fp, "<TITLE>%s</TITLE>\n", sub);
		fprintf(fp, "<CENTER><H1>%s</H1></CENTER>\n", sub);

		fprintf(fp, "<FONT SIZE=+1>\n");
		s = (char *)decrypted->message;
		i = decrypted->length;
		while (i && *s) {
			if (new_para && !isspace (*s)) {
				fprintf(fp, "<FONT SIZE=+2>%c</FONT>", *s);
				new_para = FALSE;
				goto next_char;
			}
			if (*s == '\n') {
				fputc (*s, fp);
				if (s[1] == '\n') {
					fprintf(fp, "\n<P>");
					s++;
					i--;
				}
				if (*s && s[1] == '-' && s[2] == '-') {
					fprintf (fp, "<UL>\n");
					s += 2;
					i -= 2;
					indented = TRUE;
				}
				else if (indented) {
					fprintf (fp, "</UL>\n");
					indented = FALSE;
				}
			}
			else if (*s == '*') {
				if (italics) 
					fprintf (fp, "</I>");
				else 
					fprintf (fp, "<I>");
				italics = !italics;
			}
			else if (*s == ';' || *s == '8') {
				if (s[1] == '-' && s[2] == ')') {
					fprintf(fp, "<IMG SRC=\"%s/images/smiley.gif\" width=11 height=11 alt=\"%c-)\">", www_home, *s);
					s += 2;
					i -= 2;
				}
				else
					fputc (*s, fp);
			}
			else
				fputc (*s, fp);

		next_char:
			s++;
			i--;
		} 

		fprintf(fp, "</FONT></BODY><HR>\n");
		fprintf(fp, "<A HREF=%s/contact.html>", www_home);
		fprintf(fp, "<IMG SRC=%s/images/email1.gif ", www_home);
		fprintf(fp, "width=89 height=26 align=left alt=\"Contact Info\"></A>\n");
		fprintf(fp, "Created: %s<BR>\n", dat);
		fprintf(fp, "<ADDRESS>\n");
		fprintf(fp, "<A HREF=%s>%s</A>\n", www_home, user_name);
		fprintf(fp, "</HTML>\n");
	}
	else {
		fwrite ((char *)decrypted->message, decrypted->length,
			1, fp);
	}
	fclose (fp);

	chmod (filename, 0644);

	sprintf (datafile, "%s/data/%s/%s.dat", home_dir, u, u);
	sprintf (lockfile, "%s.lock", datafile);

	while ((fd = creat (lockfile, 0) < 0) && --cnt > 0)
		sleep (50000);

	if (cnt)
		close (fd);

	fp = fopen (datafile, "at");
	if (!fp) {
		unlink (filename);
		unlink (lockfile);
		return FALSE;
	}

	fprintf (fp, "%s/%s\n", www_home, url);
	fprintf (fp, "%s (%s)\n", sub, dat);

	fclose (fp);

	unlink (lockfile);

	b = new_buffer ();
	acc = new_buffer ();
	reply_to (acc, m, "Update accepted", u, u);

	string_to_buffer (acc, "Update \`");
	string_to_buffer (acc, sub);
	string_to_buffer (acc, "\' accepted as ");
	string_to_buffer (acc, url);
	string_to_buffer (acc, ".\n\n");
	string_to_buffer (acc, "Sent to:\n");

	/* Now we have to send the message to all subscribers */

	/* First we find the mailing list file */

	if (*f != '/')
		sprintf (filename, "%s/%s", home_dir, f);
	else
		strcpy (filename, f);

	/* And lock it */

	sprintf (lockfile, "%s.lock", filename);
	while ((fd = creat (lockfile, 0)) < 0 && --cnt > 0)
		usleep (50000);

	if (cnt)
		close (fd);

	fp = fopen(filename, "rt");

	if (fp) {
		clear_buffer (b);
		while (!feof(fp)) {

			/* Read each address */

			if (!read_line (fp,l)) {

				/* Aargh, we're hard-coded */

				sprintf (line, "From: %s-list@%s\n", 
					u, our_domain);
				string_to_buffer (b, line);
				sprintf (line, "To: %s\n", l);
				string_to_buffer (b, line);
				string_to_buffer (acc, "\t");
				string_to_buffer (acc, l);
				string_to_buffer (acc, "\n");
				if (m->subject)
					sprintf (line, "Subject: %s\n", 
						m->subject);
				else
					strcpy (line, "Subject: No Subject\n");
				string_to_buffer (b, line);
				sprintf (line, "Reply-To: %s@%s\n", 
					our_userid,
					our_domain);
				string_to_buffer (b, line);

				add_to_buffer (b, decrypted->message,
					decrypted->length);

				sprintf (line, "\n\nTo unsubscribe, send mail to %s-list@unicorn.com with a\n", u);
				string_to_buffer (b, line);
				string_to_buffer (b, "subject of 'unsubscribe ");
				string_to_buffer (b, l);
				string_to_buffer (b, "' (no quotes).\n");
				string_to_buffer (b, "If ");
				string_to_buffer (b, l);
				string_to_buffer (b, " is a mailing list, then all recipients of\n");
				string_to_buffer (b, "that list will be unsubscribed from the update list.\n");

				string_to_buffer (b, footer);
				status = run_program(mail_args[0],b->message,
					b->length,mail_args,NULL);
				clear_buffer (b);
			}
		}
		fclose (fp);
	}

	unlink (lockfile);

	string_to_buffer (acc, footer);
	run_program(mail_args[0],acc->message, acc->length,mail_args,NULL);
	free_buffer (acc);

	free_buffer (decrypted);
	free_buffer (b);

	return TRUE;
}

#define	RES_SUB		1
#define RES_UNSUB	2
#define RES_HELP	3
#define RES_NONE	0

static	int	check_line (s)

char	*s;

{
	if (!strncasecmp (s, "sub", 3)) {
		return RES_SUB;
	}
	if (!strncasecmp (s, "unsub", 5)) {
		return RES_UNSUB;
	}
	if (!strncasecmp (s, "help", 4) ||
		!strncasecmp (s, "info", 4)) {
		return RES_HELP;
	}
	return RES_NONE;
}

int	process_update_list (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	char	**update_list;
	int	update_list_size;
	int	update_count;
	char	filename[1024];
	char	lockfile[1024];
	char	newfile[1024];
	char	line[1024];
	int	cnt = 500;
	int	res;
	FILE	*fp;
	char	*p = NULL;
	char	*c;
	int	i;
	int	fd;

	/* process the message */

	res = RES_NONE;
	if (m->subject) {
		res = check_line (p = m->subject);
	}
	if (res == RES_NONE) {
		BUFFER	*mc;

		mc = message_contents (m);
		if (mc)
			res = check_line (p = (char *)mc->message);
	}

	/* Send help file */

	if (res == RES_HELP) {
		sprintf(filename, "%s/data/list.help", home_dir);
		return send_file (m, u, filename);
	}

	/* OK, find the address !*/

	while (!isspace(*p) && *p)
		p++;

	if (*p)
		while (*p && isspace (*p))
			p++;
	
	if (!*p)
		p = m->email;

	/* We don't understand the message here, so pass it through */

	if (!s || !p || res == RES_NONE) {
		return save_message (m, u, default_mail_file);
	}

	/* Erase anything at the end of the address */

	c = p;
	while (!isspace(*c))
		c++;
	*c = 0;

	/* Lock the data file */

	if (*s != '/')
		sprintf (filename, "%s/%s", home_dir, s);
	else
		strcpy (filename, s);
	
	sprintf (lockfile, "%s.lock", filename);
	while ((fd = creat (lockfile, 0)) < 0 && --cnt > 0)
		usleep (50000);

	if (cnt)
		close (fd);

	update_list_size = 1024;
	if (!(update_list = (char **)malloc (update_list_size * sizeof (char *)))) {
		unlink (lockfile);
		return FALSE;
	}

	fp = fopen (filename, "rt");
	if (!fp) {
		free (update_list);
		unlink (lockfile);
		return FALSE;
	}

	/* read the list */

	while (!feof(fp)) {
		read_line (fp, line);
		if (!feof(fp)) {
			update_list[update_count++] = strdup (line);
			if (update_count == update_list_size) {
				update_list_size += 1024;
				if (!(update_list = (char **)realloc (update_list,
					update_list_size * sizeof (char *)))) {
					unlink (lockfile);	
					return FALSE;
				}
			}
		}
	}

	fclose (fp);

	/* Are we already there? */

	for (i = 0; i < update_count; i++) {
		if (update_list[i] && !strcasecmp (update_list[i], p)) {
			free (update_list[i]);
			update_list[i] = NULL;
		}
	}

	sprintf (newfile, "%s.%d.new", filename, getpid());
	fp = fopen (newfile, "wt");
	if (!fp) {
		unlink (lockfile);
		return FALSE;
	}

	chmod (newfile, 0644);

	if (res == RES_SUB)
		fprintf (fp, "%s\n", p);
	for (i = 0; i < update_count; i++) {
		if (update_list[i]) {
			fprintf (fp, "%s\n", update_list[i]);
			free (update_list[i]);
		}
	}
	free (update_list);

	if (ferror (fp)) {
		fclose (fp);
		unlink (lockfile);
		unlink (newfile);
		return FALSE;
	}

	fclose (fp);

	rename (newfile, filename);
	unlink (lockfile);

	if (res == RES_SUB) {
		sprintf (newfile, "%s.sub", filename);
	}
	else
		sprintf (newfile, "%s.unsub", filename);

	/* Fake a reply-to: line so that we reply to the correct
	   person */

	if (m->reply_to)
		free (m->reply_to);

	m->reply_to = strdup (p);

	return send_file (m, u, newfile);
}

int	process_www_update (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	BUFFER	*decrypted, *sign;
	int	status;
	char	filename[1024];
	char	local[1024];
	char	fail[4096];
	int	fd, i;
	FILE	*fp;
	BUFFER	*b;

	if (!m->subject) {
		return bounce_message (m, u, "Must include file path in subject", NULL);
	}

	if (!(m->flags & (MESS_SIGNED|MESS_ENCRYPTED))) {
		char	fail[1024];

		sprintf(fail, "No such user : %s", m->to);
		return bounce_message (m, u, fail, NULL);
	}

	decrypted = new_buffer ();
	sign = new_buffer ();

	status = decrypt_message (message_contents(m), decrypted,
		sign, NULL, FL_ASCII, NULL);

	if (status != SIG_GOOD) {
		free_buffer (decrypted);
		sprintf(fail, "Bad PGP Signature!\nStatus: %d, errors: %s", 
			status, sign->message);
		free_buffer (sign);
		return bounce_message (m, u, fail, "Bad PGP Signature");
	}

	free_buffer (sign);
	s = m->subject;

	/* Strip the prefix if they included it */

	if (!strncmp (s, www_home, strlen(www_home)))
		s += strlen(www_home);

	sprintf(local, "%s/public_html/%s", home_dir, s);

	if (strstr (local , "..")) {
		char	fail[1024];

		sprintf(fail, "Dodgy path %s", s);
		bounce_message (m, u, fail, NULL);

		free_buffer (decrypted);

		return TRUE;
	}

	/* We now have the data and the file */

	sprintf(filename, "%s.tmp", local);

	/* We need to check that all directories exist */

	fd = open (filename, O_WRONLY|O_CREAT, 0644);

	if (fd < 0) {
		char	fail[1024];

		free_buffer (decrypted);

		sprintf(fail, "Cannot open %s", filename);
		return bounce_message (m, u, fail, NULL);
	}

	if (write (fd, decrypted->message, decrypted->length) !=
		decrypted->length) {
		close (fd);
		free_buffer (decrypted);
		return FALSE;
	}

	close (fd);
	free_buffer (decrypted);

	/* Copy the file over */

	if (rename (filename, local) < 0) {
		unlink (filename);
		return FALSE;
	}

	/* Tell the sender that we accepted it */

	b = new_buffer ();
	reply_to (b, m, "WW update accepted", u, u);

	string_to_buffer (b, "WWW update to ");
	if (m->subject)
		string_to_buffer (b, m->subject);
	string_to_buffer (b, " accepted.\n");

	string_to_buffer (b, footer);
	run_program(mail_args[0],b->message, b->length,mail_args,NULL);

	free_buffer (b);
	return TRUE;
}

/* Send a file to the person who mailed us */

int	send_file (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	BUFFER	*b;
	int	fd, status;
	char	subj[1024];
	char	local[1024];
	char	line[1024];
	int	l;

	/* If it doesn't begin with a /, then it's a local file */

	if (*s != '/') {
		sprintf(local, "%s/%s", home_dir, s);
		s = local;
	}

	if (check_path (m, u, s))
		return TRUE;

	fd = open (s, O_RDONLY);
	if (fd < 0) {
		char	fail[1024];

		sprintf (fail, "No such file %s", s);
		return bounce_message (m, u, fail, NULL);
	}

	b = new_buffer();
	if (m->subject)
		sprintf (subj, "Re: %s", m->subject);
	else
		sprintf(subj, "File %s", s);

	reply_to (b, m, subj, u, u);

	do {
		l = read (fd, line, 1024);
		add_to_buffer (b, line, l);
	} while (l > 0);

	close (fd);

	/* Call Sendmail */

	string_to_buffer (b, footer);
	status = run_program(mail_args[0],b->message,
			b->length,mail_args,NULL);
	free_buffer (b);

	return !status;
}

/* Just junk the message */

int	junk_message (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	return TRUE;
}

int	save_message (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	char	local[1024];

	/* If it doesn't begin with a /, then it's a local mail file */

	if (*s != '/') {
		sprintf(local, "%s/mail/%s", home_dir, s);
		s = local;
	}

	if (!append_message_to_file (m, s))
		return TRUE;
	return FALSE;
}

#define MAX_SIZE 65535

int	maybe_save_message (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	char	local[1024];
	struct	stat	st;
	BUFFER	*mc;

	/* If it doesn't begin with a /, then it's a local mail file */

	if (*s != '/') {
		sprintf(local, "%s/mail/%s", home_dir, s);
		s = local;
	}

	if (!stat (s, &st)) {
		mc = message_contents (m);
		if (st.st_size + mc->length > MAX_SIZE) {
			char	fail[1024];

			sprintf(fail, "Mail quota exceeded for user %s", u);
			bounce_message (m, u, fail, NULL);
			return TRUE;
		}
	}

	return save_message (m, u, s);
}

int	process_message (m, uid, email)

MESSAGE	*m;
char	*uid;
char	*email;

{
	PROC	*p;
	char	fail [1024];

	/* Just in case */

	sprintf(fail, "No such user : %s", email);
	update_random ();

	p = procs;
	while (p->uid) {
		if (!strcmp (p->uid, uid)) {
			return (*p->proc) (m, uid, p->data);
		}
		p++;
	}
	bounce_message (m, uid, fail, NULL);

	return TRUE;
}

static	int	count_uids (s)

char	*s;

{
	int	n;
	int	quoted = FALSE;

	if (!s)
		return 0;

	n = 0;
	while (*s) {
		while (*s == ' ' || *s == '\t')
			s++;
		if (*s)
			n++;
		while (*s && (*s != ',' || quoted)) {
			if (*s == '\"')
				quoted = !quoted;
			s++;
		}
		if (*s)
			s++;
	}

	return n;
}

static	char	**extract_uids (n, s)

char	**n;
char	*s;

{
	char	*e, *c;
	int	quoted = FALSE;

	if (!s)
		return (n);

	while (*s) {
		while (*s == ' ' || *s == '\t')
			s++;
		if (*s) {
			e = s;
			while (*e && (quoted || *e != ',')) {
				if (*e == '\"')
					quoted = !quoted;
				e++;
			}

			*n = c = malloc (e - s + 1);

			/* Abort if malloc fails */

			if (!c) {
				exit (1);
			}
		
			while (s != e)
				*c++ = *s++;

			if (*s)
				s++;
	
			*c = 0;
			n++;
		}
	}

	return n;
}

static	char	**get_uids (m)

MESSAGE	*m;

{
	int	n;
	char	**uids;
	char	**nids;

	n = count_uids (m->to) + count_uids (m->cc) +
		count_uids (m->apparently_to);

	if (!n)
		return NULL;

	uids = (char **)malloc ((n + 1) * sizeof (char *));

	if (!uids) {
		exit (1);
	}

	nids = extract_uids (uids, m->to);
	nids = extract_uids (nids, m->cc);
	nids = extract_uids (nids, m->apparently_to);
	*nids = NULL;

	return uids;
}

static	void	free_uids (u)

char	**u;

{
	char	**s;

	s = u;
	while (*s) {
		free (*s);
		s++;
	}

	free (u);
}

int	process_mail_file (s)

char	*s;

{
	MESSAGE	*m, *newm;
	char	uid[1024], domain[1024];
	char	fail[1024];
	int	i, j;
	int	ok = FALSE;
	char	**uids;

	read_mail_file (s);

	m = messages.start;
	while (m) {
		char	*t;
		char	**u;
		char	*this_id;
		int	local = FALSE;

		/* Just in case */

		uids = get_uids (m);

		if (uids) {
			u = uids;

			while (t = *u) {

				while (*t && *t != '<')
					t++;
				if (*t) {
					char	*s;

					s = t + 1;
					while (*t && *t != '>')
						t++;

					if (*t)
						*t = 0;
					t = s;
				}
				else
					t = *u;

				this_id = t;

				i = j = 0;
				while (*t && *t != '@')
					uid[j++] = *t++;
				uid[j] = 0;

				j = 0;
				if (*t) {
					t++;
					while (*t)
						domain[j++] = *t++;
				}

				if (!strcmp(domain, our_domain)) {
					local = TRUE;
					ok = process_message (m, uid, this_id);
				}
#ifdef OTHER_DOMAIN
				else if (!strcmp(domain, other_domain)) {
					local = TRUE;
					ok = process_message (m, uid, this_id);	
				}
#endif
				u++;
			}

			/* If no local addresses, then save */

			if (!local)
				ok = save_message (m, uid, default_mail_file);

			free_uids (uids);
		}
		else
			ok = save_message (m, "postmaster", default_mail_file);

		m = m->next;
	}

	/* Free them off */

	m = messages.start;
	while (m) {
		newm = m->next;
		free_message (m);
		m = newm;
	}

	messages.start = messages.end = NULL;
	messages.number = 0;

	/* Delete messages */

#ifndef SAFE
	if (ok)
		unlink (s);
#endif

	return ok;
}


int	process_outgoing_mail (s)

char	*s;

{
	MESSAGE	*m, *newm;
	int	ok = TRUE;
	BUFFER	*b, *mc;

	read_mail_file (s);

	b = new_buffer();

	m = messages.start;
	while (m) {
		add_to_buffer (b, m->header->message, m->header->length);

		mc = message_contents (m);
		add_to_buffer (b, mc->message, mc->length);

		if (run_program(mail_args[0],b->message, b->length,mail_args,NULL)) {
			ok = FALSE;
			break;
		}
		else {
			printf("Sent mail to %s", m->to);
			if (m->subject) 
				printf(", subject \"%s\"", m->subject);
			printf("\n");
			save_message (m, our_userid, "sent-mail");
		}
		clear_buffer (b);
		m = m->next;
	}

	/* Free them off */

	m = messages.start;
	while (m) {
		newm = m->next;
		free_message (m);
		m = newm;
	}

	messages.start = messages.end = NULL;
	messages.number = 0;

	return ok;
}

main(argc, argv)

int	argc;
char	*argv[];

{
	char	mail_dir[1024];
	char	mail_file[1024];
	char	new_file[1024];
	char	env[1024];
	DIR	*dir;
	struct	dirent	*next;
	int	ok;

	/* Set the umask for security */

	umask (077);


	our_userid = cuserid (0);
	sprintf(mail_dir, "%s/in", home_dir);

	if (!(dir = opendir (mail_dir))) {
		exit (1);
	}

	sprintf(env, "PGPPATH=%s/pgp", home_dir);
	putenv (env);

	init_pgplib();

	if (argc <= 1) {
		do {
			next = readdir (dir);
			if (next) {
				if (!strncmp ("in", next->d_name, 2)) {
					sprintf(mail_file, "%s/%s", mail_dir,
						next->d_name);
					ok = process_mail_file (mail_file);
#ifdef SAFE
					if (ok) {
						next->d_name[0] = 'd';
						sprintf(new_file, "%s/%s", mail_dir,
							next->d_name);
						rename (mail_file, new_file);
					}
#endif
				}
			}
		} while (next);

		closedir (dir);
	}
	else {
		process_outgoing_mail (argv[1]);
	} 

	close_pgplib();
}

#ifndef PGPTOOLS
char	*pgp_path()

{
	static	char	pgp_path[MAXPATHLEN];
	static	int	first = TRUE;

	if (first) {
	}

	if (!access (pgp_exec, X_OK))
		return pgp_exec;
	else
		return NULL;

}
#endif
