/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPRecipientGrafPort.h,v 1.12 1999/03/10 02:41:13 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <UTables.h>

#include "CPGPUIGrafPortView.h"
#include "pgpUserInterface.h"
#include "pgpKeys.h"
#include "pgpGroups.h"
#include "pgpRecipientDialogCommon.h"

class CUserIDTable;
class CPGPRecipientDialogOptions;

class CPGPRecipientGrafPortView	:	public CPGPUIGrafPortView
{
public:

	enum
	{
		class_ID = 'CPgp',
		
		kUserIDFocusBorderPaneID		= 1,
		kUserIDScrollerPaneID			= 3,
		kUserIDTablePaneID				= 4,

		kRecipientsFocusBorderPaneID	= 5,
		kRecipientScrollerPaneID		= 7,
		kRecipientTablePaneID			= 8,

		kPromptTextPaneID			= 15,
		kUpdateFromServerButtonPaneID	= 16,
		
		kOptionsButtonPaneID 			= 'bOpt',
		
		msg_Options						= kOptionsButtonPaneID
	};

						CPGPRecipientGrafPortView(LStream *inStream);
	virtual				~CPGPRecipientGrafPortView();

	PGPError			SetOptions(PGPContextRef context,
								CPGPRecipientDialogOptions *options,
								PGPBoolean *showDialog);
	
	virtual void		FinishCreateSelf(void);
	virtual Boolean		HandleKeyPress( const EventRecord&	inKeyEvent);
	virtual	MessageT	HandleMessage(MessageT theMessage);
	virtual void		ListenToMessage(MessageT inMessage, void *ioParam);

protected:

	virtual void		SetDescriptor(ConstStringPtr prompt);
	
private:

	const CPGPRecipientDialogOptions	*mOptions;
	PGPRecipientsList					mRecipients;
	
	LPushButton				*mUpdateFromServerButton;
	LPushButton				*mOptionsButton;
	
	CUserIDTable			*mRecipientTable;
	CUserIDTable			*mUserIDTable;
	
	PGPError				BuildTable(CUserIDTable *whichTable,
									PGPRecipientUserLocation location);
	PGPError				BuildTables(void);
	void					DoOptionsDialog(void);
	
	void					AdjustButtons(void);
	PGPUInt32				MoveSelectedUsers(
									PGPRecipientUserLocation destinationList);
	
	PGPUInt32				SendSelectedToRecipients(void);
	PGPUInt32				SendSelectedToUserIDs(void);
	
	static PGPError			EventHandler(PGPRecipientsList *recipients,
									PGPRecipientEvent *event,
									PGPUserValue userValue);
};

