/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CGetResourcePatcher.cp,v 1.4 1999/04/19 03:23:43 jason Exp $
____________________________________________________________________________*/

#include <Traps.h>

#include <SetupA4.h>

#include "CGetResourcePatcher.h"



// Define statics
CGetResourcePatcher *	CGetResourcePatcher::sGetResourcePatcher = nil;

CGetResourcePatcher::CGetResourcePatcher()
{
	// Current version will only install one patch
	if (sGetResourcePatcher == nil) {
		Patch(_GetResource, kProcInfo, (ProcPtr) GetResourceCallback);
		sGetResourcePatcher = this;
	}
}



CGetResourcePatcher::~CGetResourcePatcher()
{
}



	Handle
CGetResourcePatcher::NewGetResource(
	ResType	theType,
	short	theID)
{
	// default just calls through to the original
	return OldGetResource(theType, theID);
}



	Handle
CGetResourcePatcher::OldGetResource(
	ResType	theType,
	short	theID)
{
#if	TARGET_RT_MAC_CFM
	return (Handle) ::CallUniversalProc(	mOldRoutine,
											kProcInfo,
											theType,
											theID);
#else
	return ((GetResourceProc) mOldRoutine)(	theType,
											theID);
#endif
}



	pascal Handle
CGetResourcePatcher::GetResourceCallback(
	ResType	theType,
	short	theID)
{
	EnterCallback();

	Handle	result = false;

	try {
		result = sGetResourcePatcher->NewGetResource(	theType,
														theID);
	}
	
	catch(...) {
	}
	
	ExitCallback();
	return result;
}
