/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CCommandKeyWell.h,v 1.2 1999/04/14 19:57:52 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LCaption.h>
#include <LCommander.h>
#include <LPeriodical.h>

class CCommandKeyWell : public LCaption,
						public LCommander,
						public LPeriodical
{
public:
	enum { class_ID = 'CmKW' };

						CCommandKeyWell(LStream * inStream);
						~CCommandKeyWell();
	void				SetCKW(
							UInt8			modifiers,
							UInt8			triggerKey );
	void				GetCKW(
							UInt8			&modifiers,
							UInt8			&triggerKey );
	virtual Boolean		ObeyCommand(CommandT inCommand, void *ioParam);
	
protected:
	virtual void 		FinishCreateSelf();
	virtual void 		ClickSelf( const SMouseDownEvent &inMouseDown );
	virtual void 		DrawSelf();
	virtual void 		DrawBackground(	const Rect & localFrame );
	virtual void 		DrawText(			const Rect & localFrame );
	virtual Boolean		HandleKeyPress(const EventRecord&	inKeyEvent);
	void				SpendTime( const EventRecord&	inMacEvent );
	void				ResetText();
	
	UInt8				mModifiers;
	UInt8				mKey;
};

